<?php $__env->startSection('title', __('locale.Store Dues')); ?>

<?php $__env->startSection('vendor-style'); ?>
  <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/css/datatables.scss']); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('vendor-script'); ?>
  <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/js/datatables.js']); ?>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
  <div class="row g-6 mb-6">
    <div class="col-sm-12 col-xl-12">
      <div class="card">
        <div class="card-body pb-0">
          <div class="d-flex align-items-start justify-content-between">
            <div class="content-left">
              <?php
                $grandTotal = 0;
                foreach ($totals as $row) {
                    $grandTotal += ($row->total_balance ?? 0) + ($row->total_withdrawals ?? 0);
                    $currency = $row->currency;
                }
              ?>

              <span class="text-heading">
                <?php echo e(__('locale.Amount To Be Paid')); ?>: <?php echo e($currency); ?><?php echo e($grandTotal); ?>

              </span>
              <?php $__currentLoopData = $totals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="d-flex align-items-center my-1">
                  <h4 class="mb-0 me-2 text-size-26">
                    <?php echo e($row->currency); ?><?php echo e($row->total_balance ?? 0); ?> <small>(<?php echo e(__('locale.Wallet')); ?>)</small>
                    <?php if($row->total_withdrawals > 0): ?>
                      +
                      <?php echo e($row->currency); ?><?php echo e($row->total_withdrawals ?? 0); ?>

                      <small>(<?php echo e(__('locale.Withdrawal Request')); ?>)</small>
                    <?php endif; ?>
                  </h4>
                </div>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <div class="avatar">
              <span class="avatar-initial rounded bg-label-danger">
                <i class="icon-base ti tabler-credit-card-pay icon-26px"></i>
              </span>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="col-sm-6 col-xl-6 d-none">
      <div class="card">
        <div class="card-body pb-0">
          <div class="d-flex align-items-start justify-content-between">
            <div class="content-left">
              <span class="text-heading"><?php echo e(__('locale.Amount To Be Receive')); ?></span>
              <?php $__currentLoopData = $totals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="d-flex align-items-center my-1">
                  <h4 class="mb-0 me-2 text-size-26"> <?php echo e($row->currency); ?><?php echo e($row->total_pending_dues ?? 0); ?></h4>
                </div>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <div class="avatar">
              <span class="avatar-initial rounded bg-label-success">
                <i class="icon-base ti tabler-credit-card-refund icon-26px"></i>
              </span>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <!-- Product List Table -->
  <div class="card">
    <div class="card-datatable">
      <table class="datatables-wallet table">
        <thead class="border-top">
          <tr>
            <th></th>
            <th></th>
            <th><?php echo e(__('locale.Store Details')); ?></th>
            <th><?php echo e(__('locale.Wallet Balance')); ?></th>
            <th><?php echo e(__('locale.Pending Dues')); ?></th>
            <th><?php echo e(__('locale.Actions')); ?></th>
          </tr>
        </thead>
      </table>
    </div>
  </div>
  <?php echo $__env->make('_partials/_modals/modal-clear-dues', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-script'); ?>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    window.permissions = {
      ownerType: 'store'
    };
  </script>
  <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/js/wallet_store.js']); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/layoutMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/intellisensetech/public_html/topsyapp/resources/views/admin/wallets/stores.blade.php ENDPATH**/ ?>