<?php
  $configData = Helper::appClasses();
?>



<?php $__env->startSection('title', __('locale.Car Management')); ?>

<?php $__env->startSection('vendor-style'); ?>
  <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/css/datatables.scss']); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('vendor-script'); ?>
  <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/js/datatables.js']); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
  <div class="row g-6">
    <div class="col-12">
      <div class="card">
        <div class="card-datatable">
          <div class="row p-3">
            <div class="col-md-3">
              <label for="filter_parent" class="form-label"><?php echo e(__('locale.Parent Category')); ?></label>
              <select id="filter_parent" class="form-select">
                <option value=""><?php echo e(__('locale.All')); ?></option>
                <?php $__currentLoopData = $parentCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option value="<?php echo e($parent->id); ?>"><?php echo e($parent->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </select>
            </div>

            <div class="col-md-3">
              <label for="filter_subcategory" class="form-label"><?php echo e(__('locale.Subcategory')); ?></label>
              <select id="filter_subcategory" class="form-select">
                <option value=""><?php echo e(__('locale.All')); ?></option>
              </select>
            </div>

            <div class="col-md-3">
              <label for="filter_brand" class="form-label"><?php echo e(__('locale.Brand')); ?></label>
              <select id="filter_brand" class="form-select">
                <option value=""><?php echo e(__('locale.All')); ?></option>
                <?php $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option value="<?php echo e($brand->id); ?>"><?php echo e($brand->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </select>
            </div>
            <div class="col-md-3">
              <label for="filter_model" class="form-label"><?php echo e(__('locale.Model')); ?></label>
              <select id="filter_model" class="form-select">
                <option value=""><?php echo e(__('locale.All')); ?></option>
                <?php $__currentLoopData = $models; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $model): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option value="<?php echo e($model->id); ?>"><?php echo e($model->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </select>
            </div>

          </div>

          <table class="datatables-users table border-top">
            <thead>
              <tr>
                <th>#</th>
                <th><?php echo e(__('locale.Image')); ?></th>
                <th><?php echo e(__('locale.Name')); ?></th>
                <th><?php echo e(__('locale.Category')); ?></th>
                <th><?php echo e(__('locale.Brand')); ?></th>
                <th><?php echo e(__('locale.Details')); ?></th>
                <th><?php echo e(__('locale.Status')); ?></th>
                <th><?php echo e(__('locale.Actions')); ?></th>
              </tr>
            </thead>
          </table>
        </div>
      </div>
    </div>
  </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-script'); ?>
  <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/js/car.js']); ?>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    window.permissions = {
      canDeleteCar: <?php echo json_encode(auth()->user()->can('rental-delete'), 15, 512) ?>,
      canEditCar: <?php echo json_encode(auth()->user()->can('rental-edit'), 15, 512) ?>,
      canCreateCar: <?php echo json_encode(auth()->user()->can('rental-create'), 15, 512) ?>
    };
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/layoutMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/intellisensetech/public_html/topsyapp/resources/views/admin/cars/index.blade.php ENDPATH**/ ?>