<?php
  $configData = Helper::appClasses();
?>



<?php $__env->startSection('title', __('locale.Dashboard')); ?>

<?php $__env->startSection('vendor-style'); ?>
  <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/vendor/libs/apex-charts/apex-charts.scss', 'resources/assets/vendor/libs/swiper/swiper.scss', 'resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss', 'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss', 'resources/assets/vendor/fonts/flag-icons.scss']); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-style'); ?>
  <?php echo app('Illuminate\Foundation\Vite')('resources/assets/vendor/scss/pages/cards-advance.scss'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('vendor-script'); ?>
  <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/vendor/libs/apex-charts/apexcharts.js', 'resources/assets/vendor/libs/swiper/swiper.js', 'resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js']); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
  <div class="row g-6">
    <?php $currency=Auth::user()->currency ?? Helper::setting('currency_symbol','currency'); ?>
    <!-- Website Analytics -->
    <div class="col-xl-6 col">
      <div class="swiper-container swiper-container-horizontal swiper swiper-card-advance-bg"
        id="swiper-with-pagination-cards">
        <div class="swiper-wrapper">
          <div class="swiper-slide">
            <div class="row">
              <div class="col-12">
                <h5 class="text-white mb-0"><?php echo e(__('locale.Order Analytics')); ?></h5>
              </div>
              <div class="row">
                <div class="col-lg-7 col-md-9 col-12 order-2 order-md-1 pt-md-9">
                  <h6 class="text-white mt-0 mt-md-3 mb-4"><?php echo e(__('locale.Total Orders')); ?></h6>
                  <div class="row">
                    <div class="col-6">
                      <ul class="list-unstyled mb-0">
                        <li class="d-flex mb-2 align-items-center">
                          <p class="mb-0 fw-medium me-2 website-analytics-text-bg"><?php echo e($orderCount->count()); ?></p>
                          <p class="mb-0"><?php echo e(__('locale.Orders')); ?></p>
                        </li>
                        <li class="d-flex mb-2 align-items-center">
                          <p class="mb-0 fw-medium me-2 website-analytics-text-bg"><?php echo e($orderCount->sum('items_count')); ?>

                          </p>
                          <p class="mb-0"><?php echo e(__('locale.Order Items')); ?></p>
                        </li>
                        <li class="d-flex align-items-center">
                          <p class="mb-0 fw-medium me-2 website-analytics-text-bg"><?php echo e($pendingOrderCount); ?>

                          </p>
                          <p class="mb-0"><?php echo e(__('locale.Pending Orders')); ?></p>
                        </li>
                      </ul>
                    </div>

                  </div>
                </div>
                <div class="col-lg-5 col-md-3 col-12 order-1 order-md-2 my-4 my-md-0 text-center">
                  <img src="<?php echo e(asset('assets/img/illustrations/card-website-analytics-3.png')); ?>" alt="Website Analytics"
                    height="150" class="card-website-analytics-img" />
                </div>
              </div>
            </div>
          </div>
          <div class="swiper-slide">
            <div class="row">
              <div class="col-12">
                <h5 class="text-white mb-0"><?php echo e(__('locale.Product Analytics')); ?></h5>
              </div>
              <div class="col-lg-7 col-md-9 col-12 order-2 order-md-1 pt-md-9">
                <h6 class="text-white mt-0 mt-md-3 mb-4"><?php echo e(__('locale.Total Products')); ?></h6>
                <div class="row">
                  <div class="col-6">
                    <ul class="list-unstyled mb-0">
                      <li class="d-flex mb-4 align-items-center">
                        <p class="mb-0 fw-medium me-2 website-analytics-text-bg"><?php echo e($productCount); ?></p>
                        <p class="mb-0"><?php echo e(__('locale.Products')); ?></p>
                      </li>

                    </ul>
                  </div>

                </div>
                <h6 class="text-white mt-0 mt-md-3 mb-4"><?php echo e(__('locale.Wallet')); ?></h6>
                <div class="row">
                  <div class="col-6">
                    <ul class="list-unstyled mb-0">
                      <li class="d-flex mb-4 align-items-center">
                        <button class="btn btn-sm btn-success"><?php echo e($currency); ?><?php echo e($pendingDues); ?></button>
                      </li>

                    </ul>
                  </div>

                </div>
              </div>
              <div class="col-lg-5 col-md-3 col-12 order-1 order-md-2 my-4 my-md-0 text-center">
                <img src="<?php echo e(asset('assets/img/illustrations/card-website-analytics-2.png')); ?>" alt="Website Analytics"
                  height="150" class="card-website-analytics-img" />
              </div>
            </div>
          </div>

        </div>
        <div class="swiper-pagination"></div>
      </div>
    </div>
    <!--/ Website Analytics -->

    <!-- Average Daily Sales -->
    <div class="col-xl-3 col-sm-6">
      <div class="card h-100">
        <div class="card-header pb-0">
          <h5 class="mb-3 card-title"><?php echo e(__('locale.Average Daily Sales')); ?></h5>
          <p class="mb-0 text-body"><?php echo e(__('locale.Total Sales This Month')); ?></p>
          <h4 class="mb-0" id="averageDailySalesTotal"></h4>
        </div>
        <div class="card-body px-0">
          <div id="averageDailySales"></div>
        </div>
      </div>
    </div>
    <!--/ Average Daily Sales -->

    <!-- Sales Overview -->
    <div class="col-xl-3 col-sm-6">
      <div class="card h-100">
        <div class="card-header">
          <div class="d-flex justify-content-between">
            <p class="mb-0 text-body"><?php echo e(__('locale.Sales Overview')); ?></p>
            <p class="card-text fw-medium <?php echo e($sales_percent >= 0 ? 'text-success' : 'text-danger'); ?>">
              <?php echo e($sales_percent >= 0 ? '+' : ''); ?><?php echo e($sales_percent); ?>%</p>
          </div>
          <h4 class="card-title mb-1"><?php echo e($currency); ?><?php echo e($sales->total_sales); ?></h4>
        </div>
        <div class="card-body">
          <div class="row">
            <div class="col-12">
              <div class="d-flex gap-2 align-items-center mb-2">
                <span class="badge bg-label-info p-1 rounded">
                  <i class="icon-base ti tabler-shopping-cart icon-sm"></i>
                </span>
                <p class="mb-0"><?php echo e(__('locale.Orders')); ?></p>
              </div>
              <h5 class="mb-0 pt-1 <?php echo e($orders_percent >= 0 ? 'text-success' : 'text-danger'); ?>">
                <?php echo e($orders_percent >= 0 ? '+' : ''); ?><?php echo e($orders_percent); ?>%</h5>
              <small class="text-body-secondary"><?php echo e($sales->total_orders); ?></small>
            </div>
          </div>
          <div class="d-flex align-items-center mt-6">
            <div class="progress w-100" style="height: 10px;">
              <div class="progress-bar bg-info" style="width: <?php echo e($orders_percent); ?>%" role="progressbar"
                aria-valuenow="<?php echo e($orders_percent); ?>" aria-valuemin="0" aria-valuemax="100"></div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!--/ Sales Overview -->

    <!-- Order Placed -->

    <div class="card">
      <div class="card-header"><?php echo e(__('locale.Placed Orders')); ?></div>
      <div class="card-body">
        <table id="orders-table" class="table">
          <thead>
            <tr>
              <th><?php echo e(__('locale.Order')); ?></th>
              <th><?php echo e(__('locale.Date')); ?></th>
              <th><?php echo e(__('locale.Customers')); ?></th>
              <th><?php echo e(__('locale.Payment')); ?></th>
              <th><?php echo e(__('locale.Status')); ?></th>
              <th><?php echo e(__('locale.Type')); ?></th>
              <th><?php echo e(__('locale.Actions')); ?></th>
            </tr>
          </thead>
          <tbody>
            <?php $__currentLoopData = $pendingOrders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr id="row<?php echo e($order->id); ?>">
                
                <td>
                  <a href="<?php echo e(url('store/orders/' . $order->id)); ?>">
                    <?php echo e($order->order_id); ?>

                  </a>
                </td>

                
                <td>
                  <span class="text-nowrap">
                    <?php echo e($order->created_at->format('M d, Y')); ?> <br>
                    <small><?php echo e($order->created_at->format('h:i A')); ?></small>
                  </span>
                </td>

                
                <td>
                  <div class="d-flex justify-content-start align-items-center order-name text-nowrap">
                    <div class="avatar-wrapper">
                      <div class="avatar avatar-sm me-3">
                        <?php if($order->user?->profile_image_url): ?>
                          <img src="<?php echo e($order->user?->profile_image_url); ?>" alt="Avatar" class="rounded-circle">
                        <?php else: ?>
                          <?php
                            $states = ['success', 'danger', 'warning', 'info', 'dark', 'primary', 'secondary'];
                            $state = $states[array_rand($states)];
                            $initials = strtoupper(substr($order->user?->name, 0, 2));
                          ?>
                          <span class="avatar-initial rounded-circle bg-label-<?php echo e($state); ?>">
                            <?php echo e($initials); ?>

                          </span>
                        <?php endif; ?>
                      </div>
                    </div>
                    <div class="d-flex flex-column">
                      <h6 class="m-0">
                        <span class="text-heading"><?php echo e($order->user?->name); ?></span>
                      </h6>
                      <small><?php echo e($order->user?->email); ?></small>
                    </div>
                  </div>
                </td>

                
                <td>

                  <h6 class="mb-0 align-items-center d-flex w-px-100 ">
                    <?php echo e($order->payment_status); ?>

                  </h6>
                  <?php echo e($order->currency); ?><?php echo e($order->grand_total); ?>

                  <br>
                  <small><?php echo e($order->payment_type); ?></small>

                </td>

                
                <td>

                  <span class="badge px-2 text-capitalized">
                    <?php echo e($order->status); ?>

                  </span>
                  <?php if($order->prescriptions): ?>
                    <br>
                    <button class="btn btn-sm btn-primary mt-1 view-prescription" title="Prescriptions"
                      data-image="<?php echo e($order->prescription_image); ?>">
                      <i class="icon-base ti tabler-prescription"></i>
                    </button>
                  <?php endif; ?>
                </td>

                
                <td>
                  <div class="d-flex align-items-center text-nowrap">
                    <span><?php echo e($order->payment_type); ?></span>
                  </div>
                </td>

                
                <td>
                  <div class="d-flex justify-content-sm-start align-items-sm-center">
                    <button title="Accept Order"
                      class="btn btn-text-primary rounded-pill waves-effect btn-icon acceptOrder"
                      data-order-id="<?php echo e($order->id); ?>">
                      <i class="icon-base ti tabler-check"></i>
                    </button>
                    <button class="btn btn-text-secondary rounded-pill waves-effect btn-icon dropdown-toggle hide-arrow"
                      data-bs-toggle="dropdown">
                      <i class="icon-base ti tabler-dots-vertical"></i>
                    </button>
                    <div class="dropdown-menu dropdown-menu-end m-0">
                      <a href="<?php echo e(url('store/orders/' . $order->id)); ?>" class="dropdown-item">View</a>
                    </div>
                  </div>
                </td>
              </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </tbody>
        </table>
      </div>
    </div>

    <!-- Order Placed -->

    <!-- Earning Reports -->
    <div class="col-md-6">
      <div class="card h-100">
        <div class="card-header pb-0 d-flex justify-content-between">
          <div class="card-title mb-0">
            <h5 class="mb-1"><?php echo e(__('locale.Earning Reports')); ?></h5>
            <p class="card-subtitle"><?php echo e(__('locale.Weekly Earnings Overview')); ?></p>
          </div>

        </div>
        <div class="card-body">
          <div class="row align-items-center g-md-8">
            <div class="col-12 col-md-5 d-flex flex-column">
              <div class="d-flex gap-2 align-items-center mb-3 flex-wrap">
                <h2 class="mb-0"><?php echo e($currency); ?><?php echo e(number_format($earnings, 2)); ?></h2>
                <div class="badge rounded <?php echo e($percentageChange >= 0 ? 'bg-label-success' : 'bg-label-danger'); ?>">
                  <?php echo e($percentageChange >= 0 ? '+' : ''); ?><?php echo e($percentageChange); ?>%</div>
              </div>
              <small class="text-body"><?php echo e(__('locale.You informed of this week compared to last week')); ?></small>
            </div>
            <div class="col-12 col-md-7 ps-xl-8">
              <div id="weeklyChart" data-weekly="<?php echo e(json_encode($weeklyEarnings)); ?>"></div>
              <div id="weeklyEarningReports"></div>
            </div>
          </div>
          <div class="border rounded p-5 mt-5">
            <div class="row gap-4 gap-sm-0">
              <div class="col-12 col-sm-4">
                <div class="d-flex gap-2 align-items-center">
                  <div class="badge rounded bg-label-primary p-1"><i class="icon-base icon-md pe-1 ps-1"> ₵ </i></div>
                  <h6 class="mb-0 fw-normal"><?php echo e(__('locale.Earnings')); ?></h6>
                </div>
                <h4 class="my-2"><?php echo e($currency); ?><?php echo e(number_format($earnings, 2)); ?></h4>
                <div class="progress w-75" style="height:4px">
                  <div class="progress-bar" role="progressbar" style="width: <?php echo e($percentageChange); ?>%"
                    aria-valuenow="<?php echo e($percentageChange); ?>" aria-valuemin="0" aria-valuemax="100"></div>
                </div>
              </div>
              <div class="col-12 col-sm-4">
                <div class="d-flex gap-2 align-items-center">
                  <div class="badge rounded bg-label-info p-1"><i class="icon-base ti tabler-chart-pie-2 icon-18px"></i>
                  </div>
                  <h6 class="mb-0 fw-normal"><?php echo e(__('locale.Profit')); ?></h6>
                </div>
                <h4 class="my-2"><?php echo e($currency); ?><?php echo e(number_format($profit, 2)); ?></h4>
                <div class="progress w-75" style="height:4px">
                  <div class="progress-bar bg-info" role="progressbar" style="width: <?php echo e($percentageChangeProfit); ?>%"
                    aria-valuenow="<?php echo e($percentageChangeProfit); ?>" aria-valuemin="0" aria-valuemax="100"></div>
                </div>
              </div>
              <div class="col-12 col-sm-4">
                <div class="d-flex gap-2 align-items-center">
                  <div class="badge rounded bg-label-danger p-1"><i
                      class="icon-base ti tabler-brand-paypal icon-18px"></i></div>
                  <h6 class="mb-0 fw-normal"><?php echo e(__('locale.Expense')); ?></h6>
                </div>
                <h4 class="my-2"><?php echo e($currency); ?><?php echo e(number_format($expenses, 2)); ?></h4>
                <div class="progress w-75" style="height:4px">
                  <div class="progress-bar bg-danger" role="progressbar"
                    style="width: <?php echo e($percentageChangeExpense); ?>%" aria-valuenow="<?php echo e($percentageChangeExpense); ?>"
                    aria-valuemin="0" aria-valuemax="100"></div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <!--/ Earning Reports -->

    <!-- Total Earning -->
    <div class="col-12 col-md-6 col-xxl-4 order-2 order-xl-0">
      <div class="card h-100">
        <div class="card-header">
          <div class="d-flex justify-content-between align-items-center">
            <h5 class="mb-0 card-title"><?php echo e(__('locale.Total Earning')); ?></h5>
          </div>
          <div class="d-flex align-items-center">
            <h2 class="mb-0 me-2"><?php echo e($currency); ?><?php echo e(number_format($totalRevenue, 2)); ?></h2>
            <?php if($percentageChangeList >= 0): ?>
              <i class="icon-base ti tabler-chevron-up text-success me-1"></i>
              <h6 class="text-success mb-0"><?php echo e(number_format($percentageChangeList, 1)); ?>%</h6>
            <?php else: ?>
              <i class="icon-base ti tabler-chevron-down text-danger me-1"></i>
              <h6 class="text-danger mb-0"><?php echo e(number_format(abs($percentageChangeList), 1)); ?>%</h6>
            <?php endif; ?>
          </div>
        </div>

        <div class="card-body">
          <div id="totalEarningChart"></div>

          <div class="d-flex align-items-start my-4">
            <div class="badge rounded bg-label-primary p-2 me-4 rounded">
              <i class="icon-base ti tabler-brand-paypal icon-md"></i>
            </div>
            <div class="d-flex justify-content-between w-100 gap-2 align-items-center">
              <div class="me-2">
                <h6 class="mb-0"><?php echo e(__('locale.Total Revenue')); ?></h6>
              </div>
              <h6 class="mb-0 text-success">+<?php echo e($currency); ?><?php echo e(number_format($totalRevenue, 2)); ?></h6>
            </div>
          </div>

          <div class="d-flex align-items-start">
            <div class="badge rounded bg-label-secondary p-2 me-4 rounded">
              <i class="icon-base icon-md ps-1 pe-1"> ₵ </i>
            </div>
            <div class="d-flex justify-content-between w-100 gap-2 align-items-center">
              <div class="me-2">
                <h6 class="mb-0"><?php echo e(__('locale.Total Sales')); ?></h6>
                <small class="text-body"><?php echo e(__('locale.Orders Count')); ?></small>
              </div>
              <h6 class="mb-0 text-success"><?php echo e($totalSales); ?></h6>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!--/ Total Earning -->
  </div>
  <?php echo $__env->make('_partials/_modals/modal-prescription', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
  <?php echo $__env->make('_partials/_modals/modal-accept-order', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-script'); ?>
  
  <script>
    window.totalEarningChartData = {
      earnings: <?php echo json_encode($earningsList, 15, 512) ?>,
      expenses: <?php echo json_encode($expensesList, 15, 512) ?>,
      currency: <?php echo json_encode($currency, 15, 512) ?>
    };
  </script>
  <?php echo app('Illuminate\Foundation\Vite')('resources/assets/js/dashboards-store.js'); ?>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    let selectedOrderId = null;

    $(document).on('click', '.acceptOrder', function() {
      selectedOrderId = $(this).data('order-id'); // save order ID
      $('#acceptRejectOrderModal').modal('show'); // open modal
    });

    $(document).on('click', '.change-order-status', function() {
      let status = $(this).data('status');

      $.ajax({
        url: `${baseURL}/orders/${selectedOrderId}/status`,
        method: 'POST',
        data: {
          _token: '<?php echo e(csrf_token()); ?>',
          status: status
        },
        success: function(data) {
          const toastType = data.status == 200 ? 'bg-success' : 'bg-warning';
          window.showToast({
            title: 'Orders 🛒',
            message: data.message,
            type: toastType,
            animation: 'animate__fadeInUp',
            time: 'Just now',
            delay: 3000
          });
          $('#row' + selectedOrderId).hide();
          $('#acceptRejectOrderModal').modal('hide'); // close modal
        },
        error: function(xhr) {
          console.log(xhr.responseJSON);
        }
      });
    });
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/layoutMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/intellisensetech/public_html/topsyapp/resources/views/store/dashboard.blade.php ENDPATH**/ ?>