<?php $__env->startSection('title', __('locale.Users')); ?>

<!-- Vendor Styles -->
<?php $__env->startSection('vendor-style'); ?>
  <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/css/datatables.scss']); ?>
<?php $__env->stopSection(); ?>

<!-- Vendor Scripts -->
<?php $__env->startSection('vendor-script'); ?>
  <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/js/datatables.js', 'resources/assets/vendor/libs/raty-js/raty-js.js']); ?>
<?php $__env->stopSection(); ?>



<?php $__env->startSection('content'); ?>
  <div class="row g-6 mb-6">
    <div class="col-sm-6 col-xl-3">
      <div class="card">
        <div class="card-body">
          <div class="d-flex align-items-start justify-content-between">
            <div class="content-left">
              <span class="text-heading"><?php echo e(__('locale.Users')); ?></span>
              <div class="d-flex align-items-center my-1">
                <h4 class="mb-0 me-2"><?php echo e($totalUser); ?></h4>
                <p class="text-success mb-0">(<?php echo e($totalUser > 0 ? round(($totalUser / $totalUser) * 100, 2) : 0); ?>%)</p>
              </div>
              <small class="mb-0"><?php echo e(__('locale.Total')); ?> <?php echo e(__('locale.Users')); ?></small>
            </div>
            <div class="avatar">
              <span class="avatar-initial rounded bg-label-primary">
                <i class="icon-base ti tabler-users icon-26px"></i>
              </span>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="col-sm-6 col-xl-3">
      <div class="card">
        <div class="card-body">
          <div class="d-flex align-items-start justify-content-between">
            <div class="content-left">
              <span class="text-heading"><?php echo e(__('locale.Verified')); ?> <?php echo e(__('locale.Users')); ?></span>
              <div class="d-flex align-items-center my-1">
                <h4 class="mb-0 me-2"><?php echo e($verified); ?></h4>
                <p class="text-success mb-0">(<?php echo e($totalUser > 0 ? round(($verified / $totalUser) * 100, 2) : 0); ?>%)</p>
              </div>
              <small class="mb-0"><?php echo e(__('locale.Recent analytics')); ?> </small>
            </div>
            <div class="avatar">
              <span class="avatar-initial rounded bg-label-success">
                <i class="icon-base ti tabler-user-plus icon-26px"></i>
              </span>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="col-sm-6 col-xl-3">
      <div class="card">
        <div class="card-body">
          <div class="d-flex align-items-start justify-content-between">
            <div class="content-left">
              <span class="text-heading"><?php echo e(__('locale.Disabled')); ?> <?php echo e(__('locale.Users')); ?></span>
              <div class="d-flex align-items-center my-1">
                <h4 class="mb-0 me-2"><?php echo e($userDisabled); ?></h4>
                <p class="text-danger mb-0">(<?php echo e($totalUser > 0 ? round(($userDisabled / $totalUser) * 100, 2) : 0); ?>%)
                </p>
              </div>
              <small class="mb-0"><?php echo e(__('locale.Recent analytics')); ?></small>
            </div>
            <div class="avatar">
              <span class="avatar-initial rounded bg-label-danger">
                <i class="icon-base ti tabler-user-minus icon-26px"></i>
              </span>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="col-sm-6 col-xl-3">
      <div class="card">
        <div class="card-body">
          <div class="d-flex align-items-start justify-content-between">
            <div class="content-left">
              <span class="text-heading"><?php echo e(__('locale.Verification Pending')); ?></span>
              <div class="d-flex align-items-center my-1">
                <h4 class="mb-0 me-2"><?php echo e($notVerified); ?></h4>
                <p class="text-danger mb-0">(<?php echo e($totalUser > 0 ? round(($notVerified / $totalUser) * 100, 2) : 0); ?>%)</p>
              </div>
              <small class="mb-0"><?php echo e(__('locale.Recent analytics')); ?></small>
            </div>
            <div class="avatar">
              <span class="avatar-initial rounded bg-label-warning">
                <i class="icon-base ti tabler-user-search icon-26px"></i>
              </span>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <!-- Users List Table -->
  <div class="card">
    <div class="card-header border-bottom">
      <h5 class="card-title mb-0 d-none"><?php echo e(__('locale.Search Filter')); ?></h5>
      <div class="row p-0">
        <div class="col-md-6">
          <label for="filter_verified" class="form-label"><?php echo e(__('locale.User Verified')); ?></label>
          <select id="filter_verified" class="form-select">
            <option value=""><?php echo e(__('locale.All')); ?></option>
            <option value="1"><?php echo e(__('locale.Verified')); ?></option> <!-- true -->
            <option value="0"><?php echo e(__('locale.Not Verified')); ?></option> <!-- false -->
          </select>
        </div>

        <div class="col-md-6">
          <label for="filter_status" class="form-label"><?php echo e(__('locale.Status')); ?></label>
          <select id="filter_status" class="form-select">
            <option value=""><?php echo e(__('locale.All')); ?></option>
            <option value="1"><?php echo e(__('locale.Active')); ?></option>
            <option value="0"><?php echo e(__('locale.Inactive')); ?></option>
          </select>
        </div>

      </div>
    </div>
    <div class="card-datatable">
      <table class="datatables-users table border-top">
        <thead>
          <tr>
            <th></th>
            <th><?php echo e(__('locale.ID')); ?></th>
            <th><?php echo e(__('locale.User')); ?></th>
            <th><?php echo e(__('locale.Email')); ?></th>
            <th><?php echo e(__('locale.Verified')); ?></th>
            <th><?php echo e(__('locale.Actions')); ?></th>
          </tr>
        </thead>
      </table>
    </div>
    <!-- Offcanvas to add new user -->
    <div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasAddUser" aria-labelledby="offcanvasAddUserLabel">
      <div class="offcanvas-header border-bottom">
        <h5 id="offcanvasAddUserLabel" class="offcanvas-title"><?php echo e(__('locale.Add User')); ?></h5>
        <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
      </div>
      <div class="offcanvas-body mx-0 flex-grow-0 p-6 h-100">
        <form class="add-new-user pt-0" id="addNewUserForm" method="POST" action="<?php echo e(route('users.store')); ?>">
          <?php echo e(csrf_field()); ?>

          <input type="hidden" name="id" id="user_id">
          <input type="hidden" name="user_type" value="User">
          <div class="mb-6 form-control-validation">
            <label class="form-label" for="add-user-fullname"><?php echo e(__('locale.Full Name')); ?></label>
            <input type="text" class="form-control" id="add-user-fullname" placeholder="John Doe" name="name"
              aria-label="John Doe" />
          </div>
          <div class="mb-6 form-control-validation">
            <label class="form-label" for="add-user-email"><?php echo e(__('locale.Email')); ?></label>
            <input type="text" id="add-user-email" class="form-control" placeholder="john.doe@example.com"
              aria-label="john.doe@example.com" name="email" />
          </div>
          <div class="mb-6">
            <label class="form-label" for="add-user-contact"><?php echo e(__('locale.Contact Number')); ?></label>
            <input type="text" id="add-user-contact" class="form-control phone-mask" placeholder="609 988 4411"
              aria-label="" name="phone" />
          </div>
          <div class="mb-6 form-group">
            <label class="form-label" for="add-user-password"><?php echo e(__('locale.Password')); ?></label>
            <input type="password" id="add-user-password" class="form-control" placeholder="" name="password" />
          </div>
          <input type="hidden" id="dial_code" name="dial_code">
          <input type="hidden" name="dial_code_iso" id="country_iso">
          <button type="submit" class="btn btn-primary me-3 data-submit"><?php echo e(__('locale.Submit')); ?></button>
          <button type="reset" class="btn btn-label-danger"
            data-bs-dismiss="offcanvas"><?php echo e(__('locale.Cancel')); ?></button>
        </form>
      </div>
    </div>
  </div>
  <?php echo $__env->make('_partials/_modals/modal-password', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php $__env->stopSection(); ?>
<!-- Page Scripts -->
<?php $__env->startSection('page-script'); ?>
  <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/js/users.js']); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/layoutMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/intellisensetech/public_html/topsyapp/resources/views/admin/users/index.blade.php ENDPATH**/ ?>