<?php
  $configData = Helper::appClasses();
?>



<?php $__env->startSection('title', __('locale.Rental Management')); ?>

<?php $__env->startSection('vendor-style'); ?>
  <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/css/datatables.scss', 'resources/assets/vendor/libs/flatpickr/flatpickr.scss']); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('vendor-script'); ?>
  <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/js/datatables.js', 'resources/assets/vendor/libs/flatpickr/flatpickr.js']); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
  <div class="row g-6">
    <div class="col-12">
      <div class="card">
        <div class="card-datatable">
          <div class="row p-3">
            <div class="col-md-3 driver"></div>
            <div class="col-md-3 car"></div>
            <div class="col-md-3">
              <select id="filter_verified" class="form-select">
                <option value=""><?php echo e(__('locale.All')); ?> <?php echo e(__('locale.Type')); ?></option>
                <option value="Purchase"><?php echo e(__('locale.Purchase')); ?></option> <!-- true -->
                <option value="Rental"><?php echo e(__('locale.Rental')); ?></option> <!-- false -->
              </select>
            </div>

            <div class="col-md-3">
              <select id="filter_status" class="form-select">
                <option value=""><?php echo e(__('locale.All')); ?> <?php echo e(__('locale.Status')); ?></option>
                <option value="Active"><?php echo e(__('locale.Active')); ?></option>
                <option value="Completed"><?php echo e(__('locale.Completed')); ?></option>
                <option value="Cancelled"><?php echo e(__('locale.Cancelled')); ?></option>
              </select>
            </div>

          </div>

          <table class="datatables-users table border-top">
            <thead>
              <tr>
                <th>#</th>
                <th><?php echo e(__('locale.Car Details')); ?></th>
                <th><?php echo e(__('locale.Driver Details')); ?></th>
                <th><?php echo e(__('locale.Amount')); ?></th>
                <th><?php echo e(__('locale.Installments')); ?></th>
                <th><?php echo e(__('locale.Details')); ?></th>
                <th><?php echo e(__('locale.Status')); ?></th>
                <th><?php echo e(__('locale.Actions')); ?></th>
              </tr>
            </thead>
          </table>
        </div>
        <!-- Offcanvas to add new rental -->
        <div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasAddUser" aria-labelledby="offcanvasAddUserLabel">
          <div class="offcanvas-header border-bottom">
            <h5 id="offcanvasAddUserLabel" class="offcanvas-title"><?php echo e(__('locale.Add Rental')); ?></h5>
            <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
          </div>
          <div class="offcanvas-body mx-0 flex-grow-0 p-6 h-100 ">

            <form class="add-new-user pt-0" id="addNewUserForm" method="POST" action="<?php echo e(route('rentals.store')); ?>">
              <?php echo e(csrf_field()); ?>

              <input type="hidden" name="id" id="rental_id">
              <div class="mb-2">
                <label class="form-label"><?php echo e(__('locale.Cars')); ?></label>
                <select name="car_id" id="edit_car" class="form-select" required>
                  <option value=""><?php echo e(__('locale.Select Car')); ?></option>
                  <?php $__currentLoopData = $cars; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $car): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($car->id); ?>"><?php echo e($car->vehicle_model); ?>

                      (<?php echo e($car->registration_number); ?>)
                    </option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
              </div>
              <div class="mb-2">
                <label class="form-label"><?php echo e(__('locale.Drivers')); ?></label>
                <select name="driver_id" id="edit_driver" class="form-select" required>
                  <option value=""><?php echo e(__('locale.Select Driver')); ?></option>
                  <?php $__currentLoopData = $drivers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $driver): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($driver->id); ?>"><?php echo e($driver['user']?->name); ?> (<?php echo e($driver['user']?->phone); ?>)
                    </option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
              </div>
              <div class="mb-2">
                <label class="form-label" for="order_type"><?php echo e(__('locale.Type')); ?></label>
                <select id="order_type" class="form-select" name="order_type">
                  <option value=""><?php echo e(__('locale.All')); ?> <?php echo e(__('locale.Type')); ?></option>
                  <option value="Purchase"><?php echo e(__('locale.Purchase')); ?></option>
                  <option value="Rental"><?php echo e(__('locale.Rental')); ?></option>
                </select>
              </div>
              <div class="mb-2">
                <label class="form-label" for="total_amount"><?php echo e(__('locale.Total Amount')); ?></label>
                <input type="number" id="total_amount" class="form-control" name="total_amount" />
              </div>
              <div class="mb-2">
                <label class="form-label" for="down_payment"><?php echo e(__('locale.Down Payment')); ?></label>
                <input type="number" id="down_payment" class="form-control" name="down_payment" />
              </div>
              <div class="mb-2 d-none">
                <label class="form-label" for="security_amount"><?php echo e(__('locale.Security Amount')); ?></label>
                <input type="number" id="security_amount" class="form-control" name="security_amount" />
              </div>
              <div class="mb-2">
                <label class="form-label" for="no_of_installments"><?php echo e(__('locale.No. of Installments')); ?></label>
                <input type="number" id="no_of_installments" class="form-control" name="no_of_installments" />
              </div>
              <div class="mb-2">
                <label class="form-label" for="installment_amount"><?php echo e(__('locale.Installment Amount')); ?></label>
                <input type="number" id="installment_amount" class="form-control" name="installment_amount" />
              </div>
              <div class="mb-2">
                <label class="form-label" for="due_date"><?php echo e(__('locale.Next Installment Date')); ?></label>
                <input type="text" id="flatpickr-date" class="form-control flatpickr-validation" name="due_date" />
              </div>
              <div class="mb-2">
                <label class="form-label" for="status"><?php echo e(__('locale.Status')); ?></label>
                <select id="status" class="form-select" name="status">
                  <option value="Active"><?php echo e(__('locale.Active')); ?></option>
                  <option value="Completed"><?php echo e(__('locale.Completed')); ?></option>
                  <option value="Cancelled"><?php echo e(__('locale.Cancelled')); ?></option>
                </select>
              </div>
              <input type="hidden" name="pending_amount" id="pending_amount" />
              <input type="hidden" name="paid_installments" id="paid_installments" />
              <input type="hidden" name="old_total_amount" id="old_total_amount" />
              <button type="submit" class="btn btn-primary me-3 data-submit"><?php echo e(__('locale.Submit')); ?></button>
              <button type="reset" class="btn btn-label-danger"
                data-bs-dismiss="offcanvas"><?php echo e(__('locale.Cancel')); ?></button>
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>
  <?php echo $__env->make('_partials/_modals/modal-add-installment', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
  <?php echo $__env->make('_partials/_modals/modal-installment-list', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-script'); ?>
  <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/js/rental.js', 'resources/assets/js/forms-pickers.js']); ?>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    window.permissions = {
      canDeleteRental: <?php echo json_encode(auth()->user()->can('rental-delete'), 15, 512) ?>,
      canEditRental: <?php echo json_encode(auth()->user()->can('rental-edit'), 15, 512) ?>,
      canCreateRental: <?php echo json_encode(auth()->user()->can('rental-create'), 15, 512) ?>
    };

    function calculateInstallment() {
      var totalAmount = parseFloat(document.getElementById('total_amount').value) || 0;
      var downPayment = parseFloat(document.getElementById('down_payment').value) || 0;
      var noOfInstallments = parseInt(document.getElementById('no_of_installments').value) || 0;
      const paidInstallments = parseInt(document.getElementById('paid_installments').value) || 0;
      const oldTotalAmount = parseFloat(document.getElementById('old_total_amount').value) || 0;
      var pendingAmountField = document.getElementById('pending_amount');

      // Amount already paid
      var paidAmount = oldTotalAmount > 0 ? oldTotalAmount - (parseFloat(pendingAmountField.value) || 0) : downPayment;
      // Remaining installments count
      var remainingInstallments = noOfInstallments - paidInstallments;

      if (remainingInstallments > 0) {
        var installmentAmount = (totalAmount - paidAmount) / remainingInstallments;
        document.getElementById('installment_amount').value = installmentAmount.toFixed(2);
      } else {
        document.getElementById('installment_amount').value = 0;
      }
    }

    document.getElementById('total_amount').addEventListener('input', calculateInstallment);
    document.getElementById('down_payment').addEventListener('input', calculateInstallment);
    document.getElementById('no_of_installments').addEventListener('input', calculateInstallment);

    $(document).on('click', '.add-installment', function() {
      let rentalId = $(this).data('id');
      let pendingAmount = $(this).data('pending');
      // Fetch next installment_no from API or calculate client-side
      $.ajax({
        url: `${baseURL}/rentals/${rentalId}/next-installment`, // backend endpoint
        type: 'GET',
        success: function(res) {
          $('#rental_id_installment').val(rentalId);
          $('#installment_no').val(res.data.installment_no);
          $('#amount').val(res.data.amount);
          $('#paid_amount').val(res.data.paid_amount);
          $('#due_date').val(res.data.due_date); // reset
          $('#payment_date').val(new Date().toISOString().split('T')[0]); // today's date (YYYY-MM-DD)

          // Init Flatpickr
          const dueDateInput = document.querySelector('#due_date');
          if (dueDateInput) {
            dueDateInput.flatpickr({
              dateFormat: 'Y-m-d',
              monthSelectorType: 'static',
              defaultDate: res.data.due_date,
              static: true
            });
          }

          const paymentDateInput = document.querySelector('#payment_date');
          if (paymentDateInput) {
            paymentDateInput.flatpickr({
              monthSelectorType: 'static',
              static: true
            });
          }
          $('#addInstallmentModal').modal('show');
        }
      });
    });


    $('#installmentForm').on('submit', function(e) {
      const table = $('.datatables-users').DataTable();
      e.preventDefault();
      $.ajax({
        url: `${baseURL}/installments`,
        method: 'POST',
        data: $(this).serialize(),
        success: function(data) {
          const rental = data.data;
          $('#addInstallmentModal').modal('hide');
          const toastType = data.status == 200 ? 'bg-success' : 'bg-warning';
          window.showToast({
            title: 'Installments 💵',
            message: data.message,
            type: toastType,
            animation: 'animate__fadeInUp',
            time: 'Just now',
            delay: 3000
          });
          const existingRow = table.row(`#trRow-${rental.id}`);
          if (existingRow.node()) {
            existingRow.data(rental).draw(false);
          }

        },
        error: function(err) {
          console.log(err);
        }
      });
    });

    function showInstallments(installments, currency, startDate, totalInstallments, installmentAmount) {
      let tbody = document.getElementById("installmentsBody");
      tbody.innerHTML = "";

      // Ensure installments is parsed into array
      if (typeof installments === "string") {
        try {
          installments = JSON.parse(installments);
        } catch {
          installments = [];
        }
      } else if (!Array.isArray(installments)) {
        installments = [];
      }

      // Calculate total paid amount
      let totalPaid = installments.reduce((sum, ins) => sum + parseFloat(ins.paid_amount || 0), 0);

      let currentDate = new Date(startDate);

      for (let i = 0; i < totalInstallments; i++) {
        currentDate.setMonth(currentDate.getMonth() + (i === 0 ? 0 :
          1)); // first installment = startDate, others +1 month
        const formattedDate = currentDate.toISOString().split("T")[0];

        let amount = parseFloat(installmentAmount);
        let paidAmount = 0;
        let status = "";

        if (totalPaid >= amount) {
          paidAmount = amount;
          totalPaid -= amount;
          status = `<span class="badge bg-success">Paid</span>`;
        } else if (totalPaid > 0 && totalPaid < amount) {
          paidAmount = totalPaid;
          totalPaid = 0;
          status = `<span class="badge bg-warning">Partial</span>`;
        } else {
          paidAmount = 0;
          status = `<span class="badge bg-danger">Unpaid</span>`;
        }

        tbody.innerHTML += `
      <tr>
        <td>${i + 1}</td>
        <td>${formattedDate}</td>
        <td>${currency}${amount.toFixed(2)}</td>
        <td>${currency}${paidAmount.toFixed(2)}</td>
        <td>${status}</td>
      </tr>
    `;
      }

      new bootstrap.Modal(document.getElementById("installmentsModal")).show();
    }
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/layoutMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/intellisensetech/public_html/topsyapp/resources/views/admin/rentals/index.blade.php ENDPATH**/ ?>