<?php

use Illuminate\Support\Facades\Broadcast;

Broadcast::channel('App.Models.User.{id}', function ($user, $id) {
  return (int) $user->id === (int) $id;
});
Broadcast::channel('mc-chat-conversation.{conversationId}', function ($user, $conversationId) {
  // Authorize: return true if user is allowed to join this conversation
  return true;
});
Broadcast::channel('chat.user.{userId}', function ($user, $userId) {
  return (int) $user->id === (int) $userId;
});
Broadcast::channel('user.{userId}', function ($user, $userId) {
  return (int) $user->id === (int) $userId;
});
Broadcast::channel('driver.{driverId}', function ($driver, $driverId) {
  return (int) $driver->id === (int) $driverId;
});
Broadcast::channel('order.{userId}', function ($user, $userId) {
  return (int) $user->id === (int) $userId;
});
Broadcast::channel('ride.{rideId}', function ($user, $rideId) {
  $ride = \App\Models\Ride::find($rideId);
  if (!$ride) {
    return false; // ride not found
  }
  if ($user->user_type === 'Driver') {
    return $user->id === $ride->driver?->user_id;
  }
  return $user->id === $ride->user_id;
});
