@extends('layouts/blankLayout')
@section('page-style')
  @vite(['resources/assets/vendor/scss/pages/front-page-landing.scss'])
  <style>
    .collapse {
      visibility: visible !important;
    }
  </style>
@endsection
@section('page-script')
  @vite(['resources/assets/js/front-page-landing.js'])
@endsection
@section('title', 'FAQ')
@section('content')
  <section id="faq-tabs">
    <div class="row">
      <div class="col-lg-12 col-md-12 col-sm-12 m-3">
        <h2> FAQ'S</h2>
        @foreach ($faqs as $key => $item)
          <div class="accordion" id="accordionExample{{ $key }}">
            <div class="card accordion-item @if ($key == 0) active @endif">
              <h2 class="accordion-header" id="heading{{ $key }}">
                <button type="button" class="accordion-button" data-bs-toggle="collapse"
                  data-bs-target="#accordion{{ $key }}" aria-expanded="true"
                  aria-controls="accordion{{ $key }}">{{ $item->question }}</button>
              </h2>
              <div id="accordion{{ $key }}"
                class="accordion-collapse collapse @if ($key == 0) show @endif"
                data-bs-parent="#accordionExample{{ $key }}">
                <div class="accordion-body"> {{ $item->answer }}</div>
              </div>
            </div>
          </div>
        @endforeach
      </div>
    </div>
  </section>
@endsection
@section('page-script')
@endsection
