@extends('layouts/layoutMaster')

@section('title', __('locale.Subscription Profile'))

@section('vendor-style')
  @vite(['resources/assets/vendor/libs/select2/select2.scss', 'resources/assets/vendor/libs/flatpickr/flatpickr.scss', 'resources/assets/vendor/libs/sweetalert2/sweetalert2.scss', 'resources/assets/vendor/scss/pages/page-pricing.scss'])
@endsection

@section('vendor-script')
  @vite(['resources/assets/vendor/libs/select2/select2.js', 'resources/assets/vendor/libs/flatpickr/flatpickr.js', 'resources/assets/vendor/libs/sweetalert2/sweetalert2.js', 'resources/assets/js/pages-pricing.js'])
@endsection

@section('content')
  @php $currency=Helper::setting('currency_symbol','currency'); @endphp
  <div class="container-xxl">
    @include('_partials/flashMessage')
    <div class="row">
      <div class="@if ($subscription && $customerDeleted == false) col-md-6 @else col-md-12 @endif ">
        <div class="card"
          style="box-shadow: rgba(50, 50, 93, 0.25) 0px 50px 100px -20px, rgba(0, 0, 0, 0.3) 0px 30px 60px -30px, rgba(10, 37, 64, 0.35) 0px -2px 6px 0px inset;">
          @if ($subscription && $customerDeleted == false)
            <div class="card-header d-flex justify-content-between align-items-center">
              <h4 class="card-title">{{ __('locale.Current Subscription') }}</h4>
              @if (Auth::user()->user_type == 'Store')
                <button class="btn btn-label-danger btn-sm" id="cancelSubscriptionBtn"
                  {{ $subscription?->status === 'canceled' ? 'disabled' : '' }}>
                  <i class="icon-base ti tabler-trash icon-14px me-1_5"></i> {{ __('locale.Cancel Subscription') }}
                </button>
              @endif
            </div>

            <div class="card-body row">
              <div class="col-md-12 py-2 border">
                <p class="card-text mb-2"><strong>{{ __('locale.Package') }}:</strong>
                  {{ $subscription['package']?->name }}
                </p>
                <p class="card-text mb-2"><strong>{{ __('locale.ID') }}:</strong>
                  {{ $subscription->stripe_subscription_id }}
                </p>
                <p class="card-text mb-2"><strong>{{ __('locale.Status') }}:</strong>
                  <span
                    class="btn waves-effect btn-text-{{ in_array($subscription->status, ['complete', 'paid']) ? 'success' : 'secondary' }}">
                    {{ ucfirst($subscription->status) }}
                  </span>
                </p>
                <p class="card-text mb-2"><strong>{{ __('locale.Next Billing Date') }}:</strong>
                  {{ \Carbon\Carbon::parse($subscription->next_billing_date)->format('F j, Y') }}</p>
                <p class="card-text mb-2"><strong>{{ __('locale.Total Amount') }}:</strong>
                  ${{ number_format($subscription->amount, 2) }}</p>

                @if ($subscription?->status === 'canceled')
                  <div class="mb-3">
                    <div class="pb-4 rounded-top">
                      <div class="container  px-xl-0 ">
                        <div class="row mx-0 px-lg-1 gy-0">
                          @foreach (\App\Models\Package::all() as $pkg)
                            @include('store.subscriptions.index')
                            <form method="POST" action="{{ route('subscription.subscribe') }}">
                              @csrf
                              <input type="hidden" name="package_id" value="{{ $pkg->id }}">

                              @if ($subscription['package']?->id == $pkg->id)
                                <button type="submit" class="btn btn-primary w-100">
                                  {{ __('locale.Reactivate') }}
                                </button>
                              @else
                                <button type="submit" class="btn btn-primary w-100">
                                  {{ __('locale.Upgrade') }}
                                </button>
                              @endif
                            </form>
                        </div>
                      </div>
                    </div>
                @endforeach
              </div>
            </div>
        </div>
      </div>
    @else
      <button class="btn btn-primary mt-2" id="updatePackageBtn">
        <i class="icon-base ti tabler-plus icon-14px me-1_5"></i> {{ __('locale.Upgrade Package') }}
      </button>
      @endif
    </div>
  </div>
@else
  <div class="card-body">
    <div class="pb-4 rounded-top">
      <div class="container py-1 px-xl-10 px-0">
        <h3 class="text-center mb-2 mt-4">{{ __('locale.Subscription Plans') }}</h3>
        <div class="row mx-0 px-lg-12 gy-6">
          @foreach (\App\Models\Package::with('duration')->get() as $pkg)
            @include('store.subscriptions.index')
            <!-- Action form -->
            <form method="POST" action="{{ route('subscription.subscribe') }}" class="d-grid">
              @csrf
              <input type="hidden" name="package_id" value="{{ $pkg->id }}">
              <button type="submit" class="btn btn-primary w-100">
                {{ __('locale.Subscribe Package') }}
              </button>
            </form>
        </div>
      </div>
    </div>
    @endforeach
  </div>
  </div>
  </div>
  </div>
  @endif
  </div>
  </div>
  @php
    use Carbon\Carbon;
    $today = Carbon::today();
    $start = isset($user->start_date) ? Carbon::parse($user->start_date) : Carbon::parse($user->created_at);
    $end = Carbon::parse($user->end_date);
    $default_days = 15;
    $totalDays = $start && $end ? $start->diffInDays($end) : $default_days; // total days between start and end
    $daysUsed = $start->diffInDays($today);
    $daysRemaining = $end->diffInDays($today, true); // false to get negative value if expired
    $progress = $totalDays > 0 ? min(100, intval(($daysUsed / $totalDays) * 100)) : 0;
  @endphp
  @if ($subscription && Auth::user()->user_type == 'Store')
    <div class="col-md-6">
      <div class="card "
        style="box-shadow: rgba(50, 50, 93, 0.25) 0px 50px 100px -20px, rgba(0, 0, 0, 0.3) 0px 30px 60px -30px, rgba(10, 37, 64, 0.35) 0px -2px 6px 0px inset;">
        <div class="mb-0">
          @if (empty($user['subscriptionRecord']) && $user->end_date >= $today->toDateString())
            <!-- Trial Active -->
            <div style="box-shadow: rgba(17, 17, 26, 0.1) 0px 0px 16px;">
              <div class="alert alert-warning mb-0" role="alert">
                <div class="alert-body fw-normal">{{ __('locale.Your trial period will expire in') }}
                  {{ abs($daysRemaining) }}
                  day{{ $daysRemaining == 1 ? '' : 's' }}. {{ __('locale.Please upgrade your plan.') }}</div>
              </div>
              <div class="plan-statistics pt-1 ms-2 me-2">
                <div class="d-flex justify-content-between">
                  <h5 class="fw-bolder">{{ __('locale.Days') }}</h5>
                  <h5 class="fw-bolder">{{ $daysUsed }} of {{ $totalDays }} {{ __('locale.Days') }}</h5>
                </div>
                <div class="progress">
                  <div class="progress-bar" style="width: {{ $progress }}%;" role="progressbar"
                    aria-valuenow="{{ $progress }}" aria-valuemin="0" aria-valuemax="100"></div>
                </div>
                <p class="mt-50">{{ $daysRemaining }} day{{ $daysRemaining == 1 ? '' : 's' }}
                  {{ __('locale.remaining until your plan requires update') }}</p>
              </div>
            </div>
          @elseif (empty($user['subscriptionRecord']) && $user->end_date < $today->toDateString())
            <!-- Trial Expired -->
            <div class="alert alert-warning mb-2" role="alert">
              <h6 class="alert-heading">{{ __('locale.We need your attention!') }}</h6>
              <div class="alert-body fw-normal">
                {{ __('locale.Your trial period has expired. Please upgrade your plan.') }}</div>
            </div>
          @elseif (!empty($user['subscriptionRecord']) && $user->end_date < $today->toDateString())
            <!-- Package Expired -->
            <div class="alert alert-warning mb-2" role="alert">
              <h6 class="alert-heading">{{ __('locale.We need your attention!') }}</h6>
              <div class="alert-body fw-normal">
                {{ __('locale.Your subscription has expired. Please renew your plan.') }}
              </div>
            </div>
          @else
          @endif
        </div>

        <div class="container">
          <div class="card-header d-flex justify-content-between align-items-center">
            <h4 class="card-title">💳 {{ __('locale.Manage Payment Methods') }}</h4>
          </div>

          {{-- Saved Cards --}}
          <div class="mb-3">
            <h5>{{ __('locale.Saved Cards') }}</h5>
            <?php $seen = []; ?>
            @forelse ($paymentMethods as $card)
              <?php
                $key = $card->card->brand . '|' . $card->card->last4 . '|' . $card->card->exp_month . '|' . $card->card->exp_year;
                if (!in_array($key, $seen)) {
                  $seen[] = $key;
              ?>

              <div
                class="cardMaster rounded border {{ $card->id === $user->default_payment_method ? 'border-success' : 'border-secondary' }} p-2 mb-1">
                <div class="d-flex justify-content-between flex-sm-row flex-column">
                  <div class="card-information">
                    <img class="mb-2 img-fluid" src="{{ asset('assets/img/payments/' . $card->card->brand . '.png') }}"
                      alt="{{ ucfirst($card->card->brand) }}"
                      onerror="this.onerror=null;this.src=`{{ asset('assets/img/placeholder.jpg') }}`;" />
                    <div class="d-flex align-items-center mb-50">

                    </div>
                    <h6 class="card-number">**** **** **** {{ $card->card->last4 }}</h6>
                    <span class="mt-2"><small>{{ __('locale.Expires') }}
                        {{ $card->card->exp_month }}/{{ $card->card->exp_year }}</small></span>
                  </div>
                  <div class="d-flex flex-column text-start text-lg-end">
                    <div class="d-flex order-sm-0 order-1 mt-1 mt-sm-0">
                      @if ($card->id === $user->default_payment_method)
                        <span class="btn btn-label-success btn-sm waves-effect ms-50">{{ __('locale.Default') }}</span>
                      @else
                        <form action="{{ route('stripe.set-default', $card->id) }}" method="POST"
                          class="d-inline mt-0 me-0">
                          @csrf
                          <input type="hidden" name="payment_method" value="{{ $card->id }}" />
                          <button type="submit" class="btn btn-label-primary btn-sm waves-effect ms-50">
                            <i class="icon-base ti tabler-hard-drive icon-14px me-1_5"></i>
                            <span>{{ __('locale.Set as Default') }}</span>
                          </button>
                        </form>
                      @endif
                      @if ($card->id != $user->default_payment_method)
                        <form id="deleteForm" action="{{ route('stripe.delete-card', $card->id) }}" method="POST"
                          class="d-inline ms-1 mt-0">
                          @csrf
                          @method('DELETE')
                          <button type="button" class="btn btn-label-danger btn-sm waves-effect ms-50 deleteBtn">
                            <i class="icon-base ti tabler-trash icon-14px me-1_5"></i>
                            <span></span>
                          </button>
                        </form>
                      @endif
                    </div>

                  </div>
                </div>
              </div>

              <?php } ?>
            @empty
              <p>{{ __('locale.No cards saved yet.') }}</p>
            @endforelse
          </div>

          {{-- Add Card --}}
          <div class="mb-5 p-1"
            style="box-shadow: rgba(0, 0, 0, 0.25) 0px 54px 55px, rgba(0, 0, 0, 0.12) 0px -12px 30px, rgba(0, 0, 0, 0.12) 0px 4px 6px, rgba(0, 0, 0, 0.17) 0px 12px 13px, rgba(0, 0, 0, 0.09) 0px -3px 5px;">
            <h5>{{ __('locale.Add New Card') }}</h5>
            <form id="setup-form">
              @csrf
              <div id="card-element" class="form-control mb-3"></div>
              <button type="submit" class="btn btn-primary">{{ __('locale.Save Card') }}</button>
            </form>
          </div>
        </div>
      </div>
    </div>
  @endif
  </div>

  @if ($transactions->count())
    <div class="card mt-4">
      <div class="card-header pb-0">
        <h4>{{ __('locale.Billing History') }}</h4>
      </div>
      <div class="card-body p-1">
        <div class="card-datatable">
          <table id="tableCategory" class="datatables-ajax table table-bordered table-striped table-hover">
            <thead>
              <tr>
                <th>#</th>
                <th>{{ __('locale.Amount') }}</th>
                <th>{{ __('locale.Status') }}</th>
                <th>{{ __('locale.Txn ID') }}</th>
                <th>{{ __('locale.Date') }}</th>
              </tr>
            </thead>
            <tbody>
              @foreach ($transactions as $index => $txn)
                <tr>
                  <td>{{ $index + 1 }}</td>
                  <td>{{ $currency }}{{ number_format($txn->amount, 2) }}</td>
                  <td>
                    <span class="badge bg-{{ $txn->status === 'Paid' ? 'success' : 'danger' }}">
                      {{ ucfirst($txn->status) }}
                    </span>
                  </td>
                  <td>
                    <button type="button" class="btn btn-primary" data-bs-toggle="popover"
                      data-bs-content="{{ $txn->txn_id }}" data-bs-trigger="hover" title="TXN ID:">
                      {{ \Illuminate\Support\Str::limit($txn->txn_id, 35) }}
                    </button>
                  </td>
                  <td>Txn Date: {{ \Carbon\Carbon::parse($txn->created_at)->format('F j, Y') }}<br><small>Start:
                      {{ \Carbon\Carbon::parse($txn->start_date)->format('F j, Y') }}</small></td>
                </tr>
              @endforeach
            </tbody>
          </table>
        </div>
      </div>
    </div>
  @endif

  <!-- Edit Package Modal -->
  <div class="modal fade" id="updatePackageModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-xl">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">{{ __('locale.Upgrade Package') }}</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body">
          <div class="card-body">
            <div class="pb-4 rounded-top">
              <div class="container  px-xl-10 ">
                <div class="row mx-0 px-lg-12 gy-6">
                  @foreach (\App\Models\Package::all() as $pkg)
                    @include('store.subscriptions.index')
                    <form action="#" method="POST" class="updatePackageForm">
                      @csrf
                      <input type="hidden" name="package_id" id="package_id" value="{{ $pkg->id }}">

                      @if (!empty($subscription) && $subscription['package']?->id == $pkg->id)
                        <button type="button"
                          class="btn btn-label-success d-grid w-100">{{ __('locale.Current Plan') }}</button>
                      @else
                        <button type="submit"
                          class="btn btn-label-primary d-grid w-100">{{ __('locale.Upgrade') }}</button>
                      @endif
                    </form>
                </div>
              </div>
            </div>
            @endforeach
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="modal-footer">

  </div>
  </div>
  </div>
  </div>
@endsection
@section('page-script')
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    $(document).ready(function() {

      $('#cancelSubscriptionBtn').on('click', function(event) {
        event.preventDefault();
        showSwalConfirm({
          title: 'Are you sure to cancel your subscription?',
          text: "You won't be able to revert this!",
          confirmText: 'Yes, Confirm it!',
          onConfirm: function() {
            showSwalLoading('Cancelling...', 'Please wait while we cancel your subscription.');
            sendAjaxRequest({
              type: 'POST',
              url: '{{ route('subscription.cancel') }}',
              data: {
                _token: $('meta[name="csrf-token"]').attr('content'),
                _method: 'POST',
              },
              success: function(data) {
                Swal.close();
                const type = data.status == 200 ? 'bg-success' : 'bg-warning';
                window.showToast({
                  title: 'Subscriptions 💳',
                  message: data.message ?? 'Cancel Subscription',
                  type: type,
                  animation: 'animate__fadeInUp',
                  time: 'Just now',
                  delay: 3000
                });
                if (data.status == 200) {
                  location.reload();
                }
              },
              error: function(xhr) {
                Swal.close();
                if (xhr.status === 422) {
                  // Laravel validation error
                  let errors = xhr.responseJSON.errors;
                  for (let field in errors) {
                    if (errors.hasOwnProperty(field)) {
                      console.log(errors[field][0]);
                    }
                  }
                } else {
                  window.showToast({
                    title: 'Subscriptions 💳',
                    message: 'Something went wrong while canceling.',
                    type: 'danger',
                    animation: 'animate__fadeInUp',
                    time: 'Just now',
                    delay: 3000
                  });
                }

              }
            });
          }
        });
      });
    });

    $(document).ready(function() {
      $('.deleteBtn').on('click', function() {
        showSwalConfirm({
          title: 'Are you sure to delete this payment method ?',
          text: "You won't be able to revert this!",
          confirmText: 'Yes, Confirm it!',
          onConfirm: function() {
            showSwalLoading('Deleting...', 'Please wait while we deleting your payment method.');
            sendAjaxRequest({
              type: 'POST',
              url: $('#deleteForm').attr('action'),
              data: $('#deleteForm').serialize(),
              success: function(data) {
                Swal.close();
                const type = data.status == 200 ? 'bg-success' : 'bg-warning';
                window.showToast({
                  title: 'Subscriptions 💳',
                  message: data.message ?? 'Delete Subscription',
                  type: type,
                  animation: 'animate__fadeInUp',
                  time: 'Just now',
                  delay: 3000
                });
                if (data.status == 200) {
                  location.reload();
                }
              },
              error: function(xhr) {
                Swal.close();
                if (xhr.status === 422) {
                  // Laravel validation error
                  let errors = xhr.responseJSON.errors;
                  for (let field in errors) {
                    if (errors.hasOwnProperty(field)) {
                      console.log(errors[field][0]);
                    }
                  }
                } else {
                  window.showToast({
                    title: 'Subscriptions 💳',
                    message: 'Something went wrong while deleting payment method.',
                    type: 'danger',
                    animation: 'animate__fadeInUp',
                    time: 'Just now',
                    delay: 3000
                  });
                }

              }
            });
            // Option 2: Regular form submission (not AJAX)
            // $('#deleteForm').submit(); // If you're not using AJAX, uncomment this and remove the $.ajax block
          }
        });
      });
    });

    $(document).ready(function() {
      $('#updatePackageBtn').on('click', function() {
        $('#updatePackageModal').modal('show');
      });
      $(document).on('submit', '.updatePackageForm', function(event) {
        event.preventDefault();
        const form = event.target; // ✅ guaranteed to be the form
        if (!(form instanceof HTMLFormElement)) {
          console.error("Not a form element", form);
          return;
        }
        const formData = new FormData(form);
        console.log(formData);
        showSwalConfirm({
          title: 'Are you sure to upgrade your subscription?',
          text: "Your previous subscription will be upgraded, and a new one will begin from the date of upgrade.",
          confirmText: 'Yes, Confirm it!',
          onConfirm: function() {
            showSwalLoading('Processing...', 'Please wait while we upgrade your subscription.');
            //$('#updatePackageForm').serialize(),  //  processData: true,
            sendAjaxRequest({
              type: 'POST',
              url: '{{ route('update.package') }}',
              data: formData,
              success: function(data) {
                $('#updatePackageModal').modal('hide');
                Swal.close();
                const type = data.status == 200 ? 'bg-success' : 'bg-warning';
                window.showToast({
                  title: 'Subscriptions 💳',
                  message: data.message ?? 'Upgrade Subscription',
                  type: type,
                  animation: 'animate__fadeInUp',
                  time: 'Just now',
                  delay: 3000
                });
                if (data.status == 200) {
                  location.reload();
                }
              },
              error: function(xhr) {
                Swal.close();
                if (xhr.status === 422) {
                  // Laravel validation error
                  let errors = xhr.responseJSON.errors;
                  for (let field in errors) {
                    if (errors.hasOwnProperty(field)) {
                      console.log(errors[field][0]);
                    }
                  }
                } else {
                  window.showToast({
                    title: 'Subscriptions 💳',
                    message: 'Something went wrong while upgrading.',
                    type: 'danger',
                    animation: 'animate__fadeInUp',
                    time: 'Just now',
                    delay: 3000
                  });
                }

              }
            });
          }
        });
      });
    });
  </script>

  <script src="https://js.stripe.com/v3/"></script>
  <script>
    const stripe = Stripe('{{ config('cashier.key') }}');
    const elements = stripe.elements();
    const card = elements.create('card');
    card.mount('#card-element');

    const form = document.getElementById('setup-form');
    form.addEventListener('submit', async (e) => {
      e.preventDefault();
      // Show processing alert
      showSwalLoading('Processing...', 'Please wait while we set up your payment method.');
      const {
        setupIntent,
        error
      } = await stripe.confirmCardSetup(
        '{{ $clientSecret }}', {
          payment_method: {
            card: card,
          }
        }
      );

      if (error) {
        Swal.fire({
          icon: 'error',
          title: 'Error',
          text: error.message,
        });
      } else {
        // Submit to server
        fetch('{{ route('stripe.save-payment-method') }}', {
          method: 'POST',
          headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
          },
          body: JSON.stringify({
            payment_method: setupIntent.payment_method
          })
        }).then(() => {
          Swal.close(); // Close the loading dialog
          window.location.reload();
        }).catch(() => {
          Swal.fire({
            icon: 'error',
            title: 'Error',
            text: 'Something went wrong while saving your payment method.',
          });
        });
      }
    });
  </script>
@endsection
