@extends('layouts/layoutMaster')

@section('title', __('locale.Settings'))

<!-- Vendor Styles -->
@section('vendor-style')
  @vite(['resources/assets/vendor/libs/flatpickr/flatpickr.scss', 'resources/assets/vendor/libs/select2/select2.scss'])
@endsection

<!-- Vendor Scripts -->
@section('vendor-script')
  @vite(['resources/assets/vendor/libs/cleave-zen/cleave-zen.js', 'resources/assets/vendor/libs/moment/moment.js', 'resources/assets/vendor/libs/flatpickr/flatpickr.js', 'resources/assets/vendor/libs/select2/select2.js'])
@endsection



@section('content')

  <!-- Form with Tabs -->
  <div class="row">
    <div class="col">
      <h6 class="mt-6">{{ __('locale.Settings') }}</h6>
      <div class="card mb-6">
        <div class="card-body">
          @php $store=\App\Models\Store::where('user_id',auth()->id())->first(); @endphp
          @if ($store->is_cod == 0 && $store->is_online_payment == 0)
            <div class="alert alert-warning mb-3" role="alert">
              <div class="alert-body fw-normal">{{ __('locale.Your Store Not Accept Order') }}
              </div>
            </div>
          @endif
          <h4 class="card-title d-none">{{ __('locale.Payment Methods') }}</h4>
          <label class="switch switch-square switch-lg d-none">
            <input type="checkbox" class="switch-input changestatus" data-id="{{ $store->id }}"
              data-status="{{ $store->is_cod }}" data-url="{{ url('store/store-payment-status') }}/is_cod"
              @if ($store->is_cod == 1) checked @endif>
            <span class="switch-toggle-slider">
              <span class="switch-on">
                <i class="icon-base ti tabler-check"></i>
              </span>
              <span class="switch-off">
                <i class="icon-base ti tabler-x"></i>
              </span>
            </span>
            <span class="switch-label"
              title="@if ($store->is_cod == 1) Accepting COD Payments @else Not COD Payments @endif">
              @if ($store->is_cod == 1)
                {{ __('locale.COD') }}
              @else
                {{ __('locale.No COD') }}
              @endif
            </span>
          </label>
          <br><br>
          <label class="switch switch-square switch-lg d-none">
            <input type="checkbox" class="switch-input changestatus" data-id="{{ $store->id }}"
              data-status="{{ $store->is_online_payment }}"
              data-url="{{ url('store/store-payment-status') }}/is_online_payment"
              @if ($store->is_online_payment == 1) checked @endif>
            <span class="switch-toggle-slider">
              <span class="switch-on">
                <i class="icon-base ti tabler-check"></i>
              </span>
              <span class="switch-off">
                <i class="icon-base ti tabler-x"></i>
              </span>
            </span>
            <span class="switch-label"
              title="@if ($store->is_online_payment == 1) Accepting Online Payments @else Not Accepting Online Payments @endif">
              @if ($store->is_online_payment == 1)
                {{ __('locale.Online Payment') }}
              @else
                {{ __('locale.No Online Payment') }}
              @endif
            </span>
          </label>
        </div>
      </div>
    </div>
  </div>

@endsection
<!-- Page Scripts -->
@section('page-script')
  @vite(['resources/assets/js/form-layouts.js'])
@endsection
