@extends('layouts/layoutMaster')

@section('title', __('locale.Product Details'))

@section('vendor-style')
  @vite(['resources/assets/css/datatables.scss', 'resources/assets/vendor/libs/swiper/swiper.scss', 'resources/assets/vendor/scss/pages/ui-carousel.scss', 'resources/assets/vendor/libs/apex-charts/apex-charts.scss', 'resources/assets/vendor/libs/raty-js/raty-js.scss'])
@endsection

@section('page-style')
  @vite('resources/assets/vendor/scss/pages/page-user-view.scss')
@endsection

@section('vendor-script')
  @vite(['resources/assets/js/datatables.js', 'resources/assets/vendor/libs/moment/moment.js', 'resources/assets/vendor/libs/swiper/swiper.js', 'resources/assets/vendor/libs/apex-charts/apexcharts.js', 'resources/assets/vendor/libs/raty-js/raty-js.js'])
@endsection

@section('page-script')
  @vite(['resources/assets/js/reviews.js', 'resources/assets/js/star-ratings.js', 'resources/assets/js/ui-carousel.js'])
  <script>
    window.permissions = {
      ProductId: @json($product->id),
      reviewableId: @json($product->id),
      reviewableType: @json('product')
    };
    window.reviewData = @json($reviewData['weeklyReviewCounts']);
  </script>
@endsection

@section('content')
  <div class="row">

    @php $currency=$product->currency ?? Helper::setting('currency_symbol', 'currency'); @endphp
    <!-- User Sidebar -->
    <div class="col-xl-4 col-lg-5 order-1 order-md-0">
      <!-- User Card -->
      <div class="card mb-6">
        <div class="card-body pt-12">
          <div class="user-avatar-section">
            <div class=" d-flex align-items-center flex-column">
              <img class="img-fluid rounded mb-4" src="{{ asset('storage/' . $product['images'][0]->file) }}" height="120"
                width="120" alt="Product avatar" />
              <div class="user-info text-center">
                <h5>{{ $product->title ?? '' }}</h5>
                <span class="badge bg-label-success">{{ $product['category']?->parent_name }}</span>
                <span class="badge bg-label-info">{{ $product['category']?->name }}</span>
              </div>
            </div>
          </div>
          <div class="d-flex justify-content-around flex-wrap my-6 gap-0 gap-md-3 gap-lg-4">
            <div class="d-flex align-items-center me-5 gap-4">
              <div class="avatar">
                <div class="avatar-initial bg-label-primary rounded">
                  <i class="icon-base ti tabler-truck-delivery icon-lg"></i>
                </div>
              </div>
              <div>
                <h5 class="mb-0">{{ $product->in_stock == 1 ? 'In Stock' : 'Out of Stock' }}</h5>
                <span>{{ __('locale.Stock Status') }}</span>
              </div>
            </div>
            <div class="d-flex align-items-center gap-4">
              <div class="avatar">
                <div class="avatar-initial bg-label-primary rounded">
                  <i class="icon-base ti tabler-shopping-cart icon-lg"></i>
                </div>
              </div>
              <div>
                <h5 class="mb-0">{{ $product->orders->count() }} @if ($product->orders_quantity_sum > 0)
                    ({{ $product->orders_quantity_sum }})
                  @endif
                </h5>
                <span>{{ __('locale.Product') }} {{ __('locale.Orders') }}</span>
              </div>
            </div>
          </div>
          <h5 class="pb-4 border-bottom mb-4">{{ __('locale.Details') }}</h5>
          <div class="info-container">
            <ul class="list-unstyled mb-6">
              <li class="mb-2">
                <span class="h6">{{ __('locale.Title') }}:</span>
                <span>{{ $product->title }}</span>
              </li>
              <li class="mb-2">
                <span class="h6">{{ __('locale.Sku') }}:</span>
                <span>{{ $product->sku }}</span>
              </li>
              <li class="mb-2">
                <span class="h6">{{ __('locale.Category') }}:</span>
                <span>{{ $product['category']?->parent_name }}</span>
              </li>
              <li class="mb-2">
                <span class="h6">{{ __('locale.Sub Category') }}:</span>
                <span>{{ $product['category']?->name }}</span>
              </li>

              <li class="mb-2">
                <span class="h6">{{ __('locale.Price') }}:</span>
                <span>{{ $currency }}{{ $product->price }}</span>
              </li>
              @if (!empty($product->discounted_price))
                <li class="mb-2">
                  <span class="h6">{{ __('locale.Discounted Price') }}:</span>
                  <span>{{ $currency }}{{ $product->discounted_price }}</span>
                </li>
              @endif
              <li class="mb-2">
                <span class="h6">{{ __('locale.Status') }}:</span>
                <span>
                  @if ($product->status == 1)
                    <span class="badge bg-label-primary">{{ __('locale.Active') }}</span>
                  @else
                    <span class="badge bg-label-secondary">{{ __('locale.Inactive') }}</span>
                  @endif
                </span>
              </li>

              <li class="mb-2">
                <span class="h6">{{ __('locale.Tags') }}:</span>
                <span>
                  @php
                    $tagColors = [
                        'bg-label-primary',
                        'bg-label-secondary',
                        'bg-label-success',
                        'bg-label-danger',
                        'bg-label-warning',
                        'bg-label-info',
                        'bg-label-dark',
                    ];

                    $tags = isset($product->tags) ? explode(',', $product->tags) : [];
                  @endphp

                  <div class="demo-inline-spacing">
                    @foreach ($tags as $tag)
                      @php
                        $color = $tagColors[array_rand($tagColors)];
                      @endphp
                      <span class="badge rounded-pill {{ $color }}">{{ trim($tag) }}</span>
                    @endforeach
                  </div>

                </span>
              </li>

            </ul>
          </div>
        </div>
      </div>
      <!-- /User Card -->

    </div>
    <!--/ User Sidebar -->

    <!-- User Content -->
    <div class="col-xl-8 col-lg-7 order-0 order-md-1">
      <!-- User Pills -->
      <div class="nav-align-top">
        <ul class="nav nav-tabs nav-fill" role="tablist">

          <li class="nav-item">
            <button type="button" class="nav-link active" role="tab" data-bs-toggle="tab"
              data-bs-target="#navs-justified-address" aria-controls="navs-justified-address" aria-selected="false">
              <span class="d-none d-sm-inline-flex align-items-center"><i
                  class="icon-base ti tabler-brand-producthunt icon-sm me-1_5"></i>{{ __('locale.Product Details') }}</span>
              <i class="icon-base ti tabler-brand-producthunt icon-sm d-sm-none"></i>
            </button>
          </li>
          <li class="nav-item">
            <button type="button" class="nav-link" role="tab" data-bs-toggle="tab"
              data-bs-target="#navs-justified-reviews" aria-controls="navs-justified-reviews" aria-selected="false">
              <span class="d-none d-sm-inline-flex align-items-center"><i
                  class="icon-base ti tabler-star icon-sm me-1_5"></i>{{ __('locale.Reviews') }}</span>
              <i class="icon-base ti tabler-star icon-sm d-sm-none"></i>
            </button>
          </li>

        </ul>
      </div>
      <!--/ User Pills -->


      <div class="card mb-6">
        <div class="tab-content">
          <div class="tab-pane fade show active" id="navs-justified-address" role="tabpanel">
            <p>{!! $product->description !!}</p>
            <div class="col-12">
              <h6 class="text-body-secondary mt-4">{{ __('locale.Product Images') }}</h6>
              <div id="swiper-gallery">
                <div class="swiper gallery-top">
                  <div class="swiper-wrapper">
                    @if (isset($product) && $product->images)
                      @foreach ($product->images as $image)
                        <div class="swiper-slide" style="background-image:url({{ asset('storage/' . $image->file) }})">
                        </div>
                      @endforeach
                    @endif
                  </div>
                  <!-- Add Arrows -->
                  <div class="swiper-button-next swiper-button-white"></div>
                  <div class="swiper-button-prev swiper-button-white"></div>
                </div>
                <div class="swiper gallery-thumbs">
                  <div class="swiper-wrapper">
                    @if (isset($product) && $product->images)
                      @foreach ($product->images as $image)
                        <div class="swiper-slide" style="background-image:url({{ asset('storage/' . $image->file) }})">
                        </div>
                      @endforeach
                    @endif
                  </div>

                </div>
              </div>
            </div>
          </div>
          <div class="tab-pane fade" id="navs-justified-reviews" role="tabpanel">
            <div class="row mb-6 g-6">
              {{-- Left: Rating Summary --}}
              <div class="col-md-12">
                <div class="card h-100">
                  <div class="card-body row widget-separator g-0">
                    {{-- Left side with main rating --}}
                    <div class="col-sm-5 border-shift border-end pe-sm-6">
                      <h3 class="text-primary d-flex align-items-center gap-2 mb-2">
                        {{ number_format($reviewData['avg_rating'], 2) }}
                        <i class="icon-base ti tabler-star-filled icon-32px"></i>
                      </h3>
                      <p class="h6 mb-2">{{ __('locale.Total') }} {{ $reviewData['total_reviews'] }}
                        {{ __('locale.Reviews') }}</p>
                      <p class="pe-2 mb-2">{{ __('locale.All reviews are from genuine customers') }}</p>
                      <span class="badge bg-label-primary mb-4 mb-sm-0">
                        +{{ $reviewData['new_reviews'] }} {{ __('locale.This week') }}
                      </span>
                      <hr class="d-sm-none" />
                    </div>

                    {{-- Right side with star progress --}}
                    <div
                      class="col-sm-7 gap-2 text-nowrap d-flex flex-column justify-content-between ps-sm-6 pt-2 py-sm-2">
                      @foreach (range(5, 1) as $star)
                        <div class="d-flex align-items-center gap-2">
                          <small>{{ $star }} Star</small>
                          <div class="progress w-100 bg-label-primary" style="height:8px;">
                            <div class="progress-bar bg-primary" role="progressbar"
                              style="width: {{ $reviewData['progress'][$star]['percent'] ?? 0 }}%"
                              aria-valuenow="{{ $reviewData['progress'][$star]['percent'] ?? 0 }}" aria-valuemin="0"
                              aria-valuemax="100">
                            </div>
                          </div>
                          <small class="w-px-20 text-end">{{ $reviewData['progress'][$star]['count'] ?? 0 }}</small>
                        </div>
                      @endforeach
                    </div>
                  </div>
                </div>
              </div>

              {{-- Right: Weekly Statistics --}}
              <div class="col-md-12">
                <div class="card h-100">
                  <div class="card-body row">
                    <div class="col-sm-5">
                      <div class="mb-12">
                        <h5 class="mb-2 text-nowrap">{{ __('locale.Reviews statistics') }}</h5>
                        <p class="mb-0">
                          <span class="me-2">{{ $reviewData['new_reviews'] }} {{ __('locale.New reviews') }}</span>
                          <span class="badge bg-label-success">
                            +{{ $reviewData['total_reviews'] > 0
                                ? round(($reviewData['new_reviews'] / $reviewData['total_reviews']) * 100, 1)
                                : 0 }}%
                          </span>
                        </p>
                      </div>

                      @php
                        $positiveReviews =
                            ($reviewData['progress'][5]['count'] ?? 0) + ($reviewData['progress'][4]['count'] ?? 0);
                        $positivePercentage =
                            $reviewData['total_reviews'] > 0
                                ? round(($positiveReviews / $reviewData['total_reviews']) * 100, 1)
                                : 0;
                      @endphp

                      <div>
                        <h6 class="mb-2 fw-normal">
                          <span class="text-success me-1">{{ $positivePercentage }}%</span>
                          {{ __('locale.Positive reviews') }}
                        </h6>
                        <small>{{ __('locale.Weekly Report') }}</small>
                      </div>
                    </div>

                    {{-- Placeholder for Chart --}}
                    <div class="col-sm-7 d-flex justify-content-sm-end align-items-end">
                      <div id="reviewsChart"></div>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <!-- review List Table -->
            <div class="card">
              <div class="card-datatable table-responsive">
                <table class="datatables-review table border-top">
                  <thead>
                    <tr>
                      <th></th>
                      <th></th>
                      <th>{{ __('locale.Product') }}</th>
                      <th class="text-nowrap">{{ __('locale.Reviewer') }}</th>
                      <th>{{ __('locale.Review') }}</th>
                      <th>{{ __('locale.Date') }}</th>
                      <th class="text-nowrap">{{ __('locale.Status') }}</th>
                      <th>{{ __('locale.Actions') }}</th>
                    </tr>
                  </thead>
                </table>
              </div>
            </div>
          </div>

        </div>

      </div>
    </div>


  </div>
  <!--/ User Content -->
  </div>
  <!-- /Modal -->
@endsection
