@extends('layouts/layoutMaster')

@section('title', __('locale.Product Add'))

@section('vendor-style')
  @vite(['resources/assets/vendor/libs/quill/typography.scss', 'resources/assets/vendor/libs/quill/katex.scss', 'resources/assets/vendor/libs/quill/editor.scss', 'resources/assets/vendor/libs/select2/select2.scss', 'resources/assets/vendor/libs/dropzone/dropzone.scss', 'resources/assets/vendor/libs/flatpickr/flatpickr.scss', 'resources/assets/vendor/libs/tagify/tagify.scss', 'resources/assets/vendor/libs/sweetalert2/sweetalert2.scss'])
@endsection

@section('vendor-script')
  @vite(['resources/assets/vendor/libs/quill/katex.js', 'resources/assets/vendor/libs/quill/quill.js', 'resources/assets/vendor/libs/select2/select2.js', 'resources/assets/vendor/libs/jquery-repeater/jquery-repeater.js', 'resources/assets/vendor/libs/flatpickr/flatpickr.js', 'resources/assets/vendor/libs/tagify/tagify.js', 'resources/assets/vendor/libs/sweetalert2/sweetalert2.js'])
@endsection

@section('page-script')
  @vite(['resources/assets/js/product-add.js'])
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    window.productDescription = @json($product->description ?? '');
    $(document).ready(function() {
      $('#category-org').on('change', function() {
        const hasVeg = $('#category-org option:selected').data('has-veg');
        if (hasVeg === 1 || hasVeg === '1') {
          $('#veg-options').removeClass('d-none');
        } else {
          $('#veg-options').addClass('d-none');
          $('#veg-options input[type=radio]').prop('checked', false);
          $('#veg').prop('checked', true);
        }
      }).trigger('change'); // run on page load (for edit mode)
    });
  </script>
@endsection

@section('content')
  <div class="app-ecommerce">
    <!-- Add Product -->
    <form id="productForm" method="POST"
      action="{{ isset($product) ? route('products.update', $product->id) : route('products.store') }}"
      enctype="multipart/form-data">
      @csrf
      @if (isset($product))
        @method('PUT')
        <input type="hidden" name="product_id" id="product_id" value="{{ $product->id }}">
      @endif
      <div
        class="card-header sticky-element bg-label-secondary d-flex justify-content-sm-between align-items-sm-center flex-column flex-sm-row p-2">
        <div class="d-flex flex-column justify-content-center">
          <h4 class="mb-1">{{ __('locale.Add a new Product') }}</h4>

        </div>
        <div class="d-flex align-content-center flex-wrap gap-4">
          <button type="submit" class="btn btn-primary" id="submitProduct">{{ __('locale.Publish Product') }}</button>
        </div>
      </div>


      <div class="row">
        <!-- First column-->
        <div class="col-12 col-lg-8">
          <!-- Product Information -->
          <div class="card mb-6">
            <div class="card-header">
              <h5 class="card-tile mb-0">{{ __('locale.Product information') }}</h5>
            </div>
            <div class="card-body">
              <div class="mb-6">
                <label class="form-label" for="ecommerce-product-name">{{ __('locale.Product title') }}</label>
                <input type="text" class="form-control" id="ecommerce-product-name"
                  placeholder="{{ __('locale.Product title') }}" name="title" aria-label="Product title"
                  value="{{ $product->title ?? '' }}" />
              </div>
              <!-- Description -->
              <div>
                <label class="mb-1">{{ __('locale.Description') }} ({{ __('locale.Optional') }})</label>
                <div class="form-control p-0">
                  <div class="comment-toolbar border-0 border-bottom">
                    <div class="d-flex justify-content-start">
                      <span class="ql-formats me-0">
                        <button class="ql-bold"></button>
                        <button class="ql-italic"></button>
                        <button class="ql-underline"></button>
                        <button class="ql-list" value="ordered"></button>
                        <button class="ql-list" value="bullet"></button>
                        <button class="ql-link"></button>
                        <button class="ql-image"></button>
                      </span>
                    </div>
                  </div>
                  <div class="comment-editor border-0 pb-6" id="ecommerce-category-description"></div>
                </div>
              </div>
            </div>
          </div>
          <!-- /Product Information -->
          <!-- Media -->
          <div class="card mb-6">
            <div class="card-header d-flex justify-content-between align-items-center">
              <h5 class="mb-0 card-title">{{ __('locale.Product Image') }}</h5>
            </div>
            <div class="card-body">
              <div class="card-body">
                <div class="dropzone needsclick p-0" id="dropzone-basic" data-url="{{ route('product.upload.temp') }}">
                  <meta name="csrf-token" content="{{ csrf_token() }}">
                  <div class="dz-message needsclick">
                    <p class="h4 needsclick pt-3 mb-2">{{ __('locale.Drag and drop your image here') }}</p>
                    <p class="h6 text-body-secondary d-block fw-normal mb-2">{{ __('locale.or') }}</p>
                    <span class="needsclick btn btn-sm btn-label-primary"
                      id="btnBrowse">{{ __('locale.Browse image') }}</span>
                  </div>
                  <div class="fallback">
                    <input name="file" type="file" />
                  </div>
                </div>

                <div id="uploaded-images" class="row mt-3">
                  @if (isset($product) && $product->images)
                    @foreach ($product->images as $image)
                      <div class="col-md-3 image-box" data-id="{{ $image->id }}">
                        <img src="{{ asset('storage/' . $image->file) }}" class="img-thumbnail" />
                        <button type="button" class="btn btn-sm btn-danger mt-1 delete-image"
                          data-id="{{ $image->id }}">Delete</button>
                      </div>
                    @endforeach
                  @endif
                </div>
              </div>

            </div>
          </div>
          <!-- /Media -->

        </div>
        <!-- /Second column -->

        <!-- Second column -->
        <div class="col-12 col-lg-4">
          <!-- Pricing Card -->
          <div class="card mb-6">
            <div class="card-header">
              <h5 class="card-title mb-0">{{ __('locale.Pricing') }}</h5>
            </div>
            <div class="card-body">
              <!-- Base Price -->
              <div class="mb-6">
                <label class="form-label" for="ecommerce-product-price">{{ __('locale.Base Price') }}</label>
                <input type="number" class="form-control" id="ecommerce-product-price"
                  placeholder="{{ __('locale.Price') }}" name="price" aria-label="Product price"
                  value="{{ $product->price ?? '' }}" />
              </div>
              <!-- Discounted Price -->
              <div class="mb-6">
                <label class="form-label"
                  for="ecommerce-product-discount-price">{{ __('locale.Discounted Price') }}</label>
                <input type="number" class="form-control" id="ecommerce-product-discount-price"
                  placeholder="{{ __('locale.Discounted Price') }}" name="discounted_price"
                  aria-label="Product discounted price" value="{{ $product->discounted_price ?? '' }}" />
              </div>

              <!-- Instock switch -->
              <div class="d-flex justify-content-between align-items-center border-top pt-2">
                <span class="mb-0">{{ __('locale.In stock') }}</span>
                <div class="w-25 d-flex justify-content-end">
                  <div class="form-check form-switch me-n3">
                    <input type="checkbox" name="in_stock" class="form-check-input"
                      @if (empty($product) || ($product->in_stock ?? '') == 1) checked @endif />
                  </div>
                </div>
              </div>
            </div>
          </div>
          <!-- /Pricing Card -->
          <!-- Organize Card -->
          <div class="card mb-6">
            <div class="card-header">
              <h5 class="card-title mb-0">{{ __('locale.Organize') }}</h5>
            </div>
            <div class="card-body">

              <!-- Parent Category -->
              <div class="d-flex justify-content-between align-items-center">
                <div class="mb-3 col ecommerce-select2-dropdown">
                  <label class="form-label" for="parent-category">Parent Category</label>
                  <select id="parent-category" class="select2 form-select" data-placeholder="Select Parent Category">
                    <option value="">{{ __('locale.Select Parent') }}</option>
                    @foreach ($parentCategories as $parent)
                      <option value="{{ $parent->id }}" @if (($product->category->parent_id ?? '') == $parent->id) selected @endif>
                        {{ $parent->name }}</option>
                    @endforeach
                  </select>
                </div>
              </div>
              <!-- Category -->
              <div class="d-flex justify-content-between align-items-center">
                <div class="mb-6 col ecommerce-select2-dropdown">
                  <label class="form-label mb-1" for="category-org">
                    <span>{{ __('locale.Category') }}</span>
                  </label>
                  <select id="category-org" name="category" class="select2 form-select"
                    data-placeholder="Select Category">
                    <option value="">{{ __('locale.Select Category') }}</option>
                    @foreach ($categories as $category)
                      <option value="{{ $category->id }}" data-parent-id="{{ $category->parent?->id }}"
                        data-has-veg="{{ $category->parent?->diet ? '1' : '0' }}"
                        @if (($product->category_id ?? '') == $category->id) selected @endif>
                        {{ $category->name }}</option>
                    @endforeach
                  </select>
                </div>

              </div>

              {{-- Hidden Veg/Non-Veg options --}}
              <div id="veg-options" class="mt-3 d-none">
                <label class="form-label d-block">{{ __('locale.Type') }}</label>
                <div class="form-check form-check-inline">
                  <input class="form-check-input" type="radio" name="veg_type" id="veg" value="veg"
                    @if (empty($product) || ($product->is_non_veg ?? '') == 0) checked @endif>
                  <label class="form-check-label" for="veg">{{ __('locale.Veg') }}</label>
                </div>
                <div class="form-check form-check-inline">
                  <input class="form-check-input" type="radio" name="veg_type" id="nonveg" value="nonveg"
                    @if (($product->is_non_veg ?? '') == 1) checked @endif>
                  <label class="form-check-label" for="nonveg">{{ __('locale.Non-Veg') }}</label>
                </div>
              </div>

              <!-- Status -->
              <div class="mb-6 col ecommerce-select2-dropdown">
                <label class="form-label mb-1" for="status-org">{{ __('locale.Status') }} </label>
                <select id="status-org" name="status" class="select2 form-select" data-placeholder="Published">
                  <option value="1" @if (empty($product) || ($product->status ?? '') == 1) selected @endif>{{ __('locale.Published') }}
                  </option>
                  <option value="0" @if (($product->status ?? '') == 0) selected @endif>{{ __('locale.Inactive') }}
                  </option>
                </select>
              </div>
              <!-- Tags -->
              <div class="d-none">
                <label for="ecommerce-product-tags" class="form-label mb-1">{{ __('locale.Tags') }}</label>
                <input id="ecommerce-product-tags" class="form-control" name="product_tags"
                  value='{{ json_encode(array_map(fn($tag) => ['value' => $tag], explode(',', $product->tags ?? ''))) }}'
                  aria-label="Product Tags" />
              </div>
            </div>
          </div>
          <!-- /Organize Card -->
        </div>
        <!-- /Second column -->
      </div>
    </form>
  </div>

@endsection
