@extends('layouts/layoutMaster')

@section('title', __('locale.Order Details'))

@section('vendor-style')
  @vite(['resources/assets/css/datatables.scss', 'resources/assets/vendor/libs/raty-js/raty-js.scss', 'resources/assets/vendor/scss/pages/app-invoice.scss'])
@endsection

@section('vendor-script')
  @vite(['resources/assets/js/datatables.js', 'resources/assets/vendor/libs/raty-js/raty-js.js', 'resources/assets/js/star-ratings.js'])
@endsection
<style>
  .raty img {
    display: inline-block;
    vertical-align: middle;
    block-size: 1.2rem !important;
    font-size: 1.2rem !important;
    inline-size: 1.2rem !important;
  }

  .raty {
    display: inline-flex;
    align-items: center;
    gap: 0px !important;
  }
</style>
<style>
  @media print {
    #invoiceContent {
      width: 100%;
      padding: 0;
      margin: 0;
    }

    /* Force two columns side by side */
    #invoiceContent .col-xl-6,
    #invoiceContent .col-md-6 {
      width: 50% !important;
      flex: 0 0 50% !important;
      max-width: 50% !important;
      display: inline-block !important;
      vertical-align: top !important;
    }

    /* Fix row */
    #invoiceContent .row {
      display: flex !important;
      flex-wrap: nowrap !important;
      margin: 0 !important;
    }

    /* Hide buttons */
    .btn,
    .no-print {
      display: none !important;
    }
  }
</style>

@section('content')
  @php
    $currency = $order->currency ?? Helper::setting('currency_symbol', 'currency');
  @endphp
  <div
    class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-6 row-gap-4">
    <div class="d-flex flex-column justify-content-center">
      <div class="mb-1"><span class="h5">{{ __('locale.Order') }}
          #{{ $order->order_id }} </span><span class="badge bg-label-success me-1 ms-2">{{ $order->payment_status }}</span>
        <span class="badge bg-label-info" id="orderStatus">{{ $order->status }}</span>
      </div>
      <p class="mb-0">{{ $order->created_at->format('d, M') }}<span id="orderYear">
          {{ $order->created_at->format('Y') }}</span>, {{ $order->created_at->format('h:i A') }}</p>
      <div class="read-only-ratings raty" data-read-only="true" data-score="{{ $order->rating ?? 0 }}" data-number="5">
      </div>
    </div>
    <div class="d-flex align-content-center flex-wrap gap-2">
      <div class="btn-group" id="dropdown-wrapper-{{ $order->id }}">
        <button type="button" class="btn btn-primary" id="newStatus">{{ $order->status ?? 'Placed' }}</button>
        @if ($order->status === 'Delivered')
        @else
          <button type="button" class="btn btn-primary dropdown-toggle dropdown-toggle-split" data-bs-toggle="dropdown"
            aria-expanded="false">
            <span class="visually-hidden">Toggle Dropdown</span>
          </button>
          <ul class="dropdown-menu">
            @php

              $allStatuses = [
                  'Placed',
                  'Accepted',
                  'Preparing',
                  'Ready',
                  'Dispatched',
                  'Out for Delivery',
                  'Delivered',
                  'Cancelled',
              ];
              $performedStatuses = array_unique(array_merge(['Placed'], $performedStatuses));
            @endphp

            @php
              $nextStatus = null;
              foreach ($allStatuses as $status) {
                  // Hide Delivered if order has a ride
                  if ($status === 'Delivered' && $order->ride) {
                      continue;
                  }
                  // Hide Cancelled if Accepted already performed
                  if ($status === 'Cancelled' && in_array('Accepted', $performedStatuses)) {
                      continue;
                  }
                  // Skip already performed statuses
                  if (in_array($status, $performedStatuses)) {
                      continue;
                  }
                  // First valid next status
                  $nextStatus = $status;
                  break;
              }
            @endphp
            @if ($nextStatus)
              <li>
                <a class="dropdown-item change-order-status" href="javascript:void(0);" data-id="{{ $order->id }}"
                  data-status="{{ $nextStatus }}">
                  {{ $nextStatus }}
                </a>
              </li>
            @endif

          </ul>
        @endif

      </div>

    </div>
  </div>

  <!-- Order Details Table -->

  <div class="row">
    <div class="col-12 col-lg-8">
      <div class="card mb-6">
        <div class="card-datatable">
          <table class="datatables-order-details table mb-0">
            <thead>
              <tr>

                <th>{{ __('Image') }}</th>
                <th class="w-50">{{ __('locale.Products') }}</th>
                <th class="w-25">{{ __('locale.Price') }}</th>
                <th class="w-25">{{ __('locale.Qty') }}</th>
                <th>{{ __('locale.Total') }}</th>
              </tr>
            </thead>
            <tbody>
              @foreach ($order->items as $item)
                <tr>

                  <td>
                    <div class="d-flex justify-content-start align-items-center mb-6"> @php $img=$item->product?->image?->file ?? ''; @endphp
                      <img src="{{ url('storage/' . $img) }}" style="width:35px; height:35px" alt="Avatar"
                        class="me-1"
                        onerror="this.onerror=null;this.src='{{ asset('assets/img/placeholder.jpg') }}';" />

                    </div>
                  </td>
                  <td class="w-50">
                    {{ $item->name ?? 'N/A' }}
                  </td>
                  <td class="w-25">{{ $currency }}{{ number_format($item->price, 2) }}</td>
                  <td class="w-25">{{ $item->quantity }}</td>
                  <td>{{ $currency }}{{ number_format($item->price * $item->quantity, 2) }}</td>
                </tr>
              @endforeach
            </tbody>
          </table>

          <div class="d-flex justify-content-end align-items-center m-6 mb-2">
            <div class="order-calculations">
              <div class="d-flex justify-content-start mb-2">
                <span class="w-px-100 text-heading">{{ __('locale.Subtotal') }}:</span>
                <h6 class="mb-0">{{ $currency }}{{ number_format($order->subtotal, 2) }}</h6>
              </div>
              <div class="d-flex justify-content-start mb-2">
                <span class="w-px-100 text-heading">{{ __('locale.Discount') }}:</span>
                <h6 class="mb-0 text-primary">{{ $currency }}{{ number_format($order->discount ?? 0, 2) }}</h6>
              </div>
              <div class="d-flex justify-content-start mb-2">
                <span class="w-px-100 text-heading">{{ __('locale.Shipping') }}:</span>
                <h6 class="mb-0 text-success">{{ $currency }}{{ number_format($order->shipping ?? 0, 2) }}
                </h6>
              </div>
              <div class="d-flex justify-content-start mb-2">
                <span class="w-px-100 text-heading">{{ __('locale.Tax') }}:</span>
                <h6 class="mb-0 text-success">{{ $currency }}{{ number_format($order->tax ?? 0, 2) }}</h6>
              </div>
              <div class="d-flex justify-content-start">
                <h6 class="w-px-100 mb-0">{{ __('locale.Total') }}:</h6>
                <h6 class="mb-0">{{ $currency }}{{ number_format($order->grand_total, 2) }}</h6>
              </div>
            </div>
          </div>
        </div>

      </div>
      <div class="card mb-6">
        <div class="card-header">
          <h5 class="card-title m-0">{{ __('locale.Shipping Activity') }}</h5>
        </div>
        <div class="card-body pt-1">
          <ul class="timeline pb-0 mb-0">
            @forelse($order->statusLogs->sortBy('created_at') as $log)
              <li
                class="timeline-item timeline-item-transparent {{ $loop->last ? 'border-transparent pb-0' : 'border-primary' }}">
                <span
                  class="timeline-point {{ $loop->last ? 'timeline-point-secondary' : 'timeline-point-primary' }}"></span>
                <div class="timeline-event {{ $loop->last ? 'pb-0' : '' }}">
                  <div class="timeline-header">
                    <h6 class="mb-0 text-capitalize">{{ str_replace('_', ' ', $log->status) }}</h6>
                    <small class="text-body-secondary">
                      {{ $log->created_at->format('l h:i A') }}
                    </small>
                  </div>
                  <p class="mt-3 mb-0">
                    {{ Helper::getStatusMessage($log->status) }}
                  </p>
                </div>
              </li>
            @empty
              <li class="timeline-item timeline-item-transparent border-transparent pb-0">
                <span class="timeline-point timeline-point-secondary"></span>
                <div class="timeline-event pb-0">
                  <div class="timeline-header">
                    <h6 class="mb-0">{{ __('locale.No Status Updates') }}</h6>
                  </div>
                </div>
              </li>
            @endforelse
          </ul>
        </div>
      </div>

    </div>
    <div class="col-12 col-lg-4">
      @if (
          $order->status == 'Ready' ||
              $order->status == 'Dispatched' ||
              $order->status == 'Out for Delivery' ||
              $order->status == 'Delivered')
        <!-- Invoice Actions -->
        <div class="col-xl-12 col-md-12 col-12 mb-4 invoice-actions">
          <div class="card">
            <div class="card-body">
              <button class="btn btn-primary d-grid w-100 mb-4" data-bs-toggle="offcanvas"
                data-bs-target="#sendInvoiceOffcanvas">
                <span class="d-flex align-items-center justify-content-center text-nowrap"><i
                    class="icon-base ti tabler-send icon-xs me-2"></i>Send Invoice</span>
              </button>
              <button class="btn btn-label-info d-grid w-100 mb-4" id="downloadInvoiceBtn"> <span
                  class="d-flex align-items-center justify-content-center text-nowrap"><i
                    class="icon-base ti tabler-download icon-xs me-2"></i>Download</span></button>
              <div class="d-flex mb-0">
                <button class="btn btn-label-warning d-grid w-100 mb-4" id="printInvoiceBtn">
                  <span class="d-flex align-items-center justify-content-center text-nowrap"> <i
                      class="icon-base ti tabler-printer icon-xs me-2"></i>Print </span></button>
              </div>
            </div>
          </div>
        </div>
      @endif
      <!-- /Invoice Actions -->
      @if (auth()->user()->user_type != 'Store')
        <div class="card mb-6">
          <div class="card-header">
            <h5 class="card-title m-0"><i class="icon-base ti tabler-building-warehouse icon-lg"></i>
              {{ __('locale.Store Details') }}
            </h5>
          </div>
          <div class="card-body">
            <div class="d-flex justify-content-start align-items-center mb-2">
              <div class="d-flex flex-column">
                <span class="h5 mb-1 text-primary">{{ $order->store->user->name }} </span>
                <p class="mb-0">{{ $order->store->address }}, {{ $order->store->city }}</p>
              </div>
            </div>

            <div class="d-flex justify-content-between">
              <h6 class="mb-1">{{ __('locale.Contact info') }}</h6>
            </div>

            <p class="mb-1">{{ __('locale.Email') }}: {{ $order->store?->user?->email ?? 'N/A' }}</p>
            <p class="mb-0">{{ __('locale.Phone') }}:
              {{ $order->store?->user?->dial_code ?? 'N/A' }}{{ $order->store?->user?->phone ?? 'N/A' }}</p>
          </div>

        </div>
      @endif
      <div class="card mb-6">
        <div class="card-header">
          <h5 class="card-title m-0"><i class="icon-base ti tabler-user icon-lg"></i>
            {{ __('locale.Customer details') }}
          </h5>
        </div>
        <div class="card-body">
          <div class="d-flex justify-content-start align-items-center mb-6">
            <div class="avatar me-3">
              <img
                src="{{ $order->user->profile_photo_path ? asset('storage/' . $order->user->profile_photo_path) : asset('assets/img/placeholder.jpg') }}"
                alt="Avatar" class="rounded-circle"
                onerror="this.onerror=null;this.src='{{ asset('assets/img/placeholder.jpg') }}';" />
            </div>
            <div class="d-flex flex-column">
              <a href="{{ url('users/' . $order->user->id) }}" class="text-body text-nowrap">
                <h6 class="mb-0">{{ $order->user->name ?? 'N/A' }}</h6>
              </a>
              <span>{{ __('locale.Customer ID') }}: #{{ $order->user->id }}</span>
            </div>
          </div>

          <div class="d-flex justify-content-between">
            <h6 class="mb-1">{{ __('locale.Contact info') }}</h6>
          </div>

          <p class="mb-1">{{ __('locale.Email') }}: {{ $order->user->email ?? 'N/A' }}</p>
          <p class="mb-0">{{ __('locale.Phone') }}: {{ $order->user->phone ?? 'N/A' }}</p>
        </div>

      </div>

      @php
        $address = is_array($order->address) ? $order->address : json_decode($order->address, true);
      @endphp


      <div class="card mb-6">
        <div class="card-header d-flex justify-content-between">
          <h5 class="card-title m-0"> <i class="icon-base ti tabler-address-book icon-lg"></i>
            {{ __('locale.Shipping Address') }}</h5>
          <h6 class="m-0">
          </h6>
        </div>
        <div class="card-body">
          @if (!empty($address))
            <p class="mb-0">
              {{ $address['name'] ?? '' }}<br />
              {{ $address['address'] ?? '' }}<br />
              {{ $address['city'] ?? '' }} - {{ $address['postcode'] ?? '' }}<br />
              {{ $address['state'] ?? '' }}<br />
              {{ $address['country'] ?? '' }}
            </p>
          @else
            <p class="mb-0 text-muted">{{ __('locale.No address available.') }}</p>
          @endif
        </div>
      </div>
      <div class="card mb-6">
        <div class="card-header d-flex justify-content-between">
          <h5 class="card-title m-0"> <i class="icon-base ti tabler-credit-card-pay icon-lg"></i>
            {{ __('locale.Platform Commission') }}</h5>
        </div>

        <div class="card-body">
          <h4 class="badge bg-label-info mb-4">{{ $order->currency }} {{ $order->platform_commission }}</h4>

        </div>

      </div>

      <div class="card mb-6">
        <div class="card-header d-flex justify-content-between">
          <h5 class="card-title m-0"> <i class="icon-base ti tabler-credit-card-pay icon-lg"></i>
            {{ __('locale.Payment Details') }}</h5>
        </div>

        <div class="card-body">
          <h4 class="badge bg-label-info mb-4">{{ __('locale.Payment Type') }}: {{ $order->payment_type }}</h4>
          @if ($order->transaction)
            <p class="mb-2">{{ __('locale.Txn ID') }}: {{ $order->transaction->txn_id ?? 'N/A' }}</p>
            <p class="mb-2">{{ __('locale.Payment Type') }}: {{ $order->transaction->payment_mode ?? 'N/A' }}</p>
            <p class="mb-0">{{ __('locale.Amount') }}:
              {{ $order->transaction->currency ?? $currency }}{{ $order->transaction->amount ?? 0 }}</p>
          @endif
        </div>

      </div>



    </div>
  </div>
  <div class="row invoice-preview d-none" id="invoiceContent">
    @include('store.orders.invoice')
  </div>
  @include('_partials/_offcanvas/offcanvas-send-invoice')
  <!-- Modals -->

@endsection
@section('page-script')
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    $(document).on('click', '.change-order-status', function() {
      let orderId = $(this).data('id');
      let status = $(this).data('status');

      $.ajax({
        url: `${baseURL}/orders/${orderId}/status`,
        method: 'POST',
        data: {
          _token: '{{ csrf_token() }}',
          status: status
        },
        success: function(data) {
          const toastType = data.status == 200 ? 'bg-success' : 'bg-warning';
          window.showToast({
            title: 'Orders 🛒',
            message: data.message,
            type: toastType,
            animation: 'animate__fadeInUp',
            time: 'Just now',
            delay: 3000
          });
          if (Array.isArray(data.data[0])) {
            let performedStatuses = data.data[0];
            // Always include "Placed" as performed
            performedStatuses = Array.from(new Set(['Placed', ...performedStatuses]));

            const allStatuses = ['Placed', 'Accepted', 'Preparing', 'Ready', 'Dispatched', 'Out for Delivery',
              'Delivered', 'Cancelled'
            ];
            const newDropdown = allStatuses
              .filter(s => {
                // Hide Delivered if order has a ride
                if (s === 'Delivered' && data.order && data.order.ride) {
                  return false;
                }
                // Hide Cancelled if Accepted already performed
                if (s === 'Cancelled' && performedStatuses.includes('Accepted')) {
                  return false;
                }
                // Hide statuses already performed
                return !performedStatuses.includes(s);
              })
              .slice(0, 1) // keep only the first valid one o show only next status
              .map(s =>
                `<li><a class="dropdown-item change-order-status" href="javascript:void(0);" data-id="${orderId}" data-status="${s}">${s}</a></li>`
              )
              .join('');
            $(`#dropdown-wrapper-${orderId} .dropdown-menu`).html(newDropdown);
            $('#newStatus').text(status);
            $('#orderStatus').text(status);
          }
        },
        error: function(xhr) {
          console.log(xhr.responseJSON);
        }
      });
    });
  </script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
  <script src="https://html2canvas.hertzen.com/dist/html2canvas.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.9.2/html2pdf.bundle.min.js"></script>

  <script>
    document.getElementById('printInvoiceBtn').addEventListener('click', function() {
      const invoice = document.getElementById('invoiceContent').outerHTML;

      // Open a new temporary window
      const printWindow = window.open('', '_blank', 'width=1000,height=800');

      printWindow.document.write(`
    <html>
      <head>
        <title>Invoice</title>
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
        <style>
          body { margin: 20px; }
          .d-none { display: block !important; } /* make sure hidden invoice shows */
          @media print {
            .btn, .no-print { display: none !important; }
            /* Keep Invoice To / Bill To side by side */
            .row > .col-xl-6, .row > .col-md-6 {
              width: 50% !important;
              flex: 0 0 50% !important;
              max-width: 50% !important;
              display: inline-block !important;
              vertical-align: top !important;
            }
            .row {
              display: flex !important;
              flex-wrap: nowrap !important;
              margin: 0 !important;
            }
          }
        </style>
      </head>
      <body>
        ${invoice}
      </body>
    </html>
  `);

      printWindow.document.close();

      // Wait until content is fully loaded
      printWindow.onload = function() {
        printWindow.focus();
        printWindow.print();
        printWindow.close();
      };
    });

    // Download Invoice as PDF
    document.getElementById('downloadInvoiceBtn').addEventListener('click', async function() {
      const {
        jsPDF
      } = window.jspdf;
      const invoice = document.getElementById('invoiceContent');

      // Make hidden content visible for canvas capture
      invoice.classList.remove('d-none');

      // Capture invoice as canvas
      const canvas = await html2canvas(invoice, {
        scale: 2, // higher scale = better quality
        useCORS: true,
      });

      const imgData = canvas.toDataURL('image/png');
      const pdf = new jsPDF('p', 'mm', 'a4');
      const pdfWidth = pdf.internal.pageSize.getWidth();
      const pdfHeight = (canvas.height * pdfWidth) / canvas.width;

      pdf.addImage(imgData, 'PNG', 0, 0, pdfWidth, pdfHeight);
      pdf.save('invoice.pdf');

      // Hide invoice again
      invoice.classList.add('d-none');
    });




    document.addEventListener('DOMContentLoaded', function() {
      const sendInvoiceForm = document.getElementById('sendInvoiceForm');
      const offcanvas = document.getElementById('sendInvoiceOffcanvas');

      // Fill "To", subject and message dynamically
      offcanvas.addEventListener('show.bs.offcanvas', function() {
        const userEmail = '{{ $order->user->email }}';
        const orderId = '{{ $order->order_id }}';
        const totalAmount = '{{ $currency }}{{ number_format($order->grand_total, 2) }}';
        const customerName = '{{ $order->user->name }}';

        document.getElementById('invoice-to').value = userEmail;

        document.getElementById('invoice-message').value =
          `Dear ${customerName},\n\n` +
          `Thank you for your order (ID: ${orderId}). We truly appreciate your business.\n` +
          `Please find your invoice for the total amount of ${totalAmount} attached.\n\n` +
          `Thank you for choosing us!`;

        document.getElementById('invoice-subject').value =
          `Invoice for Order #${orderId} - ${customerName} - Amount: ${totalAmount}`;
      });
      $(document).on('click', '#sendInvoiceForm button[type="submit"]', function() {
        $btn = $(this);
      });
      sendInvoiceForm.addEventListener('submit', async function(e) {
        e.preventDefault();
        toggleButtonLoading($btn, true, 'Sending...');
        try {
          const invoiceElement = document.getElementById('invoiceContent');
          invoiceElement.classList.remove('d-none');
          invoiceElement.style.display = 'block';
          // Generate PDF using html2pdf.js
          const opt = {
            margin: 5,
            filename: `invoice-{{ $order->order_id }}.pdf`,
            image: {
              type: 'jpeg',
              quality: 0.98
            },
            html2canvas: {
              scale: 2
            },
            jsPDF: {
              unit: 'mm',
              format: 'a4',
              orientation: 'p'
            }
          };

          const pdfBlob = await html2pdf().set(opt).from(invoiceElement).outputPdf('blob');

          // Prepare form data
          const formData = new FormData();
          formData.append('_token', document.querySelector('meta[name="csrf-token"]').getAttribute('content'));
          formData.append('to', document.getElementById('invoice-to').value);
          formData.append('subject', document.getElementById('invoice-subject').value);
          formData.append('message', document.getElementById('invoice-message').value);
          formData.append('file', pdfBlob, `invoice-{{ $order->order_id }}.pdf`);

          // Send invoice via fetch
          const res = await fetch(`${baseURL}/send-invoice`, {
            method: 'POST',
            body: formData
          });

          const data = await res.json();
          toggleButtonLoading($btn, false);
          const toastType = data.status === 200 ? 'bg-success' : 'bg-warning';
          window.showToast({
            title: 'Order Invoice 🛒',
            message: data.message,
            type: toastType,
            animation: 'animate__fadeInUp',
            time: 'Just now',
            delay: 3000
          });

          const offcanvasInstance = bootstrap.Offcanvas.getInstance(offcanvas);
          offcanvasInstance.hide();

        } catch (err) {
          toggleButtonLoading($btn, false);
          console.error('Invoice PDF generation/send error:', err);
          window.showToast({
            title: 'Order Invoice 🛒',
            message: 'Invoice PDF generation/send error:',
            type: 'bg-danger',
            animation: 'animate__fadeInUp',
            time: 'Just now',
            delay: 3000
          });
        }
      });
    });
  </script>
@endsection
