@php
  $configData = Helper::appClasses();
@endphp

@extends('layouts/layoutMaster')

@section('title', __('locale.Dashboard'))

@section('vendor-style')
  @vite(['resources/assets/vendor/libs/apex-charts/apex-charts.scss', 'resources/assets/vendor/libs/swiper/swiper.scss', 'resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss', 'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss', 'resources/assets/vendor/fonts/flag-icons.scss'])
@endsection
@section('page-style')
  @vite('resources/assets/vendor/scss/pages/cards-advance.scss')
@endsection
@section('vendor-script')
  @vite(['resources/assets/vendor/libs/apex-charts/apexcharts.js', 'resources/assets/vendor/libs/swiper/swiper.js', 'resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js'])
@endsection

@section('content')
  <div class="row g-6">
    @php $currency=Auth::user()->currency ?? Helper::setting('currency_symbol','currency'); @endphp
    <!-- Website Analytics -->
    <div class="col-xl-6 col">
      <div class="swiper-container swiper-container-horizontal swiper swiper-card-advance-bg"
        id="swiper-with-pagination-cards">
        <div class="swiper-wrapper">
          <div class="swiper-slide">
            <div class="row">
              <div class="col-12">
                <h5 class="text-white mb-0">{{ __('locale.Order Analytics') }}</h5>
              </div>
              <div class="row">
                <div class="col-lg-7 col-md-9 col-12 order-2 order-md-1 pt-md-9">
                  <h6 class="text-white mt-0 mt-md-3 mb-4">{{ __('locale.Total Orders') }}</h6>
                  <div class="row">
                    <div class="col-6">
                      <ul class="list-unstyled mb-0">
                        <li class="d-flex mb-2 align-items-center">
                          <p class="mb-0 fw-medium me-2 website-analytics-text-bg">{{ $orderCount->count() }}</p>
                          <p class="mb-0">{{ __('locale.Orders') }}</p>
                        </li>
                        <li class="d-flex mb-2 align-items-center">
                          <p class="mb-0 fw-medium me-2 website-analytics-text-bg">{{ $orderCount->sum('items_count') }}
                          </p>
                          <p class="mb-0">{{ __('locale.Order Items') }}</p>
                        </li>
                        <li class="d-flex align-items-center">
                          <p class="mb-0 fw-medium me-2 website-analytics-text-bg">{{ $pendingOrderCount }}
                          </p>
                          <p class="mb-0">{{ __('locale.Pending Orders') }}</p>
                        </li>
                      </ul>
                    </div>

                  </div>
                </div>
                <div class="col-lg-5 col-md-3 col-12 order-1 order-md-2 my-4 my-md-0 text-center">
                  <img src="{{ asset('assets/img/illustrations/card-website-analytics-3.png') }}" alt="Website Analytics"
                    height="150" class="card-website-analytics-img" />
                </div>
              </div>
            </div>
          </div>
          <div class="swiper-slide">
            <div class="row">
              <div class="col-12">
                <h5 class="text-white mb-0">{{ __('locale.Product Analytics') }}</h5>
              </div>
              <div class="col-lg-7 col-md-9 col-12 order-2 order-md-1 pt-md-9">
                <h6 class="text-white mt-0 mt-md-3 mb-4">{{ __('locale.Total Products') }}</h6>
                <div class="row">
                  <div class="col-6">
                    <ul class="list-unstyled mb-0">
                      <li class="d-flex mb-4 align-items-center">
                        <p class="mb-0 fw-medium me-2 website-analytics-text-bg">{{ $productCount }}</p>
                        <p class="mb-0">{{ __('locale.Products') }}</p>
                      </li>

                    </ul>
                  </div>

                </div>
                <h6 class="text-white mt-0 mt-md-3 mb-4">{{ __('locale.Wallet') }}</h6>
                <div class="row">
                  <div class="col-6">
                    <ul class="list-unstyled mb-0">
                      <li class="d-flex mb-4 align-items-center">
                        <button class="btn btn-sm btn-success">{{ $currency }}{{ $pendingDues }}</button>
                      </li>

                    </ul>
                  </div>

                </div>
              </div>
              <div class="col-lg-5 col-md-3 col-12 order-1 order-md-2 my-4 my-md-0 text-center">
                <img src="{{ asset('assets/img/illustrations/card-website-analytics-2.png') }}" alt="Website Analytics"
                  height="150" class="card-website-analytics-img" />
              </div>
            </div>
          </div>

        </div>
        <div class="swiper-pagination"></div>
      </div>
    </div>
    <!--/ Website Analytics -->

    <!-- Average Daily Sales -->
    <div class="col-xl-3 col-sm-6">
      <div class="card h-100">
        <div class="card-header pb-0">
          <h5 class="mb-3 card-title">{{ __('locale.Average Daily Sales') }}</h5>
          <p class="mb-0 text-body">{{ __('locale.Total Sales This Month') }}</p>
          <h4 class="mb-0" id="averageDailySalesTotal"></h4>
        </div>
        <div class="card-body px-0">
          <div id="averageDailySales"></div>
        </div>
      </div>
    </div>
    <!--/ Average Daily Sales -->

    <!-- Sales Overview -->
    <div class="col-xl-3 col-sm-6">
      <div class="card h-100">
        <div class="card-header">
          <div class="d-flex justify-content-between">
            <p class="mb-0 text-body">{{ __('locale.Sales Overview') }}</p>
            <p class="card-text fw-medium {{ $sales_percent >= 0 ? 'text-success' : 'text-danger' }}">
              {{ $sales_percent >= 0 ? '+' : '' }}{{ $sales_percent }}%</p>
          </div>
          <h4 class="card-title mb-1">{{ $currency }}{{ $sales->total_sales }}</h4>
        </div>
        <div class="card-body">
          <div class="row">
            <div class="col-12">
              <div class="d-flex gap-2 align-items-center mb-2">
                <span class="badge bg-label-info p-1 rounded">
                  <i class="icon-base ti tabler-shopping-cart icon-sm"></i>
                </span>
                <p class="mb-0">{{ __('locale.Orders') }}</p>
              </div>
              <h5 class="mb-0 pt-1 {{ $orders_percent >= 0 ? 'text-success' : 'text-danger' }}">
                {{ $orders_percent >= 0 ? '+' : '' }}{{ $orders_percent }}%</h5>
              <small class="text-body-secondary">{{ $sales->total_orders }}</small>
            </div>
          </div>
          <div class="d-flex align-items-center mt-6">
            <div class="progress w-100" style="height: 10px;">
              <div class="progress-bar bg-info" style="width: {{ $orders_percent }}%" role="progressbar"
                aria-valuenow="{{ $orders_percent }}" aria-valuemin="0" aria-valuemax="100"></div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!--/ Sales Overview -->

    <!-- Order Placed -->

    <div class="card">
      <div class="card-header">{{ __('locale.Placed Orders') }}</div>
      <div class="card-body">
        <table id="orders-table" class="table">
          <thead>
            <tr>
              <th>{{ __('locale.Order') }}</th>
              <th>{{ __('locale.Date') }}</th>
              <th>{{ __('locale.Customers') }}</th>
              <th>{{ __('locale.Payment') }}</th>
              <th>{{ __('locale.Status') }}</th>
              <th>{{ __('locale.Type') }}</th>
              <th>{{ __('locale.Actions') }}</th>
            </tr>
          </thead>
          <tbody>
            @foreach ($pendingOrders as $order)
              <tr id="row{{ $order->id }}">
                {{-- Order ID --}}
                <td>
                  <a href="{{ url('store/orders/' . $order->id) }}">
                    {{ $order->order_id }}
                  </a>
                </td>

                {{-- Date --}}
                <td>
                  <span class="text-nowrap">
                    {{ $order->created_at->format('M d, Y') }} <br>
                    <small>{{ $order->created_at->format('h:i A') }}</small>
                  </span>
                </td>

                {{-- Customer --}}
                <td>
                  <div class="d-flex justify-content-start align-items-center order-name text-nowrap">
                    <div class="avatar-wrapper">
                      <div class="avatar avatar-sm me-3">
                        @if ($order->user?->profile_image_url)
                          <img src="{{ $order->user?->profile_image_url }}" alt="Avatar" class="rounded-circle">
                        @else
                          @php
                            $states = ['success', 'danger', 'warning', 'info', 'dark', 'primary', 'secondary'];
                            $state = $states[array_rand($states)];
                            $initials = strtoupper(substr($order->user?->name, 0, 2));
                          @endphp
                          <span class="avatar-initial rounded-circle bg-label-{{ $state }}">
                            {{ $initials }}
                          </span>
                        @endif
                      </div>
                    </div>
                    <div class="d-flex flex-column">
                      <h6 class="m-0">
                        <span class="text-heading">{{ $order->user?->name }}</span>
                      </h6>
                      <small>{{ $order->user?->email }}</small>
                    </div>
                  </div>
                </td>

                {{-- Payment --}}
                <td>

                  <h6 class="mb-0 align-items-center d-flex w-px-100 ">
                    {{ $order->payment_status }}
                  </h6>
                  {{ $order->currency }}{{ $order->grand_total }}
                  <br>
                  <small>{{ $order->payment_type }}</small>

                </td>

                {{-- Status --}}
                <td>

                  <span class="badge px-2 text-capitalized">
                    {{ $order->status }}
                  </span>
                  @if ($order->prescriptions)
                    <br>
                    <button class="btn btn-sm btn-primary mt-1 view-prescription" title="Prescriptions"
                      data-image="{{ $order->prescription_image }}">
                      <i class="icon-base ti tabler-prescription"></i>
                    </button>
                  @endif
                </td>

                {{-- Type --}}
                <td>
                  <div class="d-flex align-items-center text-nowrap">
                    <span>{{ $order->payment_type }}</span>
                  </div>
                </td>

                {{-- Actions --}}
                <td>
                  <div class="d-flex justify-content-sm-start align-items-sm-center">
                    <button title="Accept Order"
                      class="btn btn-text-primary rounded-pill waves-effect btn-icon acceptOrder"
                      data-order-id="{{ $order->id }}">
                      <i class="icon-base ti tabler-check"></i>
                    </button>
                    <button class="btn btn-text-secondary rounded-pill waves-effect btn-icon dropdown-toggle hide-arrow"
                      data-bs-toggle="dropdown">
                      <i class="icon-base ti tabler-dots-vertical"></i>
                    </button>
                    <div class="dropdown-menu dropdown-menu-end m-0">
                      <a href="{{ url('store/orders/' . $order->id) }}" class="dropdown-item">View</a>
                    </div>
                  </div>
                </td>
              </tr>
            @endforeach
          </tbody>
        </table>
      </div>
    </div>

    <!-- Order Placed -->

    <!-- Earning Reports -->
    <div class="col-md-6">
      <div class="card h-100">
        <div class="card-header pb-0 d-flex justify-content-between">
          <div class="card-title mb-0">
            <h5 class="mb-1">{{ __('locale.Earning Reports') }}</h5>
            <p class="card-subtitle">{{ __('locale.Weekly Earnings Overview') }}</p>
          </div>

        </div>
        <div class="card-body">
          <div class="row align-items-center g-md-8">
            <div class="col-12 col-md-5 d-flex flex-column">
              <div class="d-flex gap-2 align-items-center mb-3 flex-wrap">
                <h2 class="mb-0">{{ $currency }}{{ number_format($earnings, 2) }}</h2>
                <div class="badge rounded {{ $percentageChange >= 0 ? 'bg-label-success' : 'bg-label-danger' }}">
                  {{ $percentageChange >= 0 ? '+' : '' }}{{ $percentageChange }}%</div>
              </div>
              <small class="text-body">{{ __('locale.You informed of this week compared to last week') }}</small>
            </div>
            <div class="col-12 col-md-7 ps-xl-8">
              <div id="weeklyChart" data-weekly="{{ json_encode($weeklyEarnings) }}"></div>
              <div id="weeklyEarningReports"></div>
            </div>
          </div>
          <div class="border rounded p-5 mt-5">
            <div class="row gap-4 gap-sm-0">
              <div class="col-12 col-sm-4">
                <div class="d-flex gap-2 align-items-center">
                  <div class="badge rounded bg-label-primary p-1"><i class="icon-base icon-md pe-1 ps-1"> ₵ </i></div>
                  <h6 class="mb-0 fw-normal">{{ __('locale.Earnings') }}</h6>
                </div>
                <h4 class="my-2">{{ $currency }}{{ number_format($earnings, 2) }}</h4>
                <div class="progress w-75" style="height:4px">
                  <div class="progress-bar" role="progressbar" style="width: {{ $percentageChange }}%"
                    aria-valuenow="{{ $percentageChange }}" aria-valuemin="0" aria-valuemax="100"></div>
                </div>
              </div>
              <div class="col-12 col-sm-4">
                <div class="d-flex gap-2 align-items-center">
                  <div class="badge rounded bg-label-info p-1"><i class="icon-base ti tabler-chart-pie-2 icon-18px"></i>
                  </div>
                  <h6 class="mb-0 fw-normal">{{ __('locale.Profit') }}</h6>
                </div>
                <h4 class="my-2">{{ $currency }}{{ number_format($profit, 2) }}</h4>
                <div class="progress w-75" style="height:4px">
                  <div class="progress-bar bg-info" role="progressbar" style="width: {{ $percentageChangeProfit }}%"
                    aria-valuenow="{{ $percentageChangeProfit }}" aria-valuemin="0" aria-valuemax="100"></div>
                </div>
              </div>
              <div class="col-12 col-sm-4">
                <div class="d-flex gap-2 align-items-center">
                  <div class="badge rounded bg-label-danger p-1"><i
                      class="icon-base ti tabler-brand-paypal icon-18px"></i></div>
                  <h6 class="mb-0 fw-normal">{{ __('locale.Expense') }}</h6>
                </div>
                <h4 class="my-2">{{ $currency }}{{ number_format($expenses, 2) }}</h4>
                <div class="progress w-75" style="height:4px">
                  <div class="progress-bar bg-danger" role="progressbar"
                    style="width: {{ $percentageChangeExpense }}%" aria-valuenow="{{ $percentageChangeExpense }}"
                    aria-valuemin="0" aria-valuemax="100"></div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <!--/ Earning Reports -->

    <!-- Total Earning -->
    <div class="col-12 col-md-6 col-xxl-4 order-2 order-xl-0">
      <div class="card h-100">
        <div class="card-header">
          <div class="d-flex justify-content-between align-items-center">
            <h5 class="mb-0 card-title">{{ __('locale.Total Earning') }}</h5>
          </div>
          <div class="d-flex align-items-center">
            <h2 class="mb-0 me-2">{{ $currency }}{{ number_format($totalRevenue, 2) }}</h2>
            @if ($percentageChangeList >= 0)
              <i class="icon-base ti tabler-chevron-up text-success me-1"></i>
              <h6 class="text-success mb-0">{{ number_format($percentageChangeList, 1) }}%</h6>
            @else
              <i class="icon-base ti tabler-chevron-down text-danger me-1"></i>
              <h6 class="text-danger mb-0">{{ number_format(abs($percentageChangeList), 1) }}%</h6>
            @endif
          </div>
        </div>

        <div class="card-body">
          <div id="totalEarningChart"></div>

          <div class="d-flex align-items-start my-4">
            <div class="badge rounded bg-label-primary p-2 me-4 rounded">
              <i class="icon-base ti tabler-brand-paypal icon-md"></i>
            </div>
            <div class="d-flex justify-content-between w-100 gap-2 align-items-center">
              <div class="me-2">
                <h6 class="mb-0">{{ __('locale.Total Revenue') }}</h6>
              </div>
              <h6 class="mb-0 text-success">+{{ $currency }}{{ number_format($totalRevenue, 2) }}</h6>
            </div>
          </div>

          <div class="d-flex align-items-start">
            <div class="badge rounded bg-label-secondary p-2 me-4 rounded">
              <i class="icon-base icon-md ps-1 pe-1"> ₵ </i>
            </div>
            <div class="d-flex justify-content-between w-100 gap-2 align-items-center">
              <div class="me-2">
                <h6 class="mb-0">{{ __('locale.Total Sales') }}</h6>
                <small class="text-body">{{ __('locale.Orders Count') }}</small>
              </div>
              <h6 class="mb-0 text-success">{{ $totalSales }}</h6>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!--/ Total Earning -->
  </div>
  @include('_partials/_modals/modal-prescription')
  @include('_partials/_modals/modal-accept-order')
@endsection

@section('page-script')
  {{-- Pass PHP arrays to JS --}}
  <script>
    window.totalEarningChartData = {
      earnings: @json($earningsList),
      expenses: @json($expensesList),
      currency: @json($currency)
    };
  </script>
  @vite('resources/assets/js/dashboards-store.js')
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    let selectedOrderId = null;

    $(document).on('click', '.acceptOrder', function() {
      selectedOrderId = $(this).data('order-id'); // save order ID
      $('#acceptRejectOrderModal').modal('show'); // open modal
    });

    $(document).on('click', '.change-order-status', function() {
      let status = $(this).data('status');

      $.ajax({
        url: `${baseURL}/orders/${selectedOrderId}/status`,
        method: 'POST',
        data: {
          _token: '{{ csrf_token() }}',
          status: status
        },
        success: function(data) {
          const toastType = data.status == 200 ? 'bg-success' : 'bg-warning';
          window.showToast({
            title: 'Orders 🛒',
            message: data.message,
            type: toastType,
            animation: 'animate__fadeInUp',
            time: 'Just now',
            delay: 3000
          });
          $('#row' + selectedOrderId).hide();
          $('#acceptRejectOrderModal').modal('hide'); // close modal
        },
        error: function(xhr) {
          console.log(xhr.responseJSON);
        }
      });
    });
  </script>
@endsection
