@php
  use Illuminate\Support\Facades\Auth;
  use Illuminate\Support\Facades\Route;
@endphp

<!--  Brand demo (display only for navbar-full and hide on below xl) -->
@if (isset($navbarFull))
  <div class="navbar-brand app-brand demo d-none d-xl-flex py-0 me-4 ms-0">
    <a href="{{ url('/') }}" class="app-brand-link">
      <span class="app-brand-logo demo">@include('_partials.macros')</span>
      <span class="app-brand-text demo menu-text fw-bold">{{ config('app.name') }}</span>
    </a>

    <!-- Display menu close icon only for horizontal-menu with navbar-full -->
    @if (isset($menuHorizontal))
      <a href="javascript:void(0);" class="layout-menu-toggle menu-link text-large ms-auto d-xl-none">
        <i class="icon-base ti tabler-x icon-sm d-flex align-items-center justify-content-center"></i>
      </a>
    @endif
  </div>
@endif

<!-- ! Not required for layout-without-menu -->
@if (!isset($navbarHideToggle))
  <div
    class="layout-menu-toggle navbar-nav align-items-xl-center me-4 me-xl-0{{ isset($menuHorizontal) ? ' d-xl-none ' : '' }} {{ isset($contentNavbar) ? ' d-xl-none ' : '' }}">
    <a class="nav-item nav-link px-0 me-xl-6" href="javascript:void(0)">
      <i class="icon-base ti tabler-menu-2 icon-md"></i>
    </a>
  </div>
@endif

<div class="navbar-nav-right d-flex align-items-center justify-content-end" id="navbar-collapse">
  @if (auth()->user()->user_type == 'Store')
    @php $store=\App\Models\Store::where('user_id',auth()->id())->first(); @endphp
    <label class="switch switch-square switch-lg">
      <input type="checkbox" class="switch-input changestatus" data-id="{{ $store->id }}"
        data-status="{{ $store->is_active }}" data-url="{{ url('store/store-status') }}"
        @if ($store->is_active == 1) checked @endif>
      <span class="switch-toggle-slider">
        <span class="switch-on">
          <i class="icon-base ti tabler-check"></i>
        </span>
        <span class="switch-off">
          <i class="icon-base ti tabler-x"></i>
        </span>
      </span>
      <span class="switch-label"
        title="@if ($store->is_active == 1) Accepting Order @else Not Accepting Order @endif">
        @if ($store->is_active == 1)
          {{ __('locale.Online') }}
        @else
          {{ __('locale.Offline') }}
        @endif
      </span>
    </label>


  @endif
  <ul class="navbar-nav flex-row align-items-center ms-md-auto">
    <!-- Language -->
    <li class="nav-item dropdown-language dropdown">
      <a class="nav-link dropdown-toggle hide-arrow btn btn-icon btn-text-secondary rounded-pill"
        href="javascript:void(0);" data-bs-toggle="dropdown">
        <i class="icon-base ti tabler-language icon-22px text-heading"></i>
      </a>
      <ul class="dropdown-menu dropdown-menu-end">
        <li>
          <a class="dropdown-item {{ app()->getLocale() === 'en' ? 'active' : '' }}"
            href="{{ url($adminConfigData['prefix'] . 'lang/en') }}" data-language="en" data-text-direction="ltr">
            <span>English</span>
          </a>
        </li>
      </ul>
    </li>
    <!--/ Language -->

    @if ($configData['hasCustomizer'] == true)
      <!-- Style Switcher -->
      <li class="nav-item dropdown">
        <a class="nav-link dropdown-toggle hide-arrow btn btn-icon btn-text-secondary rounded-pill" id="nav-theme"
          href="javascript:void(0);" data-bs-toggle="dropdown">
          <i class="icon-base ti tabler-sun icon-22px theme-icon-active text-heading"></i>
          <span class="d-none ms-2" id="nav-theme-text">{{ __('locale.Toggle theme') }}</span>
        </a>
        <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="nav-theme-text">
          <li>
            <button type="button" class="dropdown-item align-items-center active" data-bs-theme-value="light"
              aria-pressed="false">
              <span><i class="icon-base ti tabler-sun icon-22px me-3"
                  data-icon="sun"></i>{{ __('locale.Light') }}</span>
            </button>
          </li>
          <li>
            <button type="button" class="dropdown-item align-items-center" data-bs-theme-value="dark"
              aria-pressed="true">
              <span><i class="icon-base ti tabler-moon-stars icon-22px me-3"
                  data-icon="moon-stars"></i>{{ __('locale.Dark') }}</span>
            </button>
          </li>
          <li>
            <button type="button" class="dropdown-item align-items-center" data-bs-theme-value="system"
              aria-pressed="false">
              <span><i class="icon-base ti tabler-device-desktop-analytics icon-22px me-3"
                  data-icon="device-desktop-analytics"></i>{{ __('locale.System') }}</span>
            </button>
          </li>
        </ul>
      </li>
      <!-- / Style Switcher-->
    @endif

    @if (auth()->user()->user_type == 'Admin')
      <!-- Quick links  -->
      <li class="nav-item dropdown-shortcuts navbar-dropdown dropdown">
        <a class="nav-link dropdown-toggle hide-arrow btn btn-icon btn-text-secondary rounded-pill"
          href="javascript:void(0);" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="false">
          <i class="icon-base ti tabler-layout-grid-add icon-22px text-heading"></i>
        </a>
        <div class="dropdown-menu dropdown-menu-end p-0">
          <div class="dropdown-shortcuts-list scrollable-container">
            <div class="row row-bordered overflow-visible g-0">
              @can('event-list')
                <div class="dropdown-shortcuts-item col">
                  <span class="dropdown-shortcuts-icon rounded-circle mb-3">
                    <i class="icon-base ti tabler-calendar icon-26px text-heading"></i>
                  </span>
                  <a href="{{ url($adminConfigData['prefix'] . 'calendar') }}"
                    class="stretched-link">{{ __('locale.Calendar') }}</a>
                  <small>{{ __('locale.Events & Holidays') }}</small>
                </div>
              @endcan
              @can('chat-list')
                <div class="dropdown-shortcuts-item col">
                  <span class="dropdown-shortcuts-icon rounded-circle mb-3">
                    <i class="icon-base ti tabler-message-circle-user icon-26px text-heading"></i>
                  </span>
                  <a href="{{ url($adminConfigData['prefix'] . 'chat') }}"
                    class="stretched-link">{{ __('locale.Chat') }} <span class="badge rounded-pill badge-outline-success"
                      id="chatCounter"></span></a>

                  <small>{{ __('locale.User chat') }}</small>
                </div>
              @endcan
            </div>

            <div class="row row-bordered overflow-visible g-0">
              @can('notification-list')
                <div class="dropdown-shortcuts-item col">
                  <span class="dropdown-shortcuts-icon rounded-circle mb-3">
                    <i class="icon-base ti tabler-mail icon-26px text-heading"></i>
                  </span>
                  <a href="{{ url($adminConfigData['prefix'] . 'email') }}"
                    class="stretched-link">{{ __('locale.Email') }}</a>
                  <small>{{ __('locale.Email & Notifications') }}</small>
                </div>
              @endcan
              @can('role-list')
                <div class="dropdown-shortcuts-item col">
                  <span class="dropdown-shortcuts-icon rounded-circle mb-3">
                    <i class="icon-base ti tabler-users icon-26px text-heading"></i>
                  </span>
                  <a href="{{ url($adminConfigData['prefix'] . 'roles') }}"
                    class="stretched-link">{{ __('locale.Role Management') }}</a>
                  <small>{{ __('locale.Permission') }}</small>
                </div>
              @endcan
            </div>

            <div class="row row-bordered overflow-visible g-0">
              @can('kanban-list')
                <div class="dropdown-shortcuts-item col d-none">
                  <span class="dropdown-shortcuts-icon rounded-circle mb-3">
                    <i class="icon-base ti tabler-device-desktop-analytics icon-26px text-heading"></i>
                  </span>
                  <a href="{{ url($adminConfigData['prefix'] . 'kanban') }}"
                    class="stretched-link">{{ __('locale.kanban') }}</a>
                  <small>{{ __('locale.Admin Notes') }}</small>
                </div>
              @endcan
              @can('data-list')
                <div class="dropdown-shortcuts-item col">
                  <span class="dropdown-shortcuts-icon rounded-circle mb-3">
                    <i class="icon-base ti tabler-settings icon-26px text-heading"></i>
                  </span>
                  <a href="{{ url($adminConfigData['prefix'] . 'settings') }}"
                    class="stretched-link">{{ __('locale.Setting') }}</a>
                  <small>{{ __('locale.Account Settings') }}</small>
                </div>
              @endcan
            </div>

          </div>
        </div>
      </li>
      <!-- Quick links -->
    @endif


    <!-- Notification -->
    <li class="nav-item dropdown-notifications navbar-dropdown dropdown me-3 me-xl-2">
      <a class="nav-link dropdown-toggle hide-arrow btn btn-icon btn-text-secondary rounded-pill"
        href="javascript:void(0);" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="false">
        <span class="position-relative">
          <i class="icon-base ti tabler-bell icon-22px text-heading"></i>
          @if (Auth::check() && count($adminConfigData['notifications']) > 0)
            <span class="badge rounded-pill bg-danger badge-dot badge-notifications border"></span>
          @endif
        </span>
      </a>
      <ul class="dropdown-menu dropdown-menu-end p-0">
        <li class="dropdown-menu-header border-bottom">
          <div class="dropdown-header d-flex align-items-center py-3">
            <h6 class="mb-0 me-auto">{{ __('locale.Notifications') }}</h6>
            <div class="d-flex align-items-center h6 mb-0">
              @if (Auth::check() && count($adminConfigData['notifications']) > 0)
                <span
                  class="badge bg-label-primary me-2 notificationCount">{{ count($adminConfigData['notifications']) }}
                  {{ __('locale.New') }}</span>
                <a href="javascript:void(0)" class="dropdown-notifications-all p-2 btn btn-icon"
                  data-bs-toggle="tooltip" data-bs-placement="top" title="Mark all as read"><i
                    class="icon-base ti tabler-mail-opened text-heading"></i></a>
              @endif

            </div>
          </div>
        </li>
        <li class="dropdown-notifications-list scrollable-container">
          <ul class="list-group list-group-flush">
            @if (Auth::check())
              @forelse ($adminConfigData['notifications'] as $key => $notification)
                <li class="list-group-item list-group-item-action dropdown-notifications-item">
                  <div class="d-flex">
                    <div class="flex-shrink-0 me-3">
                      <div class="avatar">
                        <img
                          src="{{ Auth::user() ? Auth::user()->profile_photo_url : asset('assets/img/placeholder.jpg') }}"
                          alt class="rounded-circle" />
                      </div>
                    </div>
                    <div class="flex-grow-1">
                      <h6 class="small mb-1">{{ $notification->data['head'] }}</h6>
                      <small class="mb-1 d-block text-body">{{ $notification->data['body'] }}</small>
                      <small
                        class="text-body-secondary">{{ \Carbon\Carbon::parse($notification->created_at)->diffForHumans() }}</small>
                    </div>
                    <div class="flex-shrink-0 dropdown-notifications-actions">
                      <a href="{{ url($adminConfigData['prefix'] . $notification->data['url']) }}"
                        class="dropdown-notifications-read {{ $notification->data['color'] }}"><i
                          class="{{ $notification->data['class'] }}"></i></a>
                    </div>
                  </div>
                </li>
              @empty
                <li class="list-group-item list-group-item-action dropdown-notifications-item">
                  <div class="d-flex">
                    <div class="flex-grow-1">
                      <h6 class="small mb-1">{{ __('locale.No New Notification') }}</h6>
                    </div>
                  </div>
                </li>
              @endforelse
            @endif
          </ul>
        </li>
        <li class="border-top">
          <div class="d-grid p-4">
            <a class="btn btn-primary btn-sm d-flex" href="{{ url($adminConfigData['prefix'] . 'notifications') }}">
              <span class="align-middle">{{ __('locale.View all notifications') }}</span>
            </a>
          </div>
        </li>
      </ul>
    </li>
    <!--/ Notification -->
    <!-- User -->
    <li class="nav-item navbar-dropdown dropdown-user dropdown">
      <a class="nav-link dropdown-toggle hide-arrow p-0" href="javascript:void(0);" data-bs-toggle="dropdown">
        <div class="avatar avatar-online">
          <img src="{{ Auth::user() ? Auth::user()->profile_photo_url : asset('assets/img/placeholder.jpg') }}" alt
            class="rounded-circle" />
        </div>
      </a>
      <ul class="dropdown-menu dropdown-menu-end">
        <li>
          <a class="dropdown-item mt-0"
            href="{{ Route::has('profile.show') ? route('profile.show') : url('pages/profile-user') }}">
            <div class="d-flex align-items-center">
              <div class="flex-shrink-0 me-2">
                <div class="avatar avatar-online">
                  <img
                    src="{{ Auth::user() ? Auth::user()->profile_photo_url : asset('assets/img/placeholder.jpg') }}"
                    alt class="rounded-circle" />
                </div>
              </div>
              <div class="flex-grow-1">
                <h6 class="mb-0">
                  @if (Auth::check())
                    {{ Auth::user()->name }}
                  @else
                    John Doe
                  @endif
                </h6>
                <small class="text-body-secondary">
                  @if (Auth::check())
                    {{ Auth::user()->user_type }}
                  @endif
                </small>
              </div>
            </div>
          </a>
        </li>
        <li>
          <div class="dropdown-divider my-1 mx-n2"></div>
        </li>
        <li>
          <a class="dropdown-item"
            href="{{ Route::has('profile.show') ? route('profile.show') : url('pages/profile-user') }}">
            <i class="icon-base ti tabler-user me-3 icon-md"></i><span
              class="align-middle">{{ __('locale.My Profile') }}</span> </a>
        </li>
        @if (Auth::check() && Laravel\Jetstream\Jetstream::hasApiFeatures())
          <li>
            <a class="dropdown-item" href="{{ route('api-tokens.index') }}">
              <i class="icon-base ti tabler-settings me-3 icon-md"></i><span
                class="align-middle">{{ __('locale.API Tokens') }}</span>
            </a>
          </li>
        @endif

        @if (Auth::User() && Laravel\Jetstream\Jetstream::hasTeamFeatures())
          <li>
            <div class="dropdown-divider my-1 mx-n2"></div>
          </li>
          <li>
            <h6 class="dropdown-header">{{ __('locale.Manage Team') }}</h6>
          </li>
          <li>
            <div class="dropdown-divider my-1"></div>
          </li>
          <li>
            <a class="dropdown-item"
              href="{{ Auth::user() ? route('teams.show', Auth::user()->currentTeam->id) : 'javascript:void(0)' }}">
              <i class="icon-base bx bx-cog icon-md me-3"></i><span>{{ __('locale.Team Settings') }}</span>
            </a>
          </li>
          @can('create', Laravel\Jetstream\Jetstream::newTeamModel())
            <li>
              <a class="dropdown-item" href="{{ route('teams.create') }}">
                <i class="icon-base bx bx-user icon-md me-3"></i><span>{{ __('locale.Create New Team') }}</span>
              </a>
            </li>
          @endcan
          @if (Auth::user()->allTeams()->count() > 1)
            <li>
              <div class="dropdown-divider my-1"></div>
            </li>
            <li>
              <h6 class="dropdown-header">{{ __('locale.Switch Teams') }}</h6>
            </li>
            <li>
              <div class="dropdown-divider my-1"></div>
            </li>
          @endif
          @if (Auth::user())
            @foreach (Auth::user()->allTeams() as $team)
              {{-- Below commented code read by artisan command while installing jetstream. !! Do not remove if you want to use jetstream. --}}

              {{-- <x-switchable-team :team="$team" /> --}}
            @endforeach
          @endif
        @endif
        <li>
          <div class="dropdown-divider my-1 mx-n2"></div>
        </li>
        @if (Auth::check())
          <li>
            <a class="dropdown-item" href="{{ route('logout') }}"
              onclick="event.preventDefault(); handleLogout(); ">
              <!-- document.getElementById('logout-form').submit(); -->
              <i class="icon-base bx bx-power-off icon-md me-3"></i><span>{{ __('locale.Logout') }}</span>
            </a>
          </li>
          <form method="POST" id="logout-form" action="{{ url($adminConfigData['prefix'] . 'logout') }}">
            @csrf
          </form>
        @else
          <li>
            <div class="d-grid px-2 pt-2 pb-1">
              <a class="btn btn-sm btn-danger d-flex"
                href="{{ Route::has('login') ? route('login') : url('auth/login-basic') }}" target="_blank">
                <small class="align-middle">{{ __('locale.Login') }}</small>
                <i class="icon-base ti tabler-login ms-2 icon-14px"></i>
              </a>
            </div>
          </li>
        @endif
      </ul>
    </li>
    <!--/ User -->
  </ul>
</div>
