@extends('layouts/layoutMaster')

@section('title', __('locale.Support Tickets'))

<!-- Vendor Styles -->
@section('vendor-style')
  @vite(['resources/assets/css/datatables.scss'])
@endsection

<!-- Vendor Scripts -->
@section('vendor-script')
  @vite(['resources/assets/js/datatables.js'])
@endsection



@section('content')
  <div class="row g-6 mb-6">
    <div class="col-sm-6 col-xl-4">
      <div class="card">
        <div class="card-body p-4">
          <div class="d-flex align-items-start justify-content-between">
            <div class="content-left">
              <span class="text-heading">{{ __('locale.Total Tickets') }}</span>
              <div class="d-flex align-items-center my-1">
                <h4 class="mb-0 me-2" id="s_total"></h4>
              </div>
            </div>
            <div class="avatar">
              <span class="avatar-initial rounded bg-label-primary">
                <i class="icon-base ti tabler-box icon-26px"></i>
              </span>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="col-sm-6 col-xl-4">
      <div class="card">
        <div class="card-body p-4">
          <div class="d-flex align-items-start justify-content-between">
            <div class="content-left">
              <span class="text-heading">{{ __('locale.Open') }}</span>
              <div class="d-flex align-items-center my-1">
                <h4 class="mb-0 me-2" id="s_active"></h4>
              </div>
            </div>
            <div class="avatar">
              <span class="avatar-initial rounded bg-label-danger">
                <i class="icon-base ti tabler-alert-circle icon-26px"></i>
              </span>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="col-sm-6 col-xl-4">
      <div class="card">
        <div class="card-body p-4">
          <div class="d-flex align-items-start justify-content-between">
            <div class="content-left">
              <span class="text-heading">{{ __('locale.Close') }}</span>
              <div class="d-flex align-items-center my-1">
                <h4 class="mb-0 me-2" id="s_inactive"></h4>
              </div>
            </div>
            <div class="avatar">
              <span class="avatar-initial rounded bg-label-success">
                <i class="icon-base ti tabler-check icon-26px"></i>
              </span>
            </div>
          </div>
        </div>
      </div>
    </div>

  </div>
  <div class="card">
    <div class="card-datatable text-nowrap">
      <table class="datatables-users dt-fixedheader table table-bordered">
        <thead>
          <tr>
            <th>S.No</th>
            <th>{{ __('locale.User Details') }}</th>
            <th>{{ __('locale.Category') }}</th>
            <th>{{ __('locale.Subject') }}</th>
            <th>{{ __('locale.Body') }}</th>
            <th>{{ __('locale.Ticket No.') }}</th>
            <th>{{ __('locale.Admin Note') }}</th>
            <th>{{ __('locale.Status') }}</th>
            <th>{{ __('locale.Actions') }}</th>
          </tr>
        </thead>
      </table>
    </div>
  </div>
  @include('_partials/_modals/modal-tickets')
@endsection
<!-- Page Scripts -->
@section('page-script')
  @vite(['resources/assets/js/tickets.js'])
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    $(document).on('click', '.show-modal', function() {
      $('.modal-title-ticket').text('Support Ticket from ' + $(this).data('title'));
      $('#modalTicket').modal('show');
      $('#idStatus').val('Close');
      $('#idTicket').val($(this).data('id'));
    });

    $(document).on('click', '.CloseM', function(event) {
      event.preventDefault();
      const $btn = $(this);
      admin_note = $('#admin_note').val();
      id = $('#idTicket').val();
      status = $('#idStatus').val();
      if (admin_note == "") {
        alert("Admin Note is Required");
        return false;
      }
      var APP_URL = {!! json_encode(url('/')) !!};
      $.ajax({
        type: 'POST',
        url: `${baseURL}/tickets/changestatus`,
        header: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        data: {
          '_method': 'POST',
          '_token': $('meta[name="csrf-token"]').attr('content'),
          'id': id,
          'status': status,
          'admin_note': admin_note,
        },
        beforeSend: function() {
          toggleButtonLoading($btn, true, 'Processing...');
        },
        success: function(data) {
          toggleButtonLoading($btn, false);
          window.showToast({
            title: 'Support Tickets 🎫',
            message: data.message,
            type: 'bg-success',
            animation: 'animate__fadeInUp',
            time: 'Just now',
            delay: 3000
          });
          $('#modalTicket').modal('hide');
          $('#hide-' + data.data).hide();
          $('#tStatus' + data.data).hide();

        },
        error: function(data, e, ts, et) {
          console.log(data);
          toggleButtonLoading($btn, false);
        }
      });
    });
  </script>
@endsection
