@extends('layouts/layoutMaster')

@section('title', __('locale.Terms'))

<!-- Vendor Styles -->
@section('vendor-style')

@endsection

<!-- Vendor Scripts -->
@section('vendor-script')

@endsection

@section('content')

  <!-- Form with Tabs -->
  <div class="card">
    <h5 class="card-header">{{ __('locale.Terms') }}</h6>
      <div class="table-responsive text-nowrap p-2">
        <form method="POST" enctype="multipart/form-data" id="upload_form">
          {{ csrf_field() }}
          <div class="col-lg-12 col-md-12">
            <div class="form-group  d-flex ">
              <button type="submit" id="setSave"
                class="btn mb-2 btn-primary btn-sm mt-2 loading-btn">{{ __('locale.Save Terms') }}
              </button>
            </div>
          </div>
          <div id="full-wrapper">
            <div id="full-container">
              <textarea name="content_data" id="editor">{!! $data !!}</textarea>
            </div>
            <input type="hidden" name="type" value="terms">
          </div>
        </form>
      </div>
  </div>

@endsection
<!-- Page Scripts -->
@section('page-script')
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script src="https://cdn.ckeditor.com/ckeditor5/17.0.0/classic/ckeditor.js"></script>
  <script>
    ClassicEditor
      .create(document.querySelector('#editor'))
      .then(editor => {})
      .catch(error => {});
    $(function() {
      $('#upload_form').on('submit', function(event) {
        event.preventDefault();
        const $btn = $('#setSave');
        $.ajax({
          type: 'POST',
          url: `${baseURL}/postSetting`,
          header: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          },
          data: new FormData(this),
          dataType: 'JSON',
          contentType: false,
          cache: false,
          processData: false,
          beforeSend: function() {
            toggleButtonLoading($btn, true);
          },
          success: function(data) {
            toggleButtonLoading($btn, false);
            window.showToast({
              title: 'Settings ⚙️',
              message: data.message,
              type: 'bg-success',
              animation: 'animate__fadeInUp',
              time: 'Just now',
              delay: 3000
            });
          },
          error: function(data, e, ts, et) {
            toggleButtonLoading($btn, true);
            console.log(data);
          }
        });
      });
    });
  </script>
@endsection
