@extends('layouts/layoutMaster')

@section('title', __('locale.Settings'))

<!-- Vendor Styles -->
@section('vendor-style')
  @vite(['resources/assets/vendor/libs/flatpickr/flatpickr.scss', 'resources/assets/vendor/libs/select2/select2.scss'])
@endsection

<!-- Vendor Scripts -->
@section('vendor-script')
  @vite(['resources/assets/vendor/libs/cleave-zen/cleave-zen.js', 'resources/assets/vendor/libs/moment/moment.js', 'resources/assets/vendor/libs/flatpickr/flatpickr.js', 'resources/assets/vendor/libs/select2/select2.js'])
@endsection



@section('content')

  <!-- Form with Tabs -->
  <div class="row">
    <div class="col">
      <h6 class="mt-6">{{ __('locale.Settings') }}</h6>
      <div class="card mb-6">
        <div class="card-header px-0 pt-0">
          <div class="nav-align-top">
            <ul class="nav nav-tabs" role="tablist">
              <li class="nav-item">
                <button type="button" class="nav-link active" data-bs-toggle="tab" data-bs-target="#form-tabs-personal"
                  aria-controls="form-tabs-personal" role="tab" aria-selected="true"><span
                    class="icon-base ti tabler-settings icon-lg d-sm-none"></span><span
                    class="d-none d-sm-block">{{ __('locale.Site Settings') }}</span></button>
              </li>
              <li class="nav-item">
                <button type="button" class="nav-link" data-bs-toggle="tab" data-bs-target="#form-tabs-price"
                  aria-controls="form-tabs-price" role="tab" aria-selected="false"><span
                    class="icon-base ti tabler-credit-card icon-lg d-sm-none"></span><span class="d-none d-sm-block">
                    {{ __('locale.Price') }} {{ __('locale.Settings') }}</span></button>
              </li>
              <li class="nav-item">
                <button type="button" class="nav-link" data-bs-toggle="tab" data-bs-target="#form-tabs-account"
                  aria-controls="form-tabs-account" role="tab" aria-selected="false"><span
                    class="icon-base ti tabler-user-cog icon-lg d-sm-none"></span><span class="d-none d-sm-block">
                    {{ __('locale.Details') }}</span></button>
              </li>
              <li class="nav-item">
                <button type="button" class="nav-link" data-bs-toggle="tab" data-bs-target="#form-tabs-referral"
                  aria-controls="form-tabs-referral" role="tab" aria-selected="false"><span
                    class="icon-base ti tabler-folder-symlink icon-lg d-sm-none"></span><span
                    class="d-none d-sm-block">{{ __('locale.Referral Settings') }}</span></button>
              </li>
              <li class="nav-item">
                <button type="button" class="nav-link" data-bs-toggle="tab" data-bs-target="#form-tabs-social"
                  aria-controls="form-tabs-social" role="tab" aria-selected="false"><span
                    class="icon-base ti tabler-link icon-lg d-sm-none"></span><span
                    class="d-none d-sm-block">{{ __('locale.Social Links') }}</span></button>
              </li>
              <li class="nav-item">
                <button type="button" class="nav-link" data-bs-toggle="tab" data-bs-target="#form-tabs-app"
                  aria-controls="form-tabs-app" role="tab" aria-selected="false"><span
                    class="icon-base ti tabler-link icon-lg d-sm-none"></span><span
                    class="d-none d-sm-block">{{ __('locale.App Links') }}</span></button>
              </li>

            </ul>
          </div>
        </div>

        <div class="card-body">
          <div class="tab-content p-0">
            <!-- Personal Info -->
            <div class="tab-pane fade active show" id="form-tabs-personal" role="tabpanel">
              <form method="POST" enctype="multipart/form-data" id="upload_form">
                {{ csrf_field() }}
                <div class="row g-6">
                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-form-label text-sm-start"
                        for="formtabs-first-name">{{ __('locale.Currency Symbol') }}</label>
                      <div class="col-sm-12">
                        <input type="text" id="formtabs-first-name" class="form-control" placeholder=""
                          name="currency_symbol" value="{{ $data['currency_symbol'] }}" />
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-form-label text-sm-start"
                        for="formtabs-driver_commission">{{ __('locale.Driver Commission') }}(%)</label>
                      <div class="col-sm-12">
                        <input type="number" id="formtabs-driver_commission" class="form-control" placeholder=""
                          name="driver_commission" value="{{ $data['driver_commission'] }}" />
                      </div>
                    </div>
                  </div>

                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-form-label text-sm-start"
                        for="formtabs-driver_request_simultaneously">{{ __('locale.Driver Request Simultaneously') }}</label>
                      <div class="col-sm-12">
                        <input type="number" id="formtabs-driver_request_simultaneously" class="form-control"
                          placeholder="" name="driver_request_simultaneously"
                          value="{{ $data['driver_request_simultaneously'] }}" />
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-form-label text-sm-start"
                        for="formtabs-driver_response_timeout_seconds">{{ __('locale.Driver Response Timeout') }}(Seconds)</label>
                      <div class="col-sm-12">
                        <input type="number" id="formtabs-driver_response_timeout_seconds" class="form-control"
                          placeholder="" name="driver_response_timeout_seconds"
                          value="{{ $data['driver_response_timeout_seconds'] }}" />
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-form-label text-sm-start"
                        for="formtabs-request_time_minutes">{{ __('locale.Ride Request Timeout') }}(Minutes)</label>
                      <div class="col-sm-12">
                        <input type="number" id="formtabs-request_time_minutes" class="form-control" placeholder=""
                          name="request_time_minutes" value="{{ $data['request_time_minutes'] }}" />
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-form-label text-sm-start" for="formtabs-tax">{{ __('locale.Tax') }}(%)</label>
                      <div class="col-sm-12">
                        <input type="number" id="formtabs-tax" class="form-control" placeholder="" name="tax"
                          value="{{ $data['tax'] }}" />
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-form-label text-sm-start"
                        for="formtabs-tax">{{ __('locale.Driver Waiting Time Start After') }} (Minutes)</label>
                      <div class="col-sm-12">
                        <input type="number" id="formtabs-tax" class="form-control" placeholder=""
                          name="driver_waiting_time_start_after"
                          value="{{ $data['driver_waiting_time_start_after'] }}" />
                      </div>
                    </div>
                  </div>

                  <div class="col-md-6 select2-primary d-none">
                    <div class="row">
                      <label class="col-sm-3 col-form-label text-sm-end"
                        for="formtabs-language">{{ __('locale.Language') }}</label>
                      <div class="col-sm-9">
                        <select id="formtabs-language" class="select2 form-select" multiple>
                          <option value="en" selected>English</option>
                          <option value="fr" selected>French</option>
                          <option value="de">German</option>
                          <option value="pt">Portuguese</option>
                        </select>
                      </div>
                    </div>
                  </div>

                </div>
                <div class="row mt-6">
                  <div class="col-md-12 text-end">
                    <div class="row justify-content-end">
                      <div class="col-sm-12">
                        <input type="hidden" name="type" value="site_setting">
                        <button type="submit" class="btn btn-primary me-4">{{ __('locale.Submit') }}</button>
                        <button type="reset" class="btn btn-label-secondary">{{ __('locale.Cancel') }}</button>
                      </div>
                    </div>
                  </div>
                </div>
              </form>
            </div>
            <!-- Price Details -->
            <div class="tab-pane fade" id="form-tabs-price" role="tabpanel">
              <form method="POST" enctype="multipart/form-data" id="upload_form_price">
                {{ csrf_field() }}
                <div class="row g-6">
                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-form-label text-sm-start" for="formtabs-tax">{{ __('locale.Bad Weather') }}
                        ({{ __('locale.Price Hike Multiplier') }})</label>
                      <div class="col-sm-12">
                        <input type="number" step="0.01" id="formtabs-tax" class="form-control"
                          name="bad_weather" value="{{ $data['bad_weather'] }}" />
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-form-label text-sm-start"
                        for="formtabs-tax">{{ __('locale.Demand Level High') }}
                        ({{ __('locale.Price Hike Multiplier') }})</label>
                      <div class="col-sm-12">
                        <input type="number" step="0.01" id="formtabs-tax" class="form-control"
                          name="demand_level_high" value="{{ $data['demand_level_high'] }}" />
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-form-label text-sm-start"
                        for="formtabs-tax">{{ __('locale.Demand Level Medium') }}
                        ({{ __('locale.Price Hike Multiplier') }})</label>
                      <div class="col-sm-12">
                        <input type="number" step="0.01" id="formtabs-tax" class="form-control"
                          name="demand_level_medium" value="{{ $data['demand_level_medium'] }}" />
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-form-label text-sm-start" for="formtabs-tax">{{ __('locale.Busy Areas') }}
                        ({{ __('locale.Price Hike Multiplier') }})</label>
                      <div class="col-sm-12">
                        <input type="number" step="0.01" id="formtabs-tax" class="form-control" name="busy_areas"
                          value="{{ $data['busy_areas'] }}" />
                      </div>
                    </div>
                  </div>

                </div>
                <button type="button" class="btn btn-primary mt-4" data-bs-toggle="modal"
                  data-bs-target="#siteDocsModal">
                  <i class="icon-base ti tabler-book icon-lg"></i> Site Documentation
                </button>
                <div class="row mt-6">

                  <div class="col-md-12 text-end">
                    <div class="row justify-content-end">
                      <div class="col-sm-12">
                        <input type="hidden" name="type" value="site_setting">
                        <button type="submit" class="btn btn-primary me-4">{{ __('locale.Submit') }}</button>
                        <button type="reset" class="btn btn-label-secondary">{{ __('locale.Cancel') }}</button>
                      </div>
                    </div>
                  </div>
                </div>
              </form>
            </div>
            <!-- Account Details -->
            <div class="tab-pane fade" id="form-tabs-account" role="tabpanel">
              <form method="POST" enctype="multipart/form-data" id="upload_form_account">
                {{ csrf_field() }}
                <div class="row g-6">
                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-sm-3 col-form-label text-sm-end"
                        for="formtabs-contact">{{ __('locale.Contact Number') }}</label>
                      <div class="col-sm-9">
                        <input type="text" id="formtabs-contact" class="form-control" placeholder=""
                          name="contact_number" value="{{ $data['contact_number'] }}" />
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-sm-3 col-form-label text-sm-end"
                        for="formtabs-email">{{ __('locale.Email') }}</label>
                      <div class="col-sm-9">
                        <input type="email" id="formtabs-email" class="form-control" placeholder="" name="email"
                          value="{{ $data['email'] }}" />
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-sm-3 col-form-label text-sm-end"
                        for="formtabs-address">{{ __('locale.Address') }}</label>
                      <div class="col-sm-9">
                        <input type="text" id="formtabs-address" class="form-control" placeholder=""
                          aria-label="" name="address" value="{{ $data['address'] }}" />
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-sm-3 col-form-label text-sm-end"
                        for="formtabs-website">{{ __('locale.Website') }}</label>
                      <div class="col-sm-9">
                        <input type="text" id="formtabs-website" class="form-control phone-mask" placeholder=""
                          aria-label="" name="website" value="{{ $data['website'] }}" />
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-sm-3 col-form-label text-sm-end"
                        for="formtabs-bank">{{ __('locale.Bank Details') }}</label>
                      <div class="col-sm-9">
                        <input type="text" id="formtabs-bank" class="form-control" placeholder=""
                          name="bank_details" value="{{ $data['bank_details'] }}" />
                      </div>
                    </div>
                  </div>

                </div>
                <div class="row mt-6">
                  <div class="col-md-12 text-end">
                    <div class="row justify-content-end">
                      <div class="col-sm-12">
                        <input type="hidden" name="type" value="site_setting">
                        <button type="submit" class="btn btn-primary me-4">{{ __('locale.Submit') }}</button>
                        <button type="reset" class="btn btn-label-secondary">{{ __('locale.Cancel') }}</button>
                      </div>
                    </div>
                  </div>
                </div>
              </form>
            </div>
            <!-- Referral Settngs -->
            <div class="tab-pane fade" id="form-tabs-referral" role="tabpanel">
              <form method="POST" enctype="multipart/form-data" id="referral">
                {{ csrf_field() }}
                <div class="row g-6">
                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-form-label"
                        for="formtabs-daa">{{ __('locale.Mininum Orders For Driver To Get Amount') }}</label>
                      <div class="col-sm-12">
                        <input type="number" id="formtabs-daa" class="form-control" placeholder=""
                          name="driver_min_order" value="{{ $data['driver_min_order'] }}" />
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-form-label" for="formtabs-dia">{{ __('locale.Driver Refer Amount') }}</label>
                      <div class="col-sm-12">
                        <input type="number" id="formtabs-dia" class="form-control" placeholder=""
                          name="driver_refer_amount" value="{{ $data['driver_refer_amount'] }}" />
                      </div>
                    </div>
                  </div>

                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-form-label"
                        for="formtabs-caa">{{ __('locale.Mininum Orders For Customer To Get Amount') }}</label>
                      <div class="col-sm-12">
                        <input type="number" id="formtabs-caa" class="form-control" placeholder=""
                          name="customer_min_order" value="{{ $data['customer_min_order'] }}" />
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-form-label" for="formtabs-cia">{{ __('locale.Customer Refer Amount') }}</label>
                      <div class="col-sm-12">
                        <input type="number" id="formtabs-cia" class="form-control" placeholder=""
                          name="customer_refer_amount" value="{{ $data['customer_refer_amount'] }}" />
                      </div>
                    </div>
                  </div>

                </div>
                <div class="row mt-6">
                  <div class="col-md-12 text-end">
                    <div class="row justify-content-end">
                      <div class="col-sm-12">
                        <input type="hidden" name="type" value="referral">
                        <button type="submit" class="btn btn-primary me-4">{{ __('locale.Submit') }}</button>
                        <button type="reset" class="btn btn-label-secondary">{{ __('locale.Cancel') }}</button>
                      </div>
                    </div>
                  </div>
                </div>
              </form>
            </div>
            <!-- Social Links -->
            <div class="tab-pane fade" id="form-tabs-social" role="tabpanel">
              <form method="POST" enctype="multipart/form-data" id="social">
                {{ csrf_field() }}
                <div class="row g-6">
                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-sm-3 col-form-label text-sm-end"
                        for="formtabs-twitter">{{ __('locale.Twitter') }}</label>
                      <div class="col-sm-9">
                        <input type="text" id="formtabs-twitter" class="form-control"
                          placeholder="https://twitter.com/" name="twitter" value="{{ $data['twitter'] }}" />
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-sm-3 col-form-label text-sm-end"
                        for="formtabs-facebook">{{ __('locale.Facebook') }}</label>
                      <div class="col-sm-9">
                        <input type="text" id="formtabs-facebook" class="form-control"
                          placeholder="https://facebook.com/" name="facebook" value="{{ $data['facebook'] }}" />
                      </div>
                    </div>
                  </div>

                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-sm-3 col-form-label text-sm-end"
                        for="formtabs-linkedin">{{ __('locale.Linkedin') }}</label>
                      <div class="col-sm-9">
                        <input type="text" id="formtabs-linkedin" class="form-control"
                          placeholder="https://linkedin.com/" name="linkdin" value="{{ $data['linkdin'] }}" />
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-sm-3 col-form-label text-sm-end"
                        for="formtabs-instagram">{{ __('locale.Instagram') }}</label>
                      <div class="col-sm-9">
                        <input type="text" id="formtabs-instagram" class="form-control"
                          placeholder="https://instagram.com/" name="instagram" value="{{ $data['instagram'] }}" />
                      </div>
                    </div>
                  </div>

                </div>
                <div class="row mt-6">
                  <div class="col-md-12 text-end">
                    <div class="row justify-content-end">
                      <div class="col-sm-12">
                        <input type="hidden" name="type" value="social_links">
                        <button type="submit" class="btn btn-primary me-4">{{ __('locale.Submit') }}</button>
                        <button type="reset" class="btn btn-label-secondary">{{ __('locale.Cancel') }}</button>
                      </div>
                    </div>
                  </div>
                </div>
              </form>
            </div>
            <!-- App Links -->
            <div class="tab-pane fade" id="form-tabs-app" role="tabpanel">
              <form method="POST" enctype="multipart/form-data" id="app">
                {{ csrf_field() }}
                <div class="row g-6">
                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-form-label"
                        for="formtabs-daa">{{ __('locale.Driver Android App Link') }}</label>
                      <div class="col-sm-12">
                        <input type="text" id="formtabs-daa" class="form-control" placeholder=""
                          name="driver_android_app_link" value="{{ $data['driver_android_app_link'] }}" />
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-form-label" for="formtabs-dia">{{ __('locale.Driver iOS App Link') }}</label>
                      <div class="col-sm-12">
                        <input type="text" id="formtabs-dia" class="form-control" placeholder=""
                          name="driver_ios_app_link" value="{{ $data['driver_ios_app_link'] }}" />
                      </div>
                    </div>
                  </div>

                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-form-label"
                        for="formtabs-caa">{{ __('locale.Customer Android App Link') }}</label>
                      <div class="col-sm-12">
                        <input type="text" id="formtabs-caa" class="form-control" placeholder=""
                          name="customer_android_app_link" value="{{ $data['customer_android_app_link'] }}" />
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-form-label" for="formtabs-cia">{{ __('locale.Customer iOS App Link') }}</label>
                      <div class="col-sm-12">
                        <input type="text" id="formtabs-cia" class="form-control" placeholder=""
                          name="customer_ios_app_link" value="{{ $data['customer_ios_app_link'] }}" />
                      </div>
                    </div>
                  </div>

                </div>
                <div class="row mt-6">
                  <div class="col-md-12 text-end">
                    <div class="row justify-content-end">
                      <div class="col-sm-12">
                        <input type="hidden" name="type" value="app_links">
                        <button type="submit" class="btn btn-primary me-4">{{ __('locale.Submit') }}</button>
                        <button type="reset" class="btn btn-label-secondary">{{ __('locale.Cancel') }}</button>
                      </div>
                    </div>
                  </div>
                </div>
              </form>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  @include('_partials._modals.modal-site-settings');
  @include('_partials._modals.modal-developer-password');
@endsection
<!-- Page Scripts -->
@section('page-script')
  @vite([])
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    $(document).ready(function() {
      initCountryDrop("#formtabs-contact");
    })

    $(function() {
      let $btn = null;

      // Track the clicked submit button
      $(document).on('click',
        '#upload_form button[type="submit"], #developerPasswordError#upload_form_price button[type="submit"], #social button[type="submit"], #upload_form_account button[type="submit"], #app button[type="submit"], #referral button[type="submit"]',
        function() {
          $btn = $(this);
        });

      // Handle form submission
      $('#upload_form, #upload_form_price, #social, #upload_form_account, #app, #referral').on('submit', function(
        event) {
        event.preventDefault();
        const form = this;
        // Only add developer password confirmation for #upload_form
        if ($(form).attr('id') === 'upload_form' || $(form).attr('id') === 'upload_form_price') {
          $.get(`${baseURL}/developer-password/check`, function(data) {
            if (data.attempts_left <= 0) {
              window.showToast({
                title: 'Settings ⚙️',
                message: 'Too many attempts. Please wait before trying again.',
                type: 'bg-danger',
                animation: 'animate__fadeInUp',
                time: 'Just now',
                delay: 3000
              });
              $('#developerPasswordModal').modal('hide');
              toggleButtonLoading($btn, false);
            } else {
              $('#developerPasswordModal').modal('show');
            }
          });

          $('#developerPasswordError').hide();
          $('#developer_password').val('');

          // Handle modal confirm click
          $('#submitWithPassword').off('click').on('click', function() {
            const password = $('#developer_password').val().trim();

            if (!password) {
              $('#developerPasswordError').text('Password is required').show();
              return;
            }

            // AJAX check developer password
            $.ajax({
              type: 'POST',
              url: `${baseURL}/check-developer-password`,
              headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
              },
              data: {
                developer_password: password
              },
              dataType: 'JSON',
              success: function(res) {
                if (res.valid) {
                  submitFormWithAjax(form, $btn); // Submit the form after password check
                } else {}
              },
              error: function() {}
            });
          });

          return; // Prevent default submission until password confirmed
        }

        // Other forms without password check
        submitFormWithAjax(form, $btn);
      });

      // Reusable AJAX submit function
      function submitFormWithAjax(form, $btn) {
        $.ajax({
          type: 'POST',
          url: `${baseURL}/postSiteSetting`,
          headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          },
          data: new FormData(form),
          dataType: 'JSON',
          contentType: false,
          cache: false,
          processData: false,
          beforeSend: function() {
            toggleButtonLoading($btn, true, 'Saving...');
          },
          success: function(data) {
            $('#developerPasswordModal').modal('hide');
            toggleButtonLoading($btn, false);
            window.showToast({
              title: 'Settings ⚙️',
              message: data.message,
              type: 'bg-success',
              animation: 'animate__fadeInUp',
              time: 'Just now',
              delay: 3000
            });
          },
          error: function(data) {
            toggleButtonLoading($btn, false);
            console.log(data);
          }
        });
      }
    });
  </script>
@endsection
