@php
  $configData = Helper::appClasses();
@endphp

@extends('layouts/layoutMaster')

@section('title', __('locale.Faqs'))

@section('vendor-style')
  @vite(['resources/assets/css/datatables.scss'])
@endsection

@section('vendor-script')
  @vite(['resources/assets/js/datatables.js'])
@endsection



@section('content')

  <!-- Faq cards -->
  <div class="row g-6">
    <div class="col-12">
      <!-- Faq Table -->
      <div class="card">
        <div class="card-datatable">
          <table class="datatables-users table border-top">
            <thead>
              <tr>
                <th valign="middle">#</th>
                <th>{{ __('locale.Question') }}</th>
                <th>{{ __('locale.Answer') }}</th>
                <th>{{ __('locale.Status') }}</th>
                <th></th>
                <th></th>
                <th>{{ __('locale.Actions') }}</th>
              </tr>
            </thead>
          </table>
        </div>
      </div>
      <!--/ Faq Table -->
    </div>
  </div>
  <!--/ Faq cards -->
  <!-- Offcanvas to add new user -->
  <div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasAdd" aria-labelledby="offcanvasAddLabel">
    <div class="offcanvas-header border-bottom">
      <h5 id="offcanvasAddLabel" class="offcanvas-title">{{ __('locale.Add New Faq') }}</h5>
      <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body mx-0 flex-grow-0 p-6 h-100">
      <form class="add-new-faq pt-0" id="upload_form" method="POST" action="{{ route('faqs.store') }}">
        {{ csrf_field() }}
        <input type="hidden" name="id" id="user_id">
        <div class="mb-6 form-control-validation">
          <label class="form-label" for="add-user-fullname">{{ __('locale.Question') }}</label>
          <input type="text" class="form-control" id="add-user-fullname" placeholder="{{ __('locale.Question') }}"
            name="question" aria-label="John Doe" />
        </div>
        <div class="mb-6 form-control-validation">
          <label class="form-label" for="add-user-email">{{ __('locale.Answer') }}</label>
          <input type="text" id="add-user-email" class="form-control" placeholder="{{ __('locale.Answer') }}"
            aria-label="" name="answer" />
        </div>
        <input type="hidden" name="type" value="FAQS">
        <button type="submit" class="btn btn-primary me-3 data-submit">{{ __('locale.Submit') }}</button>
        <button type="reset" class="btn btn-label-danger"
          data-bs-dismiss="offcanvas">{{ __('locale.Cancel') }}</button>
      </form>
    </div>
  </div>

  <div class="modal fade text-left faq-edit-modal" id="inlineForm" tabindex="-1" role="dialog"
    aria-labelledby="myModalLabel33" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title" id="myModalLabel33">{{ __('locale.Edit') }} </h4>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <form class="add-new-faq pt-0" id="edit_form" method="POST" action="">
          {{ csrf_field() }}
          <div class="alert alert-danger display-error" style="display: none"> </div>
          <div class="modal-body">
            <div class="row">
              <div class="col-sm-12">
                <div class="form-group">
                  <label>{{ __('locale.Question') }}</label>
                  <div class="controls">
                    <input type="text" name="question" id="question_edit" class="form-control"
                      placeholder="{{ __('locale.Question') }}" required="" aria-invalid="false">
                    <div class="help-block"></div>
                  </div>
                </div>
              </div>
              <div class="col-sm-12">
                <label>{{ __('locale.Answer') }}</label>
                <fieldset class="form-group">
                  <textarea class="form-control" id="answer_edit" rows="3" name="answer" placeholder="{{ __('locale.Answer') }}"
                    required="" aria-invalid="false"></textarea>
                  <div class="help-block"></div>
                </fieldset>
              </div>
            </div>
            <div class="modal-footer">
              <input type="hidden" class="form-control" id="id_edit">
              <input type="hidden" class="form-control" name="_method" value="PUT">
              <button type="submit"
                class="btn btn-primary waves-effect waves-light edit mt-2">{{ __('locale.Update') }}</button>
            </div>
            {!! Html::form()->close() !!}
            <div class="message_box_modal" style="margin:10px 0px;text-align: center;">
            </div>
          </div>
      </div>
    </div>
  </div>

  <div id="role-helper" data-add="{{ __('locale.Add New Faq') }}"></div>
@endsection
@section('page-script')
  @vite(['resources/assets/js/forms-selects.js', 'resources/assets/js/faqs.js'])
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    window.permissions = {
      canDeleteFaq: @json(auth()->user()->can('data-delete')),
      canEditFaq: @json(auth()->user()->can('data-edit'))
    };
    $(function() {
      const table = $('.datatables-users').DataTable(); // Initialize your DataTable
      let $btn = null;
      $(document).on('click',
        '#upload_form button[type="submit"]',
        function() {
          $btn = $(this);
        });
      $('#upload_form').on('submit', function(event) {
        event.preventDefault();
        var APP_URL = {!! json_encode(url('/')) !!};
        $.ajax({
          type: "POST",
          header: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          },
          url: `${baseURL}/faqs`,
          data: new FormData(this),
          dataType: 'JSON',
          contentType: false,
          cache: false,
          processData: false,
          beforeSend: function() {
            toggleButtonLoading($btn, true, 'Saving...');
          },
          success: function(data) {
            if (data.status === 200 && data.data) {
              const faq = data.data;
              const newRow = table.row.add(faq).draw(false);
              $(newRow.node()).attr('id', `trRow-${faq.id}`);
              table.order([5, 'desc']).draw(false);
              $('#upload_form')[0].reset(); // clear form
              // ✅ Hide the offcanvas
              const offcanvasEl = document.getElementById('offcanvasAdd');
              const bsOffcanvas = bootstrap.Offcanvas.getInstance(offcanvasEl);
              if (bsOffcanvas) bsOffcanvas.hide();
            }
            toggleButtonLoading($btn, false);
            const toastType = data.status == 200 ? 'bg-success' : 'bg-warning';
            window.showToast({
              title: 'FAQS 💡',
              message: data.message,
              type: toastType,
              animation: 'animate__fadeInUp',
              time: 'Just now',
              delay: 3000
            });
          },
          error: function(xhr) {
            toggleButtonLoading($btn, false);
            console.log(xhr.responseJSON);
          }
        });
      });
    });
    //edit data
    $(document).on('click', '.edit-faq-modal', function() {
      $('.modal-title').text('Edit ' + $(this).data('title'));
      $('#id_edit').val($(this).data('id'));
      $('#question_edit').val($(this).data('title'));
      $('#answer_edit').text($(this).data('answer'));
      id = $('#id_edit').val();
      $('#inlineForm').modal('show');
    });
    $(function() {
      const table = $('.datatables-users').DataTable();
      let $btn = null;
      $(document).on('click',
        '#edit_form button[type="submit"]',
        function() {
          $btn = $(this);
        });
      $('#edit_form').on('submit', function(event) {
        event.preventDefault();
        var APP_URL = {!! json_encode(url('/')) !!};
        $.ajax({
          type: 'POST',
          url: `${baseURL}/faqs/${id}`,
          header: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          },
          data: new FormData(this),
          dataType: 'JSON',
          contentType: false,
          cache: false,
          processData: false,
          beforeSend: function() {
            toggleButtonLoading($btn, true, 'Saving...');
          },
          success: function(data) {
            if (data.status === 200 && data.data) {
              const faq = data.data;
              const existingRow = table.row(`#trRow-${faq.id}`);
              if (existingRow.node()) {
                existingRow.data(faq).draw(false);
              }
              $('#inlineForm').modal('hide');
            }
            toggleButtonLoading($btn, false);
            const toastType = data.status == 200 ? 'bg-success' : 'bg-warning';
            window.showToast({
              title: 'FAQS 💡',
              message: data.message,
              type: toastType,
              animation: 'animate__fadeInUp',
              time: 'Just now',
              delay: 3000
            });
          },
          error: function(xhr) {
            toggleButtonLoading($btn, false);
            console.log(xhr.responseJSON);
          }
        });
      });
    });
  </script>
@endsection
