@php
  $configData = Helper::appClasses();
@endphp

@extends('layouts/layoutMaster')

@section('title', __('locale.Roles'))

@section('vendor-style')
  @vite(['resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss', 'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss', 'resources/assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.scss', 'resources/assets/vendor/libs/select2/select2.scss', 'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss', 'resources/assets/vendor/libs/@form-validation/form-validation.scss', 'resources/assets/vendor/libs/sweetalert2/sweetalert2.scss', 'resources/assets/vendor/libs/datatables-fixedheader-bs5/fixedheader.bootstrap5.scss'])
@endsection

@section('vendor-script')
  @vite(['resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js', 'resources/assets/vendor/libs/select2/select2.js', 'resources/assets/vendor/libs/@form-validation/popular.js', 'resources/assets/vendor/libs/@form-validation/bootstrap5.js', 'resources/assets/vendor/libs/@form-validation/auto-focus.js', 'resources/assets/vendor/libs/cleave-zen/cleave-zen.js', 'resources/assets/vendor/libs/sweetalert2/sweetalert2.js'])
@endsection



@section('content')

  <h4 class="mb-1">{{ __('locale.Roles List') }}</h4>

  <p class="mb-6">
    {!! __('locale.Roles List Message') !!}

  </p>
  <!-- Role cards -->
  <div class="row g-6">
    @include('_partials/flashMessage')
    @foreach ($roles as $key => $role)
      <div class="col-xl-4 col-lg-6 col-md-6" id="hide-{{ $role->id }}">
        <div class="card">
          <div class="card-body">
            <div class="d-flex justify-content-between align-items-center mb-4">
              <h6 class="fw-normal mb-0 text-body">{{ __('locale.Total') }} {{ $role->users()->count() }}
                {{ __('locale.user') }}</h6>
              <ul class="list-unstyled d-flex align-items-center avatar-group mb-0">
                @foreach ($role->users as $key => $user)
                  <li data-bs-toggle="tooltip" data-popup="tooltip-custom" title="{{ $user->name }}"
                    data-bs-placement="top" title="Vinnie Mostowy" class="avatar pull-up">
                    <img class="rounded-circle" src="{{ \App\Models\User::find($user->id)->profile_photo_url }}"
                      alt="Avatar" />
                  </li>
                @endforeach

              </ul>
            </div>
            <div class="d-flex justify-content-between align-items-end">
              <div class="role-heading">
                <h5 class="mb-1">{{ $role->name }}</h5>
                @can('role-edit')
                  <a href="#" class="editRoleModal" data-permissions="{{ $role->permissions()->pluck('name') }}"
                    data-val="{{ $role->permissions()->pluck('id') }}" data-name="{{ $role->name }}"
                    data-role="{{ $role->id }}"
                    data-color="{{ $role->color }}"><span>{{ __('locale.Edit Role') }}</span></a>
                @endcan
              </div>
              @can('role-delete')
                <button type="button" class="btn btn-icon btn-danger delete-modal" data-toggle="modal"
                  data-target="#inlineFormDelete" data-id="{{ $role->id }}" data-title="{{ $role->name }}"
                  data-url="{{ url('admin/roles') }}/{{ $role->id }}">
                  <i class="icon-base ti tabler-trash icon-md text-heading"></i>
                </button>
              @endcan

            </div>
          </div>
        </div>
      </div>
    @endforeach
    @can('role-create')
      <div class="col-xl-4 col-lg-6 col-md-6">
        <div class="card h-100">
          <div class="row h-100">
            <div class="col-sm-5">
              <div class="d-flex align-items-end h-100 justify-content-center mt-sm-0 mt-4">
                <img src="{{ asset('assets/img/illustrations/add-new-roles.png') }}" class="img-fluid" alt="Image"
                  width="83" />
              </div>
            </div>
            <div class="col-sm-7">
              <div class="card-body text-sm-end text-center ps-sm-0">
                <button data-bs-target="#addRoleModal" data-bs-toggle="modal"
                  class="btn btn-sm btn-primary mb-4 text-nowrap add-new-role">{{ __('locale.Add new role') }}</button>
                <p class="mb-0">
                  {{ __('locale.Add new role') }}, <br />
                  {{ __("locale.if it doesn't exist") }}.
                </p>
              </div>
            </div>
          </div>
        </div>
      </div>
    @endcan
    <div class="col-12">
      <h4 class="mt-6 mb-1"> {{ __('locale.Total users with their roles') }}</h4>
      <p class="mb-0"> {{ __('locale.Find all of your company’s administrator accounts and their associate roles.') }}
      </p>
    </div>
    <div class="col-12">
      <!-- Role Table -->
      <div class="card">
        <div class="card-datatable">
          <table class="datatables-users table border-top">
            <thead>
              <tr>
                <th></th>
                <th></th>
                <th>{{ __('locale.User') }}</th>
                <th>{{ __('locale.Role') }}</th>
                <th>{{ __('locale.Phone') }}</th>
                <th>{{ __('locale.Status') }}</th>
                <th>{{ __('locale.Actions') }}</th>
              </tr>
            </thead>
          </table>
        </div>
      </div>
      <!--/ Role Table -->
    </div>
  </div>
  <!--/ Role cards -->
  <!-- Offcanvas to add new user -->
  <div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasAddUser" aria-labelledby="offcanvasAddUserLabel">
    <div class="offcanvas-header border-bottom">
      <h5 id="offcanvasAddUserLabel" class="offcanvas-title">{{ __('locale.Add User') }}</h5>
      <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body mx-0 flex-grow-0 p-6 h-100">
      <form class="add-new-user pt-0" id="addNewUserForm" method="POST" action="{{ route('roles.user.store') }}">
        {{ csrf_field() }}
        <input type="hidden" name="id" id="user_id">
        <div class="mb-6 form-control-validation">
          <label class="form-label" for="add-user-fullname">{{ __('locale.Full Name') }}</label>
          <input type="text" class="form-control" id="add-user-fullname" placeholder="John Doe" name="name"
            aria-label="John Doe" />
        </div>
        <div class="mb-6 form-control-validation">
          <label class="form-label" for="add-user-email">{{ __('locale.Email') }}</label>
          <input type="text" id="add-user-email" class="form-control" placeholder="john.doe@example.com"
            aria-label="john.doe@example.com" name="email" />
        </div>
        <div class="mb-6">
          <label class="form-label" for="add-user-contact">{{ __('locale.Contact Number') }}</label>
          <input type="text" id="add-user-contact" class="form-control phone-mask" placeholder="609 988 4411"
            aria-label="" name="phone" />
          <input type="hidden" id="dial_code" name="dial_code">
          <input type="hidden" name="dial_code_iso" id="country_iso">
        </div>

        <div class="mb-6">
          <label class="form-label" for="user-role">{{ __('locale.User Role') }}</label>
          <select id="user-role" class="select2 form-select" name="roles">
            @foreach (Spatie\Permission\Models\Role::orderBy('name', 'Asc')->get() as $key => $val)
              <option value="{{ $val->id }}">{{ $val->name }}</option>
            @endforeach
          </select>
        </div>
        <div class="mb-6">
          <label class="form-label" for="add-user-password">{{ __('locale.Password') }}</label>
          <input type="password" id="add-user-password" class="form-control" placeholder="" name="password" />
        </div>
        <button type="submit" class="btn btn-primary me-3 data-submit">{{ __('locale.Submit') }}</button>
        <button type="reset" class="btn btn-label-danger"
          data-bs-dismiss="offcanvas">{{ __('locale.Cancel') }}</button>
      </form>
    </div>
  </div>
  <div class="modal fade text-left" id="inlineRoleForm" tabindex="-1" role="dialog"
    aria-labelledby="myModalLabel33" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered modal-dialog-scrollable" role="document">
      <div class="modal-content">

        <div class="modal-header">
          <h4 class="modal-title" id="myModalLabel33">{{ __('locale.Edit') }}</h4>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <form class="" id="edit_form" method="POST" action="">
            <input type="hidden" name="id" id="id_edit">
            {{ csrf_field() }}
            <div class="row">
              <div class="col-sm-12 mb-1">
                <div class="form-group">
                  <div class="controls">
                    <label class="form-label" for="name">
                      {{ __('locale.Full Name') }}
                    </label>
                    <input type="text" class="form-control dt-full-name" id="edit_name" placeholder="John Doe"
                      name="name">
                    <div class="help-block"></div>
                  </div>
                </div>
              </div>
              <div class="col-sm-12 mb-1">
                <div class="form-group">
                  <div class="controls">
                    <label class="form-label" for="name">
                      {{ __('locale.Email') }}
                    </label>
                    <input type="text" id="edit_email" class="form-control dt-email"
                      placeholder="john.doe@example.com" name="email">
                    <div class="help-block"></div>
                  </div>
                </div>
              </div>
              <div class="col-sm-12 mb-1">
                <div class="form-group">
                  <label class="form-label" for="icon">
                    {{ __('locale.Contact Number') }}
                  </label>
                  <div class="custom-file">
                    <input type="text" id="edit_phone" class="form-control dt-contact" placeholder="609 933 4422"
                      name="phone" autocomplete="off" data-intl-tel-input-id="0">
                    <input type="hidden" id="dial_code_edit" name="dial_code">
                    <input type="hidden" name="dial_code_iso" id="country_iso_edit">
                  </div>
                </div>
              </div>

              <div class="col-sm-12 mb-1">
                <div class="form-group">
                  <div class="controls">
                    <label class="form-label" for="user-role">{{ __('locale.User Role') }}</label>
                    <select id="edit_user-role" class="form-select select2" name="roles">
                      @foreach (Spatie\Permission\Models\Role::orderBy('name', 'Asc')->get() as $key => $val)
                        <option value="{{ $val->id }}">{{ $val->name }}</option>
                      @endforeach

                    </select>
                    <div class="help-block"></div>
                  </div>
                </div>
              </div>



            </div>
            <div class="modal-footer">
              <button type="submit"
                class="btn btn-primary waves-effect waves-light edit mt-2">{{ __('locale.Update') }}</button>
            </div>
            {!! Html::form()->close() !!}
        </div>


        <div class="message_box_modal" style="margin:10px 0px;text-align: center;">
        </div>
      </div>
    </div>
  </div>

  <!-- Add Role Modal -->
  @include('_partials/_modals/modal-add-role')
  @include('_partials/_modals/modal-delete')
  @include('_partials/_modals/modal-password')
  <!-- / Add Role Modal -->
  <div id="role-helper" data-add="{{ __('locale.Add New User') }}"></div>
@endsection
@section('page-script')
  @vite(['resources/assets/js/forms-selects.js', 'resources/assets/js/app-access-roles.js'])
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    window.permissions = {
      canDeleteRole: @json(auth()->user()->can('role-delete')),
      canCreateRole: @json(auth()->user()->can('role-create')),
      canEditRole: @json(auth()->user()->can('role-edit'))
    };
    $(document).ready(function() {
      initCountryDrop('#add-user-contact', '#dial_code', '#country_iso');
    })

    document.getElementById('selectAll').addEventListener('change', function() {
      const checked = this.checked;
      document.querySelectorAll('.permissions').forEach(function(checkbox) {
        checkbox.checked = checked;
      });
    });
    $(document).on('click', '.editRoleModal', function() {
      var role_id = $(this).data('role');
      var edit_url = "{{ url('admin/roles/edit') }}" + '/' + role_id;
      $('.role-title').text('Edit ' + $(this).data('name'));
      $('#modalRoleName').val($(this).data('name'));
      var permission = $(this).data('permissions');
      var i = 0;
      while (permission.length > i) {
        var val = permission[i];
        $('input[value=' + val + ']').prop('checked', true);
        i++;
      }
      $('#rolesForm').attr("action", edit_url);
      $('#addRoleModal').modal('show');
      $('#color_code').val($(this).data('color'));
      $('#color_code').val($(this).data('color')).attr("selected", "selected");
      $("#color_code").val($(this).data('color')).change();
    });

    $(document).on('click', '.edit-role-modal', function() {
      $('.modal-title').text('Edit ' + $(this).data('title'));
      $('#id_edit').val($(this).data('id'));
      $('#edit_name').val($(this).data('title'));
      $('#edit_email').val($(this).data('email'));
      $('#edit_phone').val($(this).data('phone'));
      $('#dial_code_edit').val($(this).data('dial_code'));
      $('#country_iso_edit').val($(this).data('dial_code_iso'));
      $('#edit_password').val($(this).data('password'));
      id = $('#id_edit').val();
      role_id = $(this).data('role');
      $('#edit_user-role option:contains("' + role_id + '")').attr('selected', 'selected');
      $('#inlineRoleForm').modal('show');
      initCountryDrop('#edit_phone', '#dial_code_edit', '#country_iso_edit');
    });

    $(function() {
      let $btn = null;
      // Track the clicked submit button
      $(document).on('click',
        '#edit_form button[type="submit"]',
        function() {
          $btn = $(this);
        });
      $('#edit_form').on('submit', function(event) {
        event.preventDefault();
        $.ajax({
          type: 'POST',
          url: `${baseURL}/roles/update-user/` + id,
          header: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          },
          data: new FormData(this),
          dataType: 'JSON',
          contentType: false,
          cache: false,
          processData: false,
          beforeSend: function() {
            toggleButtonLoading($btn, true, 'Saving...');
          },
          success: function(data) {
            toggleButtonLoading($btn, false);
            if (data.status == 200) {
              $('#inlineRoleForm').modal('hide');
              setTimeout(function() {
                window.location.reload();
              }, 3000);
            }
            const toastType = data.status == 200 ? 'bg-success' : 'bg-warning';
            window.showToast({
              title: 'Roles 🏷️',
              message: data.message,
              type: toastType,
              animation: 'animate__fadeInUp',
              time: 'Just now',
              delay: 3000
            });
          },
          error: function(data, e, ts, et) {
            toggleButtonLoading($btn, false);
            console.log(data);
          }
        });

      });
    });

    $(function() {
      window.initColorSelect2('#color_code');
    });
  </script>
@endsection
