@extends('layouts/layoutMaster')

@section('title', __('locale.Notifications'))

@section('vendor-style')
  @vite(['resources/assets/vendor/libs/quill/typography.scss', 'resources/assets/vendor/libs/quill/katex.scss', 'resources/assets/vendor/libs/quill/editor.scss', 'resources/assets/vendor/libs/select2/select2.scss'])
@endsection

@section('page-style')
  @vite(['resources/assets/vendor/scss/pages/app-email.scss'])
@endsection

@section('vendor-script')
  @vite(['resources/assets/vendor/libs/quill/katex.js', 'resources/assets/vendor/libs/quill/quill.js', 'resources/assets/vendor/libs/select2/select2.js', 'resources/assets/vendor/libs/notiflix/notiflix.js'])
@endsection



@section('content')
  <div class="app-email card">
    <div class="row g-0">
      <!--  Notification Sidebar -->
      <div class="col app-email-sidebar border-end flex-grow-0" id="app-email-sidebar">
        <!--  Notification Filters -->
        <div class="email-filters pt-4 pb-2">
          <!--  Notification Filters: Folder -->
          <ul class="email-filter-folders list-unstyled">
            <li class="active d-flex justify-content-between align-items-center mb-1" data-target="All">
              <a href="javascript:void(0)" data-url="{{ url($adminConfigData['prefix'] . 'notifications/All') }}"
                class="d-flex flex-wrap align-items-center click_me">
                <i class="icon-base ti tabler-mail"></i>
                <span class="align-middle ms-2">{{ __('locale.All') }}</span>
              </a>
              <div class="badge bg-label-primary rounded-pill"></div>
            </li>
            <li class="d-flex mb-1" data-target="Read">
              <a href="javascript:void(0)" data-url="{{ url($adminConfigData['prefix'] . 'notifications/Read') }}"
                class="d-flex flex-wrap align-items-center click_me">
                <i class="icon-base ti tabler-mail-opened"></i>
                <span class="align-middle ms-2">{{ __('locale.Read') }}</span>
              </a>
            </li>
            <li class="d-flex justify-content-between align-items-center mb-1" data-target="Unread">
              <a href="javascript:void(0)" data-url="{{ url($adminConfigData['prefix'] . 'notifications/Unread') }}"
                class="d-flex flex-wrap align-items-center click_me">
                <i class="icon-base ti tabler-mail-exclamation"></i>
                <span class="align-middle ms-2">{{ __('locale.Unread') }}</span>
              </a>
              <div class="badge bg-label-warning rounded-pill"></div>
            </li>
          </ul>
          <!-- Email Filters: Labels -->
          <div class="email-filter-labels pt-4">
            <p class="small mx-6 text-body-secondary text-uppercase">{{ __('locale.Labels') }}</p>
            <ul class="list-unstyled mb-2">
              @if (auth()->user()->user_type == 'Admin')
                <li data-target="Register Driver">
                  <a href="javascript:void(0)"
                    data-url="{{ url($adminConfigData['prefix'] . 'notifications/Register Driver') }}" class="click_me">
                    <i class="badge badge-dot bg-success align-middle"></i>
                    <span class="align-middle ms-2">{{ __('locale.Driver') }} {{ __('locale.Register') }}</span>
                  </a>
                </li>
                <li data-target="Register User">
                  <a href="javascript:void(0)"
                    data-url="{{ url($adminConfigData['prefix'] . 'notifications/Register User') }}" class="click_me">
                    <i class="badge badge-dot bg-info align-middle"></i>
                    <span class="align-middle ms-2">{{ __('locale.User') }} {{ __('locale.Register') }}</span>
                  </a>
                </li>
                <li data-target="Support Ticket">
                  <a href="javascript:void(0)"
                    data-url="{{ url($adminConfigData['prefix'] . 'notifications/Support Tickets') }}" class="click_me">
                    <i class="badge badge-dot bg-primary align-middle"></i>
                    <span class="align-middle ms-2">{{ __('locale.Support Tickets') }}</span>
                  </a>
                </li>
                <li data-target="Driver Details Updated">
                  <a href="javascript:void(0)"
                    data-url="{{ url($adminConfigData['prefix'] . 'notifications/Driver Details Updated') }}"
                    class="click_me">
                    <i class="badge badge-dot bg-danger align-middle"></i>
                    <span class="align-middle ms-2">{{ __('locale.Driver Details Updated') }}</span>
                  </a>
                </li>
              @else
                <li data-target="Payment Withdrawal Request">
                  <a href="javascript:void(0)"
                    data-url="{{ url($adminConfigData['prefix'] . 'notifications/Payment Withdrawal Request') }}"
                    class="click_me">
                    <i class="badge badge-dot bg-primary align-middle"></i>
                    <span class="align-middle ms-2">{{ __('locale.Withdrawal Request') }}</span>
                  </a>
                </li>
                <li data-target="Order">
                  <a href="javascript:void(0)" data-url="{{ url($adminConfigData['prefix'] . 'notifications/Order') }}"
                    class="click_me">
                    <i class="badge badge-dot bg-primary align-middle"></i>
                    <span class="align-middle ms-2">{{ __('locale.Orders') }}</span>
                  </a>
                </li>
              @endif

            </ul>
          </div>
          <!--/  Notification Filters -->
        </div>
      </div>
      <!--/  Notification Sidebar -->

      <!-- Notifications List -->
      <div class="col app-emails-list">
        <div class="card shadow-none border-0 rounded-0">
          <div class="card-body emails-list-header p-3 py-2">
            <!--  Notification List: Actions -->
            <div class="d-flex justify-content-between align-items-center ps-1">
              <div class="d-flex align-items-center">
                <div class="form-check mb-0 ms-2">
                  <input class="form-check-input" type="checkbox" id="email-select-all" />
                  <label class="form-check-label" for="email-select-all"></label>
                </div>
                <div class="btn btn-text-secondary btn-icon rounded-pill me-1"><i
                    class="icon-base ti tabler-trash icon-22px email-list-delete cursor-pointer"></i></div>
                <div class="btn btn-text-secondary btn-icon rounded-pill me-1"><i
                    class="icon-base ti tabler-mail-opened icon-22px email-list-read cursor-pointer"></i></div>


              </div>
              <div class="d-flex align-items-center">
                <div class="dropdown">
                  <button class="btn btn-icon btn-text-secondary rounded-pill p-0" type="button" id="emailsActions"
                    data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    <i class="icon-base ti tabler-dots-vertical icon-22px"></i>
                  </button>
                  <div class="dropdown-menu dropdown-menu-end" aria-labelledby="emailsActions">
                    <a class="dropdown-item" href="javascript:void(0)">{{ __('locale.Mark as read') }}</a>
                    <a class="dropdown-item" href="javascript:void(0)">{{ __('locale.Delete') }}</a>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <hr class="container-m-nx m-0" />
          <!-- Notification List: Items -->
          <div class="email-list pt-0">
            <ul class="list-unstyled m-0" id="todo-task-list">
              @forelse ($notifications as $key => $noti)
                <li class="email-list-item email-marked-read d-flex align-items-center">
                  <div class="d-flex align-items-center w-100">
                    <div class="form-check mb-0 ms-2">
                      <input class="email-list-item-input form-check-input" type="checkbox"
                        value="{{ $noti->id }}" id="email-{{ $noti->id }}" />
                      <label class="form-check-label" for="email-{{ $noti->id }}"></label>
                    </div>
                    <div class="email-list-item-content ms-2 ms-sm-0 me-2">
                      <span class="email-list-item-username me-2 text-heading">{{ $noti->data['head'] }}</span>
                      <span class="email-list-item-subject d-xl-inline-block d-block"> {{ $noti->data['body'] }}</span>
                    </div>
                    <div class="email-list-item-meta ms-auto d-flex align-items-center">
                      <small
                        class="email-list-item-time text-body-secondary">{{ Carbon\Carbon::parse($noti->created_at)->diffForHumans() }}</small>
                      <ul class="list-inline email-list-item-actions">
                        @if (empty($noti->read_at))
                          <li class="list-inline-item email-unread btn btn-icon btn-text-success rounded-pill"><i
                              class="icon-base ti tabler-mail icon-md"></i></li>
                        @else
                          <li class="list-inline-item btn btn-icon btn-text-secondary rounded-pill"><i
                              class="icon-base ti tabler-mail-opened icon-md"></i></li>
                        @endif
                        <li class="list-inline-item email-delete btn btn-icon btn-text-secondary rounded-pill"><i
                            class="icon-base ti tabler-trash icon-md"></i></li>
                      </ul>
                    </div>
                  </div>
                </li>
              @empty
                <div class="no-results">
                  <h5>{{ __('locale.No Notification Found') }}</h5>
                </div>
              @endforelse

            </ul>
            <ul class="list-unstyled m-0">
              <li class="email-list-empty text-center d-none">{{ __('locale.No items found.') }}</li>
            </ul>
          </div>
        </div>
        <div class="app-overlay"></div>
      </div>
      <!-- /Notifications List -->

    </div>

  </div>
@endsection
@section('page-script')
  @vite(['resources/assets/js/app-notifications.js'])
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script type="text/javascript">
    $(document).on('click', '.click_me_href', function(e) {
      e.stopPropagation();
      var id = $(this).attr('url');
      window.location.href = id;
    })

    $(document).on("click", ".click_me", function(e) {
      e.preventDefault();
      const $btn = $(this);
      $.ajax({
        url: $(this).data('url'),
        beforeSend: function() {
          toggleButtonLoading($btn, true, 'Processing...');
        },
        success: function(data) {
          toggleButtonLoading($btn, false);
          const toastType = data.status == 200 ? 'bg-success' : 'bg-warning';
          window.showToast({
            title: 'Notification 🔔',
            message: data.message,
            type: toastType,
            animation: 'animate__fadeInUp',
            time: 'Just now',
            delay: 3000
          });
          if (data.status == 200) {
            $("#todo-task-list").replaceWith(data.data);
          }
        },
        error: function(data, e, ts, et) {
          toggleButtonLoading($btn, false);
          console.log(data);
        }
      });
      return false; // for good measure
    });
  </script>
@endsection
