@extends('layouts/layoutMaster')

@section('title', __('locale.Email'))

@section('vendor-style')
  @vite(['resources/assets/vendor/libs/quill/typography.scss', 'resources/assets/vendor/libs/quill/katex.scss', 'resources/assets/vendor/libs/quill/editor.scss', 'resources/assets/vendor/libs/select2/select2.scss'])
@endsection

@section('page-style')
  @vite(['resources/assets/vendor/scss/pages/app-email.scss'])
  <style>
    .app-email .app-email-view {
      inline-size: calc(100% - 0rem);
    }

    .app-email .app-emails-list .email-list li.email-list-item .email-list-item-time {
      display: inline-block;
      inline-size: 80px;
      text-align: end;
    }
  </style>
@endsection

@section('vendor-script')
  @vite(['resources/assets/vendor/libs/quill/katex.js', 'resources/assets/vendor/libs/quill/quill.js', 'resources/assets/vendor/libs/select2/select2.js', 'resources/assets/vendor/libs/notiflix/notiflix.js'])
@endsection

@section('content')
  <div class="app-email card">
    <div class="row g-0">
      <!-- Email Sidebar -->
      <div class="col app-email-sidebar border-end flex-grow-0" id="app-email-sidebar">
        <div class="btn-compost-wrapper d-grid">
          @can('notification-create')
            <button class="btn btn-primary btn-compose" data-bs-toggle="modal" data-bs-target="#emailComposeSidebar"
              id="emailComposeSidebarLabel">{{ __('locale.Compose') }}</button>
          @endcan
        </div>
        <!-- Email Filters -->
        <div class="email-filters pt-4 pb-2">
          <!-- Email Filters: Folder -->
          <ul class="email-filter-folders list-unstyled">
            <li class="active d-flex justify-content-between align-items-center mb-1" data-target="all">
              <a href="javascript:void(0);" class="d-flex flex-wrap align-items-center">
                <i class="icon-base ti tabler-mail"></i>
                <span class="align-middle ms-2">{{ __('locale.All') }}</span>
              </a>
            </li>
            <li class="d-flex justify-content-between mb-1" data-target="enable">
              <a href="javascript:void(0);" class="d-flex flex-wrap align-items-center">
                <i class="icon-base ti tabler-mail"></i>
                <span class="align-middle ms-2">{{ __('locale.Inbox') }}</span>
              </a>
            </li>
            <li class="d-flex justify-content-between mb-1" data-target="starred">
              <a href="javascript:void(0);" class="d-flex flex-wrap align-items-center">
                <i class="icon-base ti tabler-star"></i>
                <span class="align-middle ms-2">{{ __('locale.Starred') }}</span>
              </a>
            </li>
            <li class="d-flex justify-content-between align-items-center mb-1" data-target="spam">
              <a href="javascript:void(0);" class="d-flex flex-wrap align-items-center">
                <i class="icon-base ti tabler-alert-octagon"></i>
                <span class="align-middle ms-2">{{ __('locale.Spam') }}</span>
              </a>
              <div class="badge bg-label-danger rounded-pill"></div>
            </li>
            <li class="d-flex align-items-center mb-1" data-target="deleted">
              <a href="javascript:void(0);" class="d-flex flex-wrap align-items-center">
                <i class="icon-base ti tabler-trash"></i>
                <span class="align-middle ms-2">{{ __('locale.Trash') }}</span>
              </a>
            </li>
          </ul>
          <!-- Email Filters: Labels -->
          <div class="email-filter-labels pt-4">
            <p class="small mx-6 text-body-secondary text-uppercase">{{ __('locale.Labels') }}</p>
            <ul class="list-unstyled mb-2 email-filter-folders">
              <li data-target="email">
                <a href="javascript:void(0);">
                  <i class="badge badge-dot bg-info align-middle"></i>
                  <span class="align-middle ms-2">{{ __('locale.Email') }}</span>
                </a>
              </li>
              <li data-target="pushnotification">
                <a href="javascript:void(0);">
                  <i class="badge badge-dot bg-success align-middle"></i>
                  <span class="align-middle ms-2">{{ __('locale.Push Notification') }}</span>
                </a>
              </li>

            </ul>
          </div>
          <!--/ Email Filters -->
        </div>
      </div>
      <!--/ Email Sidebar -->

      <!-- Emails List -->
      <div class="col app-emails-list">
        <div class="card shadow-none border-0 rounded-0">
          <div class="card-body emails-list-header p-3 py-2">
            <!-- Email List: Search -->
            <div class="d-flex justify-content-between align-items-center px-3 mt-2">
              <div class="d-flex align-items-center w-100">
                <i class="icon-base ti tabler-menu-2 icon-lg cursor-pointer d-block d-lg-none me-4 mb-4"
                  data-bs-toggle="sidebar" data-target="#app-email-sidebar" data-overlay></i>
                <div class="mb-4 w-100">
                  <div class="input-group input-group-merge shadow-none">
                    <span class="input-group-text border-0 ps-0 py-0" id="email-search">
                      <i class="icon-base ti tabler-search icon-lg"></i>
                    </span>
                    <input type="text" class="form-control email-search-input border-0 py-0" placeholder="Search mail"
                      aria-label="Search mail" aria-describedby="email-search" />
                  </div>
                </div>
              </div>
            </div>
            <hr class="mx-n3 emails-list-header-hr mb-2" />
            <!-- Email List: Actions -->
            <div class="d-flex justify-content-between align-items-center ps-1">
              <div class="d-flex align-items-center">
                <div class="form-check mb-0 ms-2">
                  <input class="form-check-input" type="checkbox" id="email-select-all" />
                  <label class="form-check-label" for="email-select-all"></label>
                </div>
                @can('notification-delete')
                  <div class="btn btn-text-secondary btn-icon rounded-pill me-1"><i
                      class="icon-base ti tabler-trash icon-22px email-list-delete cursor-pointer"></i></div>
                @endcan
                <div class="btn btn-text-secondary btn-icon rounded-pill me-1 d-none"><i
                    class="icon-base ti tabler-mail-opened icon-22px email-list-read cursor-pointer"></i></div>
                <div class="dropdown me-1">
                  <button class="btn btn-icon btn-text-secondary rounded-pill p-0" type="button"
                    id="dropdownMenuFolderOne" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    <i class="icon-base ti tabler-folder icon-22px"></i>
                  </button>
                  @can('notification-edit')
                    <div class="dropdown-menu dropdown-menu-end" aria-labelledby="dropdownMenuFolderOne">
                      <a class="dropdown-item email-list-spam" href="javascript:void(0)">
                        <i class="icon-base ti tabler-info-circle icon-sm me-1"></i>
                        <span class="align-middle">{{ __('locale.Spam') }}</span>
                      </a>

                    </div>
                  @endcan
                </div>

              </div>

            </div>
          </div>
          <hr class="container-m-nx m-0" />
          <!-- Email List: Items -->
          <div class="email-list pt-0">
            @if (!empty($emails))
              <ul class="list-unstyled m-0">
                <?php foreach ($emails as $key => $value): ?>
                <li class="email-list-item email-marked-read d-flex align-items-center" data-id="{{ $value->id }}"
                  data-all="true" @if ($value->status == 'Starred') data-starred="true" @endif
                  @if ($value->status == 'Spam') data-spam="true" @endif
                  @if ($value->status == 'Deleted') data-deleted="true" @endif
                  @if ($value->status == 'Enable') data-enable="true" @endif
                  @if ($value->message_type == 'Email') data-email="true" @endif
                  @if ($value->message_type == 'Push Notification') data-pushnotification="true" @endif data-bs-toggle="sidebar"
                  data-target="#app-email-view{{ $value->id }}">
                  <div class="d-flex align-items-center w-100">
                    <div class="form-check mb-0 ms-2">
                      <input class="email-list-item-input form-check-input" type="checkbox"
                        value="{{ $value->id }}" id="email-{{ $value->id }}" />
                      <label class="form-check-label" for="email-{{ $value->id }}"></label>
                    </div>
                    <span class="ms-sm-3 me-4 d-sm-inline-block">
                      <i class="email-list-item-bookmark icon-base ti tabler-star icon-md cursor-pointer ms-1"
                        data-id="{{ $value->id }}"></i>
                    </span>
                    <img
                      src="{{ Auth::user() ? Auth::user()->profile_photo_url : asset('assets/img/placeholder.jpg') }}"
                      alt="user-avatar" class="d-block flex-shrink-0 rounded-circle me-sm-2 me-0" height="32"
                      width="32" />
                    <div class="email-list-item-content ms-2 ms-sm-0 me-2">
                      <span class="email-list-item-username me-2 text-heading">

                      </span>
                      {{ substr($value->subject, 0, 30) }}</span> <span class="text-truncate"><br>To: <button
                          type="button" class="" data-bs-toggle="tooltip" data-bs-placement="top"
                          title="{{ $value->send_to }}"><small>{{ substr($value->send_to, 0, 60) }}</small>
                        </button></span>
                      <span class="email-list-item-subject d-xl-inline-block d-block">{!! $value->body !!}</span>
                    </div>
                    <div class="email-list-item-meta ms-auto d-flex align-items-center">
                      <span
                        class="email-list-item-label badge badge-dot @if ($value->message_type == 'Push Notification') bg-success @else bg-info @endif d-none d-md-inline-block me-2"
                        data-label="{{ strtolower(str_replace(' ', '', $value->message_type)) }}"></span>

                      <small
                        class="email-list-item-time text-body-secondary">{{ date('H:i A', strtotime($value->created_at)) }}<br>{{ date('d M Y', strtotime($value->created_at)) }}</small>
                      @can('notification-delete')
                        <ul class="list-inline email-list-item-actions">
                          <li class="list-inline-item email-delete btn btn-icon btn-text-secondary rounded-pill"><i
                              class="icon-base ti tabler-trash icon-md"></i></li>
                        </ul>
                      @endcan
                    </div>
                  </div>
                </li>
                <!-- Email View -->
                <div class="col app-email-view flex-grow-0 bg-lighter" id="app-email-view{{ $value->id }}">
                  <div class="card shadow-none border-0 rounded-0 app-email-view-header p-5 pt-md-4 py-2">
                    <!-- Email View : Title  bar-->
                    <div class="d-flex justify-content-between align-items-center">
                      <div class="d-flex align-items-center overflow-hidden">
                        <span class="ms-sm-2 me-4"><i
                            class="icon-base ti tabler-chevron-left icon-md cursor-pointer scaleX-n1-rtl"
                            data-bs-toggle="sidebar" data-target="#app-email-view{{ $value->id }}"></i></span>
                        <h6 class="text-truncate mb-0 me-2 fw-normal">{{ $value->subject }}</h6>
                        <span class="badge bg-label-warning rounded-pill">{{ $value->message_type }}</span>
                      </div>
                      <!-- Email View : Action bar-->

                    </div>

                  </div>
                  <hr class="m-0" />
                  <!-- Email View : Content-->
                  <div class="app-email-view-content py-4">

                    <!-- Email View : Last mail-->
                    <div class="card email-card-last mx-sm-6 mx-3 mt-4">
                      <div class="card-header d-flex justify-content-between align-items-center flex-wrap border-bottom">
                        <div class="d-flex align-items-center mb-sm-0 mb-3">
                          <img
                            src="{{ Auth::user() ? Auth::user()->profile_photo_url : asset('assets/img/placeholder.jpg') }}"
                            alt="user-avatar" class="flex-shrink-0 rounded-circle me-4" height="38"
                            width="38" />
                          <div class="flex-grow-1 ms-1">
                            <h6 class="m-0 fw-normal">{{ $value->subject }}</h6>
                            <small class="text-body">{{ $value->send_to }}</small>
                          </div>
                        </div>
                        <div class="d-flex align-items-center">
                          <p class="mb-0 me-4 text-body-secondary">
                            {{ date('H:i A d M Y', strtotime($value->created_at)) }}</p>
                        </div>
                      </div>
                      <div class="card-body pt-5">
                        {!! $value->body !!}
                        <hr />
                        @if (!empty($value->icon))
                          <p class="text-body-secondary mb-2">{{ __('locale.Attachments') }}</p>
                          <div class="cursor-pointer">
                            <i class="icon-base ti tabler-file"></i>
                            <span class="align-middle ms-1"> <img
                                src="{{ asset('storage/Files') }}/{{ $value->icon }}"</span>
                          </div>
                        @endif
                      </div>
                    </div>

                  </div>
                </div>
                <!-- Email View -->
                <?php endforeach ?>
              </ul>
            @else
              <ul class="list-unstyled m-0">
                <li class="email-list-empty text-center d-none">{{ __('locale.No items found.') }}</li>
              </ul>
            @endif
          </div>
        </div>
        <div class="app-overlay"></div>
      </div>
      <!-- /Emails List -->


    </div>

    <!-- Compose Email -->
    <div class="app-email-compose modal" id="emailComposeSidebar" tabindex="-1"
      aria-labelledby="emailComposeSidebarLabel" aria-hidden="true">
      <div class="modal-dialog m-0 me-md-6 mb-6 modal-lg">
        <div class="modal-content p-0">
          <div class="modal-header py-3 justify-content-between">
            <h5 class="modal-title text-body fs-5">{{ __('locale.Compose Message') }}</h5>
            <div class="d-flex align-items-center gap-2">
              <button type="button" class="btn btn-sm btn-icon btn-text-secondary rounded-pill"><i
                  class="icon-base ti tabler-minus icon-20px"></i></button>
              <button type="button" class="btn btn-sm btn-icon btn-text-secondary rounded-pill"
                data-bs-dismiss="modal" aria-label="Close"><i class="icon-base ti tabler-x icon-20px"></i></button>
            </div>
          </div>
          <div class="modal-body flex-grow-1 pb-sm-0 p-5 py-2">
            {!! Html::form()->method('POST')->id('update_form')->acceptsFiles()->class('email-compose-form')->open() !!}
            <div class="compose-mail-form-field select2-primary">
              <label for="email-to" class="form-label">{{ __('locale.Message Type') }}: </label>
              <div class="flex-grow-1">
                <select class="form-control" name="message_type" id="typeSelect" required
                  data-validation-required-message="This field is required" aria-invalid="false">
                  <option data-id="">{{ __('locale.Select Message Type') }}</option>
                  <option name="Push" data-id="Push">{{ __('locale.Push Notification') }}</option>
                  <option class="" name="Email" data-id="Email">{{ __('Email') }}</option>
                </select>
              </div>
            </div>
            <div class="compose-mail-form-field select2-primary">
              <label for="email-to" class="form-label">{{ __('locale.User Type') }}: </label>
              <div class="flex-grow-1">
                <select class="form-control" name="type" id="basicSelect" required
                  data-validation-required-message="This field is required" aria-invalid="false">
                  <option> {{ __('locale.Select User Type') }}</option>
                  <option name="User" data-id="User" value="User">User</option>
                  <option name="Driver" data-id="Driver" value="Driver">Driver</option>
                  <option name="Store" data-id="Store" value="Store">Store</option>
                  @foreach ($roles as $key => $role)
                    <option class="" name="{{ $role->name }}" data-id="{{ $role->name }}">
                      {{ $role->name }}
                    </option>
                  @endforeach
                </select>
              </div>
            </div>
            <div class="compose-mail-form-field" id="image_id" style="display:none">
              <label for="emailSubject" class="form-label">{{ __('locale.Image') }}:</label>
              <input class="form-control" type="file" accept="image/*" name="icon" id="icon"
                class="custom-file-input" />
            </div>

            <div class="email-compose-to d-flex justify-content-between align-items-center mt-1">
              <label class="fw-medium mb-1 text-body-secondary" for="emailContacts">To:</label>
              <div class="select2-primary border-0 shadow-none flex-grow-1 mx-2">
                <select class="select2 form-select w-100 cl" id="email-to" name="emails[]" multiple>
                </select>
              </div>
              <div class="email-compose-toggle-wrapper">
                <input type="checkbox" id="checkbox">{{ __('locale.All') }}
                <a class="email-compose-toggle-cc text-body d-none" href="javascript:void(0);">Cc |</a>
                <a class="email-compose-toggle-bcc text-body d-none" href="javascript:void(0);">Bcc</a>
              </div>
            </div>

            <div class="email-compose-cc d-none">
              <hr class="mx-n5 my-0" />
              <div class="d-flex align-items-center">
                <label for="email-cc" class="fw-medium text-body-secondary">Cc:</label>
                <input type="text" class="form-control border-0 shadow-none flex-grow-1 mx-2" id="email-cc"
                  placeholder="someone@email.com" />
              </div>
            </div>
            <div class="email-compose-bcc d-none">
              <hr class="mx-n5 my-0" />
              <div class="d-flex align-items-center">
                <label for="email-bcc" class="fw-medium text-body-secondary">Bcc:</label>
                <input type="text" class="form-control border-0 shadow-none flex-grow-1 mx-2" id="email-bcc"
                  placeholder="someone@email.com" />
              </div>
            </div>
            <hr class="mx-n5 my-0" />
            <div class="email-compose-subject d-flex align-items-center">
              <label for="email-subject" class="fw-medium text-body-secondary">{{ __('locale.Subject') }}:</label>
              <input type="text" class="form-control border-0 shadow-none flex-grow-1 mx-2" id="email-subject"
                name="subject" />
            </div>
            <div class="email-compose-message">
              <hr class="mx-n5 my-0" />
              <div class="d-flex justify-content-end mx-n1">
                <div class="email-editor-toolbar border-0 w-100 px-0">
                  <span class="ql-formats me-0">
                    <button class="ql-bold"></button>
                    <button class="ql-italic"></button>
                    <button class="ql-underline"></button>
                    <button class="ql-list" value="ordered"></button>
                    <button class="ql-list" value="bullet"></button>
                    <button class="ql-link"></button>
                    <button class="ql-image"></button>
                  </span>
                </div>
              </div>
              <hr class="mx-n5 my-0" />
              <div class="email-editor border-0 mx-n5"></div>
            </div>
            <hr class="mx-n5 mt-0 mb-2" />
            <div class="email-compose-actions d-flex justify-content-between align-items-center my-4">
              <div class="d-flex align-items-center">
                <div class="btn-group">
                  <button type="submit" class="btn btn-primary dropdown-toggle email-send-btn">{{ __('locale.Send') }}
                    <i class="icon-base ti tabler-send icon-xs scaleX-n1-rtl ms-2"></i></button>
                  <ul class="dropdown-menu d-none">
                    <li><a class="dropdown-item" href="javascript:void(0);">Schedule send</a></li>
                    <li><a class="dropdown-item" href="javascript:void(0);">Save draft</a></li>
                  </ul>
                </div>

              </div>
              <div class="d-flex align-items-center gap-2 d-none">
                <div class="dropdown">
                  <button class="btn btn-sm btn-icon btn-text-secondary rounded-pill p-0" type="button"
                    id="dropdownMoreActions" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    <i class="icon-base ti tabler-dots-vertical icon-20px"></i>
                  </button>
                  <ul class="dropdown-menu" aria-labelledby="dropdownMoreActions">
                    <li><button type="button" class="dropdown-item">Add Label</button></li>
                    <li><button type="button" class="dropdown-item">Plain text mode</button></li>
                    <li>
                      <hr class="dropdown-divider" />
                    </li>
                    <li><button type="button" class="dropdown-item">Print</button></li>
                    <li><button type="button" class="dropdown-item">Check Spelling</button></li>
                  </ul>
                </div>
                <button type="reset" class="btn btn-sm btn-icon btn-text-secondary rounded-pill"
                  data-bs-dismiss="modal" aria-label="Close"><i
                    class="icon-base ti tabler-trash icon-20px"></i></button>
              </div>
            </div>
            {!! Html::form()->close() !!}
          </div>
        </div>
      </div>
    </div>
    <!-- /Compose Email -->
  </div>
@endsection
@section('page-script')
  @vite(['resources/assets/js/app-email.js', 'resources/assets/js/forms-selects.js'])
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script type="text/javascript">
    $("#checkbox").on('click', function() {
      if ($("#checkbox").is(':checked')) {
        $(".e1").prop("selected", "selected");
        $(".e1").trigger('change');
      } else {
        $(".e1").removeAttr("selected");
        $(".e1").prop("selected", false);
        $(".e1").trigger('change');
      }
    });
    $("#typeSelect").change(function() {
      var APP_URL = {!! json_encode(url('/')) !!};
      var type = $('#typeSelect option:selected').attr('data-id');
      if (type == 'Push') {
        $('#image_id').show();
      } else {
        $('#image_id').hide();
      }
    })
    $("#basicSelect").change(function() {
      var APP_URL = {!! json_encode(url('/')) !!};
      var id = $('#basicSelect option:selected').attr('data-id');
      var type = $('#typeSelect option:selected').attr('data-id');

      if (type == '') {
        alert('Please select message type first');
        return false;
      }
      $('#email-to').empty(); // empty the div before fetching and adding new data
      $.get(APP_URL + "/admin/email/getUsers/" + id, function(data) {
        $element = $("#email-to").empty();
        // $element.append("<option value=''>Choose Users</option>");
        // $element.removeAttr('disabled');
        $(data).each(function() {
          $element.append(" <option  class='e1' value='" + this.value + "'>" + this.label +
            "</option>");
        });
      });
    })
    $(function() {
      let $btn = null;
      $(document).on('click',
        '#update_form button[type="submit"]',
        function() {
          $btn = $(this);
        });
      $('#update_form').on('submit', function(event) {
        event.preventDefault();
        var quill_editor = $('.ql-editor');
        var formData = new FormData(this);
        formData.append('message', quill_editor[0].innerHTML);
        var APP_URL = {!! json_encode(url('/')) !!};
        isRtl = $('html').attr('data-textdirection') === 'rtl';
        $.ajax({
          type: "POST",
          header: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          },

          url: APP_URL + "/admin/email/sendEmails",
          // data: $('form#update_form').serialize(),
          data: formData,
          dataType: 'JSON',
          contentType: false,
          cache: false,
          processData: false,
          beforeSend: function() {
            toggleButtonLoading($btn, true, 'Processing...');
          },
          success: function(data) {
            toggleButtonLoading($btn, false);
            const toastType = data.status == 200 ? 'bg-success' : 'bg-warning';
            window.showToast({
              title: 'Notification 📧',
              message: data.message,
              type: toastType,
              animation: 'animate__fadeInUp',
              time: 'Just now',
              delay: 3000
            });
            if (data.status == 200) {
              setTimeout(function() {
                window.location.reload();
              }, 3000); // 3000 milliseconds = 2 seconds
            }
          },
          error: function(data, e, ts, et) {
            toggleButtonLoading($btn, false);
            console.log(data);
          }
        });
      });
    });
  </script>
@endsection
