@extends('layouts/layoutMaster')

@section('title', __('locale.Settlements'))

@section('vendor-style')
  @vite(['resources/assets/css/datatables.scss', 'resources/assets/vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.scss'])
@endsection

@section('vendor-script')
  @vite(['resources/assets/js/datatables.js', 'resources/assets/vendor/libs/moment/moment.js', 'resources/assets/vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js'])
@endsection


@section('content')

  <!-- Product List Table -->
  <div class="card">
    <div class="card-header border-bottom">
      <h5 class="card-title">
        @if (!empty($user))
          {{ $user->name }}
        @endif
      </h5>
      <div class="d-flex justify-content-between align-items-center row pt-0 gap-6 gap-md-0 g-md-6">
        <div class="col-md-2 user_mode"></div>
        <div class="col-md-2 transaction_mode"></div>
        <div class="col-md-2 transaction_type"></div>
        <div class="col-md-3 order_type"></div>
        <div class="col-md-3 date_filter">
          <label for="bs-rangepicker-range" class="form-label">{{ __('locale.Date') }}</label>
          <input type="text" class="form-control" placeholder="YYYY-MM-DD to YYYY-MM-DD" id="bs-rangepicker-range" />
        </div>
      </div>
    </div>
    <div class="card-datatable">
      <table class="datatables-transaction table">
        <thead class="border-top">
          <tr>
            <th></th>
            <th></th>
            <th>{{ __('locale.Details') }}</th>
            <th>{{ __('locale.Date') }}</th>
            <th>{{ __('locale.Amount Details') }}</th>
            <th>{{ __('locale.Type') }}</th>
            <th>{{ __('locale.Payment Mode') }}</th>
            <th>{{ __('locale.Status') }}</th>
            <th>{{ __('locale.Actions') }}</th>
          </tr>
        </thead>
      </table>
    </div>
  </div>
  <div id="role-helper-transaction" data-query="">
  @endsection
  @section('page-script')
    <script>
      window.permissions = {
        showUser: 'true'
      };
    </script>
    @vite(['resources/assets/js/wallet_transaction.js', 'resources/assets/js/forms-pickers.js'])
  @endsection
