@php
  $configData = Helper::appClasses();
@endphp

@extends('layouts/layoutMaster')

@section('title', __('locale.Vehicle Categories'))

@section('vendor-style')
  @vite(['resources/assets/css/datatables.scss'])
@endsection

@section('vendor-script')
  @vite(['resources/assets/js/datatables.js'])
@endsection

@section('content')
  <div class="row g-6">
    <div class="col-12">
      <div class="card">
        <div class="card-datatable">
          <table class="datatables-users table border-top">
            <thead>
              <tr>
                <th>#</th>
                <th>{{ __('locale.Image') }}</th>
                <th>{{ __('locale.Name') }}</th>
                <th>{{ __('locale.Used For') }}</th>
                <th>{{ __('locale.Status') }}</th>
                <th>{{ __('locale.Actions') }}</th>
              </tr>
            </thead>
          </table>
        </div>
      </div>
    </div>
  </div>

  <!-- Offcanvas to add new category -->
  <div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasAdd" aria-labelledby="offcanvasAddLabel">
    <div class="offcanvas-header border-bottom">
      <h5 id="offcanvasAddLabel" class="offcanvas-title">{{ __('locale.Add New Category') }}</h5>
      <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body mx-0 flex-grow-0 p-6 h-100">
      <form class="add-new-category pt-0" id="upload_form" method="POST" action="{{ route('categories.store') }}">
        @csrf
        <input type="hidden" name="id" id="category_id">
        <div class="mb-4">
          <label class="form-label">{{ __('locale.Name') }}</label>
          <input type="text" class="form-control" name="name" placeholder="{{ __('locale.Name') }}">
        </div>
        <div class="mb-4 d-none">
          <label class="form-label">{{ __('locale.Parent Category') }}</label>
          <select class="form-control select2" name="parent_id">
            <option value="">{{ __('locale.None') }}</option>
            @foreach ($allCategories as $cat)
              <option value="{{ $cat->id }}">{{ $cat->name }}</option>
            @endforeach
          </select>
        </div>
        <div class="mb-4">
          <label class="form-label">{{ __('locale.Used For') }}</label>
          <select class="form-control select2-multiple" name="type[]" multiple>
            <option value="Ride">Ride</option>
            <option value="Delivery">Delivery</option>
          </select>
        </div>
        <div class="mb-4">
          <label class="form-label" for="category_image">{{ __('locale.Image') }}</label>
          <input type="file" class="form-control" name="image" id="category_image" accept="image/*">
          <div class="mt-2">
            <img id="preview_image" src="{{ asset('assets/img/placeholder.jpg') }}" alt="Preview" class="img-thumbnail"
              style="max-height: 60px; display: none;">
          </div>
        </div>


        <button type="submit" class="btn btn-primary me-3 data-submit">{{ __('locale.Submit') }}</button>
        <button type="reset" class="btn btn-label-danger"
          data-bs-dismiss="offcanvas">{{ __('locale.Cancel') }}</button>
      </form>
    </div>
  </div>

  <!-- Modal to edit category -->
  <div class="modal fade text-left category-edit-modal" id="inlineForm" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <form id="edit_form" method="POST">
          @csrf
          @method('PUT')
          <div class="modal-header">
            <h4 class="modal-title">{{ __('locale.Edit Category') }}</h4>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>
          <div class="modal-body">
            <input type="hidden" name="id" id="id_edit">
            <div class="mb-4">
              <label class="form-label">{{ __('locale.Name') }}</label>
              <input type="text" name="name" id="name_edit" class="form-control"
                placeholder="{{ __('locale.Name') }}" required>
            </div>
            <div class="mb-4 d-none">
              <label class="form-label">{{ __('locale.Parent Category') }}</label>
              <select name="parent_id" id="parent_id_edit" class="form-control select2">
                <option value="">{{ __('locale.None') }}</option>
                @foreach ($allCategories as $cat)
                  <option value="{{ $cat->id }}">{{ $cat->name }}</option>
                @endforeach
              </select>
            </div>
            <div class="mb-4">
              <label class="form-label">{{ __('locale.Used For') }}</label>
              <select class="form-control select2-multiple" id="type_edit" name="type[]" multiple>
                <option value="Ride">Ride</option>
                <option value="Delivery">Delivery</option>
              </select>
            </div>
            <div class="mb-4">
              <label class="form-label" for="edit_category_image">{{ __('locale.Image') }}</label>
              <input type="file" class="form-control" name="image" id="edit_category_image" accept="image/*">
              <div class="mt-2">
                <img id="edit_preview_image" src="{{ asset('assets/img/placeholder.jpg') }}" alt="Preview"
                  class="img-thumbnail" style="max-height:60px; display: none;"
                  onerror="this.onerror=null;this.src='{{ url('assets/img/placeholder.jpg') }}';">
              </div>
            </div>


          </div>
          <div class="modal-footer">
            <button type="submit" class="btn btn-primary">{{ __('locale.Update') }}</button>
          </div>
        </form>
      </div>
    </div>
  </div>
  @include('_partials/_modals/modal-country-price')
  <div id="role-helper" data-add="{{ __('locale.Add New Category') }}" data-query=""></div>
@endsection

@section('page-script')
  @vite(['resources/assets/js/vehicle-category.js'])
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    window.permissions = {
      canDeleteCategory: @json(auth()->user()->can('vehicle-delete')),
      canEditCategory: @json(auth()->user()->can('vehicle-edit')),
      canCreateCategory: @json(auth()->user()->can('vehicle-create'))
    };

    // Preview for Add Category
    document.getElementById('category_image')?.addEventListener('change', function(e) {
      const img = document.getElementById('preview_image');
      const file = e.target.files[0];
      if (file) {
        img.src = URL.createObjectURL(file);
        img.style.display = 'block';
      } else {
        img.style.display = 'none';
      }
    });

    // Preview for Edit Category
    document.getElementById('edit_category_image')?.addEventListener('change', function(e) {
      const img = document.getElementById('edit_preview_image');
      const file = e.target.files[0];
      if (file) {
        img.src = URL.createObjectURL(file);
        img.style.display = 'block';
      } else {
        img.style.display = 'none';
      }
    });



    $(function() {
      const table = $('.datatables-users').DataTable();
      let $btn = null;

      $(document).on('click', '#upload_form button[type="submit"]', function() {
        $btn = $(this);
      });

      $('#upload_form').on('submit', function(event) {
        event.preventDefault();
        $.ajax({
          type: "POST",
          headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          },
          url: `${baseURL}/vehicle-categories`,
          data: new FormData(this),
          dataType: 'JSON',
          contentType: false,
          cache: false,
          processData: false,
          beforeSend: function() {
            toggleButtonLoading($btn, true, 'Saving...');
          },
          success: function(data) {
            if (data.status === 200 && data.data) {
              const category = data.data;
              const newRow = table.row.add(category).draw(false);
              $(newRow.node()).attr('id', `trRow-${category.id}`);
              table.order([5, 'desc']).draw(false);

              $('#upload_form')[0].reset();
              const offcanvasEl = document.getElementById('offcanvasAdd');
              const bsOffcanvas = bootstrap.Offcanvas.getInstance(offcanvasEl);
              if (bsOffcanvas) bsOffcanvas.hide();
            }
            toggleButtonLoading($btn, false);
            const toastType = data.status == 200 ? 'bg-success' : 'bg-warning';
            window.showToast({
              title: 'Categories 🗂️',
              message: data.message,
              type: toastType,
              animation: 'animate__fadeInUp',
              time: 'Just now',
              delay: 3000
            });
          },
          error: function(xhr) {
            toggleButtonLoading($btn, false);
            console.log(xhr.responseJSON);
          }
        });
      });

      // Edit modal open
      $(document).on('click', '.edit-category-modal', function() {
        $('#id_edit').val($(this).data('id'));
        $('#name_edit').val($(this).data('name'));
        $('#parent_id_edit').val($(this).data('parent_id')).trigger('change');
        let types = $(this).data('type');
        let typeArray = types ? types.split(',') : '';
        $('#type_edit').val(typeArray).trigger('change');
        const imageUrl = $(this).data('image');
        if (imageUrl) {
          $('#edit_preview_image').attr('src', imageUrl).show();
        } else {
          $('#edit_preview_image').hide();
        }
        $('#inlineForm').modal('show');
        $('.select2-multiple').select2({
          placeholder: 'Select values',
          width: '100%',
          dropdownParent: $('#inlineForm')
        });
      });

      // Edit form submit
      $('#edit_form').on('submit', function(event) {
        event.preventDefault();
        const id = $('#id_edit').val();
        $.ajax({
          type: 'POST',
          url: `${baseURL}/vehicle-categories/${id}`,
          headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          },
          data: new FormData(this),
          dataType: 'JSON',
          contentType: false,
          cache: false,
          processData: false,
          beforeSend: function() {
            toggleButtonLoading($btn, true, 'Saving...');
          },
          success: function(data) {
            if (data.status === 200 && data.data) {
              const category = data.data;
              const existingRow = table.row(`#trRow-${category.id}`);
              if (existingRow.node()) {
                existingRow.data(category).draw(false);
              }
              $('#inlineForm').modal('hide');
            }
            toggleButtonLoading($btn, false);
            const toastType = data.status == 200 ? 'bg-success' : 'bg-warning';
            window.showToast({
              title: 'Categories 🗂️',
              message: data.message,
              type: toastType,
              animation: 'animate__fadeInUp',
              time: 'Just now',
              delay: 3000
            });
          },
          error: function(xhr) {
            toggleButtonLoading($btn, false);
            console.log(xhr.responseJSON);
          }
        });
      });
    });

    //prices:
    $(function() {
      // Initialize Select2 for multiple
      $('.select2-multiple').select2({
        placeholder: 'Select values',
        width: '100%',
        dropdownParent: $('#countryPriceModal')
      });

      let selectedCategoryId = null;
      let existingPrices = {};

      // On edit icon click, open modal
      $(document).on('click', '.edit-country-modal', function() {
        selectedCategoryId = $(this).data('id');
        $('#vehicle_category_id').val(selectedCategoryId);
        $('#pricing-fields').empty();

        // Fetch existing country pricing for this vehicle category
        $.get(`${baseURL}/vehicle-categories/${selectedCategoryId}/country-prices`, function(response) {
          if (response.status == 200) {
            existingPrices = response.data || {};
            const selectedCountryIds = Object.keys(existingPrices);
            $('#countries').val(selectedCountryIds).trigger('change');
          } else {
            existingPrices = {};
            $('#countries').val(null).trigger('change');
          }

          // Open the modal after data is ready
          $('#countryPriceModal').modal('show');
        });
      });

      // On countries selected (multiple)
      $(document).on('change', '#countries', function() {
        const selected = $(this).val(); // selected country IDs
        $('#pricing-fields').empty();

        selected.forEach(id => {
          const countryName = $(this).find(`option[value="${id}"]`).text();
          const price = existingPrices[id] || {};

          $('#pricing-fields').append(`
        <div class="col-12 border p-2 mb-2 rounded">
          <strong>${countryName}</strong>
          <input type="hidden" name="prices[${id}][country_id]" value="${id}">
          <div class="row mt-2">
            <div class="col-md-3">
              <label>Minimum Fare</label>
              <input type="number" class="form-control" name="prices[${id}][base_fare]" step="0.01" value="${price.base_fare ?? ''}">
            </div>
            <div class="col-md-3">
              <label>Per Km Rate</label>
              <input type="number" class="form-control" name="prices[${id}][per_km_rate]" step="0.01" value="${price.per_km_rate ?? ''}">
            </div>
            <div class="col-md-3">
              <label>Per Minute Price</label>
              <input type="number" class="form-control" name="prices[${id}][per_minute_price]" step="0.01" value="${price.per_minute_price ?? ''}">
            </div>
             <div class="col-md-3">
              <label>Waiting Price/Minute</label>
              <input type="number" class="form-control" name="prices[${id}][per_minute_waiting_price]" step="0.01" value="${price.per_minute_waiting_price ?? ''}">
            </div>
          </div>
        </div>
      `);
        });
      });
    });

    // Handle AJAX form submit
    $(document).on('submit', '#countryPriceForm', function(e) {
      e.preventDefault();
      const form = $(this);
      const formData = form.serialize();
      $.ajax({
        type: 'POST',
        url: `${baseURL}/vehicle-categories/country-prices/store`,
        data: formData,
        beforeSend: function() {
          form.find('button[type="submit"]').prop('disabled', true).text('Saving...');
        },
        success: function(data) {
          const toastType = data.status == 200 ? 'bg-success' : 'bg-warning';
          window.showToast({
            title: 'Prices 💰 ',
            message: data.message,
            type: toastType,
            animation: 'animate__fadeInUp',
            time: 'Just now',
            delay: 3000
          });
          if (data.status == 200) {
            $('#countryPriceModal').modal('hide');
          }
        },
        beforeSend: function() {

        },
        error: function(xhr) {
          window.showToast({
            title: 'Prices 💰 ',
            message: xhr.responseJSON?.message || 'Server Error',
            type: 'bg-danger',
            animation: 'animate__fadeInUp',
            time: 'Just now',
            delay: 3000
          });
        },
        complete: function() {
          form.find('button[type="submit"]').prop('disabled', false).text('Save Prices');
        }
      });
    });
  </script>
@endsection
