@php
  $configData = Helper::appClasses();
@endphp

@extends('layouts/layoutMaster')

@section('title', __('locale.Vehicle Brands'))

@section('vendor-style')
  @vite(['resources/assets/css/datatables.scss'])
@endsection

@section('vendor-script')
  @vite(['resources/assets/js/datatables.js'])
@endsection

@section('content')
  <div class="row g-6">
    <div class="col-12">
      <div class="card">
        <div class="card-datatable">
          <table class="datatables-users table border-top">
            <thead>
              <tr>
                <th>#</th>
                <th>{{ __('locale.Image') }}</th>
                <th>{{ __('locale.Name') }}</th>
                <th></th>
                <th>{{ __('locale.Status') }}</th>
                <th>{{ __('locale.Actions') }}</th>
              </tr>
            </thead>
          </table>
        </div>
      </div>
    </div>
  </div>

  <!-- Offcanvas to add new brand -->
  <div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasAdd" aria-labelledby="offcanvasAddLabel">
    <div class="offcanvas-header border-bottom">
      <h5 id="offcanvasAddLabel" class="offcanvas-title">{{ __('locale.Add New Brand') }}</h5>
      <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body mx-0 flex-grow-0 p-6 h-100">
      <form class="add-new-brand pt-0" id="upload_form" method="POST" action="{{ route('vehicle-brands.store') }}">
        @csrf
        <input type="hidden" name="id" id="brand_id">
        <div class="mb-4">
          <label class="form-label">{{ __('locale.Name') }}</label>
          <input type="text" class="form-control" name="name" placeholder="{{ __('locale.Name') }}">
        </div>
        <div class="mb-4">
          <label class="form-label" for="brand_image">{{ __('locale.Image') }}</label>
          <input type="file" class="form-control" name="image" id="brand_image" accept="image/*">
          <div class="mt-2">
            <img id="preview_image" src="{{ asset('assets/img/placeholder.jpg') }}" alt="Preview" class="img-thumbnail"
              style="max-height: 60px; display: none;">
          </div>
        </div>

        <button type="submit" class="btn btn-primary me-3 data-submit">{{ __('locale.Submit') }}</button>
        <button type="reset" class="btn btn-label-danger"
          data-bs-dismiss="offcanvas">{{ __('locale.Cancel') }}</button>
      </form>
    </div>
  </div>

  <!-- Modal to edit brand -->
  <div class="modal fade text-left brand-edit-modal" id="inlineForm" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <form id="edit_form" method="POST">
          @csrf
          @method('PUT')
          <div class="modal-header">
            <h4 class="modal-title">{{ __('locale.Edit Brand') }}</h4>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>
          <div class="modal-body">
            <input type="hidden" name="id" id="id_edit">
            <div class="mb-4">
              <label class="form-label">{{ __('locale.Name') }}</label>
              <input type="text" name="name" id="name_edit" class="form-control"
                placeholder="{{ __('locale.Name') }}" required>
            </div>
            <div class="mb-4">
              <label class="form-label" for="edit_brand_image">{{ __('locale.Image') }}</label>
              <input type="file" class="form-control" name="image" id="edit_brand_image" accept="image/*">
              <div class="mt-2">
                <img id="edit_preview_image" src="{{ asset('assets/img/placeholder.jpg') }}" alt="Preview"
                  class="img-thumbnail" style="max-height:60px; display: none;"
                  onerror="this.onerror=null;this.src='{{ url('assets/img/placeholder.jpg') }}';">
              </div>
            </div>

          </div>
          <div class="modal-footer">
            <button type="submit" class="btn btn-primary">{{ __('locale.Update') }}</button>
          </div>
        </form>
      </div>
    </div>
  </div>
  <div id="role-helper" data-add="{{ __('locale.Add New Brand') }}"></div>
@endsection

@section('page-script')
  @vite(['resources/assets/js/vehicle-brand.js'])
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    window.permissions = {
      canDeleteBrand: @json(auth()->user()->can('vehicle-delete')),
      canEditBrand: @json(auth()->user()->can('vehicle-edit')),
      canCreateBrand: @json(auth()->user()->can('vehicle-create'))
    };
    // Preview for Add Brand
    document.getElementById('brand_image')?.addEventListener('change', function(e) {
      const img = document.getElementById('preview_image');
      const file = e.target.files[0];
      if (file) {
        img.src = URL.createObjectURL(file);
        img.style.display = 'block';
      } else {
        img.style.display = 'none';
      }
    });

    // Preview for Edit Brand
    document.getElementById('edit_brand_image')?.addEventListener('change', function(e) {
      const img = document.getElementById('edit_preview_image');
      const file = e.target.files[0];
      if (file) {
        img.src = URL.createObjectURL(file);
        img.style.display = 'block';
      } else {
        img.style.display = 'none';
      }
    });

    $(function() {
      const table = $('.datatables-users').DataTable();
      let $btn = null;

      $(document).on('click', '#upload_form button[type="submit"]', function() {
        $btn = $(this);
      });

      $('#upload_form').on('submit', function(event) {
        event.preventDefault();
        $.ajax({
          type: "POST",
          headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          },
          url: `${baseURL}/vehicle-brands`,
          data: new FormData(this),
          dataType: 'JSON',
          contentType: false,
          cache: false,
          processData: false,
          beforeSend: function() {
            toggleButtonLoading($btn, true, 'Saving...');
          },
          success: function(data) {
            if (data.status === 200 && data.data) {
              const brand = data.data;
              const newRow = table.row.add(brand).draw(false);
              $(newRow.node()).attr('id', `trRow-${brand.id}`);
              table.order([5, 'desc']).draw(false);

              $('#upload_form')[0].reset();
              const offcanvasEl = document.getElementById('offcanvasAdd');
              const bsOffcanvas = bootstrap.Offcanvas.getInstance(offcanvasEl);
              if (bsOffcanvas) bsOffcanvas.hide();
            }
            toggleButtonLoading($btn, false);
            const toastType = data.status == 200 ? 'bg-success' : 'bg-warning';
            window.showToast({
              title: 'Brands 🗂️',
              message: data.message,
              type: toastType,
              animation: 'animate__fadeInUp',
              time: 'Just now',
              delay: 3000
            });
          },
          error: function(xhr) {
            toggleButtonLoading($btn, false);
            console.log(xhr.responseJSON);
          }
        });
      });

      // Edit modal open
      $(document).on('click', '.edit-brand-modal', function() {
        $('#id_edit').val($(this).data('id'));
        $('#name_edit').val($(this).data('name'));
        const imageUrl = $(this).data('image');
        if (imageUrl) {
          $('#edit_preview_image').attr('src', imageUrl).show();
        } else {
          $('#edit_preview_image').hide();
        }
        $('#inlineForm').modal('show');
      });

      // Edit form submit
      $('#edit_form').on('submit', function(event) {
        event.preventDefault();
        const id = $('#id_edit').val();
        $.ajax({
          type: 'POST',
          url: `${baseURL}/vehicle-brands/${id}`,
          headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          },
          data: new FormData(this),
          dataType: 'JSON',
          contentType: false,
          cache: false,
          processData: false,
          beforeSend: function() {
            toggleButtonLoading($btn, true, 'Saving...');
          },
          success: function(data) {
            if (data.status === 200 && data.data) {
              const brand = data.data;
              const existingRow = table.row(`#trRow-${brand.id}`);
              if (existingRow.node()) {
                existingRow.data(brand).draw(false);
              }
              $('#inlineForm').modal('hide');
            }
            toggleButtonLoading($btn, false);
            const toastType = data.status == 200 ? 'bg-success' : 'bg-warning';
            window.showToast({
              title: 'Brands 🗂️',
              message: data.message,
              type: toastType,
              animation: 'animate__fadeInUp',
              time: 'Just now',
              delay: 3000
            });
          },
          error: function(xhr) {
            toggleButtonLoading($btn, false);
            console.log(xhr.responseJSON);
          }
        });
      });
    });
  </script>
@endsection
