@extends('layouts/layoutMaster')

@section('title', __('locale.Rides'))

@section('vendor-style')
  @vite(['resources/assets/css/datatables.scss', 'resources/assets/vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.scss'])
@endsection

@section('vendor-script')
  @vite(['resources/assets/js/datatables.js', 'resources/assets/vendor/libs/moment/moment.js', 'resources/assets/vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js', 'resources/assets/vendor/libs/raty-js/raty-js.js'])
@endsection


@section('content')
  <!-- Product List Table -->
  <div class="card">
    <div class="card-header border-bottom">
      <h5 class="card-title d-none">{{ __('locale.Filter') }}</h5>
      <div class="d-flex justify-content-between align-items-center row pt-0 gap-6 gap-md-0 g-md-6">
        <div class="col-md-3 driver">
          <label for="Driver" class="form-label">{{ __('locale.Drivers') }}</label>
          <select id="Driver" class="select2 form-select">
            <option value="">{{ __('locale.All') }}</option>
            @foreach ($drivers as $id => $name)
              <option value="{{ $id }}">{{ $name }}</option>
            @endforeach
          </select>
        </div>
        <div class="col-md-3 customer">
          <label for="Customers" class="form-label">{{ __('locale.Customers') }}</label>
          <select id="Customer" class="select2 form-select">
            <option value="">{{ __('locale.All') }}</option>
            @foreach ($customers as $id => $name)
              <option value="{{ $id }}">{{ $name }}</option>
            @endforeach
          </select>
        </div>
        <div class="col-md-3 date_filter">
          <label for="bs-rangepicker-range" class="form-label">{{ __('locale.Date') }}</label>
          <input type="text" class="form-control" placeholder="YYYY-MM-DD to YYYY-MM-DD" id="bs-rangepicker-range" />
        </div>

        <div class="col-md-3 ride_status"></div>
      </div>
    </div>
    <div class="card-datatable">
      <table class="datatables-ride table">
        <thead class="border-top">
          <tr>
            <th>{{ __('locale.ID') }}</th>
            <th>#</th>
            <th>{{ __('locale.User Details') }}</th>
            <th>{{ __('locale.Ride Details') }}</th>
            <th>{{ __('locale.Driver Details') }}</th>
            <th>{{ __('locale.Txn Detail') }}</th>
            <th>{{ __('locale.Address') }}</th>
            <th>{{ __('locale.Status') }}</th>
            <th>{{ __('locale.Actions') }}</th>
          </tr>
        </thead>
      </table>
    </div>
  </div>
  <div id="role-helper" data-query="mtype[]=Ride">
  @endsection
  @section('page-script')
    @vite(['resources/assets/js/ride.js', 'resources/assets/js/forms-pickers.js'])
  @endsection
