@extends('layouts/layoutMaster')

@section('title', __('locale.Rental Details'))

@section('vendor-style')
  @vite(['resources/assets/css/datatables.scss', 'resources/assets/vendor/libs/flatpickr/flatpickr.scss'])
@endsection

@section('page-style')
  @vite('resources/assets/vendor/scss/pages/page-user-view.scss')
@endsection

@section('vendor-script')
  @vite(['resources/assets/js/datatables.js', 'resources/assets/vendor/libs/flatpickr/flatpickr.js'])
@endsection

@section('content')
  <div class="row">
    <!-- User Sidebar -->
    <div class="col-xl-4 col-lg-5 order-1 order-md-0">
      <!-- Driver Card -->
      <div class="card mb-6">
        <div class="card-body pt-12">
          <div class="user-avatar-section">
            <div class="d-flex align-items-center flex-column">
              <img class="img-fluid rounded mb-4"
                src="{{ $rental->driver?->user?->profile_photo_path ? asset('storage/' . $rental->driver->user->profile_photo_path) : asset('assets/img/placeholder.jpg') }}"
                height="120" width="120" alt="Driver avatar" />
              <div class="user-info text-center">
                <h5>{{ $rental->driver?->user?->name ?? '-' }}</h5>
                <span class="badge bg-label-secondary">Driver</span>
              </div>
            </div>
          </div>

          <h5 class="pb-4 border-bottom mb-4">{{ __('locale.Driver Details') }}</h5>
          <div class="info-container">
            <ul class="list-unstyled mb-6">
              <li class="mb-2">
                <span class="h6">{{ __('locale.Name') }}:</span>
                <span>{{ $rental->driver?->user?->name ?? '-' }}</span>
              </li>
              <li class="mb-2">
                <span class="h6">{{ __('locale.Email') }}:</span>
                <span>{{ $rental->driver?->user?->email ?? '-' }}</span>
              </li>
              <li class="mb-2">
                <span class="h6">{{ __('locale.Phone') }}:</span>
                <span>{{ $rental->driver?->user?->phone ?? '-' }}</span>
              </li>
            </ul>
          </div>
        </div>
      </div>
      <!-- /Driver Card -->

      <!-- Car Card -->
      <div class="card mb-6 border border-2 border-primary rounded primary-shadow">
        <div class="card-body">
          <div class="d-flex align-items-center flex-column">
            <img class="img-fluid rounded mb-4"
              src="{{ $rental->car?->vehicle_image ? asset('storage/' . $rental->car->vehicle_image) : asset('default-car.png') }}"
              height="120" width="180" alt="Car Image" />
            <div class="user-info text-center">
              <h5>{{ $rental->car?->vehicle_model ?? '-' }}</h5>
              <span class="badge bg-label-primary">{{ $rental->car?->vehicle_brand ?? '-' }}</span>
            </div>
          </div>

          <h5 class="pb-4 border-bottom mb-4">{{ __('locale.Car Details') }}</h5>
          <div class="info-container">
            <ul class="list-unstyled mb-6">
              <li class="mb-2">
                <span class="h6">{{ __('locale.Model') }}:</span>
                <span>{{ $rental->car?->vehicle_model ?? '-' }}</span>
              </li>
              <li class="mb-2">
                <span class="h6">{{ __('locale.Brand') }}:</span>
                <span>{{ $rental->car?->vehicle_brand ?? '-' }}</span>
              </li>
              <li class="mb-2">
                <span class="h6">{{ __('locale.Number Plate') }}:</span>
                <span>{{ $rental->car?->vehicle_number ?? '-' }}</span>
              </li>
            </ul>
          </div>
        </div>
      </div>
      <!-- /Car Card -->
    </div>

    <!--/ User Sidebar -->

    <!-- User Content -->
    <div class="col-xl-8 col-lg-7 order-0 order-md-1">
      <!-- User Pills -->
      <div class="nav-align-top">
        <ul class="nav nav-tabs nav-fill" role="tablist">

          <li class="nav-item">
            <button type="button" class="nav-link active" role="tab" data-bs-toggle="tab"
              data-bs-target="#navs-justified-address" aria-controls="navs-justified-address" aria-selected="false">
              <span class="d-none d-sm-inline-flex align-items-center"><i
                  class="icon-base ti tabler-map-pin icon-sm me-1_5"></i>{{ __('locale.Rental Details') }}</span>
              <i class="icon-base ti tabler-map-pin icon-sm d-sm-none"></i>
            </button>
          </li>
          <li class="nav-item">
            <button type="button" class="nav-link" role="tab" data-bs-toggle="tab"
              data-bs-target="#navs-justified-installments" aria-controls="navs-justified-installments"
              aria-selected="false">
              <span class="d-none d-sm-inline-flex align-items-center"><i
                  class="icon-base ti tabler-adjustments icon-sm me-1_5"></i>{{ __('locale.Installments') }}</span>
              <i class="icon-base ti tabler-adjustments icon-sm d-sm-none"></i>
            </button>
          </li>
          <li class="nav-item">
            <button type="button" class="nav-link" role="tab" data-bs-toggle="tab"
              data-bs-target="#navs-justified-messages" aria-controls="navs-justified-messages" aria-selected="false">
              <span class="d-none d-sm-inline-flex align-items-center"><i
                  class="icon-base ti tabler-cards icon-sm me-1_5"></i>{{ __('locale.Payment History') }}</span>
              <i class="icon-base ti tabler-cards icon-sm d-sm-none"></i>
            </button>
          </li>
        </ul>
      </div>
      <!--/ User Pills -->


      <div class="card mb-6">
        <div class="tab-content">
          <div class="tab-pane fade show active" id="navs-justified-address" role="tabpanel">
            @php $currency=$rental->driver?->user?->currency ?? Helper::setting('currency_symbol', 'currency'); @endphp
            <div class="card card-action mb-6">
              <div class="card-header align-items-center py-6">
                <h5 class="card-action-title mb-0">{{ __('locale.Rental Details') }}</h5>
              </div>
              <div class="card-body">
                <div class="row mb-3">
                  <div class="col-md-6">
                    <strong>Order Type:</strong>
                    <span class="ms-2">{{ ucfirst($rental->order_type ?? '-') }}</span>
                  </div>
                  <div class="col-md-6">
                    <strong>Total Amount:</strong>
                    <span class="ms-2">{{ $currency ?? '' }}{{ number_format($rental->total_amount ?? 0, 2) }}</span>
                  </div>
                </div>

                <div class="row mb-3">
                  <div class="col-md-6">
                    <strong>Down Payment:</strong>
                    <span class="ms-2">{{ $currency ?? '' }}{{ number_format($rental->down_payment ?? 0, 2) }}</span>
                  </div>
                  <div class="col-md-6">
                    <strong>Pending Amount:</strong>
                    <span
                      class="ms-2 text-danger">{{ $currency ?? '' }}{{ number_format($rental->pending_amount ?? 0, 2) }}</span>
                  </div>
                </div>

                <div class="row mb-3">
                  <div class="col-md-6">
                    <strong>No. of Installments:</strong>
                    <span class="ms-2">{{ $rental->no_of_installments ?? '-' }}</span>
                  </div>
                  <div class="col-md-6">
                    <strong>Installment Amount:</strong>
                    <span
                      class="ms-2">{{ $currency ?? '' }}{{ number_format($rental->installment_amount ?? 0, 2) }}</span>
                  </div>
                </div>

                <div class="row mb-3">
                  <div class="col-md-6">
                    <strong>Security Amount:</strong>
                    <span
                      class="ms-2">{{ $currency ?? '' }}{{ number_format($rental->security_amount ?? 0, 2) }}</span>
                  </div>
                  <div class="col-md-6">
                    <strong>Status:</strong>
                    @php
                      $statusClass = $rental->status === 'Active' ? 'badge bg-success' : 'badge bg-danger';
                    @endphp
                    <span class="{{ $statusClass }} ms-2">{{ ucfirst($rental->status ?? '-') }}</span>
                  </div>
                </div>

                <div class="row mb-3">
                  <div class="col-md-6">
                    <strong>Start Date:</strong>
                    <span class="ms-2">{{ \Carbon\Carbon::parse($rental->start_date)->format('d M, Y') }}</span>
                  </div>
                  <div class="col-md-6">
                    <strong>Due Date:</strong>
                    @php
                      $dueClass = \Carbon\Carbon::parse($rental->due_date)->isPast()
                          ? 'text-danger fw-bold'
                          : 'text-success fw-bold';
                    @endphp
                    <span
                      class="{{ $dueClass }} ms-2">{{ \Carbon\Carbon::parse($rental->due_date)->format('d M, Y') }}</span>
                  </div>
                </div>
              </div>
            </div>
          </div>

          <div class="tab-pane fade" id="navs-justified-installments" role="tabpanel">
            @include('_partials/installment_list_table')
          </div>

          <div class="tab-pane fade" id="navs-justified-messages" role="tabpanel">
            <div class="card-header border-bottom">
              <h5 class="card-title d-none">{{ __('locale.Filter') }}</h5>
              <div class="d-flex justify-content-between align-items-center row pt-0 gap-6 gap-md-0 g-md-6">
                <div class="col-md-6 installment_status"></div>
                <div class="col-md-4 customer d-none"></div>
                <div class="col-md-6 date_filter">
                  <label for="bs-rangepicker-range" class="form-label">{{ __('locale.Date') }}</label>
                  <input type="text" class="form-control" placeholder="YYYY-MM-DD to YYYY-MM-DD"
                    id="flatpickr-range" />
                </div>
              </div>
            </div>
            <div class="card-datatable">
              <table class="datatables-installment table">
                <thead class="border-top">
                  <tr>
                    <th></th>
                    <th></th>
                    <th>{{ __('locale.Driver Details') }}</th>
                    <th>{{ __('locale.Vehicle Details') }}</th>
                    <th>{{ __('locale.Date') }}</th>
                    <th>{{ __('locale.Installment Details') }}</th>
                    <th>{{ __('locale.Due Date') }}</th>
                    <th>{{ __('locale.Status') }}</th>
                    <th>{{ __('locale.Actions') }}</th>
                  </tr>
                </thead>
              </table>
            </div>
          </div>
        </div>
      </div>


    </div>
    <!--/ User Content -->
  </div>
  <!-- /Modal -->
  @php
    // Prepare installments array safely
    $installmentsArray = $rental->installments
        ->map(function ($ins) {
            return [
                'id' => $ins->id,
                'due_date' => $ins->payment_date,
                'amount' => $ins->amount,
                'paid_amount' => $ins->paid_amount,
                'status' => $ins->paid_amount >= $ins->amount ? 'Paid' : ($ins->paid_amount > 0 ? 'Partial' : 'Unpaid'),
            ];
        })
        ->toArray();
  @endphp
@endsection

@section('page-script')
  <script>
    window.permissions = {
      RentalId: @json(request()->segment(3))
    };
  </script>
  @vite(['resources/assets/js/installment.js', 'resources/assets/js/forms-pickers.js'])
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    // Works for both <button> and <a> tabs
    $(document).on('click', 'button[data-bs-toggle="tab"][data-bs-target="#navs-justified-messages"]', function() {
      if ($.fn.DataTable.isDataTable('.datatables-installment')) {
        // Reload data if table already exists
        $('.datatables-installment').DataTable().ajax.reload(null, false);
      } else {
        // Init if not already initialized
        initInstallmentTable();
      }

      // Adjust columns after showing
      setTimeout(() => {
        $('.datatables-installment').DataTable()
          .columns.adjust()
          .responsive.recalc()
          .draw(false);
      }, 50);
    });

    function showInstallments(installments, currency, startDate, totalInstallments, installmentAmount) {
      let tbody = document.getElementById("installmentsBody");
      tbody.innerHTML = "";

      // Ensure installments is parsed into array
      if (typeof installments === "string") {
        try {
          installments = JSON.parse(installments);
        } catch {
          installments = [];
        }
      } else if (!Array.isArray(installments)) {
        installments = [];
      }

      // Calculate total paid amount
      let totalPaid = installments.reduce((sum, ins) => sum + parseFloat(ins.paid_amount || 0), 0);

      let currentDate = new Date(startDate);

      for (let i = 0; i < totalInstallments; i++) {
        currentDate.setMonth(currentDate.getMonth() + (i === 0 ? 0 :
          1)); // first installment = startDate, others +1 month
        const formattedDate = currentDate.toISOString().split("T")[0];

        let amount = parseFloat(installmentAmount);
        let paidAmount = 0;
        let status = "";

        if (totalPaid >= amount) {
          paidAmount = amount;
          totalPaid -= amount;
          status = `<span class="badge bg-success">Paid</span>`;
        } else if (totalPaid > 0 && totalPaid < amount) {
          paidAmount = totalPaid;
          totalPaid = 0;
          status = `<span class="badge bg-warning">Partial</span>`;
        } else {
          paidAmount = 0;
          status = `<span class="badge bg-danger">Unpaid</span>`;
        }

        tbody.innerHTML += `
        <tr>
          <td>${i + 1}</td>
          <td>${formattedDate}</td>
          <td>${currency}${amount.toFixed(2)}</td>
          <td>${currency}${paidAmount.toFixed(2)}</td>
          <td>${status}</td>
        </tr>
      `;
      }

      new bootstrap.Modal(document.getElementById("installmentsModal")).show();
    }

    document.addEventListener('DOMContentLoaded', function() {
      const installments = @json($installmentsArray);
      const currency = "{{ $currency }}";
      const startDate = "{{ $rental->start_date }}";
      const totalInstallments = {{ $rental->no_of_installments }};
      const installmentAmount = {{ $rental->installment_amount }};

      showInstallments(installments, currency, startDate, totalInstallments, installmentAmount);
    });
  </script>
@endsection
