@extends('layouts/layoutMaster')

@section('title', __('locale.Driver Details'))

@section('vendor-style')
  @vite(['resources/assets/css/datatables.scss', 'resources/assets/vendor/libs/apex-charts/apex-charts.scss', 'resources/assets/vendor/libs/raty-js/raty-js.scss', 'resources/assets/vendor/libs/flatpickr/flatpickr.scss'])
@endsection

@section('vendor-script')
  @vite(['resources/assets/js/datatables.js', 'resources/assets/vendor/libs/moment/moment.js', 'resources/assets/vendor/libs/apex-charts/apexcharts.js', 'resources/assets/vendor/libs/raty-js/raty-js.js', 'resources/assets/vendor/libs/flatpickr/flatpickr.js'])
@endsection

@section('page-style')
  @vite('resources/assets/vendor/scss/pages/app-ecommerce.scss')
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fancyapps/ui@6.0/dist/fancybox/fancybox.css" />
  <style>
    .raty {
      display: inline-flex;
      align-items: center;
      gap: 2px;
    }

    .raty img {
      display: inline-block;
      vertical-align: middle;
    }

    .datatables-review .raty img {
      block-size: 0.8rem !important;
      font-size: 0.8rem !important;
      inline-size: 0.8rem !important;
    }

    .datatables-review .raty {
      display: inline-flex;
      align-items: center;
      gap: 0px !important;
    }

    .datatables-ride .raty img {
      block-size: 0.8rem !important;
      font-size: 0.8rem !important;
      inline-size: 0.8rem !important;
    }

    .datatables-ride .raty {
      display: inline-flex;
      align-items: center;
      gap: 0px !important;
    }
  </style>
@endsection

@section('content')
  <div class="row">
    <!-- User Sidebar -->
    <div class="col-xl-4 col-lg-5 order-1 order-md-0">
      <!-- User Card -->
      <div class="card mb-6">
        <div class="card-body pt-4">
          <div class="user-avatar-section">
            <div class=" d-flex align-items-center flex-column">
              <!-- Profile image wrapper -->
              <div class="position-relative d-inline-block">
                <img class="img-fluid rounded mb-4" src="{{ asset($user->profile_photo_url) }}" height="120"
                  width="120" alt="User avatar" />
                <!-- Edit icon overlay -->
                <a href="{{ url('admin/drivers') }}/{{ $user['driver']?->id }}/edit"type="button"
                  class="btn btn-sm btn-icon btn-primary waves-effect position-absolute bottom-0 end-0 p-0"
                  style="transform: translate(40%, -10%);">
                  <i class="icon-base ti tabler-edit icon-20px"></i>
                </a>
              </div>

              <div class="user-info text-center">
                <h5>{{ $user->name }}</h5>

                <span class="badge bg-label-primary">{{ $user['driver']?->type }} {{ $user->user_type }}</span>
              </div>
            </div>
          </div>
          <div class="d-flex justify-content-around flex-wrap my-6 gap-0 gap-md-3 gap-lg-4">
            <div class="d-flex align-items-center me-5 gap-4">
              <div class="avatar">
                <div class="avatar-initial bg-label-primary rounded">
                  <i
                    class="icon-base ti @if ($user['driver']?->type == 'Ride') tabler-car @else tabler-truck-delivery @endif icon-lg"></i>
                </div>
              </div>
              <div>
                <h5 class="mb-0">
                  @if ($user['driver']?->is_active == 1)
                    <span class="badge bg-label-success">{{ __('locale.Active') }}</span>
                  @else
                    <span class="badge bg-label-danger">{{ __('locale.Inactive') }}</span>
                  @endif
                </h5>
                <span>{{ __('locale.Status') }}</span>
              </div>
            </div>
            <div class="d-flex align-items-center gap-4">
              <div class="avatar">
                <div class="avatar-initial bg-label-primary rounded">
                  <i class="icon-base ti tabler-briefcase icon-lg"></i>
                </div>
              </div>
              <div>
                <h5 class="mb-0">{{ $user['driver']?->rides_count }}</h5>
                <span>
                  @if ($user['driver']?->type == 'Ride')
                    {{ __('locale.Rides') }}
                  @else
                    {{ __('locale.Orders') }}
                  @endif
                </span>
              </div>
            </div>
          </div>
          <h5 class="pb-4 border-bottom mb-4">{{ __('locale.Details') }}</h5>
          <div class="info-container">
            <ul class="list-unstyled mb-6">
              <li class="mb-2">
                <span class="h6">{{ __('locale.Name') }}:</span>
                <span>{{ $user->name }}</span>
              </li>
              <li class="mb-2">
                <span class="h6">{{ __('locale.Email') }}:</span>
                <span>{{ $user->email }}</span>
              </li>
              <li class="mb-2">
                <span class="h6">{{ __('locale.Phone') }}:</span>
                <span>{{ $user->dial_code }} {{ $user->phone }}</span>
              </li>
              <li class="mb-2">
                <span class="h6">{{ __('locale.Gender') }}:</span>
                <span>{{ $user['driver']?->gender }}</span>
              </li>
              <li class="mb-2">
                <span class="h6">{{ __('locale.DOB') }}:</span>
                <span>{{ $user['driver']?->dob ?? 'N/A' }}</span>
              </li>
              <li class="mb-2">
                <span class="h6">{{ __('locale.Status') }}:</span>
                <span>
                  @if ($user->status == 1)
                    <span class="badge bg-label-primary">{{ __('locale.Enable') }}</span>
                  @else
                    <span class="badge bg-label-secondary">{{ __('locale.Disable') }}</span>
                  @endif
                </span>
              </li>
              <li class="mb-2">
                <span class="h6">{{ __('locale.Account Verified') }}:</span>
                <span>
                  @if ($user->is_verified == 1)
                    <span class="badge bg-label-success">{{ __('locale.Verified') }}</span>
                  @else
                    <span class="badge bg-label-secondary">{{ __('locale.Not Verified') }}</span>
                  @endif
                </span>
              </li>
            </ul>
            <div class="row gy-6">
              <div class="col-xxl-12 col-sm-12 col-12">
                <div class="card">
                  <h5 class="card-header">{{ __('locale.Rating') }}</h5>
                  <div class="card-body">
                    <div class="read-only-ratings raty" data-read-only="true"
                      data-score="{{ $user['driver']?->rating ?? 0 }}" data-number="5"></div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>

      <div class="col-md-12 mb-12">
        <div class="card h-100">
          <div class="card-body">
            <div class="card-icon mb-2">
              <div class="avatar">
                <div class="avatar-initial rounded bg-label-primary">
                  <i class="icon-base ti tabler-currency-dollar icon-lg"></i>
                </div>
              </div>
            </div>
            <div class="card-info">
              <h5 class="card-title mb-2">{{ __('locale.Account Balance') }}</h5>
              <div class="d-flex align-items-baseline gap-1">
                <h5 class="text-primary mb-0">
                  {{ $user->currency ?? \App\Helpers\Helpers::setting('currency_symbol', 'currency') }}{{ $user['driver']?->wallet ?? 0 }}
                </h5>
              </div>
            </div>
          </div>
        </div>
      </div>
      <!-- /User Card -->
      <!-- Plan Card -->
      <div class="card mb-6 border border-2 border-primary rounded primary-shadow">
        <div class="card-body">
          <div class="d-flex justify-content-between align-items-start">
            <span class="badge bg-label-primary">{{ __('locale.Login Details') }}</span>
          </div>
          <ul class="list-unstyled g-2 my-6">
            <li class="mb-2">
              <span class="h6">{{ __('locale.Last Login') }}:</span>
              <span>{{ $user->last_seen }}</span>
            </li>
          </ul>
        </div>
      </div>
      <!-- /Plan Card -->
    </div>
    <!--/ User Sidebar -->

    <!-- User Content -->
    <div class="col-xl-8 col-lg-7 order-0 order-md-1">
      <!-- User Pills -->
      <div class="nav-align-top">
        <ul class="nav nav-tabs nav-fill" role="tablist">
          <li class="nav-item">
            <button type="button" class="nav-link active" role="tab" data-bs-toggle="tab"
              data-bs-target="#navs-justified-home" aria-controls="navs-justified-home" aria-selected="true">
              <span class="d-none d-sm-inline-flex align-items-center">
                <i
                  class="icon-base ti @if ($user['driver']?->type == 'Ride') tabler-car @else tabler-truck-delivery @endif icon-sm me-1_5"></i>{{ __('locale.Vehicle Details') }}
                <span class="badge rounded-pill badge-center h-px-20 w-px-20 bg-label-danger ms-1_5"></span>
              </span>
              <i
                class="icon-base ti @if ($user['driver']?->type == 'Ride') tabler-car @else tabler-truck-delivery @endif icon-sm d-sm-none"></i>
            </button>
          </li>
          <li class="nav-item">
            <button type="button" class="nav-link" role="tab" data-bs-toggle="tab"
              data-bs-target="#navs-justified-profile" aria-controls="navs-justified-profile" aria-selected="false">
              <span class="d-none d-sm-inline-flex align-items-center"><i
                  class="icon-base ti tabler-address-book icon-sm me-1_5"></i>{{ __('locale.Address') }}</span>
              <i class="icon-base ti tabler-address-book icon-sm d-sm-none"></i>
            </button>
          </li>
          <li class="nav-item">
            <button type="button" class="nav-link" role="tab" data-bs-toggle="tab"
              data-bs-target="#navs-justified-reviews" aria-controls="navs-justified-reviews" aria-selected="false">
              <span class="d-none d-sm-inline-flex align-items-center"><i
                  class="icon-base ti tabler-star icon-sm me-1_5"></i>{{ __('locale.Reviews') }}</span>
              <i class="icon-base ti tabler-star icon-sm d-sm-none"></i>
            </button>
          </li>
          <li class="nav-item">
            <button type="button" class="nav-link" role="tab" data-bs-toggle="tab"
              data-bs-target="#navs-justified-rides" aria-controls="navs-justified-rides" aria-selected="false">
              <span class="d-none d-sm-inline-flex align-items-center"><i
                  class="icon-base ti @if ($user['driver']?->type == 'Ride') tabler-car @else tabler-truck-delivery @endif icon-sm me-1_5"></i>
                @if ($user['driver']?->type == 'Ride')
                  {{ __('locale.Rides') }}
                @else
                  {{ __('locale.Orders') }}
                @endif
              </span>
              <i
                class="icon-base ti @if ($user['driver']?->type == 'Ride') tabler-car @else tabler-truck-delivery @endif icon-sm d-sm-none"></i>
            </button>
          </li>
        </ul>
      </div>
      <!--/ User Pills -->


      <div class="card mb-6">
        <div class="tab-content">
          <div class="tab-pane fade show active" id="navs-justified-home" role="tabpanel">
            <div class="card">
              <div class="card-body row gy-6">
                <div class="col-sm-12 col-lg-6 text-center px-4">
                  <span class="badge bg-label-primary rounded mb-4 h-px-52 w-px-52 p-2"><i
                      class="icon-base ti @if ($user['driver']?->type == 'Ride') tabler-car @else tabler-truck-delivery @endif icon-36px"></i></span>
                  <h4 class="card-title mb-4">{{ $user['driver']['vehicle']?->vehicle_model }}</h4>
                  <p class="card-text">
                  <div class="btn-group" role="group" aria-label="Basic example">
                    <button type="button"
                      class="btn btn-secondary waves-effect waves-light">{{ $user['driver']['vehicle']?->parent_category }}</button>
                    <button type="button"
                      class="btn btn-secondary waves-effect waves-light">{{ $user['driver']['vehicle']?->vehicle_category }}</button>
                    <button type="button" class="btn btn-secondary waves-effect waves-light">
                      {{ $user['driver']['vehicle']?->vehicle_year }}</button>
                  </div>
                  </p>
                  <div class="demo-inline-spacing mt-2">
                    <button class="btn btn-primary">{{ $user['driver']['vehicle']?->vehicle_brand }}</button>
                    <button class="btn"
                      style="background:{{ $user['driver']['vehicle']['color']['code'] ?? '#ccc' }} ">
                      {{ __('locale.Color') }}: {{ $user['driver']['vehicle']['color']['name'] ?? '#ccc' }}</button>

                  </div>

                </div>
                <div class="col-12 col-md-6 col-lg-6">
                  <div class="card h-100 shadow-none border">
                    <div class="p-2 pb-0">
                      <a data-fancybox="gallery" data-caption="{{ __('locale.Insurance Image') }}"
                        href='{{ asset('storage/' . $user['driver']['vehicle']?->vehicle_image) }}'> <img
                          class="img-fluid scaleX-n1-rtl"
                          src="{{ asset('storage/' . $user['driver']['vehicle']?->vehicle_image) }}"
                          onerror="this.onerror=null;this.src=`{{ asset('assets/img/placeholder.jpg') }}`;" /></a>
                    </div>
                    <div class="card-body">
                      <h5 class="card-title">{{ $user['driver']['vehicle']?->license_plate }}</h5>
                      <p class="card-text">
                        {{ $user['driver']['vehicle']?->registration_number }}</p>
                    </div>
                  </div>
                </div>

              </div>
            </div>
            <div class="card">
              <div class="card-body row gy-6">
                <div class="col-md-6 col-lg-4">
                  <h6 class="mt-2 text-body-secondary"> {{ __('locale.Insurance Image') }}</h6>
                  <div class="card">
                    <a data-fancybox="gallery" data-caption="{{ __('locale.Insurance Image') }}"
                      href='{{ asset('storage/' . $user['driver']['vehicle']?->insurance_image) }}'><img
                        class="card-img-top"
                        src="{{ asset('storage/' . $user['driver']['vehicle']?->insurance_image) }}"
                        alt="{{ __('locale.Insurance Image') }}"
                        onerror="this.onerror=null;this.src=`{{ asset('assets/img/placeholder.jpg') }}`;">
                    </a>
                  </div>
                </div>
                <div class="col-md-6 col-lg-4">
                  <h6 class="mt-2 text-body-secondary"> {{ __('locale.Road Worthiness') }}</h6>
                  <div class="card">
                    <a data-fancybox="gallery" data-caption="{{ __('locale.Road Worthiness') }}"
                      href='{{ asset('storage/' . $user['driver']['vehicle']?->road_worthiness_image) }}'><img
                        class="card-img-top"
                        src="{{ asset('storage/' . $user['driver']['vehicle']?->road_worthiness_image) }}"
                        alt="{{ __('locale.Road Worthiness') }}"
                        onerror="this.onerror=null;this.src=`{{ asset('assets/img/placeholder.jpg') }}`;">
                    </a>
                  </div>
                </div>
                <div class="col-md-6 col-lg-4">
                  <h6 class="mt-2 text-body-secondary"> {{ __('locale.Vehicle Registration') }}</h6>
                  <div class="card">
                    <a data-fancybox="gallery" data-caption="{{ __('locale.Vehicle Registration') }}"
                      href='{{ asset('storage/' . $user['driver']['vehicle']?->vehicle_registration_image) }}'><img
                        class="card-img-top"
                        src="{{ asset('storage/' . $user['driver']['vehicle']?->vehicle_registration_image) }}"
                        alt="{{ __('locale.Vehicle Registration') }}"
                        onerror="this.onerror=null;this.src=`{{ asset('assets/img/placeholder.jpg') }}`;">
                    </a>
                  </div>
                </div>
              </div>
            </div>

            <div class="col-lg-12">
              <div class="card shadow-none bg-label-danger h-100">
                <div class="card-body d-flex justify-content-between ">
                  <div class="col-md-6 mb-0  app-academy-sm-60 justify-content-between text-center text-sm-start">
                    <div class="card-title">
                      <h5 class="text-danger mb-2">{{ __('locale.Driver License') }}</h5>
                      <p class="text-body app-academy-sm-60 app-academy-xl-100">
                        {{ __('locale.Expiry Date') }}: {{ $user['driver']?->license_expiry }}
                      </p>
                    </div>
                    <div class="mb-0">
                      <button class="btn btn-sm btn-info">{{ $user['driver']?->license_number }}</button>
                    </div>
                  </div>
                  <div
                    class=" col-md-6 app-academy-sm-40 justify-content-center justify-content-sm-end  mb-4 mb-sm-0">
                    <img class="img-fluid scaleX-n1-rtl"
                      src="{{ asset('storage/' . $user['driver']?->license_image) }}"
                      alt="{{ $user['driver']?->license_number }}"
                      onerror="this.onerror=null;this.src=`{{ asset('assets/img/placeholder.jpg') }}`;" />
                  </div>
                </div>
              </div>
            </div>

          </div>
          <div class="tab-pane fade" id="navs-justified-profile" role="tabpanel">
            <div class="card card-action mb-4">
              <div class="card-header align-items-center flex-wrap gap-2">
                <h5 class="card-action-title mb-0">{{ __('locale.Address') }}</h5>
                <div class="card-action-element">

                </div>
              </div>
              <div class="card-body">
                <div class="row">
                  <div class="col-xl-7 col-12">
                    <dl class="row mb-0 gx-2">
                      <dt class="col-sm-4 mb-sm-2 text-nowrap fw-medium text-heading">{{ __('locale.Name') }}:</dt>
                      <dd class="col-sm-8">{{ $user->name }}</dd>
                      <dt class="col-sm-4 mb-sm-2 text-nowrap fw-medium text-heading">{{ __('locale.Phone') }}:</dt>
                      <dd class="col-sm-8">{{ $user->phone }}</dd>

                      <dt class="col-sm-4 mb-sm-2 text-nowrap fw-medium text-heading mb-0">{{ __('locale.Address') }}:
                      </dt>
                      <dd class="col-sm-8 mb-0">
                        {{ $user['driver']?->address }}
                      </dd>
                      <dt class="col-sm-4 mb-sm-2 text-nowrap fw-medium text-heading">{{ __('locale.Landmark') }}:</dt>
                      <dd class="col-sm-8">{{ $user['driver']?->landmark }}</dd>
                    </dl>
                  </div>
                  <div class="col-xl-5 col-12">
                    <dl class="row mb-0 gx-2">


                      <dt class="col-sm-4 mb-sm-2 text-nowrap fw-medium text-heading">{{ __('locale.Country') }}:</dt>
                      <dd class="col-sm-8">{{ $user['driver']?->country }}</dd>

                      <dt class="col-sm-4 mb-sm-2 text-nowrap fw-medium text-heading">{{ __('locale.State') }}:</dt>
                      <dd class="col-sm-8">{{ $user['driver']?->state }}</dd>
                      <dt class="col-sm-4 mb-sm-2 text-nowrap fw-medium text-heading">{{ __('locale.City') }}:</dt>
                      <dd class="col-sm-8">{{ $user['driver']?->city }}</dd>
                      <dt class="col-sm-4 mb-sm-2 text-nowrap fw-medium text-heading">{{ __('locale.Postcode') }}:</dt>
                      <dd class="col-sm-8">{{ $user['driver']?->postcode }}</dd>
                    </dl>
                  </div>
                </div>
              </div>
            </div>
          </div>


          <div class="tab-pane fade" id="navs-justified-reviews" role="tabpanel">
            <div class="row mb-6 g-6">
              {{-- Left: Rating Summary --}}
              <div class="col-md-12">
                <div class="card h-100">
                  <div class="card-body row widget-separator g-0">
                    {{-- Left side with main rating --}}
                    <div class="col-sm-5 border-shift border-end pe-sm-6">
                      <h3 class="text-primary d-flex align-items-center gap-2 mb-2">
                        {{ number_format($reviewData['avg_rating'], 2) }}
                        <i class="icon-base ti tabler-star-filled icon-32px"></i>
                      </h3>
                      <p class="h6 mb-2">{{ __('locale.Total') }} {{ $reviewData['total_reviews'] }}
                        {{ __('locale.Reviews') }}</p>
                      <p class="pe-2 mb-2">{{ __('locale.All reviews are from genuine customers') }}</p>
                      <span class="badge bg-label-primary mb-4 mb-sm-0">
                        +{{ $reviewData['new_reviews'] }} {{ __('locale.This week') }}
                      </span>
                      <hr class="d-sm-none" />
                    </div>

                    {{-- Right side with star progress --}}
                    <div
                      class="col-sm-7 gap-2 text-nowrap d-flex flex-column justify-content-between ps-sm-6 pt-2 py-sm-2">
                      @foreach (range(5, 1) as $star)
                        <div class="d-flex align-items-center gap-2">
                          <small>{{ $star }} Star</small>
                          <div class="progress w-100 bg-label-primary" style="height:8px;">
                            <div class="progress-bar bg-primary" role="progressbar"
                              style="width: {{ $reviewData['progress'][$star]['percent'] ?? 0 }}%"
                              aria-valuenow="{{ $reviewData['progress'][$star]['percent'] ?? 0 }}" aria-valuemin="0"
                              aria-valuemax="100">
                            </div>
                          </div>
                          <small class="w-px-20 text-end">{{ $reviewData['progress'][$star]['count'] ?? 0 }}</small>
                        </div>
                      @endforeach
                    </div>
                  </div>
                </div>
              </div>

              {{-- Right: Weekly Statistics --}}
              <div class="col-md-12">
                <div class="card h-100">
                  <div class="card-body row">
                    <div class="col-sm-5">
                      <div class="mb-12">
                        <h5 class="mb-2 text-nowrap">{{ __('locale.Reviews statistics') }}</h5>
                        <p class="mb-0">
                          <span class="me-2">{{ $reviewData['new_reviews'] }} {{ __('locale.New reviews') }}</span>
                          <span class="badge bg-label-success">
                            +{{ $reviewData['total_reviews'] > 0
                                ? round(($reviewData['new_reviews'] / $reviewData['total_reviews']) * 100, 1)
                                : 0 }}%
                          </span>
                        </p>
                      </div>

                      @php
                        $positiveReviews =
                            ($reviewData['progress'][5]['count'] ?? 0) + ($reviewData['progress'][4]['count'] ?? 0);
                        $positivePercentage =
                            $reviewData['total_reviews'] > 0
                                ? round(($positiveReviews / $reviewData['total_reviews']) * 100, 1)
                                : 0;
                      @endphp

                      <div>
                        <h6 class="mb-2 fw-normal">
                          <span class="text-success me-1">{{ $positivePercentage }}%</span>
                          {{ __('locale.Positive reviews') }}
                        </h6>
                        <small>{{ __('locale.Weekly Report') }}</small>
                      </div>
                    </div>

                    {{-- Placeholder for Chart --}}
                    <div class="col-sm-7 d-flex justify-content-sm-end align-items-end">
                      <div id="reviewsChart"></div>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <!-- review List Table -->
            <div class="card">
              <div class="card-datatable table-responsive">
                <table class="datatables-review table border-top">
                  <thead>
                    <tr>
                      <th></th>
                      <th></th>
                      <th>{{ __('locale.Product') }}</th>
                      <th class="text-nowrap">{{ __('locale.Reviewer') }}</th>
                      <th>{{ __('locale.Review') }}</th>
                      <th>{{ __('locale.Date') }}</th>
                      <th class="text-nowrap">{{ __('locale.Status') }}</th>
                      <th>{{ __('locale.Actions') }}</th>
                    </tr>
                  </thead>
                </table>
              </div>
            </div>
          </div>

          <div class="tab-pane fade" id="navs-justified-rides" role="tabpanel">
            <div class="card-header border-bottom">
              <h5 class="card-title d-none">{{ __('locale.Filter') }}</h5>
              <div class="d-flex justify-content-between align-items-center row pt-0 gap-6 gap-md-0 g-md-6">
                <div class="col-md-3 driver"></div>
                <div class="col-md-6 customer d-none"></div>
                <div class="col-md-3 date_filter">
                  <input type="text" class="form-control" placeholder="YYYY-MM-DD to YYYY-MM-DD"
                    id="flatpickr-range" />
                </div>
                <div class="col-md-3 ride_type"></div>
                <div class="col-md-3 ride_status"></div>
              </div>
            </div>
            <div class="card-datatable table-responsive">
              <table class="datatables-ride table">
                <thead class="border-top">
                  <tr>
                    <th>{{ __('locale.ID') }}</th>
                    <th></th>
                    <th>{{ __('locale.User Details') }}</th>
                    <th>{{ __('locale.Ride Details') }}</th>
                    <th>{{ __('locale.Driver Details') }}</th>
                    <th>{{ __('locale.Txn Detail') }}</th>
                    <th>{{ __('locale.Address') }}</th>
                    <th>{{ __('locale.Status') }}</th>
                    <th>{{ __('locale.Actions') }}</th>
                  </tr>
                </thead>
              </table>
            </div>

          </div>
        </div>
      </div>


    </div>
    <!--/ User Content -->
  </div>
  <!-- /Modal -->
@endsection

@section('page-script')
  <script>
    window.permissions = {
      DriverId: @json(optional($user['driver'])->id),
      reviewableId: @json(optional($user['driver'])->id),
      reviewableType: @json('driver')
    };
    window.reviewData = @json($reviewData['weeklyReviewCounts']);
  </script>
  @vite(['resources/assets/js/reviews.js', 'resources/assets/js/star-ratings.js', 'resources/assets/js/ride.js', 'resources/assets/js/forms-pickers.js'])
  <script src="https://cdn.jsdelivr.net/npm/@fancyapps/ui@6.0/dist/fancybox/fancybox.umd.js"></script>
  <script>
    Fancybox.bind("[data-fancybox='gallery']", {
      Thumbs: false,
      Toolbar: true
    });
  </script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    // Works for both <button> and <a> tabs
    $(document).on('click', 'button[data-bs-toggle="tab"][data-bs-target="#navs-justified-rides"]', function() {
      if ($.fn.DataTable.isDataTable('.datatables-ride')) {
        // Reload data if table already exists
        $('.datatables-ride').DataTable().ajax.reload(null, false);
      } else {

      }

      // Adjust columns after showing
      setTimeout(() => {
        $('.datatables-ride').DataTable()
          .columns.adjust()
          .responsive.recalc()
          .draw(false);
      }, 50);
    });
    $(document).on('click', 'button[data-bs-toggle="tab"][data-bs-target="#navs-justified-reviews"]', function() {
      if ($.fn.DataTable.isDataTable('.datatables-review')) {
        // Reload data if table already exists
        $('.datatables-review').DataTable().ajax.reload(null, false);
      } else {

      }

      setTimeout(() => {
        $('.datatables-review').DataTable()
          .columns.adjust()
          .responsive.recalc()
          .draw(false);
      }, 50);
    });
  </script>
@endsection
