@extends('layouts/layoutMaster')

@section('title', __('locale.Delivery Charges'))

<!-- Vendor Styles -->
@section('vendor-style')
  @vite(['resources/assets/vendor/libs/maxLength/maxLength.scss', 'resources/assets/vendor/libs/sweetalert2/sweetalert2.scss'])
@endsection

<!-- Vendor Scripts -->
@section('vendor-script')
  @vite(['resources/assets/vendor/libs/cleave-zen/cleave-zen.js', 'resources/assets/vendor/libs/jquery-repeater/jquery-repeater.js', 'resources/assets/vendor/libs/sweetalert2/sweetalert2.js'])
@endsection



@section('content')

  <!-- Form with Tabs -->
  <div class="row">
    <div class="col">
      <h6 class="mt-6">{{ __('locale.Delivery Charges') }}</h6>
      <div class="card mb-6">
        <div class="card-body">
          @include('_partials.flashMessage')
          <div class="alert alert-warning mb-3" role="alert">
            @php
              $currency = Helper::setting('currency_symbol', 'currency');
              $selected_country = $country;
            @endphp
            @if (empty($selected_country))
              <div class="alert row alert-info mb-0 h5 mx-0" role="alert">
                <span class=" col-3 alert-icon me-0 rounded-2 px-0">
                  <i class="icon-sm ti tabler-info-circle icon-md"></i>
                </span>
                <div class="col text-wrap ps-4 pe-0">
                  {{ __('locale.Please select the country from dropdown to get delivery charges result') }}</div>
              </div>
            @endif

            <!-- Form Repeater -->
            <div class="col-12">
              <div class="mb-3">
                <label for="countries" class="form-label">{{ __('locale.Select Country') }}</label>
                <select name="country" id="country" class="select2 form-select">
                  <option value="">{{ __('locale.Select Country') }}</option>
                  @foreach ($countries as $country)
                    <option value="{{ $country->id }}" @if ($country->id == $selected_country) selected @endif>
                      {{ $country->name }} ({{ $country->currency_symbol }})</option>
                  @endforeach
                </select>
              </div>
              <div class="card">
                @if (!empty($selected_country))
                  <div class="card-body">
                    <form class="form-repeater" id="deliveryChargesForm" method="POST"
                      action="{{ route('delivery_charges.store') }}">
                      @csrf
                      <input type="hidden" name="country_id" value="{{ $selected_country }}">

                      <div data-repeater-list="group-a">
                        @forelse($charges as $charge)
                          <div data-repeater-item>
                            <div class="row">
                              <input type="hidden" name="id" value="{{ $charge->id }}">
                              <div class="mb-6 col-lg-6 col-xl-2 col-12 mb-0">
                                <label class="form-label">{{ __('From KM') }}</label>
                                <div class="input-group">
                                  <input type="text" class="form-control from-km" name="from_km"
                                    value="{{ $charge->from_km }}">
                                  <span class="input-group-text">{{ __('KM') }}</span>
                                </div>
                              </div>
                              <div class="mb-6 col-lg-6 col-xl-2 col-12 mb-0">
                                <label class="form-label">{{ __('To KM') }}</label>
                                <div class="input-group">
                                  <input type="text" class="form-control to-km" name="to_km"
                                    value="{{ $charge->to_km }}">
                                  <span class="input-group-text">{{ __('KM') }}</span>
                                </div>
                              </div>
                              <div class="mb-6 col-lg-6 col-xl-2 col-12 mb-0">
                                <label class="form-label">{{ __('Amount') }}</label>
                                <div class="input-group">
                                  <input type="text" class="form-control" name="amount"
                                    value="{{ $charge->amount }}">
                                  <span class="input-group-text">{{ $currency }}</span>
                                </div>
                              </div>

                              <div class="mb-6 col-lg-12 col-xl-2 col-12 d-flex align-items-center mb-0">
                                <button type="button" class="btn btn-label-danger mt-xl-6 btn-delete"
                                  data-id="{{ $charge->id }}">
                                  <i class="icon-base ti tabler-x me-1"></i>
                                </button>
                              </div>
                            </div>
                            <hr>
                          </div>
                        @empty
                          {{-- If no charges, show an empty row --}}
                          <div data-repeater-item>
                            <div class="row">
                              <div class="mb-6 col-lg-6 col-xl-2 col-12 mb-0">
                                <label class="form-label">{{ __('From KM') }}</label>
                                <div class="input-group">
                                  <input type="text" class="form-control from-km" name="from_km">
                                  <span class="input-group-text">{{ __('KM') }}</span>
                                </div>
                              </div>
                              <div class="mb-6 col-lg-6 col-xl-2 col-12 mb-0">
                                <label class="form-label">{{ __('To KM') }}</label>
                                <div class="input-group">
                                  <input type="text" class="form-control to-km" name="to_km">
                                  <span class="input-group-text">{{ __('KM') }}</span>
                                </div>
                              </div>
                              <div class="mb-6 col-lg-6 col-xl-2 col-12 mb-0">
                                <label class="form-label">{{ __('Amount') }}</label>
                                <div class="input-group">
                                  <input type="text" class="form-control" name="amount">
                                  <span class="input-group-text">{{ $currency }}</span>
                                </div>
                              </div>
                              <div class="mb-6 col-lg-12 col-xl-2 col-12 d-flex align-items-center mb-0">
                                <button class="btn btn-label-danger mt-xl-6" data-repeater-delete type="button">
                                  <i class="icon-base ti tabler-x me-1"></i>
                                </button>
                              </div>
                            </div>
                            <hr>
                          </div>
                        @endforelse
                      </div>

                      <div class="mb-0">
                        <button class="btn btn-success" data-repeater-create type="button">
                          <i class="icon-base ti tabler-plus me-1"></i>
                        </button>
                      </div>

                      <button type="submit" class="btn btn-primary mt-4">{{ __('Submit') }}</button>
                    </form>
                  </div>
                @endif
              </div>
            </div>
            <!-- /Form Repeater -->

          </div>

        </div>
      </div>
    </div>
  </div>

@endsection
<!-- Page Scripts -->
@section('page-script')
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    $(function() {
      let $btn = null;

      $(document).on('click', '#upload_form button[type="submit"]', function() {
        $btn = $(this);
      });
      $(document).on('click', '#deliveryChargesForm[type="submit"]', function() {
        $btn = $(this);
      });
      $('#deliveryChargesForm').submit(function(e) {
        e.preventDefault();

        let form = $(this);
        let formData = form.serialize();

        $.ajax({
          url: form.attr('action'),
          type: "POST",
          data: formData,
          beforeSend: function() {
            toggleButtonLoading($btn, true, 'Saving...');
          },
          success: function(data) {
            toggleButtonLoading($btn, false);
            const toastType = data.status == 200 ? 'bg-success' : 'bg-warning';
            window.showToast({
              title: 'Delivery Charges 🗂️',
              message: data.message,
              type: toastType,
              animation: 'animate__fadeInUp',
              time: 'Just now',
              delay: 3000
            });
            if (data.status == 200) {
              setTimeout(() => {
                window.location.reload();
              }, 2000);
            }

          },
          error: function(xhr) {
            console.log(xhr.responseJSON);
            toggleButtonLoading($btn, false);
          }
        });
      });
    });

    $(document).ready(function() {
      // On change redirect
      $('#country').change(function(e) {
        e.preventDefault();
        let c = $(this).val();
        let url = '{{ url()->current() }}?country=' + c; // use Laravel helper for current URL
        window.location.href = url;
      });
      // By default select the 1st option and trigger change
      if ($('#country option:selected').length === 0) {
        $('#country option:first').prop('selected', true).trigger('change');
      }
    });




    // Delete existing record with AJAX
    $(document).on('click', '.btn-delete', function() {
      let id = $(this).data('id');
      let row = $(this).closest('[data-repeater-item]');

      Swal.fire({
        title: 'Are you sure?',
        text: "This will permanently delete the record!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Yes, delete it!'
      }).then((result) => {
        if (result.isConfirmed) {
          $.ajax({
            url: `${baseURL}/delivery_charges/` + id,
            method: 'DELETE',
            data: {
              _token: '{{ csrf_token() }}'
            },
            success: function(res) {
              row.remove();
            },
            error: function() {}
          });
        }
      });
    });

    /**
     * Form Extras
     */

    'use strict';
    document.addEventListener('DOMContentLoaded', function(e) {
      const numeralMask = document.querySelector('.numeral-mask');
      // Numeral
      if (numeralMask) {
        numeralMask.addEventListener('input', event => {
          numeralMask.value = formatNumeral(event.target.value, {
            numeralThousandsGroupStyle: 'thousand'
          });
        });
      }

      $(document).ready(function() {
        const formRepeater = $('.form-repeater');

        if (formRepeater.length) {
          var row = 2,
            col = 1;
          let lastToKmGlobal = 0; // ✅ global tracker

          formRepeater.repeater({
            show: function() {
              var fromControl = $(this).find('.form-control, .form-select');
              var formLabel = $(this).find('.form-label');

              fromControl.each(function(i) {
                var id = 'form-repeater-' + row + '-' + col;
                $(fromControl[i]).attr('id', id);
                $(formLabel[i]).attr('for', id);
                col++;
              });
              let prevRow = $(this).prev('[data-repeater-item]');
              if (prevRow.length) {
                lastToKmGlobal = parseInt(prevRow.find('.to-km').val()) || lastToKmGlobal;
              }
              // ✅ Auto set from-km based on global tracker
              $(this).find('.from-km').val(lastToKmGlobal);

              row++;
              $(this).slideDown();
            },
            hide: function(deleteElement) {
              Swal.fire({
                title: 'Are you sure?',
                text: "This slot will be deleted!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Yes, delete it!'
              }).then((result) => {
                if (result.isConfirmed) {
                  $(this).slideUp(deleteElement, function() {
                    $(this).remove();
                  });
                  Swal.fire('Deleted!', 'The slot has been removed.', 'success');
                }
              });
            }
          });
        }
      });

    });
  </script>
@endsection
