@extends('layouts/layoutMaster')

@section('title', __('locale.Dashboard'))

@section('vendor-style')
  @vite(['resources/assets/vendor/libs/apex-charts/apex-charts.scss', 'resources/assets/vendor/fonts/flag-icons.scss'])
@endsection
@section('vendor-script')
  @vite('resources/assets/vendor/libs/apex-charts/apexcharts.js')
@endsection

@section('content')
  <div class="row g-6">
    @php $currency=Helper::setting('currency_symbol','currency'); @endphp
    <div class="col-sm-6 col-xl-3">
      <div class="card">
        <div class="card-body">
          <div class="d-flex align-items-start justify-content-between">
            <div class="content-left">
              <span class="text-heading">{{ __('locale.Verified') }} {{ __('locale.Users') }}</span>
              <div class="d-flex align-items-center my-1">
                <h4 class="mb-0 me-2">{{ $verified }}</h4>
                <p class="text-success mb-0">({{ $totalUser > 0 ? round(($verified / $totalUser) * 100, 2) : 0 }}%)</p>
              </div>
              <small class="mb-0">{{ __('locale.Recent analytics') }} </small>
            </div>
            <div class="avatar">
              <span class="avatar-initial rounded bg-label-success">
                <i class="icon-base ti tabler-user-plus icon-26px"></i>
              </span>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="col-sm-6 col-xl-3">
      <div class="card">
        <div class="card-body">
          <div class="d-flex align-items-start justify-content-between">
            <div class="content-left">
              <span class="text-heading">{{ __('locale.Verified') }} {{ __('locale.Drivers') }}</span>
              <div class="d-flex align-items-center my-1">
                <h4 class="mb-0 me-2">{{ $totalDriver }}</h4>
                <p class="text-success mb-0">
                  ({{ $totalDriver > 0 ? round(($driverVerified / $totalDriver) * 100, 2) : 0 }}%)
                </p>
              </div>
              <small class="mb-0">{{ __('locale.Total') }} {{ __('locale.Verified') }}
                {{ __('locale.Drivers') }}</small>
            </div>
            <div class="avatar">
              <span class="avatar-initial rounded bg-label-success">
                <i class="icon-base ti tabler-car-garage icon-26px"></i>
              </span>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="col-sm-6 col-xl-3">
      <div class="card">
        <div class="card-body">
          <div class="d-flex align-items-start justify-content-between">
            <div class="content-left">
              <span class="text-heading">{{ __('locale.Active Drivers') }}</span>
              <div class="d-flex align-items-center my-1">
                <h4 class="mb-0 me-2">{{ $driverActive }}</h4>
                <p class="text-primary mb-0">
                  ({{ $totalDriver > 0 ? round(($driverActive / $totalDriver) * 100, 2) : 0 }}%)
                </p>
              </div>
              <small class="mb-0">{{ __('locale.Active Drivers') }}</small>
            </div>
            <div class="avatar">
              <span class="avatar-initial rounded bg-label-warning">
                <i class="icon-base ti tabler-car icon-26px"></i>
              </span>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="col-sm-6 col-xl-3">
      <div class="card">
        <div class="card-body">
          <div class="d-flex align-items-start justify-content-between">
            <div class="content-left">
              <span class="text-heading">{{ __('locale.Active Stores') }}</span>
              <div class="d-flex align-items-center my-1">
                <h4 class="mb-0 me-2">{{ $storeActive }}</h4>
                <p class="text-primary mb-0">({{ $totalStore > 0 ? round(($storeActive / $totalStore) * 100, 2) : 0 }}%)
                </p>
              </div>
              <small class="mb-0">{{ __('locale.Total') }} {{ __('locale.Active Stores') }}</small>
            </div>
            <div class="avatar">
              <span class="avatar-initial rounded bg-label-primary">
                <i class="icon-base ti tabler-building-warehouse icon-26px"></i>
              </span>
            </div>
          </div>
        </div>
      </div>
    </div>
    <!-- Sales last year -->
    <div class="col-xl-3 col-md-3 col-6">
      <div class="card h-100">
        <div class="card-header pb-3">
          <h5 class="card-title mb-1">{{ __('locale.Order') }}</h5>
          <p class="card-subtitle">{{ __('locale.Last week') }}</p>
        </div>
        <div class="card-body">
          <div id="ordersLastWeek"></div>
          <div class="d-flex justify-content-between align-items-center gap-3">
            <h4 class="mb-0" id="ordersTotal">0</h4>
            <small class="text-success" id="ordersPercentage"></small>
          </div>
        </div>
      </div>
    </div>

    <!-- Sessions Last month -->
    <div class="col-xl-3 col-md-3 col-6">
      <div class="card h-100">
        <div class="card-header pb-0">
          <h5 class="card-title mb-1">{{ __('locale.Order') }} {{ __('locale.Sales') }}</h5>
          <p class="card-subtitle">{{ __('locale.Last Year') }}</p>
        </div>
        <div id="salesLastYear"></div>
        <div class="card-body pt-0">
          <div class="d-flex justify-content-between align-items-center mt-3 gap-3">
            <h4 class="mb-0" id="salesTotal">0</h4>
            <small class="text-danger" id="salesPercentage"></small>
          </div>
        </div>
      </div>
    </div>

    <div class="col-xl-3 col-md-3 col-6">
      <div class="card h-100">
        <div class="card-header pb-3">
          <h5 class="card-title mb-1">{{ __('locale.Rides') }}</h5>
          <p class="card-subtitle">{{ __('locale.Last week') }}</p>
        </div>
        <div class="card-body">
          <div id="ridesLastWeek"></div>
          <div class="d-flex justify-content-between align-items-center gap-3">
            <h4 class="mb-0" id="ridesTotal">0</h4>
            <small id="ridesPercentage" class="text-success">0%</small>
          </div>
        </div>
      </div>
    </div>

    <div class="col-xl-3 col-md-3 col-6">
      <div class="card h-100">
        <div class="card-header pb-0">
          <h5 class="card-title mb-1">{{ __('locale.Rides') }} {{ __('locale.Income') }}</h5>
          <p class="card-subtitle">{{ __('locale.Last Year') }}</p>
        </div>
        <div id="salesLastYearRides"></div>
        <div class="card-body pt-0">
          <div class="d-flex justify-content-between align-items-center mt-3 gap-3">
            <h4 class="mb-0" id="salesTotalRides">0</h4>
            <small id="salesPercentageRides" class="text-danger">0%</small>
          </div>
        </div>
      </div>
    </div>


    <!-- Earning Reports Tabs-->
    <div class="col-xl-12 col-12">
      <div class="card h-100">
        <div class="card-header d-flex justify-content-between">
          <div class="card-title m-0">
            <h5 class="mb-1">{{ __('locale.Graphs') }}</h5>
            <p class="card-subtitle">{{ __('locale.Yearly Overview') }}</p>
          </div>
        </div>
        <div class="card-body">
          <ul class="nav nav-tabs widget-nav-tabs pb-8 gap-4 mx-1 d-flex flex-nowrap" role="tablist">
            <li class="nav-item">
              <a href="javascript:void(0);"
                class="nav-link btn active d-flex flex-column align-items-center justify-content-center" role="tab"
                data-bs-toggle="tab" data-bs-target="#navs-orders-id" aria-controls="navs-orders-id"
                aria-selected="true">
                <div class="badge bg-label-secondary rounded p-2"><i
                    class="icon-base ti tabler-shopping-cart icon-md"></i></div>
                <h6 class="tab-widget-title mb-0 mt-2">{{ __('locale.Orders') }}</h6>
              </a>
            </li>
            <li class="nav-item">
              <a href="javascript:void(0);"
                class="nav-link btn d-flex flex-column align-items-center justify-content-center" role="tab"
                data-bs-toggle="tab" data-bs-target="#navs-sales-id" aria-controls="navs-sales-id"
                aria-selected="false">
                <div class="badge bg-label-secondary rounded p-2"><i class="icon-base ti tabler-car icon-md"></i></div>
                <h6 class="tab-widget-title mb-0 mt-2">{{ __('locale.Rides') }}</h6>
              </a>
            </li>
            <li class="nav-item">
              <a href="javascript:void(0);"
                class="nav-link btn d-flex flex-column align-items-center justify-content-center" role="tab"
                data-bs-toggle="tab" data-bs-target="#navs-profit-id" aria-controls="navs-profit-id"
                aria-selected="false">
                <div class="badge bg-label-secondary rounded p-2"><i class="icon-base icon-md pe-1 ps-1"> ₵ </i></div>
                <h6 class="tab-widget-title mb-0 mt-2">{{ __('locale.Profit') }}</h6>
              </a>
            </li>
            <li class="nav-item">
              <a href="javascript:void(0);"
                class="nav-link btn d-flex flex-column align-items-center justify-content-center" role="tab"
                data-bs-toggle="tab" data-bs-target="#navs-income-id" aria-controls="navs-income-id"
                aria-selected="false">
                <div class="badge bg-label-secondary rounded p-2"><i class="icon-base icon-md pe-1 ps-1"> ₵ </i>
                </div>
                <h6 class="tab-widget-title mb-0 mt-2">{{ __('locale.Earning') }}</h6>
              </a>
            </li>

          </ul>
          <div class="tab-content p-0 ms-0 ms-sm-2">
            <div class="tab-pane fade show active" id="navs-orders-id" role="tabpanel">
              <div id="earningReportsTabsOrders"></div>
            </div>
            <div class="tab-pane fade" id="navs-sales-id" role="tabpanel">
              <div id="earningReportsTabsSales"></div>
            </div>
            <div class="tab-pane fade" id="navs-profit-id" role="tabpanel">
              <div id="earningReportsTabsProfit"></div>
            </div>
            <div class="tab-pane fade" id="navs-income-id" role="tabpanel">
              <div id="earningReportsTabsIncome"></div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- Sales last 6 months -->
    <div class="col-xl-6 col-md-6 order-xxl-0 order-1">
      <div class="card h-100">
        <div class="card-header d-flex justify-content-between pb-4">
          <div class="card-title mb-0">
            <h5 class="mb-1">{{ __('locale.Sales') }}</h5>
            <p class="card-subtitle">{{ __('locale.Last 6 Months') }}</p>
          </div>
        </div>
        <div class="card-body">
          <div id="salesLastSixMonth"></div>
        </div>
      </div>
    </div>
    <!-- Support Tracker -->
    <div class="col-xl-6 col-md-6 order-xxl-0 order-1">
      <div class="card h-100">
        <div class="card-header d-flex justify-content-between">
          <div class="card-title mb-0">
            <h5 class="mb-1">{{ __('locale.Support Tickets') }}</h5>
            <p class="card-subtitle">{{ __('locale.Last Week') }}</p>
          </div>

        </div>
        <div class="card-body row">
          <div class="col-12 col-sm-4">
            <ul class="p-0 m-0">
              <li class="d-flex gap-4 align-items-center mb-lg-3 pb-1">
                <div class="badge rounded bg-label-primary p-1_5"><i class="icon-base ti tabler-ticket icon-md"></i>
                </div>
                <div>
                  <h6 class="mb-0 text-nowrap">{{ __('locale.Total Tickets') }}</h6>
                  <small class="text-body-secondary" id="totalTickets"></small>
                </div>
              </li>
              <li class="d-flex gap-4 align-items-center mb-lg-3 pb-1">
                <div class="badge rounded bg-label-info p-1_5"><i class="icon-base ti tabler-circle-check icon-md"></i>
                </div>
                <div>
                  <h6 class="mb-0 text-nowrap">{{ __('locale.Open Tickets') }}</h6>
                  <small class="text-body-secondary" id="openTickets"></small>
                </div>
              </li>
              <li class="d-flex gap-4 align-items-center pb-1">
                <div class="badge rounded bg-label-warning p-1_5"><i class="icon-base ti tabler-clock icon-md"></i>
                </div>
                <div>
                  <h6 class="mb-0 text-nowrap">{{ __('locale.Closed Tickets') }}</h6>
                  <small class="text-body-secondary" id="closedTickets"></small>
                </div>
              </li>
            </ul>
          </div>
          <div class="col-12 col-md-8">
            <div id="supportTracker"></div>
          </div>
        </div>
      </div>
    </div>
    <!--/ Support Tracker -->

    <!-- Active Projects -->
    <div class="col-xl-12 col-md-12">
      <div class="card h-100">
        <div class="card-header d-flex justify-content-between">
          <div class="card-title mb-0">
            <h5 class="mb-1">{{ __('locale.Active Rides') }}</h5>
          </div>

        </div>
        <div class="card-body">
          <ul class="p-0 m-0">
            <table class="table table-borderless border-top">
              <thead class="border-bottom">
                <tr>
                  <th>{{ __('locale.User Details') }}</th>
                  <th>{{ __('locale.Driver') }}</th>
                  <th>{{ __('locale.Address') }}</th>
                  <th>{{ __('locale.Price') }}</th>
                </tr>
              </thead>
              <tbody>
                @foreach ($rides as $key => $value)
                  <tr>
                    <td class="pt-5">
                      <div class="d-flex justify-content-start align-items-center">
                        <div class="me-4">
                          <img
                            class="img-fluid scaleX-n1-rtl"src="{{ asset('storage/' . $value['user']?->profile_photo_path) }}"
                            alt="{{ $value['user']?->name }}" style="height:30px"
                            onerror="this.onerror=null;this.src=`{{ asset('assets/img/placeholder.jpg') }}`;" />
                        </div>
                        <div class="d-flex flex-column">
                          <p class="mb-0 text-heading">{{ $value['user']?->name }}</p>
                          <small class="text-body">{{ $value['user']?->dial_code }}
                            {{ $value['user']?->phone }}</small>
                        </div>
                      </div>
                    </td>
                    <td class="pt-5">{{ $value['driver']?->driver_name }} <br>
                      <span class="badge bg-label-primary"><i
                          class="icon-base ti @if ($value->type == 'Ride') tabler-car @else tabler-truck-delivery @endif icon-16px"></i>
                        {{ $value->type }}</span>
                    </td>
                    <td class="pt-5">Pickup: <small>{{ $value->pickup_location }}</small><br>Drop:
                      <small>{{ $value->drop_location }}</small>
                    </td>
                    <td class="pt-5"><span
                        class="badge bg-label-success">{{ $value->currency ?? $currency }}{{ $value->fare }}</span>
                    </td>
                  </tr>
                @endforeach

              </tbody>
            </table>

          </ul>
        </div>
      </div>
    </div>
    <!--/ Active Projects -->

    <!-- Last Transaction -->
    <div class="col-md-12 col-12">
      <div class="card h-100">
        <div class="card-header d-flex justify-content-between align-items-center">
          <h5 class="card-title m-0 me-2">{{ __('locale.Transactions') }}</h5>

        </div>
        <div class="table-responsive">
          <table class="table table-borderless border-top">
            <thead class="border-bottom">
              <tr>
                <th>{{ __('locale.User Details') }}</th>
                <th>{{ __('locale.Date') }}</th>
                <th>{{ __('locale.Amount Details') }}</th>
                <th>{{ __('locale.Txn Detail') }}</th>
                <th>{{ __('locale.Type') }}</th>
              </tr>
            </thead>
            <tbody>
              @foreach ($transactions as $key => $value)
                <tr>
                  <td class="pt-5">
                    <div class="d-flex justify-content-start align-items-center">
                      <div class="me-4">
                        <img
                          class="img-fluid scaleX-n1-rtl"src="{{ asset('storage/' . $value['user']?->profile_photo_path) }}"
                          alt="{{ $value['user']?->name }}" style="height:30px"
                          onerror="this.onerror=null;this.src=`{{ asset('assets/img/placeholder.jpg') }}`;" />
                      </div>
                      <div class="d-flex flex-column">
                        @php
                          $profileUrl = '';
                          if ($value['user']?->user_type === 'User') {
                              $profileUrl = url('admin/users/' . $value['user']?->id);
                          } elseif ($value['user']?->user_type === 'Store') {
                              $profileUrl = url('admin/stores/' . $value['user']?->id);
                          } elseif ($value['user']?->user_type === 'Driver') {
                              $profileUrl = url('admin/drivers/' . $value['user']?->id);
                          }
                        @endphp
                        <a class="mb-0 text-heading" href="{{ $profileUrl }}">{{ $value['user']?->name }}</a></p>
                        <small class="text-body">{{ $value['user']?->dial_code }}
                          {{ $value['user']?->phone }}</small>
                      </div>
                    </div>
                  </td>
                  <td class="pt-5">
                    <div class="d-flex flex-column">

                      <p class="mb-0 text-heading">{{ date('M d-Y', strtotime($value->created_at)) }}</p>
                      <small class="text-body text-nowrap">{{ date('H:i', strtotime($value->created_at)) }}</small>
                    </div>
                  </td>
                  <td class="pt-5"><small>Sub
                      Amt: {{ $value->currency ?? $currency }}{{ $value->sub_amount }}<br>Tax:
                      {{ $value->currency ?? $currency }}{{ $value->tax }}</small><br>Total:
                    {{ $value->currency ?? $currency }}{{ $value->amount }}
                  </td>
                  <td class="pt-5"><span class="badge bg-label-success">{{ $value->txn_id }}</span></td>

                  <td class="pt-5">
                    <p class="mb-0 text-heading">{{ class_basename(ucfirst($value->transactionable_type)) }}</p>
                  </td>
                </tr>
              @endforeach

            </tbody>
          </table>
        </div>
      </div>
    </div>
    <!--/ Last Transaction -->


  </div>
@endsection
@section('page-script')
  <script>
    window.appConfig = {
      currency: "{{ $currency ?? '$' }}"
    };
  </script>
  @vite('resources/assets/js/dashboards.js')
@endsection
