<div class="panel-heading mb-2">
  @php
    $ids = [];
    $coupon_det = json_decode(@$coupon->details);
    if (!empty($coupon_det)) {
        foreach (json_decode($coupon->details) as $key => $details) {
            if (!empty($details->user_id)) {
                $ids[] = $details->user_id;
            }
        }
    }
    $start = isset($coupon) ? date('Y-m-d', strtotime($coupon->start_date)) : '';
    $end = isset($coupon) ? date('Y-m-d', strtotime($coupon->end_date)) : '';
  @endphp
  <h3 class="panel-title">{{ __('locale.Add Seller Base Coupon') }}</h3>

</div>

<div class="col-12">
  <div class="mb-1 row">
    <div class="col-sm-3">
      <label class="col-form-label" for="coupon_code">{{ __('locale.Coupon code') }}</label>
    </div>
    <div class="col-sm-9">
      <input type="text" placeholder="{{ __('locale.Coupon code') }}" id="coupon_code" name="coupon_code"
        class="form-control" value="{{ $coupon->code ?? '' }}" required>
    </div>
  </div>
</div>

<div class="col-12">
  <div class="mb-1 row">
    <div class="col-sm-3">
      <label class="col-form-label">{{ __('locale.Minimum Shopping') }}</label>
    </div>
    <div class="col-sm-9">
      <input type="number" min="0" step="0.01" placeholder="{{ __('locale.Minimum Shopping') }}"
        name="min_buy" class="form-control" value="{{ $coupon_det[0]?->min_buy ?? '' }}" required>
    </div>
  </div>
</div>

<div class="col-12">
  <div class="mb-1 row">
    <div class="col-sm-3">
      <label class="col-form-label" for="name">{{ __('locale.Coupon Amount') }}</label>
    </div>
    <div class="col-sm-7">
      <input type="number" min="0" step="0.01" id="discount" placeholder="{{ __('locale.Discount') }}"
        name="discount" class="form-control" value="{{ $coupon->discount ?? '' }}" required>
    </div>
    <div class="col-lg-2">
      <select class="form-control" name="discount_type" id="discountType">
        <option value="amount" @if ((!empty($coupon) && $coupon->discount_type == 'amount') || empty($coupon)) selected @endif>
          {{ \App\Helpers\Helpers::setting('currency_symbol', 'currency') }}</option>
        <option value="percent" @if (!empty($coupon) && $coupon->discount_type == 'percent') selected @endif>%</option>
      </select>
    </div>
  </div>
</div>

<div class="col-12" id="maxDiscountWrapper"
  style="display: {{ !empty($coupon) && $coupon->discount_type == 'percent' ? 'block' : 'none' }};">
  <div class="mb-1 row">
    <div class="col-sm-3">
      <label class="col-form-label">{{ __('locale.Maximum Discount Amount') }}</label>
    </div>
    <div class="col-sm-9">
      <input type="number" min="0" step="0.01" id="max_discount"
        placeholder="{{ __('locale.Maximum Discount Amount') }}" name="max_discount" id="max_discount"
        class="form-control" value="{{ $coupon_det[0]?->max_discount ?? '' }}" required>
    </div>
  </div>
</div>
<div class="col-12">
  <div class="mb-1 row">
    <div class="col-sm-3">
      <label class="col-form-label">{{ __('locale.Coupon Usage') }}</label>
    </div>
    <div class="col-sm-9">
      <select class="form-control" name="usage_type" id="usageType">
        <option value="unlimited" @if (empty($coupon) || $coupon_det[0]?->usage_type == 'unlimited') selected @endif>
          {{ __('locale.Unlimited Usage') }}
        </option>
        <option value="limited" @if (!empty($coupon) && $coupon_det[0]?->usage_type == 'limited') selected @endif>
          {{ __('locale.Limited Usage') }}
        </option>
        <option value="per_user" @if (!empty($coupon) && $coupon_det[0]?->usage_type == 'per_user') selected @endif>
          {{ __('locale.Once Per User') }}
        </option>
      </select>
    </div>
  </div>
</div>

<div class="col-12" id="maxUsageWrapper" style="display: none;">
  <div class="mb-1 row">
    <div class="col-sm-3">
      <label class="col-form-label">{{ __('locale.Maximum Usages') }}</label>
    </div>
    <div class="col-sm-9">
      <input type="number" min="1" step="1" name="maximum_usage" id="maximum_usage" class="form-control"
        placeholder="{{ __('locale.Maximum Usages') }}" value="{{ $coupon_det[0]->maximum_usage ?? '' }}">
    </div>
  </div>
</div>

<div class="col-12">
  <div class="mb-1 row">
    <div class="col-sm-3">
      <label class="col-form-label" for="flatpickr-range">{{ __('locale.Date') }}</label>
    </div>
    <div class="col-sm-9">
      <input type="text" name="date" id="flatpickr-range"
        class="form-control flatpickr-range"placeholder="YYYY-MM-DD to YYYY-MM-DD"
        value="{{ $start && $end ? "$start to $end" : '' }}" />
    </div>
  </div>
</div>
<div class="col-12">
  <div class="mb-1 row">
    <div class="col-sm-3">
      <label class="col-form-label">{{ __('locale.Stores') }}</label>
    </div>
    <div class="col-sm-9">
      <select name="customers[]" id="products" class="form-control demo-select2" multiple required
        data-placeholder="{{ __('locale.Choose Stores') }}">
        @foreach (\App\Models\User::where('user_type', 'Store')->get() as $user)
          <option value="{{ $user->id }}"{{ !empty($ids) && in_array($user->id, $ids) ? ' selected' : '' }}>
            {{ __($user->name) }} (@if (empty($user->email))
              {{ $user->phone }}
            @else
              {{ $user->email }} @if (!empty($user->phone))
                , {{ $user->phone }}
              @endif
            @endif )</option>
        @endforeach
      </select>
    </div>
  </div>
</div>

@vite(['resources/assets/js/forms-pickers.js'])
<script type="text/javascript">
  $(document).ready(function() {
    $('.demo-select2').select2();
  });
</script>
