@php
  $configData = Helper::appClasses();
@endphp

@extends('layouts/layoutMaster')

@section('title', __('locale.Coupons'))

@section('vendor-style')
  @vite(['resources/assets/css/datatables.scss'])
@endsection

@section('vendor-script')
  @vite(['resources/assets/js/datatables.js'])
  <style>
    .popover {
      min-width: 550px ! important;
      width: auto;
    }
  </style>
@endsection

@section('content')
  <div class="row g-6">
    <div class="col-12">
      <div class="card">
        <div class="card-datatable">
          <div class="row p-3">
            <div class="col-md-4">
              <label for="filter_type" class="form-label">{{ __('locale.Type') }}</label>
              <select id="filter_type" class="form-select">
                <option value="">{{ __('locale.All') }}</option>
                <option value="ride_base">{{ __('locale.Ride Base') }}</option>
                <option value="cart_base">{{ __('locale.Cart Base') }}</option>
                <option value="product_base">{{ __('locale.Product Base') }}</option>
                <option value="customer_base">{{ __('locale.Customer Base') }}</option>
                <option value="seller_base">{{ __('locale.Seller Base') }}</option>
                <option value="register_base">{{ __('locale.Register') }}</option>
              </select>
            </div>


          </div>
          <table class="datatables-users table border-top">
            <thead>
              <tr>
                <th>#</th>
                <th>{{ __('locale.Code') }}</th>
                <th>{{ __('locale.Type') }}</th>
                <th>{{ __('locale.Discount') }}</th>
                <th>{{ __('locale.Date') }}</th>
                <th></th>
                <th>{{ __('locale.Status') }}</th>
                <th>{{ __('locale.Actions') }}</th>
              </tr>
            </thead>
          </table>
        </div>
      </div>
    </div>
  </div>

  <div id="role-helper" data-add="{{ __('locale.Add New Coupon') }}"></div>
@endsection

@section('page-script')
  @vite(['resources/assets/js/coupons.js'])
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    window.permissions = {
      currencySymbol: @json(\App\Helpers\Helpers::setting('currency_symbol', 'currency')),
      canListCoupon: @json(auth()->user()->can('coupon-list')),
      canDeleteCoupon: @json(auth()->user()->can('coupon-delete')),
      canEditCoupon: @json(auth()->user()->can('coupon-edit')),
      canCreateCoupon: @json(auth()->user()->can('coupon-create'))
    };
  </script>
@endsection
