@extends('layouts/layoutMaster')

@section('title', __('locale.Add Coupon'))

<!-- Vendor Styles -->
@section('vendor-style')
  @vite(['resources/assets/vendor/libs/select2/select2.scss', 'resources/assets/vendor/libs/animate-css/animate.scss', 'resources/assets/vendor/libs/sweetalert2/sweetalert2.scss', 'resources/assets/vendor/libs/@form-validation/form-validation.scss', 'resources/assets/vendor/libs/flatpickr/flatpickr.scss', 'resources/assets/vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.scss'])
@endsection

<!-- Vendor Scripts -->
@section('vendor-script')
  @vite(['resources/assets/vendor/libs/select2/select2.js', 'resources/assets/vendor/libs/sweetalert2/sweetalert2.js', 'resources/assets/vendor/libs/@form-validation/bootstrap5.js', 'resources/assets/vendor/libs/@form-validation/popular.js', 'resources/assets/vendor/libs/@form-validation/auto-focus.js', 'resources/assets/vendor/libs/moment/moment.js', 'resources/assets/vendor/libs/flatpickr/flatpickr.js', 'resources/assets/vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js'])
@endsection


@section('content')

  <!-- Modern -->
  <div class="row">
    <!-- Modern Icons Wizard -->
    <div class="col-10 mb-6 offset-1">
      <form id="couponForm" action="" method="POST" enctype="multipart/form-data">
        @csrf
        <div class="col-12 mb-3">
          <div class="mb-1 row">
            <div class="col-sm-3">
              <label class="col-form-label" for="name">{{ __('locale.Coupon Type') }}</label>
            </div>
            <div class="col-sm-9">
              <select name="coupon_type" id="coupon_type" class="form-control demo-select2" onchange="coupon_form()"
                required>

                <option value="">{{ __('locale.Select One') }}</option>
                <option value="ride_base" @if (!empty($coupon) && $coupon['type'] == 'ride_base') selected @endif>{{ __('locale.Ride Base') }}
                </option>
                <option value="cart_base" @if (!empty($coupon) && $coupon['type'] == 'cart_base') selected @endif>{{ __('locale.Cart Base') }}
                </option>
                <option value="customer_base" @if (!empty($coupon) && $coupon['type'] == 'customer_base') selected @endif>
                  {{ __('locale.Customer Base') }}</option>
                <option value="seller_base" @if (!empty($coupon) && $coupon['type'] == 'seller_base') selected @endif>
                  {{ __('locale.Seller Base') }}</option>
                <!--
                  <option value="product_base" @if (!empty($coupon) && $coupon['type'] == 'product_base') selected @endif>
                    {{ __('locale.Product Base') }}</option>
                  <option class="d-none"value="register_base" @if (!empty($coupon) && $coupon['type'] == 'register_base') selected @endif>
                    {{ __('locale.Register') }}</option>
                  -->
                <option value="category_base" @if (!empty($coupon) && $coupon['type'] == 'category_base') selected @endif>
                  {{ __('locale.Category Base') }}</option>
                <option value="offer_base" @if (!empty($coupon) && $coupon['type'] == 'offer_base') selected @endif>
                  {{ __('locale.Offer Base') }}</option>
              </select>
            </div>
          </div>
        </div>


        <div id="coupon_form">
        </div>

        <div class="col-12 d-flex justify-content-end">
          <input type="hidden" name="id" value="{{ $coupon->id ?? '' }}" id="id">
          <button class="btn btn-success btn-submit" type="button" id="submitCouponBtn"
            data-url="{{ isset($coupon->id) ? route('coupons.update', $coupon->id) : route('coupons.store') }}"
            data-method="{{ isset($coupon->id) ? 'PUT' : 'POST' }}">{{ __('locale.Submit') }}</button>
        </div>
      </form>

    </div>
    <!-- /Modern Icons Wizard -->

  </div>
@endsection
<!-- Page Scripts -->
@section('page-script')

  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    $(document).ready(function() {
      $('.demo-select2').select2();
    });

    function coupon_form() {
      const coupon_type = $('#coupon_type').val();
      if (!coupon_type) return;

      const id = $('#id').val();
      $.post('{{ route('coupons.get_coupon_form') }}', {
        _token: '{{ csrf_token() }}',
        coupon_type: coupon_type,
        id: id
      }, function(data) {
        // Insert the form HTML
        $('#coupon_form').html(data);

        // === Initialize Select2 ===
        $('.demo-select2').select2();

        // === Initialize Date Picker / Range Picker ===
        if ($('.flatpickr-range').length) {
          $('.flatpickr-range').daterangepicker({
            locale: {
              format: 'YYYY-MM-DD'
            },
            autoUpdateInput: false
          }, function(start, end) {
            $('.flatpickr-range').val(start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD'));
          });
        }

        // === Elements after AJAX load ===
        const discountTypeSelect = document.getElementById('discountType');
        const discountInput = document.getElementById('discount');
        const maxDiscountWrapper = document.getElementById('maxDiscountWrapper');
        const maxDiscountInput = document.getElementById('max_discount');

        const usageTypeSelect = document.getElementById('usageType');
        const maxUsageWrapper = document.getElementById('maxUsageWrapper');
        const maxUsageInput = document.getElementById('maximum_usage');

        // === Discount Type Logic ===
        if (discountTypeSelect && maxDiscountWrapper && maxDiscountInput) {
          function updateMaxDiscount() {
            if (discountTypeSelect.value === 'percent') {
              maxDiscountWrapper.style.display = 'block';
              maxDiscountInput.required = true;
            } else {
              maxDiscountWrapper.style.display = 'none';
              maxDiscountInput.value = '';
              maxDiscountInput.required = false;
            }
          }

          // Listen for change
          discountTypeSelect.addEventListener('change', updateMaxDiscount);

          // Optional: sync discount input to max discount if needed
          if (discountInput) {
            discountInput.addEventListener('input', function() {
              if (discountTypeSelect.value === 'amount' && maxDiscountInput) {
                maxDiscountInput.value = discountInput.value;
              }
            });
          }

          // Initial state
          updateMaxDiscount();
        }

        // === Usage Type Logic ===
        if (usageTypeSelect && maxUsageWrapper && maxUsageInput) {
          function toggleMaxUsage() {
            maxUsageWrapper.style.display = usageTypeSelect.value === 'limited' ? 'block' : 'none';
            if (usageTypeSelect.value === 'limited') {
              maxUsageInput.required = true;
            } else {
              maxUsageInput.required = false;
            }
          }

          // Listen for change
          usageTypeSelect.addEventListener('change', toggleMaxUsage);

          // Initial state
          toggleMaxUsage();
        }

      }).fail(function(xhr, status, error) {
        console.error("Error loading coupon form:", error);
      });
    }

    $(document).ready(function() {
      // Initialize form on page load
      coupon_form();

      // Re-load form when coupon type changes
      $('#coupon_type').on('change', coupon_form);
    });

    // === Coupon Form Submit ===
    $(document).on('click', '#submitCouponBtn', function(e) {
      e.preventDefault();

      const form = $('#couponForm')[0];
      const formData = new FormData(form);
      const url = $(this).data('url');
      const couponId = $('#id').val();

      if (couponId) formData.append('_method', 'PUT');

      $.ajax({
        url: url,
        method: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        beforeSend: function() {
          $('#submitCouponBtn').prop('disabled', true).html('Submitting...');
        },
        success: function(response) {
          if (response.status == 200) {
            Swal.fire({
              icon: 'success',
              title: 'Success',
              text: response.message,
              showConfirmButton: false,
              timer: 2500
            }).then(() => {
              window.location.href = "{{ route('coupons.index') }}";
            });
          } else {
            Swal.fire({
              icon: 'error',
              title: 'Error',
              text: response.message,
              showConfirmButton: false,
              timer: 2500
            });
          }
        },
        error: function(xhr) {
          const errors = xhr.responseJSON?.errors || {};
          const msg = xhr.responseJSON?.message || 'Something went wrong.';

          Swal.fire({
            icon: 'error',
            title: 'Error',
            html: `<div>${msg}</div>` + Object.values(errors).map(err => `<div>${err}</div>`).join('')
          });
        },
        complete: function() {
          $('#submitCouponBtn').prop('disabled', false).html("{{ __('locale.Submit') }}");
        }
      });
    });
  </script>

@endsection
