@php
  $configData = Helper::appClasses();
@endphp

@extends('layouts/layoutMaster')

@section('title', __('locale.Categories'))

@section('vendor-style')
  @vite(['resources/assets/css/datatables.scss'])
@endsection

@section('vendor-script')
  @vite(['resources/assets/js/datatables.js'])
@endsection

@section('content')
  <div class="row g-6">
    <div class="col-12">
      <div class="card">
        <div class="card-datatable">
          <div class="row p-3">
            <div class="col-md-4">
              <label for="filter_parent" class="form-label">{{ __('locale.Parent Category') }}</label>
              <select id="filter_parent" class="form-select">
                <option value="">{{ __('locale.All') }}</option>
                @foreach ($allCategories as $parent)
                  <option value="{{ $parent->id }}">{{ $parent->name }}</option>
                @endforeach
              </select>
            </div>

            <div class="col-md-4">
              <label for="filter_subcategory" class="form-label">{{ __('locale.Subcategory') }}</label>
              <select id="filter_subcategory" class="form-select">
                <option value="">{{ __('locale.All') }}</option>
              </select>
            </div>
          </div>
          <table class="datatables-users table border-top">
            <thead>
              <tr>
                <th>#</th>
                <th>{{ __('locale.Image') }}</th>
                <th>{{ __('locale.Name') }}</th>
                <th>{{ __('locale.Parent') }}</th>
                <th>{{ __('locale.Status') }}</th>
                <th></th>
                <th></th>
                <th>{{ __('locale.Prescriptions') }}</th>
                <th>{{ __('locale.Actions') }}</th>
              </tr>
            </thead>
          </table>
        </div>
      </div>
    </div>
  </div>

  <!-- Offcanvas to add/edit category -->
  <div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasAdd" aria-labelledby="offcanvasAddLabel">
    <div class="offcanvas-header border-bottom">
      <h5 id="offcanvasAddLabel" class="offcanvas-title">{{ __('locale.Add New Category') }}</h5>
      <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body mx-0 flex-grow-0 p-6 h-100">
      <form class="add-new-category pt-0" id="upload_form" enctype="multipart/form-data">
        @csrf
        <input type="hidden" name="id" id="category_id">

        <div class="mb-4">
          <label class="form-label">{{ __('locale.Name') }}</label>
          <input type="text" class="form-control" name="name" id="category_name"
            placeholder="{{ __('locale.Name') }}">
        </div>

        <div class="mb-2 hideCategory">
          <label class="form-label">{{ __('locale.Parent Category') }}</label>
          <select class="form-control select2" name="parent_id" id="parent_id">
            <option value="">{{ __('locale.None') }}</option>
            @foreach ($allCategories as $cat)
              <option value="{{ $cat->id }}" data-pres="{{ $cat->prescriptions }}">{{ $cat->name }}</option>
            @endforeach
          </select>
        </div>

        <div class="col-sm-6 p-6 mb-2" id="hidePres">
          <label class="switch">
            <input type="checkbox" id="prescription_edit" name="prescriptions" class="switch-input" />
            <span class="switch-toggle-slider">
              <span class="switch-on"></span>
              <span class="switch-off"></span>
            </span>
            <span class="switch-label">{{ __('locale.Prescriptions') }}</span>
          </label>
        </div>

        <div class="mb-4">
          <label class="form-label" for="category_image">{{ __('locale.Image') }}</label>
          <input type="file" class="form-control" name="image" id="category_image" accept="image/*">
          <div class="mt-2">
            <img id="preview_image" src="{{ asset('assets/img/placeholder.jpg') }}" alt="Preview" class="img-thumbnail"
              style="max-height: 60px; display: none;">
          </div>
        </div>

        <button type="submit" class="btn btn-primary me-3 data-submit" id="saveBtn">{{ __('locale.Submit') }}</button>
        <button type="reset" class="btn btn-label-danger"
          data-bs-dismiss="offcanvas">{{ __('locale.Cancel') }}</button>
      </form>
    </div>
  </div>

  <div id="role-helper" data-add="{{ __('locale.Add New Category Type') }}" data-query="type=subcategory"></div>
@endsection

@section('page-script')
  @vite(['resources/assets/js/categories.js'])
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    window.permissions = {
      canDeleteCategory: @json(auth()->user()->can('category-delete')),
      canEditCategory: @json(auth()->user()->can('category-edit')),
      canCreateCategory: @json(auth()->user()->can('category-create'))
    };
    // Preview for Add Category
    document.getElementById('category_image')?.addEventListener('change', function(e) {
      const img = document.getElementById('preview_image');
      const file = e.target.files[0];
      if (file) {
        img.src = URL.createObjectURL(file);
        img.style.display = 'block';
      } else {
        img.style.display = 'none';
      }
    });

    $(function() {
      const table = $('.datatables-users').DataTable();
      let $btn = null;

      $(document).on('click', '#upload_form button[type="submit"]', function() {
        $btn = $(this);
      });

      $('#upload_form').on('submit', function(e) {
        e.preventDefault();
        const id = $('#category_id').val();
        let url = id ? `${baseURL}/categories/${id}` : `${baseURL}/categories`;
        let method = id ? 'POST' : 'POST'; // Using POST for both (update handled by backend)
        let formData = new FormData(this);
        if (id) {
          formData.append('_method', 'PUT'); // spoofing for update
        }
        $.ajax({
          type: method,
          url: url,
          headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          },
          data: formData,
          dataType: 'JSON',
          contentType: false,
          processData: false,
          beforeSend: function() {
            toggleButtonLoading($('#saveBtn'), true, 'Saving...');
          },
          success: function(data) {
            toggleButtonLoading($('#saveBtn'), false);
            if (data.status === 200 && data.data) {
              const category = data.data;
              const existingRow = table.row(`#trRow-${category.id}`);
              if (existingRow.node()) {
                existingRow.data(category).draw(false);
              } else {
                const newRow = table.row.add(category).draw(false);
                $(newRow.node()).attr('id', `trRow-${category.id}`);
              }
              bootstrap.Offcanvas.getInstance(document.getElementById('offcanvasAdd')).hide();
            }
            window.showToast({
              title: 'Categories 🗂️',
              message: data.message,
              type: data.status == 200 ? 'bg-success' : 'bg-warning',
              animation: 'animate__fadeInUp',
              time: 'Just now',
              delay: 3000
            });
          },
          error: function(xhr) {
            toggleButtonLoading($('#saveBtn'), false);
            console.error(xhr.responseJSON);
          }
        });
      });
    });

    // Edit modal open
    $(document).on('click', '.edit-category-modal', function() {
      $('#category_id').val($(this).data('id'));
      $('#category_name').val($(this).data('name'));
      if ($(this).data('parent_id') > 0) {
        console.log($(this).data('parent_pres'));
        $('#hidePres').show();
        $('.hideCategory').show();
        $('#prescription_edit').show();
        $('#parent_id').val($(this).data('parent_id')).trigger('change');
        if ($(this).data('parent_pres') == 1) {
          $('#hidePres').show();
          $('#prescription_edit').show();
          let value = $(this).data('prescription'); // 0 or 1
          $('#prescription_edit').prop('checked', value == 1);
        } else {
          $('#hidePres').hide();
          $('#prescription_edit').hide();
        }
      } else {
        $('#hidePres').hide();
        $('.hideCategory').hide();
        $('#prescription_edit').hide();
        $('#parent_id').hide();
      }

      const imageUrl = $(this).data('image');
      if (imageUrl) {
        $('#preview_image').attr('src', imageUrl).show();
      } else {
        $('#preview_image').hide();
      }
      $('#offcanvasAddLabel').text("{{ __('locale.Edit Category') }}");
      $('#saveBtn').text("{{ __('locale.Update') }}");
      new bootstrap.Offcanvas('#offcanvasAdd').show();
    });

    // When dropdown changes, decide whether to show/hide prescription
    // Prescription toggle based on parent_id
    $(document).on('change', '#parent_id', function() {
      let requiresPres = $(this).find('option:selected').data('pres');
      if ($(this).val() && requiresPres == 1) {
        $('#hidePres').removeClass('d-none');
      } else {
        $('#hidePres').addClass('d-none');
        $('#prescription_edit').prop('checked', false);
      }
    });
  </script>
@endsection
