@extends('layouts/layoutMaster')

@section('title', __('locale.Add Vehicle'))

<!-- Vendor Styles -->
@section('vendor-style')
  @vite(['resources/assets/vendor/libs/bs-stepper/bs-stepper.scss', 'resources/assets/vendor/libs/select2/select2.scss', 'resources/assets/vendor/libs/animate-css/animate.scss', 'resources/assets/vendor/libs/@form-validation/form-validation.scss', 'resources/assets/vendor/libs/flatpickr/flatpickr.scss'])
@endsection

<!-- Vendor Scripts -->
@section('vendor-script')
  @vite(['resources/assets/vendor/libs/bs-stepper/bs-stepper.js', 'resources/assets/vendor/libs/select2/select2.js', 'resources/assets/vendor/libs/@form-validation/bootstrap5.js', 'resources/assets/vendor/libs/@form-validation/popular.js', 'resources/assets/vendor/libs/@form-validation/auto-focus.js', 'resources/assets/vendor/libs/moment/moment.js', 'resources/assets/vendor/libs/flatpickr/flatpickr.js'])
@endsection


@section('content')

  <!-- Modern -->
  <div class="row">
    <!-- Modern Icons Wizard -->
    <div class="col-12 mb-6">
      <div class="bs-stepper wizard-icons wizard-modern wizard-modern-icons-example mt-2">
        <div class="bs-stepper-header pt-0">
          <div class="step" data-target="#address-modern" data-step-index="2">
            <button type="button" class="step-trigger">
              <span class="bs-stepper-icon">
                <svg viewBox="0 0 58 54">
                  <use xlink:href="{{ asset('assets/svg/icons/form-wizard-personal.svg#wizardPersonal') }}">
                  </use>
                </svg>
              </span>
              <span class="bs-stepper-label">{{ __('locale.Vehicle Details') }}</span>
            </button>
          </div>
          <div class="line">
            <i class="icon-base ti tabler-chevron-right"></i>
          </div>
          <div class="step" data-target="#social-links-modern" data-step-index="3">
            <button type="button" class="step-trigger">
              <span class="bs-stepper-icon">
                <svg viewBox="0 0 54 54">
                  <use xlink:href="{{ asset('assets/svg/icons/form-wizard-social-link.svg#wizardSocialLink') }}">
                  </use>
                </svg>
              </span>
              <span class="bs-stepper-label">{{ __('locale.Documents') }}</span>
            </button>
          </div>

        </div>
        <div class="bs-stepper-content">
          <form id="carForm" enctype="multipart/form-data">
            @csrf
            <input type="hidden" name="id" id="car_id" value="{{ $car->id ?? '' }}">
            <!-- Step 1: Vehicle Details -->
            <div id="address-modern" class="content">

              <div class="row g-6">
                <div class="col-sm-6">
                  <label class="form-label" for="vehicle_parent_category_id">{{ __('locale.Vehicle Category') }}*</label>
                  <select class="form-select" id="vehicle_parent_category_id" name="vehicle_parent_category_id"
                    required></select>
                </div>
                <div class="col-sm-6">
                  <label class="form-label" for="vehicle_type_id">{{ __('locale.Vehicle Type') }}*</label>
                  <select class="form-select" id="vehicle_category_id" name="vehicle_category_id" required></select>
                </div>
                <div class="col-sm-6">
                  <label class="form-label" for="vehicle_brand_id">{{ __('locale.Vehicle Brand') }}*</label>
                  <select class="form-select" id="vehicle_brand_id" name="vehicle_brand_id" required></select>
                </div>
                <div class="col-sm-6">
                  <label class="form-label" for="vehicle_model_id">{{ __('locale.Vehicle Model') }}*</label>
                  <select class="form-select" id="vehicle_model_id" name="vehicle_model_id" required></select>
                </div>
                <div class="col-sm-6">
                  <label class="form-label" for="vehicle_color">{{ __('locale.Vehicle Color') }}*</label>
                  <select class="form-select"id="vehicle_color" name="vehicle_color" required></select>
                </div>
                <div class="col-sm-6">
                  <label class="form-label" for="vehicle_year">{{ __('locale.Vehicle Manufacturing Year') }}*</label>
                  <input type="text" class="form-control" id="vehicle_year"
                    value="{{ $car->vehicle_year ?? '' }} "name="vehicle_year" required>
                </div>
                <div class="col-sm-6">
                  <label class="form-label" for="license_plate">{{ __('locale.License Plate Number') }}*</label>
                  <input type="text" class="form-control" id="license_plate" value="{{ $car->license_plate ?? '' }}"
                    name="license_plate" required>
                </div>
                <div class="col-sm-6">
                  <label class="form-label" for="vehicle_image">{{ __('locale.Vehicle Image') }}*</label>
                  <input type="file" class="form-control" id="vehicle_image" name="vehicle_image" accept="image/*"
                    @if (empty($car) && empty($car->vehicle_image)) required @endif>
                  <img id="preview_image" class="img-thumbnail mt-2"
                    style="max-height:60px; {{ isset($car) && $car->vehicle_image ? '' : 'display: none;' }}"
                    src="{{ isset($car) && $car->vehicle_image ? asset('storage/' . $car->vehicle_image) : asset('assets/img/placeholder.jpg') }}"
                    onerror="this.src='{{ url('assets/img/placeholder.jpg') }}'">

                </div>
                <div class="col-12 d-flex justify-content-between">
                  <button class="btn btn-label-primary btn-prev" type="button">
                    <i class="icon-base ti tabler-arrow-left icon-xs me-sm-2"></i>
                    <span class="align-middle d-sm-inline-block d-none">{{ __('locale.Previous') }}</span>
                  </button>
                  <button class="btn btn-primary btn-next" type="button"><span
                      class="align-middle d-sm-inline-block d-none me-sm-2">{{ __('locale.Next') }}</span> <i
                      class="icon-base ti tabler-arrow-right icon-xs"></i></button>
                </div>
              </div>
            </div>

            <!-- Step 2: Documents -->
            <div id="social-links-modern" class="content">

              <div class="row g-6">
                <div class="col-sm-6">
                  <label class="form-label"
                    for="registration_number">{{ __('locale.Vehicle Registration Number') }}*</label>
                  <input type="text" class="form-control" id="registration_number"
                    value="{{ $car->registration_number ?? '' }}" name="registration_number" required>
                </div>
                <div class="col-sm-6">
                  <label class="form-label" for="insurance_image">{{ __('locale.Insurance Image') }}*</label>
                  <input type="file" class="form-control" id="insurance_image" name="insurance_image"
                    accept="image/*" @if (empty($car) && empty($car->insurance_image)) required @endif>
                  <img id="preview_image_insurance" class="img-thumbnail mt-2"
                    style="max-height:60px; {{ isset($car) && $car->insurance_image ? '' : 'display: none;' }}"
                    src="{{ isset($car) && $car->insurance_image ? asset('storage/' . $car->insurance_image) : asset('assets/img/placeholder.jpg') }}"
                    onerror="this.src='{{ url('assets/img/placeholder.jpg') }}'">
                </div>
                <div class="col-sm-6">
                  <label class="form-label" for="road_image">{{ __('locale.Road Worthiness') }}</label>
                  <input type="file" class="form-control" id="road_image" name="road_worthiness_image"
                    accept="image/*">
                  <img id="preview_image_road" class="img-thumbnail mt-2"
                    style="max-height:60px; {{ isset($car) && $car->road_worthiness_image ? '' : 'display: none;' }}"
                    src="{{ isset($car) && $car->road_worthiness_image ? asset('storage/' . $car->road_worthiness_image) : asset('assets/img/placeholder.jpg') }}"
                    onerror="this.src='{{ url('assets/img/placeholder.jpg') }}'">
                </div>
                <div class="col-sm-6">
                  <label class="form-label" for="registration_image">{{ __('locale.Vehicle Registration') }}*</label>
                  <input type="file" class="form-control" id="registration_image" name="vehicle_registration_image"
                    accept="image/*" @if (empty($car) && empty($car->vehicle_registration_image)) required @endif>
                  <img id="preview_image_registration" class="img-thumbnail mt-2"
                    style="max-height:60px; {{ isset($car) && $car->vehicle_registration_image ? '' : 'display: none;' }}"
                    src="{{ isset($car) && $car->vehicle_registration_image ? asset('storage/' . $car->vehicle_registration_image) : asset('assets/img/placeholder.jpg') }}"
                    onerror="this.src='{{ url('assets/img/placeholder.jpg') }}'">
                </div>
                <div class="col-12 d-flex justify-content-between">
                  <button class="btn btn-label-primary btn-prev" type="button">
                    <i class="icon-base ti tabler-arrow-left icon-xs me-sm-2"></i>
                    <span class="align-middle d-sm-inline-block d-none">{{ __('locale.Previous') }}</span>
                  </button>
                  <button class="btn btn-success btn-submit" type="button">{{ __('locale.Submit') }}</button>
                </div>
              </div>
            </div>

          </form>


        </div>
      </div>
    </div>
    <!-- /Modern Icons Wizard -->

  </div>
@endsection
<!-- Page Scripts -->
@section('page-script')
  @vite(['resources/assets/js/form-car.js', 'resources/assets/js/forms-pickers.js'])
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    $(document).ready(function() {
      initCountryDrop("#phone", "#dial_code");
    });


    function previewImage(input, targetId) {
      const file = input.files[0];
      const preview = document.getElementById(targetId);
      if (file) {
        const reader = new FileReader();
        reader.onload = function(e) {
          preview.src = e.target.result;
          preview.style.display = 'block';
        };
        reader.readAsDataURL(file);
      }
    }

    // Attach to all previewable file inputs
    $('#vehicle_image').on('change', function() {
      previewImage(this, 'preview_image');
    });
    $('#insurance_image').on('change', function() {
      previewImage(this, 'preview_image_insurance');
    });
    $('#road_image').on('change', function() {
      previewImage(this, 'preview_image_road');
    });
    $('#vr_image').on('change', function() {
      previewImage(this, 'preview_image_vr');
    });
    $(function() {
      const selectedVehicleParentCategoryId = {{ $car->vehicle_parent_category_id ?? 'null' }};
      const selectedVehicleCategoryId = {{ $car->vehicle_category_id ?? 'null' }};
      const selectedVehicleBrandId = {{ $car->vehicle_brand_id ?? 'null' }};
      const selectedVehicleModelId = {{ $car->vehicle_model_id ?? 'null' }};
      const selectedVehicleColorId = {{ $car->vehicle_color ?? 'null' }};
      // Load parent categories
      $.get(`${baseURL}/vehicle-categories/dropdown`, function(categories) {
        $('#vehicle_parent_category_id').empty().append(`<option value="">Select Category</option>`);
        if (Array.isArray(categories)) {
          categories.forEach(c => {
            const selected = c.id == selectedVehicleParentCategoryId ? 'selected' : '';
            $('#vehicle_parent_category_id').append(
              `<option value="${c.id}" ${selected}>${c.name}</option>`);
          });

          // If editing and parent selected, load subcategories
          if (selectedVehicleParentCategoryId) {
            loadSubCategories(selectedVehicleParentCategoryId);
          }
        }
      }).fail(function(xhr, status, error) {
        console.error("Error loading categories:", error);
        console.log(xhr.responseText);
      });

      function loadSubCategories(categoryId) {
        $('#vehicle_category_id').empty().append(`<option value="">Select Type</option>`);
        $.get(`${baseURL}/vehicle-categories/${categoryId}/subcategories`, function(types) {
          if (Array.isArray(types)) {
            types.forEach(t => {
              const selected = t.id == selectedVehicleCategoryId ? 'selected' : '';
              $('#vehicle_category_id').append(`<option value="${t.id}" ${selected}>${t.name}</option>`);
            });
          }
        });
      }

      $('#vehicle_parent_category_id').on('change', function() {
        const categoryId = $(this).val();
        $('#vehicle_category_id').empty().append(`<option value="">Select Type</option>`);
        $('#vehicle_model_id').empty().append(`<option value="">Select Model</option>`);
        if (categoryId) {
          loadSubCategories(categoryId);
          loadVehicleModels();
        }
      });
      $('#vehicle_category_id').on('change', function() {
        $('#vehicle_model_id').empty().append(`<option value="">Select Model</option>`);
        loadVehicleModels();
      });

      // Load brands
      $.get(`${baseURL}/vehicle-brands-dropdown`, function(brands) {
        $('#vehicle_brand_id').empty().append(`<option value="">Select Brand</option>`);
        if (Array.isArray(brands)) {
          brands.forEach(b => {
            const selected = b.id == selectedVehicleBrandId ? 'selected' : '';
            $('#vehicle_brand_id').append(`<option value="${b.id}" ${selected}>${b.name}</option>`);
          });
        }
      }).fail(function(xhr, status, error) {
        console.error("Error loading brands:", error);
        console.log(xhr.responseText);
      });

      // If editing, load models for selected brand and category
      if (selectedVehicleBrandId && selectedVehicleCategoryId && selectedVehicleParentCategoryId) {
        loadVehicleModels();
      }

      // On brand or type change, load models
      $('#vehicle_brand_id, #vehicle_category_id').on('change', function() {
        loadVehicleModels();
      });

      if (selectedVehicleModelId) {
        loadVehicleModels();
      }

      function loadVehicleModels() {
        const brandId = $('#vehicle_brand_id').val() ?? selectedVehicleBrandId;
        const categoryId = $('#vehicle_category_id').val() ?? selectedVehicleCategoryId;
        const parentCategoryId = $('#vehicle_parent_category_id').val() ?? selectedVehicleParentCategoryId;

        if (!brandId || !categoryId || !parentCategoryId) return;

        $.ajax({
          url: `${baseURL}/vehicle-models-dropdown`, // <-- your route URL
          method: 'GET',
          data: {
            vehicle_brand_id: brandId,
            vehicle_category_id: categoryId,
            vehicle_parent_category_id: parentCategoryId
          },
          success: function(response) {
            $('#vehicle_model_id').empty().append('<option value="">Select Model</option>');
            response.data.forEach(model => {
              const selected = model.id == selectedVehicleModelId ? 'selected' : '';
              $('#vehicle_model_id').append(
                `<option value="${model.id}" ${selected}>${model.name}</option>`);
            });
          },
          error: function(xhr) {
            console.error(xhr.responseText);
          }
        });
      }

      // Load colors
      $.get(`${baseURL}/vehicle-color-dropdown`, function(colors) {
        $('#vehicle_color').empty().append(`<option value="">Select Color</option>`);
        if (Array.isArray(colors)) {
          colors.forEach(c => {
            const selected = c.id == selectedVehicleColorId ? 'selected' : '';
            $('#vehicle_color').append(
              `<option value="${c.id}" ${selected} data-color="${c.code}">${c.name}</option>`);
          });
        }
      }).fail(function(xhr, status, error) {
        console.error("Error loading colors:", error);
        console.log(xhr.responseText);
      });

    });
    // Initialize Flatpickr
    document.addEventListener('DOMContentLoaded', function() {
      flatpickr('#license_expiry', {
        dateFormat: 'Y-m-d',
        minDate: 'today',
        allowInput: false
      });

      flatpickr('#dob', {
        dateFormat: 'Y-m-d',
        maxDate: new Date(new Date().setFullYear(new Date().getFullYear() - 18)),
        allowInput: false
      });
    });

    $(function() {
      window.initColorSelect2('#vehicle_color');
    });
  </script>
@endsection
