@extends('layouts/layoutMaster')

@section('title', __('locale.Banners'))

@section('page-style')
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fancyapps/ui@6.0/dist/fancybox/fancybox.css" />

@endsection



@section('page-script')
  <script src="https://cdn.jsdelivr.net/npm/@fancyapps/ui@6.0/dist/fancybox/fancybox.umd.js"></script>
  <script>
    Fancybox.bind("[data-fancybox='gallery']", {
      Thumbs: false,
      Toolbar: true
    });
  </script>

@endsection

@section('content')
  <div class="row">


    <!-- User Content -->
    <div class="col-xl-12 col-lg-12 order-0 order-md-1">
      @php
        use Carbon\Carbon;
        use Illuminate\Support\Str;
        use App\Models\Store;
        use App\Models\Product;
        use App\Models\Category;

        $start = $banner?->start_date ? Carbon::parse($banner->start_date) : null;
        $end = $banner?->end_date ? Carbon::parse($banner->end_date) : null;

        // Date logic
        $dateLabel = 'No Expiry Date';
        $dateColor = 'secondary';
        if ($start && $end) {
            $now = Carbon::now();
            if ($now->between($start, $end)) {
                $dateLabel = 'Active';
                $dateColor = 'success';
            } elseif ($now->lt($start)) {
                $dateLabel = 'Upcoming';
                $dateColor = 'warning';
            } else {
                $dateLabel = 'Expired';
                $dateColor = 'danger';
            }
        }

        // Link type color & icon
        $linkMap = [
            'external_link' => ['color' => 'info', 'icon' => 'link', 'label' => 'External Link'],
            'product' => ['color' => 'primary', 'icon' => 'box', 'label' => 'Product'],
            'store' => ['color' => 'success', 'icon' => 'building-store', 'label' => 'Store'],
            'category' => ['color' => 'warning', 'icon' => 'layout-board', 'label' => 'Category'],
        ];
        $linkMeta = $linkMap[$banner?->link] ?? ['color' => 'secondary', 'icon' => 'question-circle', 'label' => 'N/A'];

        // Status
        $statusMeta =
            $banner?->status == 1
                ? ['color' => 'success', 'text' => 'Enabled', 'icon' => 'circle-check']
                : ['color' => 'warning', 'text' => 'Disabled', 'icon' => 'xbox-x'];

        // Linked name
        $linkedName = match ($banner?->link) {
            'store' => Store::find($banner->record_id)?->store_name ?? '-',
            'product' => Product::find($banner->record_id)?->title ?? '-',
            'category' => Category::find($banner->record_id)?->name ?? '-',
            'external_link' => $banner->link_url ?? '-',
            default => '-',
        };
      @endphp

      <div class="card mb-6">
        <div class="card">
          <div class="card-body row gy-6">
            <div class="col-12 col-md-12 col-lg-12">
              <div class="card h-100 shadow-none ">
                <div class="p-2 pb-0">
                  <a data-fancybox="gallery" data-caption="{{ $banner?->name ?? __('locale.Banners') }}"
                    href='{{ asset('storage/' . $banner?->image) }}'> <img class="img-fluid scaleX-n1-rtl"
                      style="max-height: 100vh; width: 100%; object-fit: cover;"
                      src="{{ asset('storage/' . $banner?->image) }}"
                      onerror="this.onerror=null;this.src=`{{ asset('assets/img/placeholder.jpg') }}`;" /></a>
                </div>
                <div class="card-body">
                  {{-- Header --}}
                  <div class="d-flex justify-content-between align-items-start mb-3">
                    <h5 class="fw-bold mb-0 text-primary">
                      {{ $banner?->name ?? '' }}
                    </h5>
                    <span class="badge bg-{{ $dateColor }} text-uppercase px-3 py-2">
                      {{ $dateLabel }}
                    </span>
                  </div>

                  {{-- Date Range --}}
                  @if ($start && $end)
                    <span class="text-muted">{{ __('locale.Date') }}:</span>
                    <h5 class="mb-2">
                      <i class="icon-base ti tabler-calendar icon-md"></i>
                      {{ $start->format('d M Y') }} → {{ $end->format('d M Y') }}
                    </h5>
                  @endif

                  {{-- Description --}}
                  @if ($banner?->description)
                    <span class="text-muted">{{ __('locale.Description') }}:</span>
                    <h5 class="mb-3">{{ $banner->description }}</h5>
                  @endif

                  {{-- Link Type & Status --}}
                  <div class="d-flex flex-wrap gap-2 mb-3 mt-4">
                    <span class="badge bg-{{ $linkMeta['color'] }} px-3 py-2 d-flex align-items-center gap-1">
                      <i class="icon-base ti tabler-{{ $linkMeta['icon'] }} icon-md"></i> {{ $linkMeta['label'] }}
                      {{-- Linked Target --}}
                      @if ($linkedName !== '-')
                        <div class="border rounded p-2 bg-light small">

                          @if ($banner?->link === 'external_link')
                            <a href="{{ $linkedName }}" target="_blank" class="text-info fw-bold ms-1">
                              <i class="icon-base ti tabler-external-link icon-md"></i> {{ Str::limit($linkedName, 40) }}
                            </a>
                          @else
                            <span class="fw-bold text-info ms-1">{{ $linkedName }}</span>
                          @endif
                        </div>
                      @endif
                    </span>

                    <span class="badge bg-{{ $statusMeta['color'] }} px-3 py-2 d-flex align-items-center gap-1">
                      <i class="icon-base ti tabler-{{ $statusMeta['icon'] }} icon-md"></i> {{ $statusMeta['text'] }}
                    </span>
                  </div>


                </div>
              </div>
            </div>

          </div>
        </div>

      </div>


    </div>
    <!--/ User Content -->
  </div>
  <!-- /Modal -->
@endsection
