@php
  $configData = Helper::appClasses();
@endphp

@extends('layouts/layoutMaster')

@section('title', __('locale.Banners'))

@section('vendor-style')
  @vite(['resources/assets/css/datatables.scss', 'resources/assets/vendor/libs/flatpickr/flatpickr.scss'])
@endsection

@section('vendor-script')
  @vite(['resources/assets/js/datatables.js', 'resources/assets/vendor/libs/moment/moment.js', 'resources/assets/vendor/libs/flatpickr/flatpickr.js'])
  <style>
    .flatpickr-monthDropdown-months {
      padding: 0px !important;
    }
  </style>
@endsection

@section('content')
  <div class="row g-6">
    <div class="col-12">
      <div class="card">
        <div class="card-datatable">
          <table class="datatables-users table border-top">
            <thead>
              <tr>
                <th>#</th>
                <th>{{ __('locale.Image') }}</th>
                <th>{{ __('locale.Title') }}</th>
                <th>{{ __('locale.Date') }}</th>
                <th>{{ __('locale.Details') }}</th>
                <th>{{ __('locale.Status') }}</th>
                <th>{{ __('locale.Actions') }}</th>
              </tr>
            </thead>
          </table>
        </div>
      </div>
    </div>
  </div>

  <!-- Offcanvas to add new banner -->
  <div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasAdd" aria-labelledby="offcanvasAddLabel">
    <div class="offcanvas-header border-bottom">
      <h5 id="offcanvasAddLabel" class="offcanvas-title">{{ __('locale.Add New Banner') }}</h5>
      <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body mx-0 flex-grow-0 p-6 h-100">
      <form class="add-new-banner pt-0" id="upload_form" method="POST" action="{{ route('banners.store') }}">
        @csrf
        <input type="hidden" name="id" id="banner_id">
        <div class="col-md-12 mb-4">
          <label class="form-label">{{ __('locale.Title') }}</label>
          <input type="text" class="form-control" name="name" placeholder="{{ __('locale.Title') }}">
        </div>
        <div class="col-md-12 mb-3">
          <label class="form-label">{{ __('locale.Description') }}</label>
          <textarea name="description" class="form-control" rows="1"></textarea>
        </div>
        <div class="col-md-12 mb-3">
          <label class="form-label" for="flatpickr-range">{{ __('locale.Date Range') }}</label>
          <input type="text" name="date" class="form-control" placeholder="YYYY-MM-DD to YYYY-MM-DD"
            id="flatpickr-range">
        </div>

        <div class="col-md-12 mb-3">
          <label class="form-label">{{ __('locale.Link Type') }}</label>
          <select name="link" id="link_type" class="form-control select2">
            <option value="">{{ __('locale.No Link') }}</option>
            <option value="external_link">{{ __('locale.External Link') }}</option>
            <option value="category">{{ __('locale.Category') }}</option>
            <option value="store">{{ __('locale.Store') }}</option>
            <option value="product">{{ __('locale.Product') }}</option>
          </select>
        </div>
        <div class="col-md-12 mb-3 category" style="display:none;">
          <label class="form-label">{{ __('locale.Main Category') }}</label>
          <select name="main_category" id="main_category" class="form-control select2">
            <option value="">{{ __('locale.Select Category') }}</option>
            @foreach (\App\Models\Category::whereNull('parent_id')->where('status', 1)->get() as $key => $label)
              <option value="{{ $label->id }}">{{ $label->name }}</option>
            @endforeach
          </select>
        </div>
        <div class="row">
          <div class="col-md-12 external" style="display:none;">
            <label class="form-label">{{ __('locale.External URL') }}</label>
            <input type="text" name="link_url" class="form-control">
          </div>

          <div class="col-md-12 store" style="display:none;">
            <label class="form-label">{{ __('locale.Store') }}</label>
            <select name="store" id="store" class="form-control select2"></select>
          </div>

          <div class="col-md-12 product" style="display:none;">
            <label class="form-label">{{ __('locale.Product') }}</label>
            <select name="product" id="product" class="form-control select2"></select>
          </div>
        </div>
        <div class="mb-4">
          <label class="form-label" for="banner_image">{{ __('locale.Image') }}</label>
          <input type="file" class="form-control" name="image" id="banner_image" accept="image/*">
          <div class="mt-2">
            <img id="preview_image" src="{{ asset('assets/img/placeholder.jpg') }}" alt="Preview" class="img-thumbnail"
              style="max-height: 60px; display: none;">
          </div>
        </div>

        <button type="submit" class="btn btn-primary me-3 data-submit">{{ __('locale.Submit') }}</button>
        <button type="reset" class="btn btn-label-danger"
          data-bs-dismiss="offcanvas">{{ __('locale.Cancel') }}</button>
      </form>
    </div>
  </div>

  <!-- Modal to edit banner -->

  <div id="role-helper" data-add="{{ __('locale.Add New Banner') }}"></div>
@endsection

@section('page-script')
  @vite(['resources/assets/js/forms-pickers.js', 'resources/assets/js/banner.js'])
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    window.permissions = {
      canListBanner: @json(auth()->user()->can('banner-list')),
      canDeleteBanner: @json(auth()->user()->can('banner-delete')),
      canEditBanner: @json(auth()->user()->can('banner-edit')),
      canCreateBanner: @json(auth()->user()->can('banner-create'))
    };
    // Preview for Add Banner
    document.getElementById('banner_image')?.addEventListener('change', function(e) {
      const img = document.getElementById('preview_image');
      const file = e.target.files[0];
      if (file) {
        img.src = URL.createObjectURL(file);
        img.style.display = 'block';
      } else {
        img.style.display = 'none';
      }
    });

    // Preview for Edit Banner
    document.getElementById('edit_banner_image')?.addEventListener('change', function(e) {
      const img = document.getElementById('edit_preview_image');
      const file = e.target.files[0];
      if (file) {
        img.src = URL.createObjectURL(file);
        img.style.display = 'block';
      } else {
        img.style.display = 'none';
      }
    });

    $(document).ready(function() {
      const table = $('.datatables-users').DataTable();
      let $btn = null;

      // Track which button triggered submit
      $(document).on('click', '#upload_form button[type="submit"]', function() {
        $btn = $(this);
      });

      // Form submit via AJAX
      $('#upload_form').on('submit', function(event) {
        event.preventDefault();
        let formData = new FormData(this);
        let bannerId = $('#banner_id').val();
        let actionUrl = bannerId ? `${baseURL}/banners/${bannerId}` : `${baseURL}/banners`;
        if (bannerId) formData.append('_method', 'PUT');

        $.ajax({
          type: "POST",
          url: actionUrl,
          headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          },
          data: formData,
          contentType: false,
          processData: false,
          cache: false,
          beforeSend: () => toggleButtonLoading($btn, true, 'Saving...'),
          success: function(data) {
            toggleButtonLoading($btn, false);

            if (data.status === 200 && data.data) {
              const banner = data.data;
              const rowSelector = `#trRow-${banner.id}`;
              const existingRow = table.row(rowSelector);

              if (existingRow.any()) {
                existingRow.data(banner).draw(false);
              } else {
                const newRow = table.row.add(banner).draw(false);
                $(newRow.node()).attr('id', `trRow-${banner.id}`);
                table.order([5, 'desc']).draw(false);
              }

              $('#upload_form')[0].reset();
              const offcanvasEl = document.getElementById('offcanvasAdd');
              bootstrap.Offcanvas.getInstance(offcanvasEl)?.hide();
            }

            window.showToast({
              title: 'Banners 🖼️',
              message: data.message,
              type: data.status === 200 ? 'bg-success' : 'bg-warning',
              animation: 'animate__fadeInUp',
              time: 'Just now',
              delay: 3000
            });
          },
          error: function(xhr) {
            toggleButtonLoading($btn, false);
          }
        });
      });

      // Edit banner
      $(document).on('click', '.editBanner', function() {
        let bannerId = $(this).data('id');
        $.get(`${baseURL}/banners/${bannerId}/edit`, function(response) {

          // Fill form
          $('#banner_id').val(response.id);
          $('input[name="name"]').val(response.name);
          $('textarea[name="description"]').val(response.description);
          if (response.start_date && response.end_date) {
            $('input[name="date"]').val(`${response.start_date} to ${response.end_date}`);
          }

          // Set link type and trigger UI update
          $('#link_type').val(response.link).trigger('change');

          // Populate dependent dropdowns with proper timing
          if (response.link === 'external_link') {
            $('input[name="link_url"]').val(response.link_url);
          } else if (response.link === 'store') {
            $('#store').val(response.record_id).trigger('change');
          } else if (response.link === 'product') {
            // First set store (from record_store_id if you have it)
            $('#store').val(response.store_id).trigger('change');
            setTimeout(() => $('#product').val(response.record_id).trigger('change'), 300);
          } else if (response.link === 'category') {
            $('#main_category').val(response.record_id).trigger('change');
          }

          // Image preview
          if (response.image) {
            $('#preview_image').attr('src', "{{ asset('storage') }}/" + response.image).show();
          } else {
            $('#preview_image').hide();
          }

          // Update form title and action
          $('#upload_form').attr('action', "{{ route('banners.store') }}");
          $('#offcanvasAddLabel').text("Edit Banner");
          new bootstrap.Offcanvas(document.getElementById('offcanvasAdd')).show();
        });
      });

      // Link type visibility
      function linkType() {
        let type = $('#link_type').val();
        $('.external, .store, .product, .category').hide();
        if (type === 'external_link') $('.external').show();
        if (type === 'store') {
          $('.category').show();
          $('.store').show();
        }
        if (type === 'category') $('.category').show();
        if (type === 'product') {
          $('.category').show();
          $('.store').show();
          $('.product').show();
        }
      }
      $('#link_type').on('change', linkType);
      linkType(); // initial call

      // Dependent dropdowns
      $('#main_category').on('change', function() {
        let mainCategory = $(this).val();
        $('#store').html('<option value="">Select Store</option>'); // reset
        if (!mainCategory) return;

        $.post("{{ route('get-stores') }}", {
          _token: "{{ csrf_token() }}",
          main_category: mainCategory
        }, function(response) {
          if (response.status == 200) {
            let options = '<option value="">Select Store</option>';
            $.each(response.data, function(i, store) {
              options += `<option value="${store.id}">${store.user.name}</option>`;
            });
            $('#store').html(options).trigger('change');
          }
        });
      });

      $('#store').on('change', function() {
        let store = $(this).val();
        $('#product').html('<option value="">Select Product</option>'); // reset
        if (!store) return;

        $.post("{{ route('get-products') }}", {
          _token: "{{ csrf_token() }}",
          store: store
        }, function(response) {
          if (response.status == 200) {
            let options = '<option value="">Select Product</option>';
            $.each(response.data, function(i, product) {
              options += `<option value="${product.id}">${product.title}</option>`;
            });
            $('#product').html(options).trigger('change');
          }
        });
      });
    });
  </script>
@endsection
