<div class="modal fade" id="ruleModal" tabindex="-1">
  <div class="modal-dialog modal-lg">
    <form id="ruleForm">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">{{ __('locale.Add/Edit Rule') }}</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body">
          @csrf
          <input type="hidden" name="id" id="ruleId">

          <!-- Country -->
          <div class="mb-3">
            <label class="form-label">{{ __('locale.Select Country') }}</label>
            <select name="country_id" id="country" class="select2 form-select">
              @foreach ($countries as $country)
                <option value="{{ $country->id }}">
                  {{ $country->name }} ({{ $country->currency_symbol }})
                </option>
              @endforeach
            </select>
          </div>

          <!-- Rule Name -->
          <div class="mb-3">
            <label class="form-label">{{ __('locale.Rule Name') }}</label>
            <input type="text" class="form-control" name="rule_name" required>
          </div>

          <!-- Conditions -->
          <div class="mb-3">
            <label class="form-label">{{ __('locale.Rule Conditions') }}</label>
            <div id="conditionsWrapper">
              <!-- Dynamic condition rows will be appended here -->
            </div>
            <button type="button" class="btn btn-sm btn-primary mt-2" id="addCondition">
              + {{ __('locale.Add Condition') }}
            </button>
          </div>

          <!-- Pricing -->
          <div class="row">
            <div class="col-md-4 mb-3">
              <label class="form-label">{{ __('locale.Price Type') }}</label>
              <select class="form-select" name="price_type" required>
                <option value="flat">{{ __('locale.Increment-Flat') }}</option>
                <option value="percent">{{ __('locale.Increment-Percentage') }}</option>
                <option value="multiplier">{{ __('locale.Multiplier') }}</option>
                <option value="discount">{{ __('locale.Discount Percentage') }}</option>
              </select>
            </div>
            <div class="col-md-4 mb-3">
              <label class="form-label" for="amount_label">{{ __('locale.Amount') }}</label>
              <input type="number" step="0.01" class="form-control" name="amount" required>
            </div>
            <div class="col-md-4 mb-3 d-none">
              <label class="form-label">{{ __('locale.Priority') }}</label>
              <input type="number" class="form-control" name="priority" value="1" required>
            </div>
          </div>

          <!-- Status -->
          <div class="mb-3">
            <label class="form-label">{{ __('locale.Active') }}</label>
            <select class="form-select" name="is_active">
              <option value="1" selected>{{ __('locale.Active') }}</option>
              <option value="0">{{ __('locale.Inactive') }}</option>
            </select>
          </div>

        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">{{ __('locale.Save Rule') }}</button>
        </div>
      </div>
    </form>
  </div>
</div>
