<div class="modal-onboarding modal fade animate__animated" id="onboardingHorizontalSlideModal" tabindex="-1"
  aria-hidden="true">
  <style>
    .carousel-control-prev.disabled,
    .carousel-control-next.disabled {
      opacity: 0.3;
      pointer-events: none;
    }

    .carousel-item {
      max-height: 300px
    }

    .modal-image {
      max-height: 80vh;
      /* Fit inside modal vertically */
      width: auto;
      /* Maintain aspect ratio */
      object-fit: contain;
      /* Don’t crop */
      display: block;
      margin-left: auto;
      margin-right: auto;
    }
  </style>
  <div class="modal-dialog modal-xl" role="document">
    <div class="modal-content text-center">
      <div class="modal-header border-0">
        <button type="button" class="btn btn-danger me-2" id="reject-driver-btn">{{ __('locale.Reject') }}</button>
        <button type="button" class="btn btn-success" id="approve-driver-btn">{{ __('locale.Approve') }}</button>

        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div id="modalHorizontalCarouselControls" class="carousel slide pb-6 mb-2" data-bs-interval="false">
        <div class="carousel-indicators">
          <button type="button" data-bs-target="#modalHorizontalCarouselControls" data-bs-slide-to="0" class="active"
            aria-current="true" aria-label="Slide 1"></button>
          <button type="button" data-bs-target="#modalHorizontalCarouselControls" data-bs-slide-to="1"
            aria-label="Slide 2"></button>
          <button type="button" data-bs-target="#modalHorizontalCarouselControls" data-bs-slide-to="2"
            aria-label="Slide 3"></button>
        </div>
        <div class="carousel-inner mt-4 mb-2">

          <div class="carousel-item active">
            <div class="onboarding-horizontal px-4">
              <div class="row gy-4">
                <div class="col-lg-6 text-center">
                  <h4 class="onboarding-title text-body mb-3">{{ __('locale.Vehicle Details') }}</h4>
                  <span class="badge bg-label-primary rounded mb-3 h-px-52 w-px-52 p-2">
                    <i
                      class="icon-base ti {{ $user['driver']?->type == 'Ride' ? 'tabler-car' : 'tabler-truck-delivery' }} icon-24px"></i>
                  </span>
                  <h5>{{ $user['driver']['vehicle']?->vehicle_model }}</h5>
                  <div class="btn-group my-2">
                    <button type="button"
                      class="btn btn-secondary">{{ $user['driver']['vehicle']?->parent_category }}</button>
                    <button type="button"
                      class="btn btn-secondary">{{ $user['driver']['vehicle']?->vehicle_category }}</button>
                    <button type="button"
                      class="btn btn-secondary">{{ $user['driver']['vehicle']?->vehicle_year }}</button>
                  </div>
                  <div class="demo-inline-spacing mt-2">
                    <button class="btn btn-primary">{{ $user['driver']['vehicle']?->vehicle_brand }}</button>
                    <button class="btn"
                      style="background:{{ $user['driver']['vehicle']['color']['code'] ?? '#ccc' }}">
                      {{ __('locale.Color') }}: {{ $user['driver']['vehicle']['color']['name'] ?? '' }}
                    </button>
                  </div>
                </div>

                <div class="col-lg-6">
                  <div class="card h-100 shadow-none border">
                    <div class="p-2 pb-0">
                      <a data-fancybox="gallery" data-caption="{{ __('locale.Vehicle Image') }}"
                        href="{{ asset('storage/' . $user['driver']['vehicle']?->vehicle_image) }}">
                        <img class="img-fluid scaleX-n1-rtl"
                          src="{{ asset('storage/' . $user['driver']['vehicle']?->vehicle_image) }}"
                          onerror="this.onerror=null;this.src='{{ asset('assets/img/placeholder.jpg') }}';" />
                      </a>
                    </div>
                    <div class="card-body">
                      <h5 class="card-title">{{ $user['driver']['vehicle']?->license_plate }}</h5>
                      <p class="card-text">{{ $user['driver']['vehicle']?->registration_number }}</p>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>

          <!-- Step 2: Documents -->
          <div class="carousel-item">
            <div class="onboarding-horizontal px-4">
              <div class="row g-4">
                @php
                  $docs = [
                      ['label' => __('locale.Insurance Image'), 'field' => 'insurance_image'],
                      ['label' => __('locale.Road Worthiness'), 'field' => 'road_worthiness_image'],
                      ['label' => __('locale.Vehicle Registration'), 'field' => 'vehicle_registration_image'],
                  ];
                @endphp
                @foreach ($docs as $doc)
                  <div class="col-md-4">
                    <h6>{{ $doc['label'] }}</h6>
                    <div class="card">
                      <a data-fancybox="gallery" data-caption="{{ $doc['label'] }}"
                        href="{{ asset('storage/' . $user['driver']['vehicle'][$doc['field']] ?? '') }}">
                        <img class="img-fluid scaleX-n1-rtl"
                          src="{{ asset('storage/' . $user['driver']['vehicle'][$doc['field']] ?? '') }}"
                          onerror="this.onerror=null;this.src='{{ asset('assets/img/placeholder.jpg') }}';"
                          alt="{{ $doc['label'] }}">
                      </a>
                    </div>
                  </div>
                @endforeach
              </div>
            </div>
          </div>

          <!-- Step 3: Driver License + Address -->
          <div class="carousel-item">
            <div class="onboarding-horizontal px-4">

              <div class="row gy-4">
                <div class="col-md-7">
                  <h4 class="onboarding-title text-body mb-3">{{ __('locale.Driver License') }} &
                    {{ __('locale.Address') }}</h4>
                  <div class="card shadow-none bg-label-danger">
                    <div class="card-body d-flex justify-content-between flex-wrap">
                      <div class="text-center text-sm-start">
                        <h5 class="text-danger">{{ __('locale.Driver License') }}</h5>
                        <p>{{ __('locale.Expiry') }}: {{ $user['driver']?->license_expiry }}</p>
                        <button class="btn btn-sm btn-info">{{ $user['driver']?->license_number }}</button>
                      </div>
                      <div class="text-end">
                        <img style="max-height:200px"class="img-fluid scaleX-n1-rtl"
                          src="{{ asset('storage/' . $user['driver']?->license_image) }}"
                          alt="{{ $user['driver']?->license_number }}"
                          onerror="this.onerror=null;this.src='{{ asset('assets/img/placeholder.jpg') }}';" />
                      </div>
                    </div>
                  </div>
                </div>

                <div class="col-md-5">
                  <dl class="row mb-0">
                    <dt class="col-sm-4">{{ __('locale.Name') }}:</dt>
                    <dd class="col-sm-8">{{ $user->name }}</dd>

                    <dt class="col-sm-4">{{ __('locale.Phone') }}:</dt>
                    <dd class="col-sm-8">{{ $user->phone }}</dd>

                    <dt class="col-sm-4">{{ __('locale.Address') }}:</dt>
                    <dd class="col-sm-8">{{ $user['driver']?->address }}</dd>

                    <dt class="col-sm-4">{{ __('locale.Landmark') }}:</dt>
                    <dd class="col-sm-8">{{ $user['driver']?->landmark }}</dd>

                    <dt class="col-sm-4">{{ __('locale.City') }}:</dt>
                    <dd class="col-sm-8">{{ $user['driver']?->city }}</dd>

                    <dt class="col-sm-4">{{ __('locale.State') }}:</dt>
                    <dd class="col-sm-8">{{ $user['driver']?->state }}</dd>

                    <dt class="col-sm-4">{{ __('locale.Country') }}:</dt>
                    <dd class="col-sm-8">{{ $user['driver']?->country }}</dd>

                    <dt class="col-sm-4">{{ __('locale.Postcode') }}:</dt>
                    <dd class="col-sm-8">{{ $user['driver']?->postcode }}</dd>
                  </dl>
                </div>
              </div>
            </div>
          </div>
          <input type="hidden" id="approve-driver-id" value="{{ $user->id }}">
        </div>

        <a class="carousel-control-prev" id="prevSlideBtn" href="#modalHorizontalCarouselControls" role="button"
          data-bs-slide="prev">
          <i class="icon-base ti tabler-chevrons-left me-2"></i><span>Previous</span>
        </a>
        <a class="carousel-control-next" id="nextSlideBtn" href="#modalHorizontalCarouselControls" role="button"
          data-bs-slide="next">
          <span>Next</span><i class="icon-base ti tabler-chevrons-right ms-2"></i>
        </a>

      </div>
    </div>
  </div>
</div>
