//logout
// script.js
import '../vendor/libs/sweetalert2/sweetalert2.js';
window.handleLogout = async function () {
  await unsubscribePush();
  document.getElementById('logout-form').submit();
};

async function unsubscribePush() {
  console.log('Unsubscribing push notifications...');
  if (!('serviceWorker' in navigator) || !('PushManager' in window)) {
    console.warn('Push not supported in this browser');
    return;
  }
  try {
    // Ensure service worker is actually registered
    const regs = await navigator.serviceWorker.getRegistrations();
    if (regs.length === 0) {
      console.warn('No service worker registered');
      return;
    }
    for (const reg of regs) {
      const subscription = await reg.pushManager.getSubscription();
      if (subscription) {
        const success = await subscription.unsubscribe();
        console.log(success ? 'Unsubscribed from push' : 'Unsubscribe failed');
      } else {
        console.log('No active subscription in this registration');
      }
    }
  } catch (err) {
    console.error('Error during unsubscribe:', err);
  }
}

// ✅ Global defaults (headers, etc.)
$.ajaxSetup({
  headers: {
    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
  }
});

// ✅ Global Error Handler
$(document).ajaxError(function (event, xhr, settings, thrownError) {
  let res = xhr.responseJSON;

  if (xhr.status === 422 && res?.errors) {
    // Validation errors
    let messages = Object.values(res.errors).flat().join('<br>');
    window.showToast({
      title: '❌ Validation Error',
      message: messages,
      type: 'bg-danger',
      delay: 4000
    });
  } else {
    // Server or unauthorized error
    window.showToast({
      title: '🔥 Error',
      message: res?.message || 'Something went wrong',
      type: 'bg-danger',
      delay: 4000
    });
  }
});

window.showSwalConfirm = function ({
  title = 'Are you sure?',
  text = 'This action cannot be undone.',
  confirmText = 'Yes, confirm it!',
  cancelText = 'Cancel',
  confirmClass = 'btn btn-primary',
  cancelClass = 'btn btn-outline-danger ms-1',
  onConfirm = () => {}
}) {
  Swal.fire({
    title,
    text,
    icon: 'warning',
    showCancelButton: true,
    confirmButtonText: confirmText,
    cancelButtonText: cancelText,
    customClass: {
      confirmButton: confirmClass,
      cancelButton: cancelClass
    },
    buttonsStyling: false
  }).then(result => {
    if (result.isConfirmed && typeof onConfirm === 'function') {
      onConfirm();
    }
  });
};
window.showSwalLoading = function (title = 'Processing...', text = 'Please wait...') {
  Swal.fire({
    title,
    html: text,
    allowOutsideClick: false,
    didOpen: () => Swal.showLoading()
  });
};

function closeSwal() {
  Swal.close();
}

// Global function
window.showToast = function ({
  title = 'Bootstrap',
  message = 'Hello, world!',
  type = 'bg-primary',
  animation = 'animate__fadeInRight',
  time = 'Just now',
  delay = 4000
} = {}) {
  return new Promise(resolve => {
    const toastId = 'toast-' + Date.now();

    const base = document.querySelector('#base-toast-wrapper .toast').cloneNode(true);
    base.id = toastId;
    base.classList.add(type, animation);
    base.setAttribute('data-bs-delay', delay);

    base.querySelector('.toast-title').innerText = title;
    base.querySelector('.toast-message').innerText = message;
    base.querySelector('.toast-time').innerText = time;

    const container = document.getElementById('toast-container');
    container.appendChild(base);

    const toast = new bootstrap.Toast(base);
    toast.show();

    base.addEventListener('hidden.bs.toast', () => {
      base.remove();
      resolve(); // ✅ resolve the promise when toast is hidden
    });
  });
};

window.toggleButtonLoading = function (button, isLoading = true, loadingText = null) {
  const $btn = $(button);
  const originalText = $btn.data('original-text') || $btn.html();

  if (isLoading) {
    // Store original button HTML once
    if (!$btn.data('original-text')) {
      $btn.data('original-text', originalText);
    }
    const text = loadingText || 'Uploading';
    $btn.attr('disabled', true).html(`
        <span class="spinner-border spinner-border-sm me-1" role="status" aria-hidden="true"></span>
        ${text}
      `);
  } else {
    $btn.attr('disabled', false).html(originalText);
  }
};

window.sendAjaxRequest = function ({
  type = 'GET',
  url,
  data = {},
  success = () => {},
  error = () => {},
  beforeSend = null,
  updateTarget = null
}) {
  $.ajax({
    type,
    url,
    data,
    processData: false,
    contentType: false,
    cache: false,
    dataType: 'JSON',
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    },
    beforeSend: () => {},
    success: function (response) {
      if (updateTarget && $(updateTarget).length) {
        $(updateTarget).html(response);
      }
      success(response);
    },
    error: function (xhr) {
      error(xhr);
    }
  });
};

//Notifications start
document.addEventListener('DOMContentLoaded', function () {
  const markAllBtn = document.querySelector('.dropdown-notifications-all');
  const notificationList = document.querySelector('.dropdown-menu ul'); // or more specific selector

  if (markAllBtn) {
    markAllBtn.addEventListener('click', () => {
      fetch(`${baseURL}/notifications/mark-all-read`, {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
          'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        }
      })
        .then(response => {
          if (!response.ok) throw new Error('Network error');
          return response.json();
        })
        .then(data => {
          if (data.status === 200) {
            window.showToast({
              title: 'Notification ✉️',
              message: data.message,
              type: 'bg-success',
              animation: 'animate__fadeInUp',
              time: 'Just now',
              delay: 3000
            });
            document.querySelector('.notificationCount')?.classList.add('d-none');
            // Remove all list items except the "no notification" placeholder
            notificationList.innerHTML = `
            <li class="list-group-item list-group-item-action dropdown-notifications-item">
              <div class="d-flex">
                <div class="flex-grow-1">
                  <h6 class="small mb-1">No New Notification</h6>
                </div>
              </div>
            </li>
          `;
          }
        })
        .catch(error => {
          console.error('Mark all read failed:', error);
        });
    });
  }
});

if (window.Echo && typeof window.Echo.private === 'function') {
  if (authId) {
    window.Echo.private(`userNotifications.${authId}`).notification(notification => {
      console.log('🔔 Notification received:', notification);

      const list = document.getElementById('notificationList');

      // Hide "No New Notification" message if it exists
      const emptyMessage = list.querySelector('.dropdown-notifications-item .small.mb-1');
      if (emptyMessage && emptyMessage.textContent.includes('No New Notification')) {
        list.innerHTML = '';
      }

      const html = `
      <li class="list-group-item list-group-item-action dropdown-notifications-item">
        <div class="d-flex">
          <div class="flex-shrink-0 me-3">
            <div class="avatar">
              <img src="${baseURL}/assets/img/avatars/1.png" alt class="rounded-circle" />
            </div>
          </div>
          <div class="flex-grow-1">
            <h6 class="small mb-1">${notification.head}</h6>
            <small class="mb-1 d-block text-body">${notification.body}</small>
            <small class="text-body-secondary">Just now</small>
          </div>
          <div class="flex-shrink-0 dropdown-notifications-actions">
            <a href="${baseURL}/${notification.url}" class="dropdown-notifications-read">
              <span class="badge badge-dot"></span>
            </a>
          </div>
        </div>
      </li>
    `;

      list.insertAdjacentHTML('afterbegin', html);
      window.showToast({
        title: notification.head,
        message: notification.body,
        type: 'bg-success',
        animation: 'animate__fadeInUp',
        time: 'Just now',
        delay: 3000
      });

      // Play sound
      const sound = document.getElementById('notificationSound');
      if (sound) {
        sound.currentTime = 0; // restart sound if already playing
        const playPromise = sound.play();
        if (playPromise !== undefined) {
          playPromise.catch(err => {
            console.log('Notification sound play blocked:', err);
          });
        }
      }

      // Show count badge
      const badge = document.querySelector('.notificationCount');
      if (badge) {
        badge.classList.remove('d-none');
        badge.textContent = parseInt(badge.textContent || 0) + 1;
      }
    });
  }
}
//Notifications end

//Delete
$(document).on('click', '.delete-modal', function () {
  $('.modal-title').text('Delete ' + $(this).data('title'));
  $('#idDelete').val($(this).data('id'));
  $('#urlDelete').val($(this).data('url'));
  $('#inlineFormDelete').modal('show');
  $('#title_delete').val($(this).data('title'));
});

$('.modal-footer').on('click', '.deleteModal', function (event) {
  event.preventDefault();
  var APP_URL = $('#urlDelete').val();
  $.ajax({
    type: 'POST',
    url: APP_URL,
    header: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    },
    data: {
      _method: 'DELETE',
      _token: $('meta[name="csrf-token"]').attr('content')
    },
    success: function (data) {
      window.showToast({
        title: 'Deleted Record Notification 🔔',
        message: data.message,
        type: 'bg-success',
        animation: 'animate__fadeInUp',
        time: 'Just now',
        delay: 3000
      });
      $('#hide-' + data.data).hide();
      $('#inlineFormDelete').modal('hide');
      deleteRecord();
    },
    error: function (data, e, ts, et) {
      console.log(data);
    }
  });
});
//End Delete

//Change status
$(function () {
  $(document).on('click', '.changestatus', function () {
    const route = $(this).data('url');
    const id = $(this).data('id');
    const status = $(this).data('status');
    const token = $('meta[name="csrf-token"]').attr('content');
    $.ajax({
      type: 'POST',
      url: route,
      data: {
        _token: token,
        id: id,
        status: status
      },
      success: function (data) {
        window.showToast({
          title: 'Status Change Notification 🚃',
          message: data.message,
          type: 'bg-success',
          animation: 'animate__fadeInUp',
          time: 'Just now',
          delay: 3000
        });
      },
      error: function (data, e, ts, et) {
        console.log(data);
      }
    });
  });
});
//End Change status

//Set Password
$(document).on('click', '.set-password', function () {
  $('.modal-title-password').text('Set New Password for User ' + $(this).data('title'));
  $('#idEdit').val($(this).data('id'));
  $('#titlePassword').val($(this).data('title'));
  $('#modalPassword').modal('show');
});
$(function () {
  $('#password_form').on('submit', function (event) {
    event.preventDefault();

    $.ajax({
      type: 'POST',
      url: `${baseURL}/users/set-password`,
      headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
      },
      data: new FormData(this),
      dataType: 'JSON',
      contentType: false,
      cache: false,
      processData: false,
      beforeSend: function () {
        // Optional: show loading spinner
      },
      success: function (data) {
        const toastType = data.status == 400 ? 'bg-success' : 'bg-warning';
        window.showToast({
          title: 'Password 🗝️',
          message: data.message,
          type: toastType,
          animation: 'animate__fadeInUp',
          time: 'Just now',
          delay: 3000
        });

        if (data.status != 401) {
          $('#modalPassword').modal('hide');
        }
      },
      error: function (xhr, status, error) {
        console.error('Error:', xhr.responseText || error);
      }
    });
  });
});
//End Set Password

// initCountryDrop.js
window.initCountryDrop = function (inputSelector, dialSelector, isoSelector, onReady) {
  const input = document.querySelector(inputSelector);
  const dialInput = document.querySelector(dialSelector);
  const isoInput = document.querySelector(isoSelector);

  if (!input) return null;

  let iti = null;

  // Fetch countries from API
  $.ajax({
    url: `${baseURL}/countries-dropdown`,
    method: 'GET',
    success: function (response) {
      const allowedCountries = response.map(c => c.sortname.toLowerCase());

      iti = window.intlTelInput(input, {
        separateDialCode: true,
        autoHideDialCode: false,
        nationalMode: true,
        initialCountry: isoInput && isoInput.value ? isoInput.value.toLowerCase() : 'in',
        onlyCountries: allowedCountries,
        geoIpLookup: function (success) {
          $.get('https://ipinfo.io', function () {}, 'jsonp').always(function (resp) {
            success(resp && resp.country ? resp.country.toLowerCase() : 'in');
          });
        }
      });

      updateHiddenFields();

      // 🔥 Call the callback after iti is ready
      if (typeof onReady === 'function') {
        onReady(api);
      }
    }
  });

  const updateHiddenFields = () => {
    if (!iti || !dialInput || !isoInput) return;
    const countryData = iti.getSelectedCountryData();
    isoInput.value = countryData.iso2.toUpperCase();
    dialInput.value = '+' + countryData.dialCode;
  };

  input.addEventListener('countrychange', updateHiddenFields);
  input.addEventListener('input', updateHiddenFields);

  const prefill = (fullNumber, iso) => {
    if (!iti || !fullNumber) return;

    const dial = fullNumber.match(/^\+\d+/) || [''];
    const national = fullNumber.replace(dial[0], '');
    input.value = national;

    if (iso) {
      try {
        iti.setCountry(iso.toLowerCase());
      } catch (e) {}
    }

    setTimeout(updateHiddenFields, 50);
  };

  const reset = (defaultIso = 'IN') => {
    if (!iti) return;
    input.value = '';
    if (dialInput) dialInput.value = '';
    if (isoInput) isoInput.value = defaultIso;
    try {
      iti.setCountry(defaultIso.toLowerCase());
    } catch (e) {}
    updateHiddenFields();
  };

  const api = {
    get iti() {
      return iti;
    },
    set: prefill,
    reset
  };

  return api;
};

//color dropdown
window.initColorSelect2 = function (selector) {
  function formatColor(option) {
    if (!option.id) return option.text; // For placeholders

    var colorCode = $(option.element).data('color');
    return $(
      '<span>' +
        '<span style="display:inline-block;width:18px;height:18px;background-color:' +
        colorCode +
        ';border:1px solid #ccc;margin-right:6px;"></span>' +
        option.text +
        '</span>'
    );
  }

  $(selector).select2({
    templateResult: formatColor,
    templateSelection: formatColor,
    escapeMarkup: function (markup) {
      return markup; // Allow HTML
    }
  });
};
//color dropdown

// Register Service Worker & subscribe for push
async function initPush() {
  if ('serviceWorker' in navigator && 'PushManager' in window) {
    const reg = await navigator.serviceWorker.register(`${baseUrl}/service-worker.js`);

    const subscription = await reg.pushManager.subscribe({
      userVisibleOnly: true,
      applicationServerKey: urlBase64ToUint8Array(VAPID_PUBLIC_KEY)
    });
    const subscriptionJson = subscription.toJSON();
    // send to server using fetch (no axios)
    const resp = await fetch(`${baseURL}/save-subscription`, {
      method: 'POST',
      credentials: 'same-origin', // include cookies if same origin
      headers: {
        'Content-Type': 'application/json',
        'X-Requested-With': 'XMLHttpRequest',
        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || ''
      },
      body: JSON.stringify(subscriptionJson)
    });

    if (!resp.ok) {
      const txt = await resp.text().catch(() => null);
      throw new Error(`Save subscription failed: ${resp.status} ${resp.statusText} ${txt || ''}`);
    }
    console.log('Push subscription saved');
  }
}

function urlBase64ToUint8Array(base64String) {
  const padding = '='.repeat((4 - (base64String.length % 4)) % 4);
  const base64 = (base64String + padding).replace(/\-/g, '+').replace(/_/g, '/');
  const rawData = window.atob(base64);
  return Uint8Array.from([...rawData].map(char => char.charCodeAt(0)));
}

if (authTYPE == 'Admin') {
  initPush();
}

//Service Worker

//session Messages:
// 🔥 Auto-run on page load if Laravel session flashes exist
document.addEventListener('DOMContentLoaded', () => {
  const error = document.body.dataset.flashError;
  const success = document.body.dataset.flashSuccess;

  if (error) {
    window.showToast({
      title: 'Error',
      message: error,
      type: 'bg-danger',
      time: 'Now'
    });
  }

  if (success) {
    window.showToast({
      title: 'Success',
      message: success,
      type: 'bg-success',
      time: 'Now'
    });
  }
});

var select2 = $('.select2');
if (select2.length) {
  select2.each(function () {
    var $this = $(this);
    $this.wrap('<div class="position-relative"></div>').select2({
      placeholder: 'All',
      allowClear: true,
      dropdownParent: $this.parent()
    });
  });
}
