/**
 * Page User management
 */

'use strict';

// Datatable (js)
document.addEventListener('DOMContentLoaded', function (e) {
  let borderColor, bodyBg, headingColor;

  borderColor = config.colors.borderColor;
  bodyBg = config.colors.bodyBg;
  headingColor = config.colors.headingColor;

  // Variable declaration for table
  const dt_rental_table = document.querySelector('.datatables-users'),
    userView = baseUrl + 'admin/rentals',
    offCanvasForm = document.getElementById('offcanvasAddUser');
  var statusObj = {
    Active: { title: 'Active', class: 'bg-label-primary' },
    Completed: { title: 'Completed', class: 'bg-label-success' },
    Cancelled: { title: 'Cancelled', class: 'bg-label-danger' }
  };
  var typeObj = {
    Rental: { title: 'Rental', class: 'bg-label-info' },
    Purchase: { title: 'Purchase', class: 'bg-label-dark' }
  };
  // Select2 initialization
  var select2 = $('.select2');
  if (select2.length) {
    var $this = select2;
    $this.wrap('<div class="position-relative"></div>').select2({
      placeholder: 'Select Country',
      dropdownParent: $this.parent()
    });
  }

  // ajax setup
  $.ajaxSetup({
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
  });

  // Users datatable
  if (dt_rental_table) {
    const dt_rental = new DataTable(dt_rental_table, {
      processing: true,
      serverSide: false,
      ajax: {
        url: baseURL + '/rental-list-all',
        dataSrc: function (json) {
          json.recordsTotal = Number(json.recordsTotal) || 0;
          json.recordsFiltered = Number(json.recordsFiltered) || 0;
          json.data = Array.isArray(json.data) ? json.data : [];
          return json.data;
        },
        data: function (d) {
          const order_type = $('#filter_verified').val();
          const status = $('#filter_status').val();
          d.order_type = order_type === '' ? null : order_type;
          d.status = status === '' ? null : status;
        }
      },
      columns: [
        { data: 'id' }, // Serial #
        { data: 'car_model' }, // Car Details
        { data: 'driver_name' }, // Driver Details
        { data: 'total_amount' }, // Amount
        { data: 'no_of_installments' }, // Installments
        { data: 'due_date', visible: false },
        { data: 'status' }, // Status
        { data: 'action' } // Actions
      ],
      createdRow: function (row, data) {
        $(row).attr('id', `trRow-${data.id}`);
      },
      columnDefs: [
        {
          // Serial Number
          targets: 0,
          render: (data, type, full, meta) => meta.row + meta.settings._iDisplayStart + 1
        },
        {
          targets: 1,
          render: function (data, type, full, meta) {
            const name = full['car_model'];
            const email = full['car_brand'];
            const avatar = full['car_image'];
            let output;

            if (avatar) {
              // For Avatar image
              output = `<img src="${avatar}" alt="Avatar" class="rounded-circle">`;
            } else {
              // For Avatar badge
              const stateNum = Math.floor(Math.random() * 6);
              const states = ['success', 'danger', 'warning', 'info', 'dark', 'primary', 'secondary'];
              const state = states[stateNum];
              const initials = (name.match(/\b\w/g) || []).slice(0, 2).join('').toUpperCase();
              output = `<span class="avatar-initial rounded-circle bg-label-${state}">${initials}</span>`;
            }
            // Creates full output for row
            const rowOutput = `
              <div class="d-flex justify-content-start align-items-center transaction-name text-nowrap">
                <div class="avatar-wrapper">
                  <div class="avatar avatar-sm me-3">
                    ${output}
                  </div>
                </div>
                <div class="d-flex flex-column">
                  <h6 class="m-0"><a href="${baseURL}/cars/${full.car_id}" class="text-heading">${name}</a></h6>
                  <small>${email} (${full.car_plate})</small>
                </div>
              </div>`;

            return rowOutput;
          }
        },
        {
          targets: 2,
          render: function (data, type, full, meta) {
            const name = full['driver_name'];
            const email = full['driver_email'];
            const avatar = full['driver_avatar'];
            let output;

            if (avatar) {
              // For Avatar image
              output = `<img src="${avatar}" alt="Avatar" class="rounded-circle">`;
            } else {
              // For Avatar badge
              const stateNum = Math.floor(Math.random() * 6);
              const states = ['success', 'danger', 'warning', 'info', 'dark', 'primary', 'secondary'];
              const state = states[stateNum];
              const initials = (name.match(/\b\w/g) || []).slice(0, 2).join('').toUpperCase();
              output = `<span class="avatar-initial rounded-circle bg-label-${state}">${initials}</span>`;
            }
            // Creates full output for row
            const rowOutput = `
              <div class="d-flex justify-content-start align-items-center transaction-name text-nowrap">
                <div class="avatar-wrapper">
                  <div class="avatar avatar-sm me-3">
                    ${output}
                  </div>
                </div>
                <div class="d-flex flex-column">
                  <h6 class="m-0"><a href="${baseURL}/drivers/${full.driver_id}" class="text-heading">${name}</a></h6>
                  <small>${email}</small>
                </div>
              </div>`;

            return rowOutput;
          }
        },
        {
          // Amount
          targets: 3,
          render: (data, type, full) => {
            let pendingLine = '';
            if (full.pending_amount > 0) {
              pendingLine = `<span class="bg-label-danger"><strong>Pending:</strong> ${full.currency}${full.pending_amount}</span><br>`;
            }

            let securityLine = '';
            if (full.security_amount > 0) {
              securityLine = `<strong>Security:</strong> ${full.currency}${full.security_amount}`;
            }

            return `<div>
      <strong>Total:</strong> ${full.currency}${full.total_amount}<br>
      <small>
        <strong>Down:</strong> ${full.currency}${full.down_payment}<br>
        ${pendingLine}
        ${securityLine}
      </small>
    </div>`;
          }
        },

        {
          // Installments
          targets: 4,
          render: (data, type, full) => {
            const startDate = new Date(full.start_date);
            const dueDate = new Date(full.due_date);
            const today = new Date();

            const formattedStart = startDate.toLocaleDateString('en-US', {
              month: 'short',
              day: 'numeric',
              year: 'numeric'
            });

            const formattedDue = dueDate.toLocaleDateString('en-US', {
              month: 'short',
              day: 'numeric',
              year: 'numeric'
            });

            // Compare due date with today
            let dueLabel = '';
            if (dueDate < today) {
              dueLabel = `<span class="badge bg-danger">Overdue: ${formattedDue}</span>`;
            } else {
              dueLabel = `<span class="badge bg-success">Due: ${formattedDue}</span>`;
            }

            return `
      <span>${full.no_of_installments} x ${full.currency}${full.installment_amount}<i class="ti tabler-info-circle text-primary ms-1"
       style="cursor:pointer"
      onclick='showInstallments(${JSON.stringify(full.installments_list)},
                             "${full.currency}",
                             "${full.start_date}",
                             ${full.no_of_installments},
                             ${full.installment_amount})'>
    </i></span>
      <br>Start: ${formattedStart}
      <br>${dueLabel}
    `;
          }
        },

        {
          // Status
          targets: 6,
          render: (data, type, full) => {
            const statusInfo = statusObj[full.status] || { class: 'bg-secondary', title: 'Unknown' };
            const typeInfo = typeObj[full.order_type] || { class: 'bg-secondary', title: 'Unknown' };
            return `<span class="badge ${statusInfo.class}">${statusInfo.title}</span><br><span class="mt-2 badge ${typeInfo.class}">${typeInfo.title}</span>`;
          }
        },
        {
          // Actions
          targets: -1,
          title: 'Actions',
          searchable: false,
          orderable: false,
          render: function (data, type, full, meta) {
            let actions = '<div class="d-flex align-items-center gap-4">';
            if (full.edit && full.pending_amount > 0) {
              actions += `
    <button class="btn btn-sm btn-icon add-installment"
            data-id="${full['id']}"
            data-pending="${full['pending_amount']}">
      <i class="icon-base ti tabler-adjustments icon-22px"></i>
    </button>`;
            }

            actions += `<button class="btn btn-sm btn-icon dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
            <i class="icon-base ti tabler-dots-vertical icon-22px"></i>
          </button>
          <div class="dropdown-menu dropdown-menu-end m-0">`;
            if (full.edit) {
              actions += `<button class="dropdown-item edit-record" data-id="${full['id']}" >
      <i class="icon-base ti tabler-edit icon-22px"></i> Edit
    </button>`;
            }
            if (full.delete) {
              actions += `<button class="dropdown-item delete-record" data-url="${full['delete-url']}" data-id="${full.id}" data-title="${full.name}">
      <i class="icon-base ti tabler-trash icon-22px"></i> Delete
    </button>`;
            }
            actions += `<a href="${userView}/${full.id}" class="dropdown-item"><i class="icon-base ti tabler-eye icon-md"></i> View</a>
          </div>
          </div>`;

            return actions;
          }
        }
      ],

      order: [[0, 'desc']],
      layout: {
        topStart: {
          rowClass: 'row m-3 my-0 justify-content-between',
          features: [
            {
              pageLength: {
                menu: [10, 20, 50, 70, 100],
                text: '_MENU_'
              }
            }
          ]
        },
        topEnd: {
          features: [
            {
              search: {
                placeholder: 'Search User',
                text: '_INPUT_'
              }
            },
            {
              buttons: [
                {
                  extend: 'collection',
                  className: 'btn btn-label-secondary dropdown-toggle',
                  text: '<i class="icon-base ti tabler-upload me-2 icon-sm"></i>Export',
                  buttons: [
                    {
                      extend: 'print',
                      title: 'Users',
                      text: '<i class="icon-base ti tabler-printer me-2" ></i>Print',
                      className: 'dropdown-item',
                      exportOptions: {
                        columns: [1, 2, 3, 4, 6],
                        // prevent avatar to be print
                        format: {
                          body: function (inner, coldex, rowdex) {
                            if (inner.length <= 0) return inner;

                            // Check if inner is HTML content
                            if (typeof inner === 'string' && inner.indexOf('<') > -1) {
                              const parser = new DOMParser();
                              const doc = parser.parseFromString(inner, 'text/html');

                              // Get all text content
                              let text = '';

                              // Handle specific elements
                              const userNameElements = doc.querySelectorAll('.user-name');
                              if (userNameElements.length > 0) {
                                userNameElements.forEach(el => {
                                  // Get text from nested structure
                                  const nameText =
                                    el.querySelector('.fw-medium')?.textContent ||
                                    el.querySelector('.d-block')?.textContent ||
                                    el.textContent;
                                  text += nameText.trim() + ' ';
                                });
                              } else {
                                // Get regular text content
                                text = doc.body.textContent || doc.body.innerText;
                              }

                              return text.trim();
                            }

                            return inner;
                          }
                        }
                      },
                      customize: function (win) {
                        win.document.body.style.color = config.colors.headingColor;
                        win.document.body.style.borderColor = config.colors.borderColor;
                        win.document.body.style.backgroundColor = config.colors.bodyBg;
                        const table = win.document.body.querySelector('table');
                        table.classList.add('compact');
                        table.style.color = 'inherit';
                        table.style.borderColor = 'inherit';
                        table.style.backgroundColor = 'inherit';
                      }
                    },
                    {
                      extend: 'csv',
                      title: 'Users',
                      text: '<i class="icon-base ti tabler-file-text me-2" ></i>Csv',
                      className: 'dropdown-item',
                      exportOptions: {
                        columns: [1, 2, 3, 4, 6],
                        format: {
                          body: function (inner, coldex, rowdex) {
                            if (inner.length <= 0) return inner;

                            // Parse HTML content
                            const parser = new DOMParser();
                            const doc = parser.parseFromString(inner, 'text/html');

                            let text = '';

                            // Handle user-name elements specifically
                            const userNameElements = doc.querySelectorAll('.user-name');
                            if (userNameElements.length > 0) {
                              userNameElements.forEach(el => {
                                // Get text from nested structure - try different selectors
                                const nameText =
                                  el.querySelector('.fw-medium')?.textContent ||
                                  el.querySelector('.d-block')?.textContent ||
                                  el.textContent;
                                text += nameText.trim() + ' ';
                              });
                            } else {
                              // Handle other elements (status, role, etc)
                              text = doc.body.textContent || doc.body.innerText;
                            }

                            return text.trim();
                          }
                        }
                      }
                    },
                    {
                      extend: 'excel',
                      text: '<i class="icon-base ti tabler-file-spreadsheet me-2"></i>Excel',
                      className: 'dropdown-item',
                      exportOptions: {
                        columns: [1, 2, 3, 4, 6],
                        format: {
                          body: function (inner, coldex, rowdex) {
                            if (inner.length <= 0) return inner;

                            // Parse HTML content
                            const parser = new DOMParser();
                            const doc = parser.parseFromString(inner, 'text/html');

                            let text = '';

                            // Handle user-name elements specifically
                            const userNameElements = doc.querySelectorAll('.user-name');
                            if (userNameElements.length > 0) {
                              userNameElements.forEach(el => {
                                // Get text from nested structure - try different selectors
                                const nameText =
                                  el.querySelector('.fw-medium')?.textContent ||
                                  el.querySelector('.d-block')?.textContent ||
                                  el.textContent;
                                text += nameText.trim() + ' ';
                              });
                            } else {
                              // Handle other elements (status, role, etc)
                              text = doc.body.textContent || doc.body.innerText;
                            }

                            return text.trim();
                          }
                        }
                      }
                    },
                    {
                      extend: 'pdf',
                      title: 'Users',
                      text: '<i class="icon-base ti tabler-file-code-2 me-2"></i>Pdf',
                      className: 'dropdown-item',
                      exportOptions: {
                        columns: [1, 2, 3, 4, 6],
                        format: {
                          body: function (inner, coldex, rowdex) {
                            if (inner.length <= 0) return inner;

                            // Parse HTML content
                            const parser = new DOMParser();
                            const doc = parser.parseFromString(inner, 'text/html');

                            let text = '';

                            // Handle user-name elements specifically
                            const userNameElements = doc.querySelectorAll('.user-name');
                            if (userNameElements.length > 0) {
                              userNameElements.forEach(el => {
                                // Get text from nested structure - try different selectors
                                const nameText =
                                  el.querySelector('.fw-medium')?.textContent ||
                                  el.querySelector('.d-block')?.textContent ||
                                  el.textContent;
                                text += nameText.trim() + ' ';
                              });
                            } else {
                              // Handle other elements (status, role, etc)
                              text = doc.body.textContent || doc.body.innerText;
                            }

                            return text.trim();
                          }
                        }
                      }
                    },
                    {
                      extend: 'copy',
                      title: 'Users',
                      text: '<i class="icon-base ti tabler-copy me-2" ></i>Copy',
                      className: 'dropdown-item',
                      exportOptions: {
                        columns: [1, 2, 3, 4, 6],
                        format: {
                          body: function (inner, coldex, rowdex) {
                            if (inner.length <= 0) return inner;

                            // Parse HTML content
                            const parser = new DOMParser();
                            const doc = parser.parseFromString(inner, 'text/html');

                            let text = '';

                            // Handle user-name elements specifically
                            const userNameElements = doc.querySelectorAll('.user-name');
                            if (userNameElements.length > 0) {
                              userNameElements.forEach(el => {
                                // Get text from nested structure - try different selectors
                                const nameText =
                                  el.querySelector('.fw-medium')?.textContent ||
                                  el.querySelector('.d-block')?.textContent ||
                                  el.textContent;
                                text += nameText.trim() + ' ';
                              });
                            } else {
                              // Handle other elements (status, role, etc)
                              text = doc.body.textContent || doc.body.innerText;
                            }

                            return text.trim();
                          }
                        }
                      }
                    }
                  ]
                },
                {
                  text: '<i class="icon-base ti tabler-plus icon-sm me-0 me-sm-2"></i><span class="d-none d-sm-inline-block">Add New Rental</span>',
                  className: `add-new btn btn-primary`,
                  attr: {
                    'data-bs-toggle': 'offcanvas',
                    'data-bs-target': '#offcanvasAddUser'
                  }
                }
              ]
            }
          ]
        },
        bottomStart: {
          rowClass: 'row mx-3 justify-content-between',
          features: [
            {
              info: {
                text: 'Showing _START_ to _END_ of _TOTAL_ entries'
              }
            }
          ]
        },
        bottomEnd: 'paging'
      },
      displayLength: 10,
      language: {
        paginate: {
          first: '<i class="icon-base ti tabler-chevrons-left scaleX-n1-rtl icon-18px"></i>',
          last: '<i class="icon-base ti tabler-chevrons-right scaleX-n1-rtl icon-18px"></i>',
          next: '<i class="icon-base ti tabler-chevron-right scaleX-n1-rtl icon-18px"></i>',
          previous: '<i class="icon-base ti tabler-chevron-left scaleX-n1-rtl icon-18px"></i>'
        }
      },
      // For responsive popup
      responsive: {
        details: {
          display: DataTable.Responsive.display.modal({
            header: function (row) {
              const data = row.data();
              return 'Details of ' + data['name'];
            }
          }),
          type: 'column',
          renderer: function (api, rowIdx, columns) {
            const data = columns
              .map(function (col) {
                return col.title !== '' // Do not show row in modal popup if title is blank (for check box)
                  ? `<tr data-dt-row="${col.rowIndex}" data-dt-column="${col.columnIndex}">
                      <td>${col.title}:</td>
                      <td>${col.data}</td>
                    </tr>`
                  : '';
              })
              .join('');

            if (data) {
              const div = document.createElement('div');
              div.classList.add('table-responsive');
              const table = document.createElement('table');
              div.appendChild(table);
              table.classList.add('table');
              const tbody = document.createElement('tbody');
              tbody.innerHTML = data;
              table.appendChild(tbody);
              return div;
            }
            return false;
          }
        }
      },
      initComplete: function (settings, json) {
        const api = this.api();
        // --- Driver Filter ---
        api.columns(2).every(function () {
          const column = this;
          const select = document.createElement('select');
          select.id = 'Driver';
          select.className = 'form-select text-capitalize';
          select.innerHTML = '<option value="">Driver</option>';
          document.querySelector('.driver').appendChild(select);

          const seen = new Set();
          column.data().each(function (d, i) {
            const rowData = api.row(i).data();
            if (!rowData || !rowData.driver_id || seen.has(rowData.driver_id)) return;
            seen.add(rowData.driver_id);

            const option = document.createElement('option');
            option.value = rowData.driver_id;
            option.text = rowData.driver_name; // use driver_name from your data
            select.appendChild(option);
          });

          select.addEventListener('change', function () {
            const val = select.value ? `^${select.value}$` : '';
            column.search(val, true, false).draw();
          });
        });

        // --- Car Filter ---
        api.columns(1).every(function () {
          const column = this;
          const select = document.createElement('select');
          select.id = 'Car';
          select.className = 'form-select text-capitalize';
          select.innerHTML = '<option value="">Car</option>';
          document.querySelector('.car').appendChild(select);

          const seen = new Set();
          column.data().each(function (d, i) {
            const rowData = api.row(i).data();
            if (!rowData || !rowData.car_id || seen.has(rowData.car_id)) return;
            seen.add(rowData.car_id);

            const option = document.createElement('option');
            option.value = rowData.car_id;
            option.text = rowData.car_model; // use car_model from your data
            select.appendChild(option);
          });

          select.addEventListener('change', function () {
            const val = select.value ? `^${select.value}$` : '';
            column.search(val, true, false).draw();
          });
        });
        // Remove btn-secondary from export buttons
        document.querySelectorAll('.dt-buttons .btn').forEach(btn => {
          btn.classList.remove('btn-secondary');
          if (!json.create) {
            $('.add-new').addClass('d-none');
          }
        });
      }
    });
    // Refresh table on filter change
    $('#filter_verified, #filter_status').on('change', function () {
      dt_rental.draw();
    });

    // Fixed header
    if (window.Helpers.isNavbarFixed()) {
      const navHeight = document.getElementById('layout-navbar').offsetHeight;
      new DataTable.FixedHeader(dt_rental).headerOffset(navHeight);
    } else {
      new DataTable.FixedHeader(dt_rental);
    }
    // Delete Record
    document.addEventListener('click', function (e) {
      if (e.target.closest('.delete-record')) {
        const deleteBtn = e.target.closest('.delete-record');
        const user_id = deleteBtn.dataset.id;
        const dtrModal = document.querySelector('.dtr-bs-modal.show');

        // hide responsive modal in small screen
        if (dtrModal) {
          const bsModal = bootstrap.Modal.getInstance(dtrModal);
          bsModal.hide();
        }

        // sweetalert for confirmation of delete
        Swal.fire({
          title: 'Are you sure?',
          text: "You won't be able to revert this!",
          icon: 'warning',
          showCancelButton: true,
          confirmButtonText: 'Yes, delete it!',
          customClass: {
            confirmButton: 'btn btn-primary me-3',
            cancelButton: 'btn btn-label-secondary'
          },
          buttonsStyling: false
        }).then(function (result) {
          if (result.value) {
            // delete the data
            fetch(`${baseURL}/rentals/${user_id}`, {
              method: 'DELETE',
              headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'Content-Type': 'application/json'
              }
            })
              .then(response => {
                if (response.ok) {
                  dt_rental.draw();

                  // success sweetalert
                  Swal.fire({
                    icon: 'success',
                    title: 'Deleted!',
                    text: 'The Rental has been deleted!',
                    customClass: {
                      confirmButton: 'btn btn-success'
                    }
                  });
                } else {
                  throw new Error('Delete failed');
                }
              })
              .catch(error => {
                console.log(error);
              });
          }
          /*           else if (result.dismiss === Swal.DismissReason.cancel) {
            Swal.fire({
              title: 'Cancelled',
              text: 'The User is not deleted!',
              icon: 'error',
              customClass: {
                confirmButton: 'btn btn-success'
              }
            });
          } */
        });
      }
    });

    // edit record
    document.addEventListener('click', function (e) {
      if (e.target.closest('.edit-record')) {
        const editBtn = e.target.closest('.edit-record');
        const rental_id = editBtn.dataset.id;
        const dtrModal = document.querySelector('.dtr-bs-modal.show');
        // hide responsive modal in small screen
        if (dtrModal) {
          const bsModal = bootstrap.Modal.getInstance(dtrModal);
          bsModal.hide();
        }

        // changing the title of offcanvas
        document.getElementById('offcanvasAddUserLabel').innerHTML = 'Edit Rental';

        // get data
        fetch(`${baseURL}/rentals/${rental_id}/edit`)
          .then(response => response.json())
          .then(data => {
            document.getElementById('rental_id').value = data.id;
            // fill select + inputs
            document.getElementById('edit_car').value = data.car_id;
            document.getElementById('edit_driver').value = data.driver_id;
            document.getElementById('order_type').value = data.order_type;
            document.getElementById('total_amount').value = data.total_amount;
            document.getElementById('old_total_amount').value = data.total_amount;
            document.getElementById('down_payment').value = data.down_payment;
            document.getElementById('security_amount').value = data.security_amount;
            document.getElementById('no_of_installments').value = data.no_of_installments;
            document.getElementById('installment_amount').value = data.installment_amount;
            document.getElementById('due_date').value = data.due_date;
            document.getElementById('pending_amount').value = data.pending_amount;
            document.getElementById('paid_installments').value = data.paid_installments;
            let statusDropdown = document.getElementById('status');
            if (statusDropdown) {
              statusDropdown.value = data.status;
              if (data.status === 'Active') {
                statusDropdown.disabled = false; // Active → editable
              } else {
                statusDropdown.disabled = true; // Not Active → disable
              }
            }
            // Hide or show down payment & order type based on installment
            const downPaymentField = document.getElementById('down_payment').closest('.mb-2');
            const orderTypeField = document.getElementById('order_type').closest('.mb-2');
            const dueField = document.getElementById('flatpickr-date').closest('.mb-2');
            if (data.installments_paid === true) {
              downPaymentField.style.display = 'none';
              orderTypeField.style.display = 'none';
              dueField.style.display = 'none';
            } else {
              downPaymentField.style.display = '';
              orderTypeField.style.display = '';
              dueField.style.display = '';
            }
            // Show offcanvas only after all data is filled
            const offcanvasEl = document.getElementById('offcanvasAddUser');
            const offcanvas = new bootstrap.Offcanvas(offcanvasEl);
            offcanvas.show();
          });
      }
    });

    // changing the title
    const addNewBtn = document.querySelector('.add-new');
    if (addNewBtn) {
      addNewBtn.addEventListener('click', function () {
        document.getElementById('rental_id').value = ''; //resetting input field
        document.getElementById('offcanvasAddUserLabel').innerHTML = 'Add Rental';
        const downPaymentField = document.getElementById('down_payment').closest('.mb-2');
        const orderTypeField = document.getElementById('order_type').closest('.mb-2');
        const dueField = document.getElementById('flatpickr-date').closest('.mb-2');
        downPaymentField.style.display = 'block';
        orderTypeField.style.display = 'block';
        dueField.style.display = 'block';
        var formId = 'addNewUserForm';
        const form = document.getElementById(formId);
        if (!form) return;
        // 1️⃣ Reset all text, number, hidden, and textarea inputs
        form.querySelectorAll('input, textarea').forEach(input => {
          if (input.type === 'checkbox' || input.type === 'radio') {
            input.checked = false;
          } else {
            input.value = '';
          }
        });
        // 2️⃣ Reset all select elements (normal or select2)
        form.querySelectorAll('select').forEach(select => {
          $(select).val(null).trigger('change'); // works with select2 and normal selects
        });
      });
    }

    // Filter form control to default size
    setTimeout(() => {
      const elementsToModify = [
        { selector: '.dt-buttons .btn', classToRemove: 'btn-secondary' },
        { selector: '.dt-search .form-control', classToRemove: 'form-control-sm' },
        { selector: '.dt-length .form-select', classToRemove: 'form-select-sm', classToAdd: 'ms-0' },
        { selector: '.dt-length', classToAdd: 'mb-md-6 mb-0' },
        {
          selector: '.dt-layout-end',
          classToRemove: 'justify-content-between',
          classToAdd: 'd-flex gap-md-4 justify-content-md-between justify-content-center gap-2 flex-wrap'
        },
        { selector: '.dt-buttons', classToAdd: 'd-flex gap-4 mb-md-0 mb-4' },
        { selector: '.dt-layout-table', classToRemove: 'row mt-2' },
        { selector: '.dt-layout-full', classToRemove: 'col-md col-12', classToAdd: 'table-responsive' }
      ];

      // Delete record
      elementsToModify.forEach(({ selector, classToRemove, classToAdd }) => {
        document.querySelectorAll(selector).forEach(element => {
          if (classToRemove) {
            classToRemove.split(' ').forEach(className => element.classList.remove(className));
          }
          if (classToAdd) {
            classToAdd.split(' ').forEach(className => element.classList.add(className));
          }
        });
      });
    }, 100);
  }

  // validating form and updating user's data
  const addNewUserForm = document.getElementById('addNewUserForm');

  // user form validation
  if (addNewUserForm) {
    addNewUserForm.addEventListener('submit', function (e) {
      e.preventDefault(); // prevent native submit
    });
    const fv = FormValidation.formValidation(addNewUserForm, {
      fields: {
        car_id: {
          validators: {
            notEmpty: {
              message: 'Please select car'
            }
          }
        },
        driver_id: {
          validators: {
            notEmpty: {
              message: 'Please select driver'
            }
          }
        },
        total_amount: {
          validators: {
            notEmpty: {
              message: 'Please enter amount'
            }
          }
        }
      },
      plugins: {
        trigger: new FormValidation.plugins.Trigger(),
        bootstrap5: new FormValidation.plugins.Bootstrap5({
          // Use this for enabling/changing valid/invalid class
          eleValidClass: '',
          rowSelector: function (field, ele) {
            // field is the field name & ele is the field element
            return '.mb-2';
          }
        }),
        submitButton: new FormValidation.plugins.SubmitButton(),
        autoFocus: new FormValidation.plugins.AutoFocus()
      }
    }).on('core.form.valid', function () {
      // adding or updating user when form successfully validate
      const formData = new FormData(addNewUserForm);
      const formDataObj = {};

      // Convert FormData to URL-encoded string
      formData.forEach((value, key) => {
        formDataObj[key] = value;
      });

      const searchParams = new URLSearchParams();
      for (const [key, value] of Object.entries(formDataObj)) {
        searchParams.append(key, value);
      }
      const rentalId = formDataObj.id;
      if (rentalId) {
        searchParams.append('_method', 'PUT');
      }
      const url = rentalId ? `${baseURL}/rentals/${rentalId}` : `${baseURL}/rentals`;
      const method = rentalId ? 'POST' : 'POST'; // Laravel can handle create/update in same route
      fetch(url, {
        method: method,
        headers: {
          'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
          'Content-Type': 'application/x-www-form-urlencoded'
        },
        body: searchParams.toString()
      })
        .then(async response => {
          const text = await response.text();
          const data = JSON.parse(text);
          if (!response.ok) throw new Error(data.message || 'Something went wrong');
          if (dt_rental_table) {
            const table = new DataTable(dt_rental_table);
            table.order([0, 'desc']).draw(false); // Column 0 ordered descending
          }

          // Hide offcanvas
          const offcanvasInstance = bootstrap.Offcanvas.getInstance(offCanvasForm);
          offcanvasInstance && offcanvasInstance.hide();
          const type = data.status == 200 ? 'success' : 'warning';
          // sweetalert
          Swal.fire({
            icon: type,
            title: `Rentals 💵`,
            text: `${data.message}`,
            customClass: {
              confirmButton: 'btn btn-success'
            }
          });
        })
        .catch(async err => {
          console.log(err);
          let message = 'Something went wrong';
          if (err instanceof Response) {
            const text = await err.text();
            try {
              const res = JSON.parse(text);
              message = res.message || message;
            } catch {
              message = text || message;
            }
          } else if (err.message) {
            message = err.message;
          }
          window.showToast({
            title: 'Rentals 💵',
            message: message,
            type: 'bg-danger',
            animation: 'animate__fadeInUp',
            time: 'Just now',
            delay: 3000
          });
        });
    });

    // clearing form data when offcanvas hidden
    offCanvasForm.addEventListener('hidden.bs.offcanvas', function () {
      fv.resetForm(true);
    });
  }

  // Phone mask initialization
  const phoneMaskList = document.querySelectorAll('.phone-mask');

  if (phoneMaskList) {
    phoneMaskList.forEach(function (phoneMask) {
      phoneMask.addEventListener('input', event => {
        let input = event.target.value.replace(/[^+\d]/g, ''); // allow + and digits only

        // Extract country code (starts with + followed by 1-4 digits)
        const countryCodeMatch = input.match(/^\+?\d{1,3}/);
        const countryCode = countryCodeMatch ? countryCodeMatch[0] : '';

        // Remove country code to get only phone digits
        let phoneDigits = input.replace(countryCode, '').replace(/\D/g, '').substring(0, 10); // limit to 10 digits

        // Format phone digits as 3-3-4
        const formattedPhone = phoneDigits.replace(/(\d{3})(\d{3})(\d{0,4})/, (_, p1, p2, p3) => {
          return `${p1} ${p2}${p3 ? '' + p3 : ''}`;
        });

        // Combine country code and formatted phone
        phoneMask.value = `${countryCode} ${formattedPhone}`.trim();
      });
    });
  }
});
