/**
 * app-ecommerce-ride-list Script
 */

'use strict';

// Datatable (js)
document.addEventListener('DOMContentLoaded', function (e) {
  let borderColor, bodyBg, headingColor;

  borderColor = config.colors.borderColor;
  bodyBg = config.colors.bodyBg;
  headingColor = config.colors.headingColor;

  // Variable declaration for table

  const dt_ride_table = document.querySelector('.datatables-parcel');
  var statusObj = {
    Pending: { title: 'Pending', class: 'bg-label-secondary' },
    Accepted: { title: 'Accepted', class: 'bg-label-primary' },
    Arrived: { title: 'Arrived', class: 'bg-label-primary' },
    'Picked Up': { title: 'Picked Up', class: 'bg-label-primary' },
    Ongoing: { title: 'Ongoing', class: 'bg-label-primary' },
    Invoiced: { title: 'Invoiced', class: 'bg-label-info' },
    Completed: { title: 'Completed', class: 'bg-label-success' },
    Failed: { title: 'Failed', class: 'bg-label-danger' },
    Cancelled: { title: 'Cancelled', class: 'bg-label-danger' }
  };
  var typeObj = {
    Ride: { title: 'Ride', class: 'bg-label-info', tabler: 'car' },
    Parcel: { title: 'Parcel', class: 'bg-label-info', tabler: 'box' },
    Delivery: { title: 'Delivery', class: 'bg-label-info', tabler: 'truck-delivery' }
  };
  function getUserId() {
    return (
      (window.permissions && window.permissions.UserId) ||
      $('.datatables-parcel').data('user-id') ||
      $('#user_id').val() ||
      new URLSearchParams(location.search).get('user_id') ||
      null
    );
  }
  function getDriverId() {
    return (
      (window.permissions && window.permissions.DriverId) ||
      $('.datatables-parcel').data('driver-id') ||
      $('#driver_id').val() ||
      new URLSearchParams(location.search).get('driver_id') ||
      null
    );
  }
  // E-commerce Products datatable

  if (dt_ride_table) {
    const roleHelper = document.getElementById('role-helper-parcel');
    const queryValue = roleHelper.dataset.query;
    const dt_ride = new DataTable(dt_ride_table, {
      processing: true,
      serverSide: true,
      ajax: {
        url: baseURL + '/ride-list-all?' + queryValue,
        type: 'GET',
        data: function (d) {
          const uid = getUserId();
          if (uid) {
            d.user_id = uid;
          }
          const did = getDriverId();
          if (did) {
            d.driver_id = did;
          }
          let dateRange = $('#flatpickr-range-parcel').val();
          if (dateRange && dateRange.includes(' to ')) {
            let dates = dateRange.split(' to ');
            d.start_date = dates[0];
            d.end_date = dates[1];
          } else if (dateRange && dateRange.includes(' - ')) {
            let dates = dateRange.split(' - ');
            d.start_date = dates[0];
            d.end_date = dates[1];
          }
        }
      },
      columns: [
        // columns according to JSON
        { data: 'id' },
        { data: 'id' },
        { data: 'driver' },
        { data: 'customer' },
        { data: 'type' }, //email //avatar
        { data: 'sender_name' },
        { data: 'status' },
        { data: 'pickup_location' }, //method_number
        { data: 'id' }
      ],
      drawCallback: function () {
        this.api()
          .table()
          .rows({ page: 'current' })
          .every(function () {
            const data = this.data();
            const ratingEl = document.getElementById(`rating-${data.id}`);
            let r = parseInt(window.Helpers.getCssVar('gray-200', true).slice(1, 3), 16);
            let g = parseInt(window.Helpers.getCssVar('gray-200', true).slice(3, 5), 16);
            let b = parseInt(window.Helpers.getCssVar('gray-200', true).slice(5, 7), 16);
            if (ratingEl && !ratingEl.dataset.initialized) {
              new Raty(ratingEl, {
                score: data.rating ?? 0,
                readOnly: true,
                starOn:
                  "data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' width='16' %3E%3Cpath fill='%23FFD700' d='M21.947 9.179a1 1 0 0 0-.868-.676l-5.701-.453l-2.467-5.461a.998.998 0 0 0-1.822-.001L8.622 8.05l-5.701.453a1 1 0 0 0-.619 1.713l4.213 4.107l-1.49 6.452a1 1 0 0 0 1.53 1.057L12 18.202l5.445 3.63a1.001 1.001 0 0 0 1.517-1.106l-1.829-6.4l4.536-4.082c.297-.268.406-.686.278-1.065'/%3E%3C/svg%3E",
                starOff: `data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' width='16' %3E%3Cpath fill='rgb(${r},${g},${b})' d='M21.947 9.179a1 1 0 0 0-.868-.676l-5.701-.453l-2.467-5.461a.998.998 0 0 0-1.822-.001L8.622 8.05l-5.701.453a1 1 0 0 0-.619 1.713l4.213 4.107l-1.49 6.452a1 1 0 0 0 1.53 1.057L12 18.202l5.445 3.63a1.001 1.001 0 0 0 1.517-1.106l-1.829-6.4l4.536-4.082c.297-.268.406-.686.278-1.065'/%3E%3C/svg%3E`,
                starHalf:
                  "data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' width='16'%3E%3Cdefs%3E%3CclipPath id='halfStar'%3E%3Crect x='0' y='0' width='12' height='24'/%3E%3C/clipPath%3E%3C/defs%3E%3Cpath fill='%23FFD700' clip-path='url(%23halfStar)' d='M21.947 9.179a1 1 0 0 0-.868-.676l-5.701-.453l-2.467-5.461a.998.998 0 0 0-1.822-.001L8.622 8.05l-5.701.453a1 1 0 0 0-.619 1.713l4.213 4.107l-1.49 6.452a1 1 0 0 0 1.53 1.057L12 18.202l5.445 3.63a1.001 1.001 0 0 0 1.517-1.106l-1.829-6.4l4.536-4.082c.297-.268.406-.686.278-1.065'/%3E%3Cpath fill='none' stroke='%23FFD700' stroke-width='0' d='M0 0h24v24H0z'/%3E%3C/svg%3E"
              }).init();
              ratingEl.dataset.initialized = true;
            }
          });
      },

      columnDefs: [
        {
          // For Responsive
          className: 'control',
          searchable: false,
          orderable: false,
          responsivePriority: 2,
          targets: 0,
          render: () => ''
        },
        {
          // Row index
          searchable: false,
          orderable: false,
          targets: 1,
          render: (data, type, full, meta) => meta.row + meta.settings._iDisplayStart + 1
        },
        {
          // Customer info with avatar
          targets: 2,
          responsivePriority: 2,
          render: (data, type, full) => {
            const name = full.customer || '';
            const email = full.email || '';
            const avatar = full.avatar || '';
            let output;

            if (avatar) {
              output = `<img src="${avatar}" alt="Avatar" class="rounded-circle">`;
            } else {
              const states = ['success', 'danger', 'warning', 'info', 'dark', 'primary', 'secondary'];
              const state = states[full.user_id % states.length]; // deterministic color
              const initials = (name.match(/\b\w/g) || []).join('').slice(0, 2).toUpperCase();
              output = `<span class="avatar-initial rounded-circle bg-label-${state}">${initials}</span>`;
            }

            return `
        <div class="d-flex align-items-center">
          <div class="avatar avatar-sm me-3">${output}</div>
          <div class="d-flex flex-column">
            <h6 class="m-0">
              ${
                full.user_type === 'Admin'
                  ? `<a href="${baseURL}/users/${full.user_id}" class="text-heading">${name}</a>`
                  : `<span class="text-heading">${name}</span>`
              }
            </h6>
            <small>${email}</small>
          </div>
        </div>
      `;
          }
        },
        {
          // Created date + rating placeholder
          targets: 3,
          responsivePriority: 3,
          render: (data, type, full) => {
            const dateObj = new Date(full.created_at);
            const mtype = full.type;
            const formattedDate = dateObj.toLocaleDateString('en-US', {
              month: 'short',
              day: 'numeric',
              year: 'numeric'
            });
            const formattedTime = dateObj.toLocaleTimeString('en-US', {
              hour: '2-digit',
              minute: '2-digit',
              hour12: true
            });

            // Return container for Raty (init in drawCallback)
            if (mtype === 'Ride') {
              return `
            <span class="text-nowrap">${formattedDate}<br><small>${formattedTime}</small></span>
            <span class="text-nowrap">
                <br><small>Distance: ${full.trip_distance} Km<br>Time: ${full.trip_time} Minutes</small>
            </span>
            <div class="rating read-only-ratings raty d-flex" data-score="${full.rating ?? 0}" id="rating-${full.id}"></div>
        `;
            } else if (mtype === 'Parcel') {
              return `
                <span class="text-nowrap">${formattedDate}<br><small>${formattedTime}</small></span>
            <small><br><span class="text-nowrap text-primary">Category: ${full.parcel_category}</span>
            <span class="text-nowrap">Sender: ${full.sender_name}<br>Receiver: ${full.receiver_name}</span>
              <div class="rating read-only-ratings raty d-flex" data-score="${full.rating ?? 0}" id="rating-${full.id}"></small></div>
        `;
            } else if (mtype === 'Delivery') {
              return `
                <span class="text-nowrap">${formattedDate}<br><small>${formattedTime}</small></span>
            <small><br><a class="text-nowrap text-primary" href="${baseURL}/orders/${full.order_id}">Order ID: ${full.orderID}</a>
              <div class="rating read-only-ratings raty d-flex" data-score="${full.rating ?? 0}" id="rating-${full.id}"></small></div>
        `;
            } else {
              return `<span class="text-nowrap">Unknown Type</span>`;
            }
          }
        },
        {
          // Driver info
          targets: 4,
          responsivePriority: 4,
          render: (data, type, full) => {
            const name = full.driver || '';
            const email = full.driver_email || '';
            const avatar = full.driver_avatar || '';
            let output;

            if (avatar) {
              output = `<img src="${avatar}" alt="Avatar" class="rounded-circle">`;
            } else {
              const states = ['success', 'danger', 'warning', 'info', 'dark', 'primary', 'secondary'];
              const state = states[full.driver_id % states.length];
              const initials = (name.match(/\b\w/g) || []).join('').slice(0, 2).toUpperCase();
              output = `<span class="avatar-initial rounded-circle bg-label-${state}">${initials}</span>`;
            }

            return `
        <div class="d-flex align-items-center">
          <div class="avatar avatar-sm me-3">${output}</div>
          <div class="d-flex flex-column">
            <h6 class="m-0">
              ${
                full.user_type === 'Admin'
                  ? `<a href="${baseURL}/drivers/${full.driverId}" class="text-heading">${name}</a>`
                  : `<span class="text-heading">${name}</span>`
              }
            </h6>
            <small>${email}</small>
          </div>
        </div>
      `;
          }
        },
        {
          // Fare + commission
          targets: 5,
          responsivePriority: 5,
          render: (data, type, full) => {
            const commission = full.platform_commission
              ? `<br>Commission: ${full.currency}${full.platform_commission}`
              : '';
            return `
        <span class="text-nowrap">
          Amt: ${full.currency}${full.fare ?? ''}
          <small>${commission}<br>Txn:  <span title="${full.txn ?? 'N/A'}">
          ${full.txn && full.txn.length > 10 ? full.txn.substring(0, 10) + '...' : (full.txn ?? 'N/A')}
        </span></small>
        </span>
      `;
          }
        },
        {
          // Pickup & drop
          targets: -3,
          responsivePriority: 7,
          render: (data, type, full) => `<small>Pickup: ${full.pickup_location}<br>Drop: ${full.drop_location}</small>`
        },
        {
          // Status + type
          targets: -2,
          responsivePriority: 6,
          render: (data, type, full) => {
            // If Cancelled, add a clickable icon that shows cancelled info
            if (full.status === 'Cancelled') {
              var statusButton = `<button type="button" class="badge mt-1 p-1 btn-cancelled"
          data-bs-toggle="popover" data-bs-html="true"
          data-bs-content="
            <strong>Cancelled By:</strong> ${full.cancelled_by ?? '-'}<br>
            <strong>Message:</strong> ${full.cancelled_message ?? '-'}
          ">
          <i class="icon-base ti tabler-alert-circle"></i> Cancelled
        </button>`;
            } else {
              var statusButton = `<button type="button" class="badge px-2 ${statusObj[full.status].class}" id="status-${full.id}">
        ${full.status}
      </button>`;
            }

            // Type button
            const typeButton = `<button type="button" class="badge mt-1 p-50 ${typeObj[full.type].class}">
        <i class="icon-base ti fs-4 tabler-${typeObj[full.type].tabler}"></i> ${full.type}
      </button>`;

            return `${statusButton}<br>${typeButton}`;
          }
        },
        {
          // Actions (hidden)
          targets: -1,
          searchable: false,
          orderable: false,
          visible: false,
          render: () => ''
        }
      ],

      select: {
        style: 'multi',
        selector: 'td:nth-child(2)'
      },
      ride: [1, 'desc'],
      layout: {
        topStart: {
          search: {
            placeholder: 'Search Ride',
            text: '_INPUT_'
          }
        },
        topEnd: {
          rowClass: 'row mx-3 my-0 justify-content-between',
          features: [
            {
              pageLength: {
                menu: [7, 10, 25, 50, 100],
                text: '_MENU_'
              }
            },
            {
              buttons: [
                {
                  extend: 'collection',
                  className: 'btn btn-label-primary dropdown-toggle',
                  text: '<span class="d-flex align-items-center gap-1"><i class="icon-base ti tabler-upload icon-xs"></i> <span class="d-none d-sm-inline-block">Export</span></span>',
                  buttons: [
                    {
                      extend: 'print',
                      text: `<span class="d-flex align-items-center"><i class="icon-base ti tabler-printer me-1"></i>Print</span>`,
                      className: 'dropdown-item',
                      exportOptions: {
                        columns: [2, 3, 4, 5, 6],
                        stripHtml: false, // ✅ keep HTML
                        format: {
                          body: function (inner, coldex, rowdex) {
                            if (!inner) return inner;

                            // Parse HTML to preserve avatars, badges, etc.
                            const parser = new DOMParser();
                            const doc = parser.parseFromString(inner, 'text/html');

                            // Return the HTML inside, not just text
                            return doc.body.innerHTML;
                          }
                        }
                      },
                      customize: function (win) {
                        win.document.body.style.color = headingColor;
                        win.document.body.style.borderColor = borderColor;
                        win.document.body.style.backgroundColor = bodyBg;

                        const table = win.document.body.querySelector('table');
                        table.classList.add('compact');
                        table.style.color = 'inherit';
                        table.style.borderColor = 'inherit';
                        table.style.backgroundColor = 'inherit';

                        // ✅ Add Bootstrap-like classes so avatars/badges look nice
                        const style = win.document.createElement('style');
                        style.textContent = `
      .avatar { border-radius: 50%; width: 32px; height: 32px; object-fit: cover; vertical-align: middle; margin-right: 6px; }
      .badge { display: inline-block; padding: 0.35em 0.65em; font-size: 0.75em; border-radius: 0.25rem; }
      .d-flex { display: flex; align-items: center; }
      .me-1 { margin-right: 0.25rem; }
      .me-2 { margin-right: 0.5rem; }
    `;
                        win.document.head.appendChild(style);
                      }
                    },

                    {
                      extend: 'csv',
                      text: `<span class="d-flex align-items-center"><i class="icon-base ti tabler-file me-1"></i>Csv</span>`,
                      className: 'dropdown-item',
                      exportOptions: {
                        columns: [2, 3, 4, 5, 6, 7],
                        format: {
                          body: function (inner, coldex, rowdex) {
                            if (inner.length <= 0) return inner;
                            const el = new DOMParser().parseFromString(inner, 'text/html').body.childNodes;
                            let result = '';
                            el.forEach(item => {
                              if (item.classList && item.classList.contains('user-name')) {
                                result += item.lastChild.firstChild.textContent;
                              } else {
                                result += item.textContent || item.innerText || '';
                              }
                            });
                            return result;
                          }
                        }
                      }
                    },
                    {
                      extend: 'excel',
                      text: `<span class="d-flex align-items-center"><i class="icon-base ti tabler-upload me-1"></i>Excel</span>`,
                      className: 'dropdown-item',
                      exportOptions: {
                        columns: [2, 3, 4, 5, 6, 7],
                        format: {
                          body: function (inner, coldex, rowdex) {
                            if (inner.length <= 0) return inner;
                            const el = new DOMParser().parseFromString(inner, 'text/html').body.childNodes;
                            let result = '';
                            el.forEach(item => {
                              if (item.classList && item.classList.contains('user-name')) {
                                result += item.lastChild.firstChild.textContent;
                              } else {
                                result += item.textContent || item.innerText || '';
                              }
                            });
                            return result;
                          }
                        }
                      }
                    },
                    {
                      extend: 'pdf',
                      text: `<span class="d-flex align-items-center"><i class="icon-base ti tabler-file-text me-1"></i>Pdf</span>`,
                      className: 'dropdown-item',
                      exportOptions: {
                        columns: [2, 3, 4, 5, 6, 7],
                        format: {
                          body: function (inner, coldex, rowdex) {
                            if (inner.length <= 0) return inner;
                            const el = new DOMParser().parseFromString(inner, 'text/html').body.childNodes;
                            let result = '';
                            el.forEach(item => {
                              if (item.classList && item.classList.contains('user-name')) {
                                result += item.lastChild.firstChild.textContent;
                              } else {
                                result += item.textContent || item.innerText || '';
                              }
                            });
                            return result;
                          }
                        }
                      }
                    },
                    {
                      extend: 'copy',
                      text: `<i class="icon-base ti tabler-copy me-1"></i>Copy`,
                      className: 'dropdown-item',
                      exportOptions: {
                        columns: [2, 3, 4, 5, 6, 7],
                        format: {
                          body: function (inner, coldex, rowdex) {
                            if (inner.length <= 0) return inner;
                            const el = new DOMParser().parseFromString(inner, 'text/html').body.childNodes;
                            let result = '';
                            el.forEach(item => {
                              if (item.classList && item.classList.contains('user-name')) {
                                result += item.lastChild.firstChild.textContent;
                              } else {
                                result += item.textContent || item.innerText || '';
                              }
                            });
                            return result;
                          }
                        }
                      }
                    }
                  ]
                }
              ]
            }
          ]
        },
        bottomStart: {
          rowClass: 'row mx-3 justify-content-between',
          features: ['info']
        },
        bottomEnd: 'paging'
      },
      language: {
        paginate: {
          next: '<i class="icon-base ti tabler-chevron-right scaleX-n1-rtl icon-18px"></i>',
          previous: '<i class="icon-base ti tabler-chevron-left scaleX-n1-rtl icon-18px"></i>',
          first: '<i class="icon-base ti tabler-chevrons-left scaleX-n1-rtl icon-18px"></i>',
          last: '<i class="icon-base ti tabler-chevrons-right scaleX-n1-rtl icon-18px"></i>'
        }
      },
      // For responsive popup
      responsive: {
        details: {
          display: DataTable.Responsive.display.modal({
            header: function (row) {
              const data = row.data();
              return 'Details of ' + data['customer'];
            }
          }),
          type: 'column',
          renderer: function (api, rowIdx, columns) {
            const data = columns
              .map(function (col) {
                return col.title !== '' // Do not show row in modal popup if title is blank (for check box)
                  ? `<tr data-dt-row="${col.rowIndex}" data-dt-column="${col.columnIndex}">
                      <td>${col.title}:</td>
                      <td>${col.data}</td>
                    </tr>`
                  : '';
              })
              .join('');

            if (data) {
              const div = document.createElement('div');
              div.classList.add('table-responsive');
              const table = document.createElement('table');
              div.appendChild(table);
              table.classList.add('table');
              const tbody = document.createElement('tbody');
              tbody.innerHTML = data;
              table.appendChild(tbody);
              return div;
            }
            return false;
          }
        }
      },
      autoWidth: false,
      scrollX: false,
      initComplete: function () {
        $('body').popover({
          selector: '.btn-cancelled',
          trigger: 'hover' // or 'click'
        });
        const api = this.api();

        // Adding status filter once table is initialized
        api.columns(6).every(function () {
          const column = this;
          const select = document.createElement('select');
          select.id = 'RideStatus';
          select.className = 'form-select text-capitalize';
          select.innerHTML = '<option value="">Status</option>';

          document.querySelector('.ride_status_parcel').appendChild(select);

          select.addEventListener('change', function () {
            const val = select.value ? `^${select.value}$` : '';
            column.search(val, true, false).draw();
          });

          column
            .data()
            .unique()
            .sort()
            .each(function (d) {
              const option = document.createElement('option');
              option.value = d;
              option.textContent = d;
              select.appendChild(option);
            });
        });
        api.columns(4).every(function () {
          const column = this;
          const select = document.createElement('select');
          select.id = 'RideType';
          select.className = 'form-select text-capitalize';
          select.innerHTML = '<option value="">Type</option>';

          document.querySelector('.ride_type_parcel').appendChild(select);

          select.addEventListener('change', function () {
            const val = select.value ? `^${select.value}$` : '';
            column.search(val, true, false).draw();
          });

          column
            .data()
            .unique()
            .sort()
            .each(function (d) {
              const option = document.createElement('option');
              option.value = d;
              option.textContent = d;
              select.appendChild(option);
            });
        });

        // Adding stock filter once table is initialized
        api.columns(2).every(function () {
          const column = this;
          const select = document.createElement('select');
          select.id = 'Driver';
          select.className = 'form-select text-capitalize';
          select.innerHTML = '<option value="">Driver</option>';
          document.querySelector('.driver_parcel').appendChild(select);
          // When a customer is selected, search by their user_id (option value)
          select.addEventListener('change', function () {
            const val = select.value ? `^${select.value}$` : '';
            column.search(val, true, false).draw();
          });
          // Get the raw data for this column and build the dropdown
          const seen = new Set();
          column.data().each(function (d, i) {
            // You need the original row data from DataTable source
            const rowData = column.dataSrc() ? api.row(i).data() : null;
            if (!rowData || !rowData.driver_id || seen.has(rowData.driver_id)) return;
            seen.add(rowData.driver_id);
            const option = document.createElement('option');
            option.value = rowData.driver_id; // filter by user_id
            option.text = rowData.driver; // show customer name
            select.appendChild(option);
          });
        });
        api.columns(3).every(function () {
          const column = this;
          const select = document.createElement('select');
          select.id = 'Customer';
          select.className = 'form-select text-capitalize';
          select.innerHTML = '<option value="">Customer</option>';
          document.querySelector('.customer_parcel').appendChild(select);
          // When a customer is selected, search by their user_id (option value)
          select.addEventListener('change', function () {
            const val = select.value ? `^${select.value}$` : '';
            column.search(val, true, false).draw();
          });
          // Get the raw data for this column and build the dropdown
          const seen = new Set();
          column.data().each(function (d, i) {
            // You need the original row data from DataTable source
            const rowData = column.dataSrc() ? api.row(i).data() : null;
            if (!rowData || !rowData.user_id || seen.has(rowData.user_id)) return;
            seen.add(rowData.user_id);
            const option = document.createElement('option');
            option.value = rowData.user_id; // filter by user_id
            option.text = rowData.customer; // show customer name
            select.appendChild(option);
          });
        });
      }
    });

    $('#flatpickr-range-parcel').on('change', function () {
      dt_ride.ajax.reload();
    });
    const bsRangePicker = $('#bs-rangepicker-range');
    bsRangePicker.attr('autocomplete', 'off');
    // Apply event: update input and redraw DataTable
    bsRangePicker.on('apply.daterangepicker', function (ev, picker) {
      $(this).val(picker.startDate.format('YYYY-MM-DD') + ' to ' + picker.endDate.format('YYYY-MM-DD'));
      dt_ride.ajax.reload();
    });
    // Cancel event: clear input and redraw
    bsRangePicker.on('cancel.daterangepicker', function (ev, picker) {
      $(this).val('');
      dt_ride.ajax.reload();
    });

    // Fixed header
    if (window.Helpers.isNavbarFixed()) {
      const navHeight = document.getElementById('layout-navbar').offsetHeight;
      new DataTable.FixedHeader(dt_ride).headerOffset(navHeight);
    } else {
      new DataTable.FixedHeader(dt_ride);
    }

    //? The 'delete-record' class is necessary for the functionality of the following code.
    document.addEventListener('click', function (e) {
      if (e.target.classList.contains('delete-record')) {
        dt_ride.row(e.target.closest('tr')).remove().draw();
        const modalEl = document.querySelector('.dtr-bs-modal');
        if (modalEl && modalEl.classList.contains('show')) {
          const modal = bootstrap.Modal.getInstance(modalEl);
          modal?.hide();
        }
      }
    });
  }

  // Filter form control to default size
  // ? setTimeout used for ride-list table initialization
  setTimeout(() => {
    const elementsToModify = [
      { selector: '.dt-buttons .btn', classToRemove: 'btn-secondary' },
      { selector: '.dt-search .form-control', classToRemove: 'form-control-sm' },
      { selector: '.dt-length .form-select', classToRemove: 'form-select-sm', classToAdd: 'ms-0' },
      { selector: '.dt-length', classToAdd: 'mb-md-6 mb-0' },
      {
        selector: '.dt-layout-end',
        classToRemove: 'justify-content-between',
        classToAdd: 'd-flex gap-md-4 justify-content-md-between justify-content-center gap-2 flex-wrap'
      },
      { selector: '.dt-buttons', classToAdd: 'd-flex gap-4 mb-md-0 mb-4' },
      { selector: '.dt-layout-table', classToRemove: 'row mt-2' },
      { selector: '.dt-layout-full', classToRemove: 'col-md col-12', classToAdd: 'table-responsive' }
    ];

    // Delete record
    elementsToModify.forEach(({ selector, classToRemove, classToAdd }) => {
      document.querySelectorAll(selector).forEach(element => {
        if (classToRemove) {
          classToRemove.split(' ').forEach(className => element.classList.remove(className));
        }
        if (classToAdd) {
          classToAdd.split(' ').forEach(className => element.classList.add(className));
        }
      });
    });
  }, 100);
});
