/**
 * Dashboard CRM
 */

'use strict';
(function () {
  let cardColor, labelColor, fontFamily, headingColor, shadeColor, legendColor, borderColor, barBgColor;
  if (isDarkStyle) {
    barBgColor = '#3d4157';
    shadeColor = 'dark';
  } else {
    barBgColor = '#efeef0';
    shadeColor = '';
  }
  cardColor = config.colors.cardColor;
  labelColor = config.colors.textMuted;
  legendColor = config.colors.bodyColor;
  borderColor = config.colors.borderColor;
  headingColor = config.colors.headingColor;

  // Orders last week Bar Chart
  // --------------------------------------------------------------------
  const ordersLastWeekEl = document.querySelector('#ordersLastWeek');
  const ordersTotalEl = document.querySelector('#ordersTotal');
  const ordersPercentageEl = document.querySelector('#ordersPercentage');

  if (ordersLastWeekEl) {
    fetch(`${baseURL}/dashboard/orders-last-week`)
      .then(response => response.json())
      .then(data => {
        // Update numbers in the card
        if (ordersTotalEl) ordersTotalEl.textContent = data.total.toLocaleString();
        if (ordersPercentageEl) {
          ordersPercentageEl.textContent = (data.percentage >= 0 ? '+' : '') + data.percentage + '%';
          ordersPercentageEl.className = data.percentage >= 0 ? 'text-success' : 'text-danger';
        }

        // Build chart config
        const ordersLastWeekConfig = {
          chart: { height: 75, parentHeightOffset: 0, type: 'bar', toolbar: { show: false } },
          tooltip: { enabled: false },
          plotOptions: {
            bar: {
              barHeight: '100%',
              columnWidth: '7px',
              startingShape: 'rounded',
              endingShape: 'rounded',
              borderRadius: 4,
              colors: {
                backgroundBarColors: [
                  barBgColor,
                  barBgColor,
                  barBgColor,
                  barBgColor,
                  barBgColor,
                  barBgColor,
                  barBgColor
                ],
                backgroundBarRadius: 4
              }
            }
          },
          colors: [config.colors.primary],
          grid: { show: false, padding: { top: -30, left: -16, bottom: 0, right: -6 } },
          dataLabels: { enabled: false },
          series: [{ data: data.series }],
          legend: { show: false },
          xaxis: {
            categories: data.categories,
            axisBorder: { show: false },
            axisTicks: { show: false },
            labels: { show: false }
          },
          yaxis: { labels: { show: false } },
          responsive: [
            /* keep your responsive settings */
          ]
        };

        const ordersLastWeek = new ApexCharts(ordersLastWeekEl, ordersLastWeekConfig);
        ordersLastWeek.render();
      });
  }

  // Sales last year Area Chart
  // --------------------------------------------------------------------
  const salesLastYearEl = document.querySelector('#salesLastYear');
  const salesTotalEl = document.querySelector('#salesTotal');
  const salesPercentageEl = document.querySelector('#salesPercentage');

  if (salesLastYearEl) {
    fetch(`${baseURL}/dashboard/sales-last-year`)
      .then(res => res.json())
      .then(data => {
        // Update numbers
        if (salesTotalEl) salesTotalEl.textContent = data.total.toLocaleString();
        if (salesPercentageEl) {
          salesPercentageEl.textContent = (data.percentage >= 0 ? '+' : '') + data.percentage + '%';
          salesPercentageEl.className = data.percentage >= 0 ? 'text-success' : 'text-danger';
        }

        // Build chart config
        const salesLastYearConfig = {
          chart: {
            height: 75,
            type: 'area',
            parentHeightOffset: 0,
            toolbar: { show: false },
            sparkline: { enabled: true }
          },
          markers: { colors: 'transparent', strokeColors: 'transparent' },
          grid: { show: false },
          colors: [config.colors.success],
          fill: {
            type: 'gradient',
            gradient: {
              shadeIntensity: 1,
              opacityFrom: 0.4,
              gradientToColors: [config.colors.cardColor],
              opacityTo: 0.1,
              stops: [0, 100]
            }
          },
          dataLabels: { enabled: false },
          stroke: { width: 2, curve: 'smooth' },
          series: [{ data: data.series }],
          xaxis: { show: false, labels: { show: false }, axisBorder: { show: false }, axisTicks: { show: false } },
          yaxis: { show: false },
          tooltip: { enabled: false }
        };

        const salesLastYearChart = new ApexCharts(salesLastYearEl, salesLastYearConfig);
        salesLastYearChart.render();
      });
  }

  fetch(`${baseURL}/dashboard/rides-data`)
    .then(res => res.json())
    .then(data => {
      // Rides Last Week numbers
      document.querySelector('#ridesTotal').textContent = data.rides_last_week.total.toLocaleString();
      document.querySelector('#ridesPercentage').textContent =
        (data.rides_last_week.percentage >= 0 ? '+' : '') + data.rides_last_week.percentage + '%';
      document.querySelector('#ridesPercentage').className =
        data.rides_last_week.percentage >= 0 ? 'text-success' : 'text-danger';

      // Sales Last Year numbers
      document.querySelector('#salesTotalRides').textContent = data.sales_last_year.total.toLocaleString();
      document.querySelector('#salesPercentageRides').textContent =
        (data.sales_last_year.percentage >= 0 ? '+' : '') + data.sales_last_year.percentage + '%';
      document.querySelector('#salesPercentageRides').className =
        data.sales_last_year.percentage >= 0 ? 'text-success' : 'text-danger';

      // Chart 1: Rides Last Week (bar)
      new ApexCharts(document.querySelector('#ridesLastWeek'), {
        chart: { height: 75, type: 'bar', parentHeightOffset: 0, toolbar: { show: false } },
        tooltip: { enabled: false },
        plotOptions: {
          bar: {
            barHeight: '100%',
            columnWidth: '7px',
            borderRadius: 4,
            startingShape: 'rounded',
            endingShape: 'rounded',
            colors: { backgroundBarColors: Array(7).fill(barBgColor), backgroundBarRadius: 4 }
          }
        },
        colors: [config.colors.primary],
        grid: { show: false, padding: { top: -30, left: -16, bottom: 0, right: -6 } },
        dataLabels: { enabled: false },
        series: [{ data: data.rides_last_week.series }],
        xaxis: {
          categories: data.rides_last_week.categories,
          labels: { show: false },
          axisTicks: { show: false },
          axisBorder: { show: false }
        },
        yaxis: { labels: { show: false } }
      }).render();

      // Chart 2: Sales Last Year (area)
      new ApexCharts(document.querySelector('#salesLastYearRides'), {
        chart: {
          height: 75,
          type: 'area',
          parentHeightOffset: 0,
          toolbar: { show: false },
          sparkline: { enabled: true }
        },
        markers: { colors: 'transparent', strokeColors: 'transparent' },
        grid: { show: false },
        colors: [config.colors.success],
        fill: {
          type: 'gradient',
          gradient: {
            shadeIntensity: 1,
            opacityFrom: 0.4,
            gradientToColors: [config.colors.cardColor],
            opacityTo: 0.1,
            stops: [0, 100]
          }
        },
        dataLabels: { enabled: false },
        stroke: { width: 2, curve: 'smooth' },
        series: [{ data: data.sales_last_year.series }],
        tooltip: { enabled: false }
      }).render();
    });

  // Earning Reports Tabs Function
  function EarningReportsBarChart(arrayData, highlightData, chartType) {
    const basicColor = config.colors_label.primary,
      highlightColor = config.colors.primary;
    var colorArr = [];

    for (let i = 0; i < arrayData.length; i++) {
      if (i === highlightData) {
        colorArr.push(highlightColor);
      } else {
        colorArr.push(basicColor);
      }
    }

    const earningReportBarChartOpt = {
      chart: {
        height: 231,
        parentHeightOffset: 0,
        type: 'bar',
        toolbar: {
          show: false
        }
      },
      plotOptions: {
        bar: {
          columnWidth: '32%',
          startingShape: 'rounded',
          borderRadius: 6,
          distributed: true,
          dataLabels: {
            position: 'top'
          }
        }
      },
      grid: {
        show: false,
        padding: {
          top: 0,
          bottom: 0,
          left: -10,
          right: -10
        }
      },
      colors: colorArr,
      dataLabels: {
        enabled: true,
        formatter: function (val) {
          let formatted = val;
          if (val >= 1000) {
            formatted = (val / 1000).toFixed(1).replace(/\.0$/, '') + 'k';
          }
          // Append currency only for Profit or Income
          if (chartType === 'Profit' || chartType === 'Income') {
            const currency = window.appConfig?.currency || ''; // or set globally
            return currency + formatted;
          }
          return formatted;
        },
        offsetY: -30,
        style: {
          fontSize: '15px',
          colors: [headingColor],
          fontWeight: '500',
          fontFamily: fontFamily
        }
      },
      series: [
        {
          data: arrayData
        }
      ],
      legend: {
        show: false
      },
      tooltip: {
        enabled: false
      },
      xaxis: {
        categories: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep'],
        axisBorder: {
          show: true,
          color: borderColor
        },
        axisTicks: {
          show: false
        },
        labels: {
          style: {
            colors: labelColor,
            fontSize: '13px',
            fontFamily: fontFamily
          }
        },
        title: {
          text: 'Months',
          style: { color: labelColor, fontSize: '14px', fontFamily: fontFamily, fontWeight: 600 }
        }
      },
      yaxis: {
        labels: {
          offsetX: 0,
          formatter: function (val) {
            const currency = window.appConfig?.currency || '';
            let formattedVal = parseInt(val / 1);
            // Append currency only for Profit or Income
            if (chartType === 'Profit' || chartType === 'Income') {
              return currency + formattedVal;
            }
            return formattedVal + '';
          },
          style: {
            fontSize: '13px',
            colors: labelColor,
            fontFamily: fontFamily
          },
          min: 0,
          max: 60000,
          tickAmount: 6
        },
        title: {
          text: chartType, // this sets the Y-axis title
          rotate: -90, // optional: rotate vertically
          offsetX: 5, // adjust horizontal offset
          offsetY: 0, // adjust vertical offset
          style: {
            color: labelColor,
            fontSize: '14px',
            fontFamily: fontFamily,
            fontWeight: 600
          }
        }
      },
      responsive: [
        {
          breakpoint: 1441,
          options: {
            plotOptions: {
              bar: {
                columnWidth: '41%'
              }
            }
          }
        },
        {
          breakpoint: 590,
          options: {
            plotOptions: {
              bar: {
                columnWidth: '61%',
                borderRadius: 5
              }
            },
            yaxis: {
              labels: {
                show: false
              }
            },
            grid: {
              padding: {
                right: 0,
                left: -20
              }
            },
            dataLabels: {
              style: {
                fontSize: '12px',
                fontWeight: '400'
              }
            }
          }
        }
      ],
      states: {
        hover: {
          filter: {
            type: 'none'
          }
        },
        active: {
          filter: {
            type: 'none'
          }
        }
      }
    };
    return earningReportBarChartOpt;
  }
  $.get(`${baseURL}/dashboard/earning-reports`, function (earningReportsChart) {
    const earningReportsTabsOrdersEl = document.querySelector('#earningReportsTabsOrders'),
      earningReportsTabsOrdersConfig = EarningReportsBarChart(
        earningReportsChart['data'][0]['chart_data'],
        earningReportsChart['data'][0]['active_option'],
        'Orders'
      );
    if (earningReportsTabsOrdersEl) {
      new ApexCharts(earningReportsTabsOrdersEl, earningReportsTabsOrdersConfig).render();
    }

    const earningReportsTabsSalesEl = document.querySelector('#earningReportsTabsSales'),
      earningReportsTabsSalesConfig = EarningReportsBarChart(
        earningReportsChart['data'][1]['chart_data'],
        earningReportsChart['data'][1]['active_option'],
        'Rides'
      );
    if (earningReportsTabsSalesEl) {
      new ApexCharts(earningReportsTabsSalesEl, earningReportsTabsSalesConfig).render();
    }

    const earningReportsTabsProfitEl = document.querySelector('#earningReportsTabsProfit'),
      earningReportsTabsProfitConfig = EarningReportsBarChart(
        earningReportsChart['data'][2]['chart_data'],
        earningReportsChart['data'][2]['active_option'],
        'Profit'
      );
    if (earningReportsTabsProfitEl) {
      new ApexCharts(earningReportsTabsProfitEl, earningReportsTabsProfitConfig).render();
    }

    const earningReportsTabsIncomeEl = document.querySelector('#earningReportsTabsIncome'),
      earningReportsTabsIncomeConfig = EarningReportsBarChart(
        earningReportsChart['data'][3]['chart_data'],
        earningReportsChart['data'][3]['active_option'],
        'Income'
      );
    if (earningReportsTabsIncomeEl) {
      new ApexCharts(earningReportsTabsIncomeEl, earningReportsTabsIncomeConfig).render();
    }
  });

  // Sales Last 6 Months - Radar Chart
  // --------------------------------------------------------------------
  fetch(`${baseURL}/dashboard/sales-last-six-months`)
    .then(res => res.json())
    .then(data => {
      const salesLastMonthEl = document.querySelector('#salesLastSixMonth'),
        salesLastMonthConfig = {
          series: [
            {
              name: 'Orders',
              data: data.orders
            },
            {
              name: 'Rides',
              data: data.rides
            }
          ],
          chart: {
            height: 340,
            type: 'radar',
            toolbar: {
              show: false
            }
          },
          plotOptions: {
            radar: {
              polygons: {
                strokeColors: borderColor,
                connectorColors: borderColor
              }
            }
          },
          stroke: {
            show: false,
            width: 0
          },
          legend: {
            show: true,
            fontSize: '13px',
            position: 'bottom',
            labels: {
              colors: legendColor,
              useSeriesColors: false
            },
            markers: {
              height: 12,
              width: 12
            },
            itemMargin: {
              horizontal: 10
            },
            onItemHover: {
              highlightDataSeries: false
            }
          },
          colors: [config.colors.primary, config.colors.info],
          fill: {
            opacity: [1, 0.85]
          },
          markers: {
            size: 0
          },
          grid: {
            show: false,
            padding: {
              top: -25,
              bottom: -5
            }
          },
          xaxis: {
            categories: data.labels,
            labels: {
              show: true,
              style: {
                colors: Array(data.labels.length).fill(labelColor),
                fontSize: '13px',
                fontFamily: fontFamily
              }
            }
          },
          yaxis: {
            show: false,
            min: 0,
            max: Math.max(...data.orders.concat(data.rides)) + 5,
            tickAmount: 4
          },
          responsive: [
            {
              breakpoint: 769,
              options: {
                chart: {
                  height: 400
                }
              }
            }
          ]
        };

      if (typeof salesLastMonthEl !== undefined && salesLastMonthEl !== null) {
        const salesLastMonth = new ApexCharts(salesLastMonthEl, salesLastMonthConfig);
        salesLastMonth.render();
      }
    });

  fetch(`${baseURL}/dashboard/support-tracker`)
    .then(res => res.json())
    .then(data => {
      document.querySelector('#totalTickets').textContent = data.total;
      document.querySelector('#openTickets').textContent = data.open;
      document.querySelector('#closedTickets').textContent = data.closed;

      const supportTrackerOptions = {
        series: [data.completionPercent],
        labels: ['Completed Tickets'],
        chart: { height: 337, type: 'radialBar' },
        plotOptions: {
          radialBar: {
            offsetY: 10,
            startAngle: -140,
            endAngle: 130,
            hollow: { size: '65%' },
            track: { background: cardColor, strokeWidth: '100%' },
            dataLabels: {
              name: { offsetY: -20, color: labelColor, fontSize: '13px', fontWeight: '400', fontFamily: fontFamily },
              value: { offsetY: 10, color: headingColor, fontSize: '38px', fontWeight: '400', fontFamily: fontFamily }
            }
          }
        },
        colors: [config.colors.primary],
        fill: {
          type: 'gradient',
          gradient: {
            shade: 'dark',
            shadeIntensity: 0.5,
            gradientToColors: [config.colors.primary],
            inverseColors: true,
            opacityFrom: 1,
            opacityTo: 0.6,
            stops: [30, 70, 100]
          }
        },
        stroke: { dashArray: 10 }
      };

      new ApexCharts(document.querySelector('#supportTracker'), supportTrackerOptions).render();
    });

  // Progress Chart
  // --------------------------------------------------------------------
  // Radial bar chart functions
  function radialBarChart(color, value) {
    const radialBarChartOpt = {
      chart: {
        height: 48,
        width: 38,
        type: 'radialBar'
      },
      plotOptions: {
        radialBar: {
          hollow: {
            size: '25%'
          },
          dataLabels: {
            show: false
          },
          track: {
            background: config.colors_label.secondary
          }
        }
      },
      stroke: {
        lineCap: 'round'
      },
      colors: [color],
      grid: {
        padding: {
          top: -15,
          bottom: -15,
          left: -5,
          right: -15
        }
      },
      series: [value],
      labels: ['Progress']
    };
    return radialBarChartOpt;
  }
  // All progress chart
  const chartProgressList = document.querySelectorAll('.chart-progress');
  if (chartProgressList) {
    chartProgressList.forEach(function (chartProgressEl) {
      const color = config.colors[chartProgressEl.dataset.color],
        series = chartProgressEl.dataset.series;
      const optionsBundle = radialBarChart(color, series);
      const chart = new ApexCharts(chartProgressEl, optionsBundle);
      chart.render();
    });
  }

  // Project Status - Line Chart
  // --------------------------------------------------------------------
  const projectStatusEl = document.querySelector('#projectStatusChart'),
    projectStatusConfig = {
      chart: {
        height: 230,
        type: 'area',
        toolbar: false
      },
      markers: {
        strokeColor: 'transparent'
      },
      series: [
        {
          data: [2000, 2000, 4000, 4000, 3050, 3050, 2000, 2000, 3050, 3050, 4700, 4700, 2750, 2750, 5700, 5700]
        }
      ],
      dataLabels: {
        enabled: false
      },
      grid: {
        show: false,
        padding: {
          left: -10,
          right: -5
        }
      },
      stroke: {
        width: 3,
        curve: 'straight'
      },
      colors: [config.colors.warning],
      fill: {
        type: 'gradient',
        gradient: {
          shadeIntensity: 1,
          opacityFrom: 0.4,
          gradientToColors: [config.colors.cardColor],
          opacityTo: 0.1,
          stops: [0, 100]
        }
      },
      xaxis: {
        labels: {
          show: false
        },
        axisBorder: {
          show: false
        },
        axisTicks: {
          show: false
        },
        lines: {
          show: false
        }
      },
      yaxis: {
        labels: {
          show: false
        },
        min: 1000,
        max: 6000,
        tickAmount: 5
      },
      tooltip: {
        enabled: false
      }
    };
  if (typeof projectStatusEl !== undefined && projectStatusEl !== null) {
    const projectStatus = new ApexCharts(projectStatusEl, projectStatusConfig);
    projectStatus.render();
  }
})();
