<?php
namespace App\Repositories\Eloquent;
use App\Models\Vehicle;
use App\Repositories\Contracts\VehicleModelRepositoryInterface;
use App\Repositories\Contracts\VehicleBrandRepositoryInterface;
use App\Repositories\Contracts\VehicleCategoryRepositoryInterface;
use App\Repositories\Contracts\VehicleRepositoryInterface;
use App\Repositories\BaseRepository;
class VehicleRepository extends BaseRepository implements VehicleRepositoryInterface
{

  protected $vehicleModelRepository;
  protected $vehicleBrandRepository;
  protected $vehicleCategoryRepository;
  public function __construct(
    Vehicle $vehicleModel,
    VehicleCategoryRepositoryInterface $vehicleCategoryRepository,
    VehicleModelRepositoryInterface $vehicleModelRepository,
    VehicleBrandRepositoryInterface $vehicleBrandRepository
  ) {
    $this->vehicleCategoryRepository = $vehicleCategoryRepository;
    $this->vehicleModelRepository = $vehicleModelRepository;
    $this->vehicleBrandRepository = $vehicleBrandRepository;
    parent::__construct($vehicleModel);
  }

  public function allVehicles()
  {
    $parentCategories = $this->vehicleCategoryRepository->dropdown();
    $brands = $this->vehicleBrandRepository->dropdown();
    $models = $this->vehicleModelRepository->dropdown();
    return [
      'categories' => $parentCategories,
      'brands' => $brands,
      'models' => $models
    ];
  }

  public function dropdown()
  {
    return Vehicle::where('status', 1)->orderBy('name')->get();
  }

  public function store(array $data)
  {
    return Vehicle::create([
      'name' => $data['name'],
      'image' => $data['image'],
      'status' => 1,
    ]);
  }

}
