<?php
namespace App\Repositories\Eloquent;
use App\Models\Faq;
use App\Repositories\BaseRepository;
use App\Repositories\Contracts\FaqRepositoryInterface;
class FaqRepository extends BaseRepository implements FaqRepositoryInterface
{
  public function __construct(Faq $faqModel)
  {
    parent::__construct($faqModel);
  }

  public function store(array $data)
  {
    return Faq::create([
      'question' => $data['question'],
      'answer' => $data['answer'],
      'type' => $data['type'],
      'status' => 'Enable',
    ]);
  }

}
