<?php
namespace App\Repositories\Eloquent;
use App\Models\Category;
use App\Repositories\BaseRepository;
use App\Repositories\Contracts\CategoryRepositoryInterface;
class CategoryRepository extends BaseRepository implements CategoryRepositoryInterface
{
  public function __construct(Category $categoryModel)
  {
    parent::__construct($categoryModel);
  }
  public function allList($type)
  {
    return Category::when(!empty($type), function ($query) {
      $query->whereNotNull('parent_id');
    }, function ($query) {
      $query->whereNull('parent_id');
    })
      ->orderByDesc('created_at')
      ->get()
      ->map(function ($item) {
        $item->has_prices = $item->countryPrices_count > 0;
        return $item;
      });
  }
  public function allCategories()
  {
    //remove  whereNull('parent_id') for multiple level categories
    return Category::whereNull('parent_id')
      ->orderBy('name')->get();
  }
  function buildIndentedCategoryList($categories, $prefix = '')
  {
    $list = [];
    foreach ($categories as $category) {
      $list[$category->id] = $prefix . $category->name;
      if ($category->children) {
        $list += $this->buildIndentedCategoryList($category->children, $prefix . '— ');
      }
    }
    return $list;
  }

  public function dropdown()
  {
    return $this->buildIndentedCategoryList(Category::with('children')->whereNull('parent_id')->where('status', 1)->get());
  }

  public function store(array $data)
  {
    return Category::create([
      'parent_id' => $data['parent_id'] ?? null,
      'name' => $data['name'],
      'description' => $data['description'] ?? '',
      'tax' => $data['tax'] ?? null,
      'image' => $data['image'] ?? '',
      'prescriptions' => empty($data['prescriptions']) ? 0 : ($data['prescriptions'] ? 1 : 0),
      'status' => 1,
    ]);
  }

  public function subCategories($id)
  {
    return Category::where('parent_id', $id)->get();
  }


  //Api's
  public function categories()
  {
    return Category::whereNull('parent_id')->where('status', 1)->get();
  }
  public function subCategoriesDashboard($id)
  {
    return Category::where('parent_id', $id)->where('status', 1)->get();
  }
}
