<?php
namespace App\Repositories\Eloquent;
use App\Models\Car;
use Illuminate\Http\Request;
use App\Repositories\Contracts\VehicleModelRepositoryInterface;
use App\Repositories\Contracts\VehicleBrandRepositoryInterface;
use App\Repositories\Contracts\VehicleCategoryRepositoryInterface;
use App\Repositories\Contracts\CarRepositoryInterface;
use App\Repositories\BaseRepository;
use App\Traits\ImageUploadTrait;
class CarRepository extends BaseRepository implements CarRepositoryInterface
{
  use ImageUploadTrait;
  protected $vehicleModelRepository;
  protected $vehicleBrandRepository;
  protected $vehicleCategoryRepository;
  public function __construct(
    Car $bannerModel,
    VehicleCategoryRepositoryInterface $vehicleCategoryRepository,
    VehicleModelRepositoryInterface $vehicleModelRepository,
    VehicleBrandRepositoryInterface $vehicleBrandRepository
  ) {
    parent::__construct($bannerModel);
    $this->vehicleCategoryRepository = $vehicleCategoryRepository;
    $this->vehicleModelRepository = $vehicleModelRepository;
    $this->vehicleBrandRepository = $vehicleBrandRepository;
  }


  public function allCars()
  {
    $parentCategories = $this->vehicleCategoryRepository->dropdown();
    $brands = $this->vehicleBrandRepository->dropdown();
    $vehicleModel = $this->vehicleModelRepository->dropdown();
    return [
      'categories' => $parentCategories,
      'brands' => $brands,
      'models' => $vehicleModel
    ];
  }

  public function dropdown()
  {
    return Car::with(['vehicleModel:id,name']) // eager load relation
      ->where('status', 1)
      ->orderBy('id')
      ->get(['id', 'registration_number', 'vehicle_model_id']); // must include FK

  }

  public function store(Request $request, ?int $Id = null): int
  {
    $vehicle = $Id ? Car::find($Id) : new Car;
    $imageFields = ['vehicle_image', 'insurance_image', 'road_worthiness_image', 'vehicle_registration_image'];
    $uploadedImages = $this->uploadMultipleImages($imageFields, $request, 'cars', $vehicle);
    $fillableData = $request->except($imageFields);
    $fillableData = array_merge($fillableData, $uploadedImages);
    $fillableData['status'] = $vehicle->exists ? $vehicle->status : 1;
    $vehicle->fill($fillableData);
    $vehicle->save();
    return $vehicle->id;
  }

}
