<?php

namespace App\Repositories\Contracts;
use Illuminate\Http\Request;
interface UserRepositoryInterface
{
  public function all();
  public function allList(Request $request);
  public function find($id);
  public function store(Request $request);
  public function create(Request $request);
  public function softDelete($id);
  public function changeStatus($id, $status);
  public function setPassword(array $data);
  public function address(Request $request);
  public function addressList();
  public function deleteAddress($id);
  public function setDefaultAddress($id);
  public function sendOtp(Request $request);
}
