<?php

namespace App\Repositories\Contracts;
use Illuminate\Http\Request;
interface StoreRepositoryInterface
{
  public function all(array $filters = []);
  public function allList(Request $request);
  public function allMaps();
  public function changeStatus($id, $status);
  public function storeStatus($id, $status);
  public function storePaymentStatus($id, $status, $type);
  public function changePopular($id, $status);
  public function find(int $id);
  public function impersonate($storeId);
  public function stopImpersonate();
  public function getStores(Request $request);
  public function store(Request $request, $id);
  public function availabilityUpdate(Request $request);
  public function storeDashboard(Request $request, $type, $limit);
  public function storeDetail(Request $request, $id);

}
