<?php
namespace App\Repositories\Contracts;
use App\Models\RideTemp;
use Illuminate\Http\Request;
interface RideRepositoryInterface
{
  public function createFromTemp(RideTemp $temp, $driverId);
  public function findNearestDrivers($lat, $lng, $number, $vehicleCategoryId, $countryId, $excluded);
  public function respondToRequest(Request $request);
  public function all();
  public function allList(Request $request);
  public function find($id);
  public function driverStatus($id, $status);
  public function rideComplete(Request $request, $rideId);
  public function markDelivered(Request $request, $orderId);
  public function rideEnd(Request $request, $rideId);
  public function rideStart(Request $request, $rideId);
  public function rideCancel(Request $request);
  public function rideStatus(Request $request);
  public function waitingTime(Request $request);
  public function updateLocation(Request $request);
  public function lastDriverLocation($rideId);
  public function getRideCustomersDropdown();
  public function getRideDriversDropdown();
  public function getParcelCustomersDropdown();
  public function getParcelDriversDropdown();
  public function myRides();
  public function assignDriver($orderId, $driverId);
  public function driverCurrentRide();
  public function userCurrentRide();


}
