<?php

namespace App\Repositories;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Collection;

abstract class BaseRepository
{
  protected Model $model;

  public function __construct(Model $model)
  {
    $this->model = $model;
  }

  public function all(array $filters = [], bool $datatable = false)
  {
    $query = $this->model->query()->orderByDesc('created_at');

    foreach ($filters as $key => $value) {
      if (!is_null($value) && $value !== '') {
        if (is_array($value)) {
          $query->whereIn($key, $value);
        } else {
          $query->where($key, $value);
        }
      }
    }
    if ($datatable) {
      return \DataTables::eloquent($query)
        ->addIndexColumn()
        ->make(true);
    }

    return $query->get();
  }

  public function find(int $id): Model
  {
    return $this->model->findOrFail($id);
  }

  public function create(array $data): Model
  {
    return $this->model->create($data);
  }

  public function update(int $id, array $data): Model
  {
    $record = $this->find($id);
    $record->update($data);
    return $record;
  }

  public function delete(int $id): bool
  {
    $record = $this->find($id);
    return $record->delete();
  }

  public function toggleStatus(int $id, int $status = 1): Model
  {
    $record = $this->find($id);
    $record->status = $record->status ? 0 : 1;    //no need to get $status
    $record->save();
    return $record;
  }
}
